/* $Id: obj_prog.c,v 1.666 2004/09/20 10:49:51 shrike Exp $  */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"
#include "fight.h"
#include "rating.h"
#include "wanderers.h"

DECLARE_DO_FUN(do_yell      );
DECLARE_DO_FUN(do_say       );

extern bool is_specialized  (CHAR_DATA *ch, int spec);

#define DECLARE_OPROG(f) OPROG_FUN f

// TATTOO

DECLARE_OPROG(fight_prog_tattoo_shamash);
DECLARE_OPROG(fight_prog_tattoo_dracula);
DECLARE_OPROG(fight_prog_tattoo_ahuramazda);
DECLARE_OPROG(fight_prog_tattoo_crazer);
DECLARE_OPROG(fight_prog_tattoo_karmael);
DECLARE_OPROG(fight_prog_tattoo_odin);
DECLARE_OPROG(fight_prog_tattoo_phobos);
DECLARE_OPROG(fight_prog_tattoo_nimloth);
DECLARE_OPROG(fight_prog_tattoo_crom);
DECLARE_OPROG(fight_prog_tattoo_slider);
DECLARE_OPROG(fight_prog_tattoo_aseroth);
DECLARE_OPROG(fight_prog_tattoo_orlangur);
DECLARE_OPROG(fight_prog_tattoo_montaaron);
DECLARE_OPROG(fight_prog_tattoo_khorne);
DECLARE_OPROG(fight_prog_tattoo_mortie);
DECLARE_OPROG(fight_prog_tattoo_trantor);
DECLARE_OPROG(fight_prog_tattoo_graymage);
DECLARE_OPROG(fight_prog_tattoo_astern);
DECLARE_OPROG(fight_prog_tattoo_nimnull);
DECLARE_OPROG(fight_prog_tattoo_ais);
DECLARE_OPROG(fight_prog_tattoo_stella);
DECLARE_OPROG(fight_prog_tattoo_timimm);

// TATTOO

DECLARE_OPROG(wear_prog_boots_flying);
DECLARE_OPROG(remove_prog_boots_flying);

DECLARE_OPROG(wear_prog_giant_str);
DECLARE_OPROG(remove_prog_giant_str);

DECLARE_OPROG(wear_prog_field);
DECLARE_OPROG(remove_prog_field);

DECLARE_OPROG(wear_prog_shield);
DECLARE_OPROG(remove_prog_shield);

DECLARE_OPROG(wear_prog_pshield);
DECLARE_OPROG(remove_prog_pshield);

// WEAR-REMOVE CAST

DECLARE_OPROG(wear_prog_excalibur);
DECLARE_OPROG(remove_prog_excalibur);
DECLARE_OPROG(death_prog_excalibur);
DECLARE_OPROG(speech_prog_excalibur);
DECLARE_OPROG(sac_prog_excalibur);

DECLARE_OPROG(fight_prog_sub_weapon);
DECLARE_OPROG(speech_prog_kassandra);

DECLARE_OPROG(fight_prog_chaos_blade);
DECLARE_OPROG(death_prog_chaos_blade);

DECLARE_OPROG(get_prog_heart);

DECLARE_OPROG(wear_prog_bracer);
DECLARE_OPROG(remove_prog_bracer);

DECLARE_OPROG(wear_prog_ranger_staff);
DECLARE_OPROG(fight_prog_ranger_staff);
DECLARE_OPROG(death_prog_ranger_staff);

DECLARE_OPROG(wear_prog_coconut);
DECLARE_OPROG(entry_prog_coconut);
DECLARE_OPROG(greet_prog_coconut);
DECLARE_OPROG(get_prog_coconut);
DECLARE_OPROG(remove_prog_coconut);

DECLARE_OPROG(fight_prog_firegauntlets);
DECLARE_OPROG(wear_prog_firegauntlets);
DECLARE_OPROG(remove_prog_firegauntlets);

/* ibrahim armbands */
DECLARE_OPROG(fight_prog_armbands);
DECLARE_OPROG(wear_prog_armbands);
DECLARE_OPROG(remove_prog_armbands);

DECLARE_OPROG(get_prog_rodacid);
DECLARE_OPROG(fight_prog_rodacid);
DECLARE_OPROG(wear_prog_rodacid);
DECLARE_OPROG(remove_prog_rodacid);

DECLARE_OPROG(fight_prog_demonfireshield);
DECLARE_OPROG(wear_prog_demonfireshield);
DECLARE_OPROG(remove_prog_demonfireshield);

DECLARE_OPROG(get_prog_spec_weapon);
DECLARE_OPROG(get_prog_quest_obj);
DECLARE_OPROG(fight_prog_shockwave);
DECLARE_OPROG(fight_prog_snake);

DECLARE_OPROG(fight_prog_rose_shield);
DECLARE_OPROG(fight_prog_lion_claw);

DECLARE_OPROG(speech_prog_ring_ra);
DECLARE_OPROG(wear_prog_eyed_sword);
DECLARE_OPROG(wear_prog_ruler_shield);
DECLARE_OPROG(wear_prog_katana_sword);

DECLARE_OPROG(wear_prog_snake);
DECLARE_OPROG(remove_prog_snake);
DECLARE_OPROG(get_prog_snake);

DECLARE_OPROG(wear_prog_fire_shield);
DECLARE_OPROG(remove_prog_fire_shield);
DECLARE_OPROG(wear_prog_quest_weapon);
DECLARE_OPROG(get_prog_quest_reward);

DECLARE_OPROG(wear_prog_unique);

DECLARE_OPROG(fight_prog_swordbreaker);

DECLARE_OPROG(get_prog_holycross);
DECLARE_OPROG(fight_prog_holycross);
DECLARE_OPROG(wear_prog_holycross);
DECLARE_OPROG(get_prog_unholycross);
DECLARE_OPROG(fight_prog_unholycross);
DECLARE_OPROG(wear_prog_unholycross);
DECLARE_OPROG(get_prog_bookcrom);
DECLARE_OPROG(fight_prog_robehealer);
DECLARE_OPROG(fight_prog_heal);


/* OPROGS by GrayMage */
DECLARE_OPROG(fight_prog_vorpalblade);
DECLARE_OPROG(fight_prog_lightsabervorpal);
DECLARE_OPROG(fight_prog_axevorpal);
DECLARE_OPROG(get_prog_mine);
DECLARE_OPROG(fight_prog_angel);
DECLARE_OPROG(death_prog_angel);
DECLARE_OPROG(fight_prog_cape);
DECLARE_OPROG(fight_prog_bonus);
DECLARE_OPROG(wear_prog_owner);
DECLARE_OPROG(fight_prog_staff_ruling);
DECLARE_OPROG(fight_prog_staff_might);
DECLARE_OPROG(wear_prog_dragon_egg);
DECLARE_OPROG(fight_prog_loriel);
DECLARE_OPROG(fight_prog_magic_sword);
DECLARE_OPROG(fight_prog_fire_sword);
DECLARE_OPROG(fight_prog_ice_sword);
DECLARE_OPROG(fight_prog_dark_sword);
DECLARE_OPROG(fight_prog_dark_mask);
DECLARE_OPROG(fight_prog_haste_boots);
DECLARE_OPROG(fight_prog_crimson_banner);
DECLARE_OPROG(fight_prog_horn_of_ages);
DECLARE_OPROG(fight_prog_plazma_cannon);
DECLARE_OPROG(fight_prog_miniplazma_cannon);
DECLARE_OPROG(wear_prog_stone_skin);
DECLARE_OPROG(remove_prog_stone_skin);
DECLARE_OPROG(fight_prog_stone_skin);

/* end of OPROGS by GrayMage */


/*new obj prog by Jennifer*/
DECLARE_OPROG(wear_prog_cathead);
DECLARE_OPROG(remove_prog_cathead);
DECLARE_OPROG(fight_prog_cathead);
/*end*/

char* optype_table[] = {
    "wear_prog",
    "remove_prog",
    "drop_prog",
    "sac_prog",
    "give_prog",
    "greet_prog",
    "fight_prog",
    "death_prog",
    "speech_prog",
    "entry_prog",
    "get_prog",
    "area_prog",
    NULL
};

OPROG_DATA oprog_table[] = {
    { "fight_prog_tattoo_shamash", fight_prog_tattoo_shamash },
    { "fight_prog_tattoo_dracula", fight_prog_tattoo_dracula },
    { "fight_prog_tattoo_ahuramazda", fight_prog_tattoo_ahuramazda },
    { "fight_prog_tattoo_crazer", fight_prog_tattoo_crazer },
    { "fight_prog_tattoo_karmael", fight_prog_tattoo_karmael },
    { "fight_prog_tattoo_odin", fight_prog_tattoo_odin },
    { "fight_prog_tattoo_phobos", fight_prog_tattoo_phobos },
    { "fight_prog_tattoo_nimloth", fight_prog_tattoo_nimloth },
    { "fight_prog_tattoo_crom", fight_prog_tattoo_crom },
    { "fight_prog_tattoo_slider", fight_prog_tattoo_slider },
    { "fight_prog_tattoo_aseroth", fight_prog_tattoo_aseroth },
    { "fight_prog_tattoo_orlangur", fight_prog_tattoo_orlangur },
    { "fight_prog_tattoo_montaaron", fight_prog_tattoo_montaaron },
    { "fight_prog_tattoo_khorne", fight_prog_tattoo_khorne },
    { "fight_prog_tattoo_mortie", fight_prog_tattoo_mortie },
    { "fight_prog_tattoo_trantor", fight_prog_tattoo_trantor },
    { "fight_prog_tattoo_ais", fight_prog_tattoo_ais },
    { "fight_prog_tattoo_nimnull", fight_prog_tattoo_nimnull },
    { "fight_prog_tattoo_graymage", fight_prog_tattoo_graymage },
    { "fight_prog_tattoo_astern", fight_prog_tattoo_astern },
    { "fight_prog_tattoo_stella", fight_prog_tattoo_stella },
    { "fight_prog_tattoo_timimm", fight_prog_tattoo_timimm },

// TATTOO    

    { "wear_prog_boots_flying", wear_prog_boots_flying },
    { "remove_prog_boots_flying", remove_prog_boots_flying },
    { "wear_prog_giant_str", wear_prog_giant_str },
    { "remove_prog_giant_str", remove_prog_giant_str },
    { "wear_prog_field", wear_prog_field },
    { "remove_prog_field", remove_prog_field },
    { "wear_prog_shield", wear_prog_shield },
    { "remove_prog_shield", remove_prog_shield },
    { "wear_prog_pshield", wear_prog_pshield },
    { "remove_prog_pshield", remove_prog_pshield },
    
// WEAR-REMOVE CAST
    
    { "wear_prog_excalibur", wear_prog_excalibur },
    { "remove_prog_excalibur", remove_prog_excalibur },
    { "death_prog_excalibur", death_prog_excalibur },
    { "speech_prog_excalibur", speech_prog_excalibur },
    { "sac_prog_excalibur", sac_prog_excalibur },
    { "fight_prog_sub_weapon", fight_prog_sub_weapon },
    { "speech_prog_kassandra", speech_prog_kassandra },
    { "fight_prog_chaos_blade", fight_prog_chaos_blade },
    { "death_prog_chaos_blade", death_prog_chaos_blade },
    { "fight_prog_breaker", fight_prog_swordbreaker },
    { "get_prog_heart", get_prog_heart },
    { "wear_prog_bracer", wear_prog_bracer },
    { "remove_prog_bracer", remove_prog_bracer },
    { "wear_prog_ranger_staff", wear_prog_ranger_staff },
    { "fight_prog_ranger_staff", fight_prog_ranger_staff },
    { "death_prog_ranger_staff", death_prog_ranger_staff },
    { "wear_prog_coconut", wear_prog_coconut },
    { "entry_prog_coconut", entry_prog_coconut },
    { "greet_prog_coconut", greet_prog_coconut },
    { "get_prog_coconut", get_prog_coconut },
    { "remove_prog_coconut", remove_prog_coconut },
    { "fight_prog_firegauntlets", fight_prog_firegauntlets },
    { "wear_prog_firegauntlets", wear_prog_firegauntlets },
    { "remove_prog_firegauntlets", remove_prog_firegauntlets },
    { "fight_prog_armbands", fight_prog_armbands },
    { "wear_prog_armbands", wear_prog_armbands },
    { "remove_prog_armbands", remove_prog_armbands },
    { "get_prog_rodacid", get_prog_rodacid },
    { "fight_prog_rodacid", fight_prog_rodacid },
    { "wear_prog_rodacid", wear_prog_rodacid },
    { "remove_prog_rodacid", remove_prog_rodacid },
    { "fight_prog_demonfireshield", fight_prog_demonfireshield },
    { "wear_prog_demonfireshield", wear_prog_demonfireshield },
    { "remove_prog_demonfireshield", remove_prog_demonfireshield },
    { "get_prog_spec_weapon", get_prog_spec_weapon },
    { "get_prog_quest_obj", get_prog_quest_obj },
    { "fight_prog_shockwave", fight_prog_shockwave },
    { "fight_prog_snake", fight_prog_snake },
    { "fight_prog_rose_shield", fight_prog_rose_shield },
    { "fight_prog_lion_claw", fight_prog_lion_claw },
    { "speech_prog_ring_ra", speech_prog_ring_ra },
    { "wear_prog_eyed_sword", wear_prog_eyed_sword },
    { "wear_prog_ruler_shield", wear_prog_ruler_shield },
    { "wear_prog_katana_sword", wear_prog_katana_sword },
    { "wear_prog_snake", wear_prog_snake },
    { "remove_prog_snake", remove_prog_snake },
    { "get_prog_snake", get_prog_snake },
    { "wear_prog_fire_shield", wear_prog_fire_shield },
    { "remove_prog_fire_shield", remove_prog_fire_shield },
    { "wear_prog_quest_weapon", wear_prog_quest_weapon },
    { "wear_prog_unique", wear_prog_unique },
    { "get_prog_quest_reward", get_prog_quest_reward },
    { "get_prog_holycross", get_prog_holycross },
    { "fight_prog_holycross", fight_prog_holycross },
    { "wear_prog_holycross", wear_prog_holycross },
    { "get_prog_unholycross", get_prog_unholycross },
    { "fight_prog_unholycross", fight_prog_unholycross },
    { "wear_prog_unholycross", wear_prog_unholycross },
    { "get_prog_bookcrom", get_prog_bookcrom },
    { "fight_prog_robehealer", fight_prog_robehealer },
    { "fight_prog_heal", fight_prog_heal },

/* OPROGS by GrayMage */
    { "fight_prog_vorpalblade", fight_prog_vorpalblade },
    { "fight_prog_lightsabervorpal", fight_prog_lightsabervorpal },
    { "fight_prog_axevorpal", fight_prog_axevorpal },
    { "get_prog_mine", get_prog_mine },
    { "fight_prog_angel", fight_prog_angel },
    { "death_prog_angel", death_prog_angel },
    { "fight_prog_cape", fight_prog_cape },
    { "wear_prog_owner", wear_prog_owner },
    { "fight_prog_bonus", fight_prog_bonus },
    { "fight_prog_staff_ruling", fight_prog_staff_ruling },
    { "fight_prog_staff_might", fight_prog_staff_might },
    { "wear_prog_dragon_egg", wear_prog_dragon_egg },
    { "fight_prog_loriel", fight_prog_loriel },
    { "fight_prog_magic_sword", fight_prog_magic_sword },
    { "fight_prog_fire_sword", fight_prog_fire_sword },
    { "fight_prog_ice_sword", fight_prog_ice_sword },
    { "fight_prog_dark_sword", fight_prog_dark_sword },
    { "fight_prog_dark_mask", fight_prog_dark_mask },
    { "fight_prog_haste_boots", fight_prog_haste_boots },
    { "fight_prog_crimson_banner", fight_prog_crimson_banner },
    { "fight_prog_horn_of_ages", fight_prog_horn_of_ages },
    { "fight_prog_plazma_cannon", fight_prog_plazma_cannon },
    { "fight_prog_miniplazma_cannon", fight_prog_miniplazma_cannon },
    { "wear_prog_stone_skin", wear_prog_stone_skin },
    { "remove_prog_stone_skin", remove_prog_stone_skin },
    { "fight_prog_stone_skin", fight_prog_stone_skin },
/* end of OPROGS by GrayMage */

    { "wear_prog_cathead", wear_prog_cathead },
    { "remove_prog_cathead", remove_prog_cathead },
    { "fight_prog_cathead", fight_prog_cathead },
        { NULL }
};

int optype_lookup(const char *name)
{
    int i;

    for (i = 0; optype_table[i] != NULL; i++)
        if (str_cmp(optype_table[i], name) == 0)
            return i;
    return -1;
}

int oprog_call(int optype, OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->pIndexData->oprogs_old
    &&  obj->pIndexData->oprogs_old[optype] != NULL)
        return (obj->pIndexData->oprogs_old[optype])(obj, ch, arg);
    return 0;
}

OPROG_DATA *oprog_lookup(const char *name)
{
    OPROG_DATA *p;

    for (p = oprog_table; p->name != NULL; p++)
        if (str_cmp(p->name, name) == 0)
            return p;
    return NULL;
}

char *oprog_name_lookup(OPROG_FUN *fn)
{
    OPROG_DATA *p;

    for (p = oprog_table; p->name != NULL; p++)
        if (p->fn == fn)
            break;

    return p->name;
}

void oprog_set(OBJ_INDEX_DATA *pObjIndex,const char *progtype, const char *name)
{
    int opindex;
    OPROG_DATA *oprog;

    opindex = optype_lookup(progtype);
    if (opindex == -1) {
        log_printf("oprog_set: vnum %d: unknown obj prog type `%s'",
               pObjIndex->vnum, progtype);
        exit(1);
    }

    oprog = oprog_lookup(name);
    if (oprog == NULL) {
        log_printf("oprog_set: vnum %d: unknown obj prog `%s'",
               pObjIndex->vnum, name);
        exit(1);
    }

    if (pObjIndex->oprogs_old == NULL)
        pObjIndex->oprogs_old = calloc(1, sizeof(*pObjIndex->oprogs_old) *
                          OPROG_MAX);
    pObjIndex->oprogs_old[opindex] = oprog->fn;
}

bool check_galka(CHAR_DATA *ch)
{
    if (IS_NPC(ch))
        return FALSE;
    if (ch->religion != RELIGION_GALKA)
        return FALSE;
    return TRUE;
}

int fight_prog_tattoo_ais(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(5)) {
    case 1:
        char_act("The tattoo on your shoulder glows {Cblue{z.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_critical(gsn_cure_critical, ch->level,ch, ch, TARGET_CHAR);
        break;
    case 4:
        if (is_affected(ch, gsn_blindness)) {
            char_act("The tattoo on your shoulder glows {Cyellow{z.", ch);
            if (check_galka(victim))
            {
          //      act_say(victim, "!", NULL);
                ch = victim;
            }
            spell_cure_blindness(sn_lookup("cure blindness"), ch->level,ch, ch, TARGET_CHAR);
        }
        break;

    case 5:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        char_act("{W {z  .", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_lightning_breath(gsn_lightning_breath, ch->level, ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_nimnull(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
        CHAR_DATA *victim = ch->fighting;
        int dam;

    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(5)) {
    case 0:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        ch->hit += ch->level;
        ch->hit = UMIN(ch->hit,ch->max_hit);
        char_act("   .", ch);
        break;
    case 1:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        dam = number_range(LVL(ch)*4, LVL(ch)*7) +
              20 * ch->size + 2 * ch->damroll;
        if (!IS_NPC(ch->fighting))
            dam /= 2;
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
       damage(ch, ch->fighting, dam, gsn_annihilate, DAM_ENERGY, TRUE);
        break;
    }
    return 0;
}

int fight_prog_tattoo_graymage(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(4))
    {
    case 0: if (ch->hit < ch->max_hit)
        {
            char_act("The tattoo on your shoulder glows {Ggreen{x.", ch);
            ch->hit += ch->level * 2;
            ch->hit = UMIN(ch->hit, ch->max_hit);
            char_act(" {W{z  .", ch);
        } else
        {
            if (number_percent () > get_curr_stat(ch, STAT_LCK))
                obj_cast_spell(sn_lookup("lightning bolt"),
                    ch->level * 2, ch, ch, NULL);
        } 

        if (!ch || JUST_KILLED(ch))
            return 0;

        if (ch->mana < ch->max_mana
        && number_percent () < get_curr_stat(ch, STAT_LCK))
        {
            char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
            ch->mana += ch->level * 6;
            ch->mana = UMIN(ch->mana, ch->max_mana);
            char_act(" {W{z  .", ch);
        }
        break;
    }
    return 0;
}

int fight_prog_tattoo_astern(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(8))
    {
    case 0:
        if (IS_AFFECTED(ch, AFF_BLIND))
            spell_cure_blindness(sn_lookup("cure blindness"),
                LVL(ch), ch, ch, TARGET_CHAR);
    case 1:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            spell_cure_serious(gsn_cure_serious, ch->level, victim, victim, TARGET_CHAR);
        }
        spell_cure_serious(gsn_cure_serious, ch->level, ch, ch, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_stella(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;
        
    switch(number_bits(5)) {
    case 5:
        if (is_affected(ch, gsn_giant_strength))
        {
            char_act("The tattoo on your shoulder glows {Rred{x.", ch);
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                ch = victim;
            }
            spell_chill_touch(gsn_chill_touch, ch->level, ch, ch->fighting, TARGET_CHAR);
            char_act(" {C{c{C{c{C{c{x       .", ch);
        }
        else
        {
            char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                ch = victim;
            }
            spell_giant_strength(gsn_giant_strength, ch->level, ch, ch, TARGET_CHAR);
            char_act("    .", ch);
        }
        break;
    case 3:
    case 4: 
        if (!IS_AFFECTED(ch->fighting, AFF_SLOW))
        {
            char_act("The tattoo on your shoulder glows {Yyellow{x.", ch);
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                ch = victim;
            }
            spell_slow(gsn_slow, ch->level, ch, ch->fighting, TARGET_CHAR);
            char_act(" {C{c{C{c{C{c{x     .", ch);
        }
        else
        {
            char_act("The tattoo on your shoulder glows {Yyellow{x.", ch);
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                ch = victim;
            }
            spell_weaken(gsn_weaken, ch->level, ch, ch->fighting, TARGET_CHAR);
            char_act(" {C{c{C{c{C{c{x     .", ch);
        }
        break;
    }
    return 0;
}

int fight_prog_tattoo_timimm(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(5)) {
    case 0:
    case 1:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            victim = ch;
        }
        spell_lightning_bolt(gsn_lightning_bolt, ch->level,
            ch, victim, TARGET_CHAR);
        break;
    case 2:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        act_yell(ch, "   !", NULL, NULL);
        if (check_galka(victim))
        {
        //    act_say(victim, ".", NULL);
            spell_deafen(gsn_deafen, (ch->level*3/2), ch, ch, TARGET_CHAR);
            break;
        }
        spell_scream(gsn_scream, (ch->level*3/2),
            ch, ch->fighting, TARGET_CHAR);
        break;
    case 4:
        if (!is_affected(ch, gsn_bless)) {
        char_act("The tattoo on your shoulder glows {Cyellow{z.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_bless(gsn_bless, ch->level,ch, ch, TARGET_CHAR);
        }
    break;

    }
    return 0;
}

int fight_prog_tattoo_slider(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    int nhits = 1;
    if (victim == NULL)
        return 0;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;
    
    switch(number_bits(6))
    {
    case 0:
    case 1:
        char_act("The tattoo on your shoulder glows white.", ch);
        // evil Galki's idea
        if (ch->religion == victim->religion
        && number_range(1,5) == 1)
        {
            CHAR_DATA *wch = ch;
            act_say(ch, "My honour is my life.", NULL);
            act_say(victim, "No, my honour is my life.", NULL);
            while (ch != NULL && victim != NULL
            && !JUST_KILLED(ch) && !JUST_KILLED(victim)
            && ch->in_room && victim->in_room
            && ch->in_room == victim->in_room)
            {
                act_say(wch, "No, My honour is my life.", NULL);
                one_hit(wch, (wch == ch) ? victim : ch, TYPE_UNDEFINED, WEAR_WIELD);
                wch = (wch == ch) ? victim : ch;
                if (number_range(1,10) == 1)
                    break;
            }
            return 0;
        }
                
        act_say(ch, "My honour is my life.", NULL);
        if (check_galka(victim))
        {
//            act_say(victim, ", -!", NULL); //underground
            return 0;
        }
        
        if (IS_AFFECTED(ch, AFF_SLOW))
            nhits -= 2;

        if (IS_AFFECTED(ch, AFF_HASTE))
        {
            AFFECT_DATA *af;
            for (af = ch->affected; af != NULL; af = af->next)
            {
                if (af->type == gsn_haste)
                {
                    nhits += 1;
                }
                else if (af->bitvector == AFF_HASTE)
                {
                    nhits += 1;
                }
                else if (af->location != APPLY_DEX)
                continue;
            }
        }

        if (nhits <= 0) break;
        while (nhits--)
        {
            one_hit(ch, victim, TYPE_UNDEFINED, WEAR_WIELD);
        }
        break;
    }
    return 0;
}


int fight_prog_tattoo_shamash(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(6)) {
    case 0:
    case 1:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_serious(gsn_cure_serious, ch->level,
                   ch, ch, TARGET_CHAR);
        break;
    case 2:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        act_yell(ch, "Ever dance with good....", NULL, NULL);
        if (check_galka(victim))
        {
        //    act_yell(ch, "{cCommon, baby, light my fire!{x", NULL, NULL);
            break;
        }
        spell_holy_word(sn_lookup("holy word"), ch->level,
                ch, NULL, TARGET_NONE);
        break;
    }
    return 0;
}


int fight_prog_tattoo_dracula(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(6)) {
    case 0:
    case 1:
    case 2:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_critical(gsn_cure_critical, ch->level,
                    ch, ch, TARGET_CHAR);
        break;
    case 3:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        if (IS_AFFECTED(ch, AFF_PLAGUE))
            spell_cure_disease(sn_lookup("cure disease"),
                       MAX_LEVEL, ch, ch, TARGET_CHAR);
        if (IS_AFFECTED(ch, AFF_POISON))
            spell_cure_poison(gsn_cure_poison,
                      MAX_LEVEL, ch, ch, TARGET_CHAR);
        break;
    case 4:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_energy_drain(sn_lookup("energy drain"), ch->level,
                    ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_ahuramazda(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(6)) {
    case 0:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_serious(gsn_cure_serious, ch->level,
                   ch, ch, TARGET_CHAR);
        break;
    case 1:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
            if (IS_EVIL(victim))
                break;
        }
        spell_dispel_evil(sn_lookup("dispel evil"), ch->level,
                  ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_crazer(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(6)) {
    case 0:
        char_act("The tattoo on your shoulder glows {Cblue{z.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_light(gsn_cure_light, ch->level,
                 ch, ch, TARGET_CHAR);
        break;
    case 1:
    case 4:
        char_act("The tattoo on your shoulder glows {Cblue{z.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_serious(gsn_cure_serious, ch->level,
                   ch, ch, TARGET_CHAR);
        break;
    case 6:
        char_act("The tattoo on your shoulder glows {Rbright red{z.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_plasma_web(gsn_plasma_web, ch->level, ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_odin(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(5)) {
    case 0:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_critical(gsn_cure_critical, ch->level,
                    ch, ch, TARGET_CHAR);
        break;
    case 1:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_faerie_fire(gsn_faerie_fire, ch->level,
                  ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_phobos(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(6)) {
    case 0:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_serious(gsn_cure_serious, ch->level,
                   ch, ch, TARGET_CHAR);
        break;
    case 1:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_colour_spray(sn_lookup("colour spray"), ch->level,
                   ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_nimloth(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(7)) {
    case 0:
        char_act("  ϣ   {C {x!", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_bless(gsn_bless, ch->level, ch, ch, TARGET_CHAR);
        char_act("{CNimloth{x   ϣ !", ch);
        break;
    case 1:
        char_act("  ϣ   {R {x!", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
            if (IS_EVIL(victim))
                break;
        }
        spell_dispel_evil(gsn_dispel_evil, ch->level,
                 ch, ch->fighting, TARGET_CHAR);
        char_act("   {R{x   !", ch);
        break;
    case 2:
        char_act("  ϣ   {Y {x!", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_protection_evil(gsn_protection_evil, ch->level, 
                             ch, ch, TARGET_CHAR);
        char_act("{CNimloth{x      {R {x!", ch);
        break;
    case 6:
        char_act("  ϣ   {W {x!", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
            break;
        }
        spell_ray_of_truth(gsn_ray_of_truth, ch->level, ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_crom(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    AFFECT_DATA af;

    if(get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    if (number_percent() < 50) {
        switch(number_bits(4)) {
        case 0:
            if (IS_AFFECTED(ch,AFF_BERSERK)
            ||  is_affected(ch,gsn_berserk)
            ||  is_affected(ch,gsn_frenzy)) {
                char_act("You get a little madder.", ch);
                return 0;
            }
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                break;
            }
            af.where = TO_AFFECTS;
            af.type = gsn_berserk;
            af.level = ch->level;
            af.duration = ch->level / 3;
            af.modifier = ch->level / 5;
            af.bitvector = AFF_BERSERK;

            af.location = APPLY_HITROLL;
            affect_to_char(ch, &af);

            af.location = APPLY_DAMROLL;
            affect_to_char(ch, &af);

            af.modifier = 10 * (ch->level / 10);
            af.location = APPLY_AC;
            affect_to_char(ch, &af);

            ch->hit += ch->level * 2;
            ch->hit = UMIN(ch->hit,ch->max_hit);

            char_act("Your pulse races as you are consumned by rage!", ch);
            act("$n gets a wild look in $gn{his} eyes.", ch, NULL, NULL, TO_ROOM);
            break;
        }
    }
    else {
        switch(number_bits(4)) {
        case 0:
            do_yell(ch, "Cry Havoc and Let Loose the Dogs of War!");
            break;
        case 1:
            do_yell(ch, "No Mercy!");
            break;
        case 2:
            do_yell(ch, "Los Valdar Cuebiyari!");
            break;
        case 3:
            do_yell(ch, "Carai an Caldazar! Carai an Ellisande! "
                    "Al Ellisande!");
            break;
        case 4:
            do_yell(ch, "Siempre Vive el Riesgo!");
            break;
        }
    }
    return 0;
}

int fight_prog_tattoo_aseroth(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA   *victim;
    int hp_percent = 100 * ch->hit/ch->max_hit;
    int pen = UMIN(ch->max_hit/100, 10);
    int n = number_bits(6);
    int lev = number_range(1, 4);
     
    if ((victim = ch->fighting) == NULL)
    {
        act("What da fuck? report this bug! (Aseroth tattoo)", ch, NULL, NULL, TO_CHAR);
        return 0;
    }
    
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    if ((hp_percent > 75) && (n < 4))
    {
        ch->hit -= pen*lev;
        act("Your tattoo drains blood from you!", ch, NULL, NULL, TO_CHAR);
    }
    else if ((hp_percent > 25) && (n < 4))
    {
        lev = 0;
    }
    else if (n < 4)
    {
        act("Your tattoo betrayed you!", ch, NULL, NULL, TO_CHAR);
        return 0;
    }
                

    switch(n) {
    case 0:
        if (!is_immune(victim, DAM_DISEASE))
        {
            act("Magical rune of disease glows {Rred{x on your shoulder.", ch, NULL, NULL, TO_CHAR);
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                victim = ch;
            }
            spell_plague(gsn_plague, LVL(ch)+lev,
                     ch, victim, TARGET_CHAR);
        }
        else
        {
            act("Ancient rune of dead silence glows {Rred{x on your shoulder.", ch, NULL, NULL, TO_CHAR);
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                victim = ch;
            }
            spell_deafen(gsn_deafen, LVL(ch)+lev,
                     ch, victim, TARGET_CHAR);
        }
        break;
    case 1:
        if (IS_GOOD(victim))
        {        
            act("You feel the {Rhatred{x, emanating from your tattoo.", ch, NULL, NULL, TO_CHAR);
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                break;
            }
            spell_dispel_good(sn_lookup("dispel good"), LVL(ch)+lev,
                          ch, victim, TARGET_CHAR);
        }
        else
        {
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                victim = ch;
            }
            spell_demonfire(gsn_demonfire, LVL(ch)*2/3+lev, 
                            ch, victim, TARGET_CHAR);
        }
        if (ch == NULL || victim == NULL 
            || JUST_KILLED(ch) || JUST_KILLED(victim))
            return 0;

        /* FALLTHRU */
    case 2:

        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            victim = ch;
        }
        spell_weaken(gsn_weaken, LVL(ch) + lev, ch, victim, TARGET_CHAR);
        if (ch == NULL || victim == NULL 
            || JUST_KILLED(ch) || JUST_KILLED(victim))
            return 0;

        /* FALLTHRU */
    case 3:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            victim = ch;
        }
        spell_slow(gsn_slow, LVL(ch)+lev, ch, victim, TARGET_CHAR);
        break;
    }
    return 0;
}


int fight_prog_tattoo_karmael(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(6)) {
    case 0:
    case 1:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_serious(gsn_cure_serious, ch->level,
                   ch, ch, TARGET_CHAR);
        break;
    case 2:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_web(gsn_web, ch->level, ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_orlangur(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) == obj)
    switch(number_bits(10)) {
    case 0:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_critical(gsn_cure_critical, ch->level,
                    ch, ch, TARGET_CHAR);
        break;
    case 1:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);

        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        if (IS_EVIL(ch->fighting) && !IS_EVIL(ch))
            spell_dispel_evil(sn_lookup("dispel evil"),
                      ch->level * 12 / 10,
                      ch, ch->fighting, TARGET_CHAR);
        else if (IS_GOOD(ch->fighting) && !IS_GOOD(ch))
            spell_dispel_good(sn_lookup("dispel good"),
                      ch->level * 12 / 10,
                      ch, ch->fighting, TARGET_CHAR);
        else
            spell_lightning_bolt(sn_lookup("lightning bolt"),
                         ch->level * 12 / 10,
                         ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_montaaron(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(5)) {
    case 0:
    case 1:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_heal(sn_lookup("heal"), ch->level, ch, ch, TARGET_CHAR);
        break;
    case 2:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_group_heal(sn_lookup("group heal"), ch->level,
                 ch, ch, TARGET_CHAR);
        break;
    }
    return 0;
}

int fight_prog_tattoo_khorne(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
                return 0;

    switch(number_bits(5)) {
        case 0:
        case 1:
            char_act("The tattoo on your shoulder glows {Dblack{x.", ch);
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                ch = victim;
            }
            spell_chaos_combat(gsn_chaos_combat, ch->level, ch,
                                ch->fighting, TARGET_CHAR);
            break;
        case 3:
            char_act("The tattoo on your shoulder glows {rred{x.", ch);
            if (check_galka(victim))
            {
            //    act_say(victim, "!", NULL);
                ch = victim;
            }
            spell_spiritual_hammer(gsn_spiritual_hammer, ch->level, ch,
                                ch->fighting, TARGET_CHAR);
            break;
    }
    return 0;
}


int fight_prog_tattoo_mortie(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
                return 0;

        switch(number_bits(5)) {
        case 0:
        case 1:
                char_act("The tattoo on your shoulder glows {Dblack{x.", ch);
                if (check_galka(victim))
                {
                //    act_say(victim, "!", NULL);
                    ch = victim;
                }
                spell_frenzy(gsn_frenzy, ch->level, ch,
                                ch, TARGET_CHAR);
                break;
        case 3:
                char_act("The tattoo on your shoulder glows {rred{x.", ch);
                if (check_galka(victim))
                {
                //    act_say(victim, "!", NULL);
                    ch = victim;
                }
                spell_banshee_scream(gsn_banshee_scream, ch->level, ch,
                                ch->fighting, TARGET_CHAR);
                break;
        }
        return 0;
}

int fight_prog_tattoo_trantor(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim = ch->fighting;
    if (get_eq_char(ch, WEAR_TATTOO) != obj)
        return 0;

    switch(number_bits(5)) {
    case 0:
        char_act("The tattoo on your shoulder glows {Cblue{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_cure_critical(gsn_cure_critical, ch->level,
                    ch, ch, TARGET_CHAR);
        break;
    case 1:
        char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_curse(gsn_curse, ch->level,
                  ch, ch->fighting, TARGET_CHAR);
        break;
    case 4:
    char_act("The tattoo on your shoulder glows {Rred{x.", ch);
        if (check_galka(victim))
        {
        //    act_say(victim, "!", NULL);
            ch = victim;
        }
        spell_scream(gsn_scream, ch->level,
                  ch, ch->fighting, TARGET_CHAR);
        break;
    }
    return 0;
}

int wear_prog_boots_flying(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    AFFECT_DATA af;

    if (!is_affected(ch, gsn_fly))
    {
        char_act("     .", ch);
        act(" $n    .", ch, NULL, NULL, TO_ROOM);

      af.where      = TO_AFFECTS;
      af.type       = gsn_fly;
      af.duration   = -2;
      af.level      = ch->level;
      af.bitvector  = AFF_FLYING;
      af.location   = 0;
      af.modifier   = 0;
      affect_to_char(ch, &af);
    }
    return 0;
}

int remove_prog_boots_flying(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (is_affected(ch, gsn_fly))
    {
        affect_strip(ch, gsn_fly);
        char_act("    .", ch);
    }
    return 0;
}

int wear_prog_giant_str(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    AFFECT_DATA af;

    if (!is_affected(ch, gsn_giant_strength))
    {
        char_act("    !", ch);
        act(" $n   !", ch, NULL, NULL, TO_ROOM);

        af.where        = TO_AFFECTS;
        af.type         = gsn_giant_strength;
        af.duration     = -2;
        af.level        = ch->level;
        af.bitvector    = 0;
        af.location     = APPLY_STR;
        af.modifier     = UMAX(2, ch->level / 10);
        affect_to_char(ch, &af);
    }
    return 0;
}

int remove_prog_giant_str(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (is_affected(ch, gsn_giant_strength))
    {
        affect_strip(ch, gsn_giant_strength);
        char_act("Your muscles regain its original value.", ch);
    }
    return 0;
}

int wear_prog_excalibur(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act("$p begins to shine a bright white.",ch,obj,NULL,TO_CHAR);
    act("$p begins to shine a bright white.",ch,obj,NULL,TO_ROOM);
    if (               ch->level <= 20) obj->value[2] = 3;
    else if (ch->level > 20 && ch->level <= 30) obj->value[2] = 4;
    else if (ch->level > 30 && ch->level <= 40) obj->value[2] = 5;
    else if (ch->level > 40 && ch->level <= 50) obj->value[2] = 6;
    else if (ch->level > 50 && ch->level <= 60) obj->value[2] = 8;
    else if (ch->level > 60 && ch->level <= 70) obj->value[2] = 10;
    else if (ch->level > 70 && ch->level <= 80) obj->value[2] = 11;
    else                        obj->value[2] = 12;
    return 0;
}

int wear_prog_bracer(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    AFFECT_DATA af;

    if (!is_affected(ch, gsn_haste))
    {
      char_act("As you slide your arms into these bracers, they mold to your skin.", ch);
      char_act("Your hands and arms feel incredibly light.", ch);

      af.where = TO_AFFECTS;
      af.type = gsn_haste;
      af.duration = -2;
      af.level = ch->level;
      af.bitvector = AFF_HASTE;
      af.location = APPLY_DEX;
      af.modifier = 1 + (ch->level >= 18) + (ch->level >= 30) + (ch->level >= 45);
      affect_to_char(ch, &af);
    }
    return 0;
}

int remove_prog_bracer(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (is_affected(ch, gsn_haste))
    {
      affect_strip(ch, gsn_haste);
      char_act("Your hands and arms feel heavy again.", ch);
    }
    return 0;
}


int remove_prog_excalibur(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act("$p stops glowing.",ch,obj,NULL,TO_CHAR);
    act("$p stops glowing.",ch,obj,NULL,TO_ROOM);
    return 0;
}

bool death_prog_excalibur(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (number_percent()<25) {
        act_puts("$p starts to glow with a blue aura.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        act("$p starts to glow with a blue aura,",ch,obj,NULL,TO_ROOM);
        ch->hit = ch->max_hit;
        char_act("You feel much better.",ch);
        act("$n looks much better.",ch,NULL,NULL,TO_ROOM);
        return TRUE;
    }
    else return FALSE;
}

int speech_prog_excalibur(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char *speech = (char*) arg;

    if (!str_cmp(speech, "sword of acid")
    &&  (ch->fighting)
    &&  ((get_eq_char(ch, WEAR_WIELD) == obj) ||
         (get_eq_char(ch,WEAR_SECOND_WIELD) == obj))) {
        char_act("Acid sprays from the blade of Excalibur.", ch);
        act("Acid sprays from the blade of Excalibur.",
            ch, NULL, NULL, TO_ROOM);
        spell_acid_blast(gsn_acid_blast, ch->level,
                 ch, ch->fighting, TARGET_CHAR);
        WAIT_STATE(ch, 2 * PULSE_VIOLENCE);
    }
    return 0;
}

bool sac_prog_excalibur(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act("The gods are infuriated!",ch,NULL,NULL,TO_CHAR);
    act("The gods are infuriated!",ch,NULL,NULL,TO_ROOM);
    damage(ch,ch,
         (ch->hit - 1) > 1000? 1000 : (ch->hit - 1),
         TYPE_HIT,DAM_HOLY, TRUE);
    ch->gold = 0;
    return TRUE;
}

int fight_prog_ranger_staff(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if ((get_eq_char(ch,WEAR_WIELD) == obj
    ||   get_eq_char(ch,WEAR_SECOND_WIELD) == obj)
    &&   number_percent() < 10) {
        char_act("Your ranger's staff glows blue!", ch);
        act("$n's ranger's staff glows blue!", ch, NULL, NULL, TO_ROOM);
        if (ch->level < 75)
            obj_cast_spell(gsn_cure_critical, (ch->level*3)/2, ch, ch, obj);
        else if (number_bits(1) == 0)
            obj_cast_spell(gsn_cure_critical, ch->level*2, ch, ch, obj);
        else
            obj_cast_spell(sn_lookup("superior heal"), ch->level, ch, ch, obj);

    }
    return 0;
}

int fight_prog_sub_weapon(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch,WEAR_WIELD) == obj && number_percent() < 30)
    {
      if (((float) ch->hit)/((float) ch->max_hit) > 0.9)
        char_act("Your weapon whispers, 'You're doing great!'", ch);
      else if (((float) ch->hit)/((float) ch->max_hit) > 0.6)
        char_act("Your weapon whispers, 'Keep up the good work!'", ch);
      else if (((float) ch->hit)/((float) ch->max_hit) > 0.4)
          char_act("Your weapon whispers, 'You can do it!'", ch);
      else char_act("Your weapon whispers, 'Run away! Run away!'", ch);
    }
    return 0;
}

bool death_prog_ranger_staff(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your ranger's staff disappears.", ch);
    act("$n's ranger's staff disappears.",ch,NULL,NULL,TO_ROOM);
    extract_obj(obj);
    return 0;
}

int get_prog_spec_weapon(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name)) {
        if (IS_AFFECTED(ch, AFF_POISON) && (dice(1,5)==1))  {
            char_act("Your weapon glows blue.", ch);
            act("$n's weapon glows blue.", ch, NULL, NULL, TO_ROOM);
            spell_cure_poison(gsn_cure_poison, 30, ch, ch, TARGET_CHAR);
            return 0;
        }

        if (IS_AFFECTED(ch, AFF_CURSE) && (dice(1,5)==1))  {
            char_act("Your weapon glows blue.", ch);
            act("$n's weapon glows blue.", ch, NULL, NULL, TO_ROOM);
            spell_remove_curse(gsn_remove_curse, 30, ch, ch, TARGET_CHAR);
            return 0;
        }
        char_act("Your weapon's humming gets lauder.", ch);
        return 0;
    }

    act("You are zapped by $p and drop it.", ch, obj, NULL, TO_CHAR);

    obj_from_char(obj);
    obj_to_room(obj, ch->in_room);

    switch(dice(1, 10)) {
    case 1:
        spell_curse(gsn_curse, ch->level < 10 ? 1 : ch->level-9,
                ch, ch, TARGET_CHAR);
        break;
    case 2:
        spell_poison(gsn_poison, ch->level < 10 ? 1 : ch->level-9,
                 ch, ch, TARGET_CHAR);
        break;
    }
    return 0;
}

int get_prog_quest_obj(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name)) {
        if (IS_AFFECTED(ch, AFF_POISON) && (dice(1, 5) == 1)) {
            act("$p glows blue.", ch, obj, NULL, TO_ROOM);
            act_puts("$p glows blue.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            spell_cure_poison(gsn_cure_poison, 30, ch, ch, TARGET_CHAR);
            return 0;
        }

        char_act("Quest staff waits patiently to return.", ch);
        return 0;
    }

    act("You are zapped by $p and drop it.", ch, obj, NULL, TO_CHAR);

    obj_from_char(obj);
    obj_to_room(obj, ch->in_room);

    switch(dice(1, 10))  {
    case 1:
        spell_curse(gsn_curse, ch->level < 10? 1 : ch->level-9,
                ch, ch, TARGET_CHAR);
        break;
    case 2:
        spell_poison(gsn_poison, ch->level < 10? 1 : ch->level-9,
                 ch, ch, TARGET_CHAR);
        break;
    }
    return 0;
}

int speech_prog_kassandra(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char *speech = (char*) arg;

    if (!str_cmp(speech, "kassandra") && (get_eq_char(ch, WEAR_HOLD) == obj)
    && !IS_NPC(ch))
        obj_cast_spell(gsn_kassandra, ch->level, ch, ch, NULL);
    else if (!str_cmp(speech, "sebat") && (get_eq_char(ch, WEAR_HOLD) == obj)
    && !IS_NPC(ch))
        obj_cast_spell(gsn_sebat, ch->level, ch, ch, NULL);
    else if (!str_cmp(speech, "matandra") && (get_eq_char(ch, WEAR_HOLD) == obj)
    && (ch->fighting) && !IS_NPC(ch))
    {
      act("A blast of energy bursts from your hand toward $N!",
          ch,NULL,ch->fighting,TO_CHAR);
      act("A blast of energy bursts from $n's hand toward you!",
          ch,NULL,ch->fighting,TO_VICT);
      act("A blast of energy bursts from $n's hand toward $N!",
          ch,NULL,ch->fighting,TO_NOTVICT);
      obj_cast_spell(gsn_matandra, ch->level, ch, ch->fighting, NULL);
    }
    return 0;
}

int fight_prog_chaos_blade(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch, WEAR_WIELD) != obj
    && get_eq_char(ch, WEAR_SECOND_WIELD) != obj)
        return 0;

    switch(number_bits(4)) 
    {
/*  
 *    (sg)
        case 0:
        act("The chaotic blade trembles violently!",
            ch, NULL, NULL, TO_ROOM);
        char_act("Your chaotic blade trembles violently!", ch);
        obj_cast_spell(gsn_mirror, ch->level, ch, ch, obj);
        break;
*/
    case 1:
        act("The chaotic blade shakes a bit.", ch, NULL, NULL, TO_ROOM);
        char_act("Your chaotic blade shakes a bit.", ch);
        obj_cast_spell(gsn_garble, ch->level, ch, ch->fighting, obj);
        break;
    }
    return 0;
}

bool death_prog_chaos_blade(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your chaotic blade disappears.", ch);
    act("$n's chaotic blade disappears.",ch,NULL,NULL,TO_ROOM);
    extract_obj(obj);
    return 0;
}

int get_prog_heart(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->timer == 0)
        obj->timer = 24;
    return 0;
}

int fight_prog_snake(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if ((get_eq_char(ch, WEAR_WIELD) == obj) ||
        (get_eq_char(ch,WEAR_SECOND_WIELD) == obj))
    {
      switch(number_bits(7)) {
      case 0:
        act("One of the snake heads on your whip bites $N!",
            ch, NULL, ch->fighting, TO_CHAR);
        act("A snake from $n's whip strikes out and bites you!",
            ch, NULL, ch->fighting, TO_VICT);
        act("One of the snakes from $n's whip strikes at $N!",
            ch, NULL, ch->fighting, TO_NOTVICT);
        obj_cast_spell(gsn_poison, ch->level, ch, ch->fighting, obj);
        break;
      case 1:
        act("One of the snake heads on your whip bites $N!", ch, NULL,
            ch->fighting, TO_CHAR);
        act("A snake from $n's whip strikes out and bites you!", ch, NULL,
            ch->fighting, TO_VICT);
        act("One of the snakes from $n's whip strikes at $N!", ch, NULL,
            ch->fighting, TO_NOTVICT);
        obj_cast_spell(gsn_weaken, ch->level, ch, ch->fighting, obj);
        break;
      }
    }
    return 0;
}

int fight_prog_shockwave(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if ((get_eq_char(ch, WEAR_WIELD) == obj)
    || (get_eq_char(ch,WEAR_SECOND_WIELD) == obj))
    switch(number_bits(2))
    {
    case 1:
      act("A bolt of lightning arcs out from your $p, hitting $N!",
        ch, obj, ch->fighting, TO_CHAR);
      act("A bolt of lightning crackles along $n's $p and arcs towards you!",
        ch, obj, ch->fighting, TO_VICT);
      act("A bolt of lightning shoots out from $n's $p, arcing towards $N!",
        ch, obj, ch->fighting, TO_NOTVICT);
      obj_cast_spell(gsn_lightning_bolt, LVL(ch), ch, ch->fighting, NULL);
      break;
    }
    return 0;
}

int wear_prog_ranger_staff(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name))
    {
        act_puts("Your $p starts glowing.",
            ch, obj, NULL, TO_CHAR, POS_SLEEPING);
        return 0;
    }
    char_act("You don't know to use this thing.", ch);
    unequip_char(ch, obj);
    char_act("Ranger staff slides off from your hand.", ch);
    obj_from_char(obj);
    obj_to_room(obj, ch->in_room);
    return 0;
}

int wear_prog_coconut(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act("You start to bang the coconut shells together.",ch,NULL,NULL,TO_CHAR);
    act("You hear a sound like horses galloping and you mount your steed.",
        ch, NULL, NULL, TO_CHAR);
    act("$n pretends to mount an invisible horse.",
        ch,NULL,NULL,TO_ROOM);
    return 0;
}

int entry_prog_coconut(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->carried_by != NULL)
    if (get_eq_char(obj->carried_by, WEAR_HOLD) == obj)
    act("$n gallops in on his invisible steed, banging two coconuts together.",
        obj->carried_by, NULL, NULL, TO_ROOM);
    return 0;
}

int greet_prog_coconut(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->carried_by != NULL)
    {
      if (get_eq_char(obj->carried_by, WEAR_HOLD) == obj &&
            obj->carried_by != ch)
        act("You hear the sound of galloping horses.", ch, NULL, NULL, TO_CHAR);
    }
    else
    char_act("$p beckons with the faint sound of galloping horses.", ch);
    return 0;
}

int get_prog_coconut(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("You hold the coconut up to your ear and suddenly you hear the faint roar of galloping horses.", ch);
    act("$n holds a coconut up to $gn{his} ear.", ch, NULL, NULL, TO_ROOM);
    return 0;
}

int remove_prog_coconut(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("The sounds of horses fade away.", ch);
    act("$n pretends to dismount a horse.", ch, NULL, NULL, TO_ROOM);
    return 0;
}

int fight_prog_firegauntlets(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    int dam;

    if (!(get_eq_char(ch, WEAR_WIELD) == NULL  
    && get_eq_char(ch, WEAR_SECOND_WIELD) == NULL))
        return 0;

    if (get_eq_char(ch, WEAR_HANDS) != obj)
        return 0;

    if (IS_NPC(ch))
        return 0;

    if (number_percent() < 50)  
    {
        dam = number_percent() / 2 + 30 + 2 * LVL(ch);
        if IS_NPC(ch->fighting) dam = dam * 2;
        act("Your gauntlets burns $N's face!", ch, NULL, ch->fighting, TO_CHAR);
        act("$n's gauntlets burns $N's face!", ch, NULL, ch->fighting, TO_NOTVICT);
        act("$N's gauntlets burns your face!", ch->fighting, NULL, ch, TO_CHAR);
        damage(ch, ch->fighting, dam/2, gsn_burning_hands, DAM_FIRE, TRUE);
        if (ch == NULL || ch->fighting == NULL)
            return 0;
        fire_effect(ch->fighting, obj->level/2, dam/2, TARGET_CHAR);
    }
    return 0;
}

int wear_prog_firegauntlets(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your hands warm up by the gauntlets.", ch);
    return 0;
}

int remove_prog_firegauntlets(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your hands cool down.", ch);
    return 0;
}

int fight_prog_armbands(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    int dam;
    if (get_eq_char(ch, WEAR_ARMS) != obj)
        return 0;

    if (IS_NPC(ch))
        return 0;

    if (number_percent() < 40)
    {
        dam = number_percent()/4*LVL(ch);
        act("Your armbands burns $N's face!", ch, NULL, ch->fighting, TO_CHAR);
        act("$n's armbands burns $N's face!", ch, NULL, ch->fighting, TO_NOTVICT);
        act("$N's armbands burns your face!", ch->fighting, NULL, ch, TO_CHAR);
/*        obj_cast_spell(gsn_burning_hands, ch->level, ch, ch->fighting, NULL);*/
        damage(ch, ch->fighting, dam, gsn_burning_hands, DAM_FIRE, TRUE);
        if (ch == NULL || ch->fighting == NULL)
            return 0;
        fire_effect(ch->fighting, ch->fighting->level*1.50, dam, TARGET_CHAR);
    }
    return 0;
}

int wear_prog_armbands(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your arms warm up by the armbands of the volcanoes.", ch);
    return 0;
}

int remove_prog_armbands(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your arms cool down again.", ch);
    return 0;
}


int get_prog_rodacid(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act("Rod glows {Bblue{z and a blast of acid hits you!", ch, NULL, ch, TO_CHAR);
    act("Rod glows {Bblue{z and a blast of acid hits $N!", ch, NULL, ch, TO_NOTVICT);
    obj_cast_spell(gsn_acid_blast, ch->level, ch, ch, NULL);
    return 0;
}

int fight_prog_rodacid(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch, WEAR_HOLD) != obj)
        return 0;

    if (IS_NPC(ch))
        return 0;

    if (number_percent() < 10)
    {
        act("Your rod glows {Rred{z and a blast of acid hits $N!",
            ch, NULL, ch->fighting, TO_CHAR);
        act("$n's rod glows {Rred{z and a blast of acid hits $N!",
            ch, NULL, ch->fighting, TO_NOTVICT);
        act("$N's rod glows {Rred{z and a blast of acid hits you!",
            ch->fighting, NULL, ch, TO_CHAR);
        obj_cast_spell(gsn_acid_blast, LVL(ch)/1.5+10, ch, ch->fighting, NULL);
    }
    return 0;
}

int wear_prog_rodacid(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your rod glows {Ggreen{z.", ch);
    return 0;
}

int remove_prog_rodacid(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your rod stop glowing.", ch);
    return 0;
}

int fight_prog_demonfireshield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    int dam;

    if (get_eq_char(ch, WEAR_SHIELD) != obj)
        return 0;

    if (IS_NPC(ch))
        return 0;

    if (number_percent() < 15)
    {
        dam = number_percent()/2 + 5 * LVL(ch);
        act("A magical hole appears in your shield !", ch, NULL, ch->fighting, TO_CHAR);
        act("Your shield burns $N's face!", ch, NULL, ch->fighting, TO_CHAR);
        act("$n's shield burns $N's face!", ch, NULL, ch->fighting, TO_NOTVICT);
        act("$N's shield burns your face!", ch->fighting, NULL, ch, TO_CHAR);
        damage(ch, ch->fighting, dam, gsn_demonfire, DAM_FIRE, TRUE);
        if (ch == NULL || ch->fighting == NULL)
         return 0;
        fire_effect(ch->fighting, obj->level,dam, TARGET_CHAR);
    }
    return 0;
}

int wear_prog_demonfireshield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your hands warm up by the fire shield.", ch);
    return 0;
}

int remove_prog_demonfireshield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("Your hands cool down.", ch);
    return 0;
}

int fight_prog_rose_shield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!((ch->in_room->sector_type != SECT_FIELD)
    || (ch->in_room->sector_type != SECT_FOREST)
    || (ch->in_room->sector_type != SECT_MOUNTAIN)
    || (ch->in_room->sector_type != SECT_HILLS)))
        return 0;

    if (get_eq_char(ch, WEAR_SHIELD) != obj)
        return 0;

    if (number_percent() < 90)
        return 0;

    char_act("The leaves of your shield grows suddenly.", ch);
    char_act("The leaves of shield surrounds you!.", ch->fighting);
    act("$n's shield of rose grows suddenly.", ch, NULL, NULL, TO_ROOM);
    obj_cast_spell(gsn_slow, ch->level, ch, ch->fighting, NULL);
    return 0;
}

int fight_prog_lion_claw(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (number_percent() < 90) return 0;

    if ((obj == get_eq_char(ch,WEAR_WIELD)) 
    || (obj == get_eq_char(ch,WEAR_SECOND_WIELD)))
    {
        char_act("The nails of your claw appears from its fingers.", ch);
        act_puts("the nails of $n's claw appears for an instant.", 
            ch, NULL, NULL, TO_ROOM, POS_DEAD);
        one_hit(ch, ch->fighting, TYPE_HIT, WEAR_WIELD);
        one_hit(ch, ch->fighting, TYPE_HIT, WEAR_WIELD);
        one_hit(ch, ch->fighting, TYPE_HIT, WEAR_WIELD);
        one_hit(ch, ch->fighting, TYPE_HIT, WEAR_WIELD);
        char_act("The nails of your claw disappears.", ch);
        act_puts("the nails of $n's claw disappears suddenly.", 
            ch, NULL, NULL, TO_ROOM, POS_DEAD);
    }
    return 0;
}

int speech_prog_ring_ra(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char *speech = (char*) arg;

    if (!str_cmp(speech, "punish")
    && (ch->fighting) 
    &&
    ((get_eq_char(ch,WEAR_FINGER_L) == obj) || (get_eq_char(ch,WEAR_FINGER_R) == obj)))
    {
        char_act("An electrical arc sprays from the ring.", ch);
        act("An electrical arc sprays from the ring.", ch, NULL, NULL, TO_ROOM);
        obj_cast_spell(gsn_lightning_breath, ch->level, ch, ch->fighting, NULL);
        WAIT_STATE(ch, 2 * PULSE_VIOLENCE);
    }
    return 0;
}

int wear_prog_eyed_sword(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act("$p's eye opens.", ch, obj, NULL, TO_CHAR);
    act("$p's eye opens.", ch, obj, NULL, TO_ROOM);
    if (ch->level <= 10)                        obj->value[2] = 3;
    else if (ch->level > 10 && ch->level <= 20) obj->value[2] = 4;
    else if (ch->level > 20 && ch->level <= 30) obj->value[2] = 5;
    else if (ch->level > 30 && ch->level <= 40) obj->value[2] = 6;
    else if (ch->level > 40 && ch->level <= 50) obj->value[2] = 7;
    else if (ch->level > 50 && ch->level <= 60) obj->value[2] = 8;
    else if (ch->level > 60 && ch->level <= 70) obj->value[2] = 9;
    else if (ch->level > 70 && ch->level <= 80) obj->value[2] = 10;
    else                                        obj->value[2] = 11;
    obj->level = ch->level;
    return 0;
}

int wear_prog_katana_sword(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->pIndexData->item_type == ITEM_WEAPON
    &&  IS_WEAPON_STAT(obj, WEAPON_KATANA)) 
    {
        if (!str_cmp(obj->owner, ch->name)) 
        {
            obj->value[1] = 2 + (ch->level-1) / 5;
            obj->value[2] = 6;
            obj->level = ch->level;
            char_act("You feel your katana like a part of you!", ch);
        } else 
        {
            obj->value[1] = -1;
            obj->value[2] = -1;
            char_act("You feel it isn't your weapon!", ch);
        }
    }
    return 0;
}


int wear_prog_snake(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act_puts("Snakes of whip starts to breath a poisonous air.", 
        ch, obj, NULL, TO_CHAR, POS_DEAD);
    act_puts("Snakes of whip starts to breath a poisonous air.", 
        ch, obj, NULL, TO_ROOM, POS_DEAD);
    if (ch->level <= 10)                        obj->value[2] = 3;
    else if (ch->level > 10 && ch->level <= 20) obj->value[2] = 4;
    else if (ch->level > 20 && ch->level <= 30) obj->value[2] = 5;
    else if (ch->level > 30 && ch->level <= 40) obj->value[2] = 6;
    else if (ch->level > 40 && ch->level <= 50) obj->value[2] = 7;
    else if (ch->level > 50 && ch->level <= 60) obj->value[2] = 8;
    else if (ch->level > 60 && ch->level <= 70) obj->value[2] = 9;
    else if (ch->level > 70 && ch->level <= 80) obj->value[2] = 10;
    else                                        obj->value[2] = 11;
    return 0;
}


int remove_prog_snake(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act_puts("Snakes of whip slowly melds to non-living skin.", 
        ch, obj, NULL, TO_CHAR, POS_DEAD);
    act_puts("Snakes of whip slowy melds to non-living skin.", 
        ch, obj, NULL, TO_ROOM, POS_DEAD);
    return 0;
}

int get_prog_snake(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act("You feel as if snakes of whip moved.", ch, obj, NULL, TO_CHAR);
    return 0;
}

int wear_prog_fire_shield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    AFFECT_DATA af;

    if (strstr(mlstr_mval(obj->ed->description), "cold") != NULL)  
    {
        if (!is_affected(ch, gsn_fire_shield))
        {
            char_act("As you wear shield, you become resistive to cold.", ch);

            af.where        = TO_RESIST;
            af.type         = gsn_fire_shield;
            af.duration     = -2;
            af.level        = ch->level;
            af.bitvector    = DAM_COLD;
            af.location     = APPLY_NONE;
            af.modifier     = 20;
            affect_to_char(ch, &af);
        }
    } else
    {
        if (!is_affected(ch, gsn_fire_shield))
        {
            char_act("As you wear shield, you become resistive to fire.", ch);

            af.where        = TO_RESIST;
            af.type         = gsn_fire_shield;
            af.duration     = -2;
            af.level        = ch->level;
            af.bitvector    = DAM_FIRE;
            af.location     = APPLY_NONE;
            af.modifier     = 20;
            affect_to_char(ch, &af);
        }
    }
    return 0;
}

int remove_prog_fire_shield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (is_affected(ch, gsn_fire_shield)) 
    {
        affect_strip(ch, gsn_fire_shield);
        if (strstr(mlstr_mval(obj->ed->description), "cold") != NULL)
            char_act("You have become normal to cold attacks.", ch);
        else
            char_act("You have become normal to fire attacks.", ch);
    }
    return 0;
}

int wear_prog_quest_weapon(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name))  
    {
        char_act("Your weapon starts glowing.", ch);
             if (                  ch->level <= 20) obj->value[2] = 3;
        else if (ch->level > 20 && ch->level <= 30) obj->value[2] = 4;
        else if (ch->level > 30 && ch->level <= 40) obj->value[2] = 5;
        else if (ch->level > 40 && ch->level <= 50) obj->value[2] = 6;
        else if (ch->level > 50 && ch->level <= 60) obj->value[2] = 8;
        else if (ch->level > 60 && ch->level <= 70) obj->value[2] = 10;
        else if (ch->level > 70 && ch->level <= 80) obj->value[2] = 11;
        else                                        obj->value[2] = 12;
        obj->level = ch->level;
        return 0;
    }

    act("You are zapped by $p and drop it.", ch, obj, NULL, TO_CHAR);

    obj_from_char(obj);
    obj_to_room(obj, ch->in_room);
    return 0;
}

int get_prog_quest_reward(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name))  
    {
        act_puts("Your $p starts glowing.", ch, obj, NULL, TO_CHAR, POS_SLEEPING);
        return 0;
    }

    if (!IS_IMMORTAL(ch))
    {
        obj_from_char(obj);
        obj_to_room(obj, ch->in_room);

        act("You are zapped by $p and drop it.", ch, obj, NULL, TO_CHAR);
        act("$n is zapped by $p and drops it.", ch, obj, NULL, TO_ROOM);
        return 3; //  get all     (  )   
                  //       
     }
    
     return 0;
}

int wear_prog_unique(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name))
        act_puts("$p  {B{z ", 
            ch, obj, NULL, TO_CHAR, POS_DEAD);
    else 
    {
        obj_from_char(obj);
        obj_to_room(obj, ch->in_room);
        
        act("   $p   .", ch, obj, NULL, TO_CHAR);
        act("$n   $p   .", ch, obj, NULL, TO_ROOM);
    }
    return 0;
}


int wear_prog_ruler_shield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    clan_t *clan = clan_lookup(ch->clan);

    if (!clan || str_cmp(clan->name, "rulers")) 
    {
        act("   $p   .",
            ch, obj, NULL, TO_CHAR);
        act("$n   $p   .",
            ch, obj, NULL, TO_ROOM);
        obj_from_char(obj);
        obj_to_room(obj, ch->in_room);
    }
    return 0;
}

int fight_prog_swordbreaker(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim;
    OBJ_DATA *wield;

    victim = ch->fighting;

//    if((wield = get_eq_char(victim, WEAR_WIELD)) == NULL)
        return 0;

    if ((get_eq_char(ch, WEAR_WIELD) == obj
    || get_eq_char(ch, WEAR_SECOND_WIELD) == obj)
    && number_percent() < 10)
    {
        if (wield->pIndexData->limit != -1
        || IS_OBJ_STAT(wield, ITEM_INDESTRUCTABLE))
        {
            act("    $N,  $gN{}   .",
                ch, NULL, victim, TO_CHAR);
            act("$n   ϣ ,    .",
                ch, NULL, victim, TO_VICT);
            act("$n    $N,  $gN{}   .",
                ch, NULL, victim, TO_NOTVICT);
            return 0;
        }

        act("You {Wcleaved{x $N's sword into two.",
            ch, NULL, victim, TO_CHAR);
        act("$n {Wcleaved{x your sword into two.",
            ch, NULL, victim, TO_VICT);
        act("$n {Wcleaved{x $N's sword into two.",
            ch, NULL, victim, TO_NOTVICT);
        extract_obj(get_eq_char(victim, WEAR_WIELD));
    }
    return 0;
}

int get_prog_holycross(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name))
    {
        act_puts(" $p  {W{z .",
            ch, obj, NULL, TO_CHAR, POS_SLEEPING);
        return 0;
    }

    act("   $p  p .", ch, obj, NULL, TO_CHAR);
    act("$n   $p  p .", ch, obj, NULL, TO_ROOM);
    obj_from_char(obj);
    obj_to_room(obj, ch->in_room);

    if (IS_EVIL(ch))
        obj_cast_spell(sn_lookup("dispel evil"),
            obj->level * 3 / 2, ch, ch, NULL);
    else if (IS_NEUTRAL(ch))
        obj_cast_spell(sn_lookup("lightning bolt"),
            obj->level * 3 / 2, ch, ch, NULL);
    return 0;
}

int fight_prog_holycross(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch, WEAR_NECK_1) == obj)
        switch(number_bits(4))
        {
        case 0:
            if (IS_EVIL(ch->fighting))
            {
                act_puts(" $p  {Y{x .",
                    ch, obj, NULL, TO_CHAR, POS_RESTING);
                obj_cast_spell(sn_lookup("dispel evil"),
                    LVL (ch), ch, ch->fighting, NULL);
            }
            break;
        case 1:
        case 2:
        case 3:
            if (!is_affected(ch, gsn_positive_luck))
            {
                act_puts(" $p  {R{x .",
                    ch, obj, NULL, TO_CHAR, POS_RESTING);
                obj_cast_spell(sn_lookup("positive luck"),
                    LVL (ch), ch, ch, NULL);
            }
            break;
        }
        return 0;
}

int wear_prog_holycross(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name))
    {
        act_puts("$p  {W{z ",
            ch, obj, NULL, TO_CHAR, POS_DEAD);

        if (ch->move < ch->max_move)
            obj_cast_spell(sn_lookup("refresh"),
                ch->level * 3, ch, ch, NULL);
    } else
    {
        act("   $p   .", ch, obj, NULL, TO_CHAR);
        act("$n   $p   .", ch, obj, NULL, TO_ROOM);
        obj_from_char(obj);
        obj_to_room(obj, ch->in_room);
    }
    return 0;
}
int get_prog_unholycross(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name))
    {
        act_puts(" $p  {r{z .",
            ch, obj, NULL, TO_CHAR, POS_SLEEPING);
        return 0;
    }

    act("   $p  p .", ch, obj, NULL, TO_CHAR);
    act("$n   $p  p .", ch, obj, NULL, TO_ROOM);
    obj_from_char(obj);
    obj_to_room(obj, ch->in_room);

    if (IS_GOOD(ch))
        obj_cast_spell(sn_lookup("dispel good"),
            obj->level * 3 / 2, ch, ch, NULL);
    else if (IS_NEUTRAL(ch))
        obj_cast_spell(sn_lookup("lightning bolt"),
            obj->level * 3 / 2, ch, ch, NULL);
    return 0;
}

int fight_prog_unholycross(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch, WEAR_NECK_1) == obj)
    switch(number_bits(4))
    {
        case 0:
            if (IS_GOOD(ch->fighting))
            {
                act_puts(" $p  {r{x .",
                    ch, obj, NULL, TO_CHAR, POS_RESTING);
                obj_cast_spell(sn_lookup("dispel good"),
                    LVL (ch), ch, ch->fighting, NULL);
            }
            break;
        case 1:
        case 2:
        case 3:
            if (!is_affected(ch->fighting, gsn_negative_luck))
            {
                act_puts(" $p  {y{x .",
                    ch, obj, NULL, TO_CHAR, POS_RESTING);
                obj_cast_spell(sn_lookup("negative luck"),
                    LVL (ch), ch, ch->fighting, NULL);
            }
            break;
    }
    return 0;
}

int wear_prog_unholycross(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name))
    {
        act_puts("$p  {r{z ",
            ch, obj, NULL, TO_CHAR, POS_DEAD);
    if (ch->move < ch->max_move)
        obj_cast_spell(sn_lookup("refresh"),
            ch->level * 3, ch, ch, NULL);
    } else
    {
        act("   $p   .", ch, obj, NULL, TO_CHAR);
        act("$n   $p   .", ch, obj, NULL, TO_ROOM);
        obj_from_char(obj);
        obj_to_room(obj, ch->in_room);
    }
    return 0;
}

int get_prog_bookcrom(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act_puts("$p  {W{z     .",
        ch, obj, NULL, TO_CHAR, POS_DEAD);
    act("$p  {W{z     .",
        ch, obj, NULL, TO_ROOM);
    damage(ch, ch, ch->hit - 1, TYPE_HIT, DAM_ENERGY, TRUE);
    extract_obj(obj);
    return 0;
}

int fight_prog_robehealer(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (ch->hit >= ch->max_hit)
        return 0;

    if (obj->wear_loc == WEAR_NONE)
        return 0;

    switch(number_bits(6))
    {
    case 2: if (obj->cost > 0)
    {
        act_puts("{G̣ {z   $p.", 
            ch, obj, NULL, TO_CHAR, POS_DEAD);
        spell_heal(sn_lookup("heal"), 
            ch->level, ch, ch, TARGET_CHAR);
        if (obj->cost > 2)
            obj->cost -= 2;
        else
            obj->cost = 0;
    }
    break;
    case 6: if (obj->cost > 0)
    {
        act_puts("{C {z   $p.", 
            ch, obj, NULL, TO_CHAR, POS_DEAD);
        spell_heal(sn_lookup("master healing"), 
            ch->level, ch, ch, TARGET_CHAR);
        if(obj->cost > 10)
            obj->cost -= 10;
        else
            obj->cost = 0;
    }
    break;
    }

    if (obj->cost == 0)
    {
        act_puts("$p  {W- {z  .", 
            ch, obj, NULL, TO_CHAR, POS_DEAD);
        extract_obj(obj);
    }
    return 0;
}

// GrayMage's Part

int fight_prog_heal(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (ch->hit >= ch->max_hit)
        return 0;

    if (obj->wear_loc == WEAR_NONE)
        return 0;

    switch(number_bits(4))
    {
    case 2:
        act_puts("{G̣ {z   $p.", 
            ch, obj, NULL, TO_CHAR, POS_DEAD);
        spell_heal(sn_lookup("heal"), 
            ch->level, ch, ch, TARGET_CHAR);
    break;
    case 4:
        act_puts("{C {z   $p.", 
            ch, obj, NULL, TO_CHAR, POS_DEAD);
        spell_heal(sn_lookup("master healing"), 
            ch->level, ch, ch, TARGET_CHAR);
    break;
    }
    return 0;
}

int wear_prog_cathead(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("     .", ch);
    return 0;
}
    
int remove_prog_cathead(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    char_act("   .", ch);
    return 0;
}

int fight_prog_cathead(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch, WEAR_FACE) != obj)
        return 0;
        
    switch(number_bits(5))
    {
    case 3:
        act("    {R{z.\n", ch, obj, NULL, TO_CHAR);
        act("    {R{z.\n", ch, obj, NULL, TO_ROOM);
        obj_cast_spell(gsn_chill_touch, ch->level, ch, ch->fighting, NULL);
        break;
    }
    return 0;
}   
                                                         
int fight_prog_vorpalblade(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim;
/*
    if (IS_NPC(ch))
        return 0;
*/
    if ((get_eq_char(ch, WEAR_WIELD) != obj)
    && (get_eq_char(ch, WEAR_SECOND_WIELD) !=obj))
        return 0;

    victim = ch->fighting;
    if (number_percent() < 80
    && !IS_IMMORTAL(victim)
    && !IS_SET (victim->abilities, EA_IMMUN_VORPAL)) 
    {
        act("$p makes an huge arc in the air, chopping $n's head OFF!",
            victim, obj, NULL, TO_ROOM);
        act("$p whistles in the air, chopping your head OFF!",
            victim, obj, NULL, TO_CHAR);
        char_act("{R {x!!!\n", victim);
        handle_death(ch, victim);
    }
    return 0;
}

int fight_prog_lightsabervorpal(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim;
    OBJ_DATA *wield;

    if (IS_NPC(ch))
        return 0;

    if (get_eq_char(ch, WEAR_WIELD) != obj)
        return 0;

    victim = ch->fighting;

    if (number_percent() < get_curr_stat(ch, STAT_LCK) / 5
    && IS_NPC(victim) && IS_AFFECTED(victim, AFF_CHARM) 
    && !IS_SET (victim->abilities, EA_IMMUN_VORPAL))
    {
        act("$p makes an huge arc in the air, chopping $n's head OFF!",
            victim, obj, NULL, TO_ROOM);
        act("$p whistles in the air, chopping your head OFF!",
            victim, obj, NULL, TO_CHAR);
        char_act("{R {x!!!\n", victim);
        handle_death(ch, victim);
    } 
    if (number_percent() > get_curr_stat(ch, STAT_LCK) / 10)
        return 0;

    if ((wield = get_eq_char(victim, WEAR_WIELD)) == NULL)
        return 0;

    if (wield->pIndexData->limit != -1
    || IS_OBJ_STAT(wield, ITEM_INDESTRUCTABLE)
    || check_material(wield, "unique")
    || IS_WEAPON_STAT(wield, WEAPON_KATANA))
    {
        return 0;
    } else
    {
        act("You {Wcleaved{x $N's wield into two.",
            ch, NULL, victim, TO_CHAR);
        act("$n {Wcleaved{x your wield into two.",
            ch, NULL, victim, TO_VICT);
        act("$n {Wcleaved{x $N's wield into two.",
            ch, NULL, victim, TO_NOTVICT);
        extract_obj(get_eq_char(victim, WEAR_WIELD));
    }
    return 0;
}

int fight_prog_axevorpal(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    CHAR_DATA *victim;
    int chance;
    int chance1;

    if (IS_NPC(ch)) return 0;

    if (ch->class != CLASS_WARRIOR) return 0;

    if ((get_eq_char(ch, WEAR_WIELD) != obj)
    && (get_eq_char(ch, WEAR_SECOND_WIELD) !=obj))
        return 0;

    if (ch->fighting == NULL)
        return 0;

    victim = ch->fighting;
    chance = get_skill(ch, gsn_axe) +
        get_curr_stat(ch, STAT_STR) * 4 - (25-get_curr_stat(ch, STAT_DEX)*10);

    if (victim->level > (ch->level + 20) && !is_specialized (ch, SPEC_AXE))
        chance /= 10;

    if (IS_NPC(victim) && IS_AFFECTED(victim, AFF_CHARM))
        chance *= 10;

    if (victim->level > (ch->level * 2) && IS_NPC(victim))
        chance /= 2;

    if (victim->level > (ch->level * 3) && IS_NPC(victim))
        chance = 0;

    chance1 = number_range(1, 20000);
    if (chance > chance1
    && !IS_IMMORTAL(victim)
    && !IS_CLAN_GUARD(victim)
    && !IS_SET (victim->abilities, EA_IMMUN_VORPAL))
    {
        if (!IS_NPC(victim) && chance / 10 < chance1) return 0;

        act("$p makes an huge arc in the air, chopping $n's head OFF!",
            victim, obj, NULL, TO_ROOM);
        act("$p whistles in the air, chopping your head OFF!",
            victim, obj, NULL, TO_CHAR);
        char_act("{R {x!!!\n", victim);
        handle_death(ch, victim);
    }
    return 0;
}

int get_prog_mine(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    int dam;

    dam = number_range(ch->level*obj->level / 10, ch->level*obj->level * 2);

    if (saves_spell(ch->level, ch, DAM_FIRE))
        dam /= 4;

    if (IS_SET(ch->plr_flags, PLR_GHOST) || (ch->level < 30))
        dam = 0;

    if ((ch->level > (obj->level - 10)) && dam != 0)
    {
        act(" ң -   - !", ch, NULL, ch, TO_CHAR);
        act("$N ң -   - !", ch, NULL, ch, TO_NOTVICT);
        damage(ch, ch, dam, TYPE_HIT, DAM_FIRE, TRUE);
    }

    extract_obj(obj);
    return 0;
}

bool death_prog_angel(OBJ_DATA *obj, CHAR_DATA *victim, const void *arg)
{
    CHAR_DATA *ch = (CHAR_DATA *) arg;

    act("$p     .", victim,obj,NULL,TO_CHAR);
    act("$p  $n   .", victim,obj,NULL,TO_ROOM);

    extract_obj(obj);

    while (victim->affected)
        affect_remove(victim, victim->affected);

    // todo: to avoid sudden attack we have to execute 
    // remove_mind for EACH mobile in ch->in_room
    if (ch && IS_NPC(ch) && !IS_SET (ch->pIndexData->act, ACT_CLAN_GUARD))
    {
        remove_mind(ch, victim->name);
        ch->last_fought = NULL;
    }

    stop_fighting(victim, TRUE);

    RESET_FIGHT_TIME(ch);

    victim->last_death_time = current_time;

    victim->hit     = (victim->max_hit/2);
    victim->mana    = (victim->max_mana/5);
    victim->move    = (victim->max_move/100);

    return 1;
}

int fight_prog_angel(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch,WEAR_LIGHT) == obj)
    {
        if (number_percent() < 40)
        {
            act("Your $p glows {Cbright blue{x!",ch, obj, NULL, TO_CHAR);
            act("$n's $p glows {Cbright blue{x!",ch,obj,NULL,TO_ROOM);
            obj_cast_spell(gsn_cure_critical,ch->level,ch,ch,obj);
            return 0;
        } else if (number_percent() > 60)
        {
            act("Your $p glows {cblue{x!",ch, obj, NULL, TO_CHAR);
            act("$n's $p glows {cblue{x!",ch,obj,NULL,TO_ROOM);
            obj_cast_spell(gsn_cure_serious,ch->level,ch,ch,obj);
        }
    }
    return 0;
}

int fight_prog_cape(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->wear_loc == WEAR_NONE)
        return 0;

    if (number_percent() < 25)
    {
        if (IS_AFFECTED(ch, AFF_BLIND)) 
        {
            act("You are cured by $p.", ch, obj, NULL, TO_CHAR);
            spell_cure_blindness(sn_lookup("cure blindness"),
                LVL(ch) + 10, ch, ch, TARGET_CHAR);
        }
    }
    return 0;
}

int wear_prog_owner(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (!str_cmp(obj->owner, ch->name))  
    {
        act_puts("Your $p starts glowing.", ch, obj, NULL, TO_CHAR, POS_SLEEPING);
        return 0;
    }

    act("You are zapped by $p and drop it.", ch, obj, NULL, TO_CHAR);
    act("$n is zapped by $p and drops it.", ch, obj, NULL, TO_ROOM);

    unequip_char(ch, obj);
    obj_from_char(obj);
    obj_to_room(obj, ch->in_room);
    return 0;
}

int fight_prog_bonus(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->wear_loc == WEAR_NONE)
        return 0;

    if (ch->hit < ch->max_hit)
    {
        act("You $p glows {Cblue{x.", ch, obj, NULL, TO_CHAR);
/*        if (number_percent () < get_curr_stat(ch, STAT_LCK) / 2)
            obj_cast_spell(gsn_cure_critical, (ch->level*3)/2, ch, ch, obj);
        else if (number_percent () < get_curr_stat(ch, STAT_LCK) / 2)
            obj_cast_spell(gsn_cure_serious, (ch->level*3)/2, ch, ch, obj);
        else if (number_percent () < get_curr_stat(ch, STAT_LCK) / 2)
            obj_cast_spell(gsn_cure_light, (ch->level*3)/2, ch, ch, obj);
        else if (number_percent () < get_curr_stat(ch, STAT_LCK) / 2)
            spell_heal(sn_lookup("heal"), ch->level, ch, ch, TARGET_CHAR);
        else if (number_percent () < get_curr_stat(ch, STAT_LCK) / 2)
            obj_cast_spell(sn_lookup("superior heal"), ch->level, ch, ch, obj);
        else if (number_percent () < get_curr_stat(ch, STAT_LCK) / 2)
            obj_cast_spell(sn_lookup("master healing"), ch->level, ch, ch, obj);
        else
        {
*/
            ch->hit += LVL(ch) / 9 + dice(3, 8);
            ch->hit = UMIN(ch->hit, ch->max_hit);
/*
        }
*/
    }
    return 0;
}

int fight_prog_staff_ruling(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch, WEAR_HOLD) != obj)
        return 0;
    if (ch->fighting == NULL)
        return 0;

    if (number_percent() < 20)
    {
        act("You $p glows {Rbright red{x.", ch, obj, NULL, TO_CHAR);
        act("$n $p glows {Rbright red{x.", ch, obj, NULL, TO_ROOM);

        if (IS_GOOD(ch) && (IS_EVIL(ch->fighting)))
            obj_cast_spell(gsn_ray_of_truth, ch->level, ch, ch->fighting,NULL);
        else if (IS_EVIL(ch) && (IS_GOOD(ch->fighting)))
            obj_cast_spell(gsn_demonfire, ch->level, ch, ch->fighting,NULL);
        else if (IS_NEUTRAL(ch))
            obj_cast_spell(gsn_bluefire, ch->level, ch, ch->fighting,NULL);
        else
            act("There's no possible target for $p!", ch, obj, NULL, TO_CHAR);
    }
    return 0;
}

int fight_prog_staff_might(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch, WEAR_HOLD) != obj)
        return 0;
    if (ch->fighting == NULL)
        return 0;

    if (number_percent() < 40)
    {
        act("You $p glows {Rbright red{x.", ch, obj, NULL, TO_CHAR);
        act("$n $p glows {Rbright red{x.", ch, obj, NULL, TO_ROOM);
        obj_cast_spell(sn_lookup("earthquake"), ch->level*10, ch, ch->fighting,NULL);
    }
    return 0;
}

int wear_prog_dragon_egg(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    act("  $p  !", ch, obj, NULL, TO_CHAR);
    act(" $p  !  $n  .", ch, obj, NULL, TO_ROOM);
    obj_cast_spell(sn_lookup("call dragon"), ch->level, ch, ch, NULL);
    extract_obj(obj);
    return 0;
}

int fight_prog_loriel(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (ch->fighting == NULL)
        return 0;
    if (get_eq_char(ch, WEAR_HOLD) == obj
    && number_percent() < 20)
    {
        int dam;
        dam = number_percent() / 4 * LVL(ch);
        act("You $p burns $N's face.", ch, obj, ch->fighting, TO_CHAR);
        act("$N's $p burns your face!", ch->fighting, obj, ch, TO_CHAR);
        damage(ch, ch->fighting, dam, gsn_burning_hands, DAM_FIRE, TRUE);
        if (ch == NULL || ch->fighting == NULL)
            return 0;
        fire_effect(ch->fighting, ch->fighting->level*1.05, dam, TARGET_CHAR);
    }

    if (get_eq_char(ch, WEAR_HEAD) == obj
    && number_percent() < 20)
    {
        act("You $p glows {Cbright blue{x.", ch, obj, NULL, TO_CHAR);
        act("$n $p glows {Cbright blue{x.", ch, obj, NULL, TO_ROOM);
        if (ch->level < 75)
            obj_cast_spell(gsn_cure_critical, (ch->level*3)/2, ch, ch, obj);
        else if (number_bits(1) == 0)
            obj_cast_spell(sn_lookup("group heal"), ch->level*2, ch, ch, obj);
        else
            obj_cast_spell(sn_lookup("superior heal"), ch->level/10, ch, ch, obj);
    }
    return 0;
}

int fight_prog_magic_sword(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->wear_loc == WEAR_NONE)
        return 0;
    if (ch->fighting == NULL)
        return 0;
    if (number_percent() < 20)
    {
        act(" $p     $N .", 
            ch, obj, ch->fighting, TO_CHAR);
        act(" $N $p      !", 
            ch->fighting, obj, ch, TO_CHAR);
        obj_cast_spell(gsn_acid_blast, ch->level, ch, ch->fighting, obj);
    }
    return 0;
}

int fight_prog_fire_sword(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->wear_loc == WEAR_NONE)
        return 0;
    if (ch->fighting == NULL)
        return 0;
    if (number_percent() < 20)
    {
        act(" $p     $N .", 
            ch, obj, ch->fighting, TO_CHAR);
        act(" $N $p      !", 
            ch->fighting, obj, ch, TO_CHAR);
        obj_cast_spell(sn_lookup("fireball"), 
            ch->level + 40, ch, ch->fighting, obj);
    }
    return 0;
}

int fight_prog_ice_sword(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->wear_loc == WEAR_NONE)
        return 0;
    if (ch->fighting == NULL)
        return 0;
    if (number_percent() < 20)
    {
        act(" $p     $N .", 
            ch, obj, ch->fighting, TO_CHAR);
        act(" $N $p      !", 
            ch->fighting, obj, ch, TO_CHAR);
        obj_cast_spell(sn_lookup("iceball"), 
            ch->level + 40, ch, ch->fighting, obj);
    }
    return 0;
}

int fight_prog_dark_sword(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->wear_loc == WEAR_NONE)
        return 0;

    if (ch->fighting == NULL)
        return 0;

    if (number_percent() < 20)
    {
        act(" $p     $N .", 
            ch, obj, ch->fighting, TO_CHAR);
        act(" $N $p      !", 
            ch->fighting, obj, ch, TO_CHAR);
        obj_cast_spell(sn_lookup("hand of undead"), 
            LVL(ch) + 10, ch, ch->fighting, obj);
    }
    return 0;
}
int fight_prog_dark_mask(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (obj->wear_loc == WEAR_NONE)
        return 0;

    if (ch->fighting == NULL)
        return 0;

    if (number_percent() < 40)
    {
        act("Your $p glows blue.", ch, obj, NULL, TO_CHAR);
        act("$n's $p glows blue.", ch, obj, NULL, TO_ROOM);
        if (IS_AFFECTED(ch, AFF_BLIND))
            spell_cure_blindness(sn_lookup("cure blindness"),
                LVL(ch) * 2, ch, ch, TARGET_CHAR);
        if (IS_AFFECTED(ch, AFF_POISON))
            spell_cure_poison(gsn_cure_poison,
                LVL(ch) * 2, ch, ch, TARGET_CHAR);
        if (IS_AFFECTED(ch, AFF_CURSE))
            spell_remove_curse(gsn_remove_curse,
                LVL(ch) * 2, ch, ch, TARGET_CHAR);
        if (IS_AFFECTED(ch, AFF_PLAGUE))
            spell_cure_disease(sn_lookup("cure disease"),
                LVL(ch) * 2, ch, ch, TARGET_CHAR);
        if (IS_AFFECTED(ch, AFF_WEB)
        && number_percent() < str_app[IS_NPC(ch) ?
            20 : get_curr_stat(ch,STAT_STR)].tohit * 5)
        {
            affect_strip(ch, gsn_web);
            REMOVE_BIT(ch->affected_by, AFF_WEB);
        }
    }
    if (number_percent() < 60)
    {
        act("   $p    $N.",
            ch, obj, ch->fighting, TO_CHAR);
        act("   $p    !",
            ch->fighting, obj, ch, TO_CHAR);

        if (!IS_AFFECTED(ch->fighting, AFF_CURSE))
            obj_cast_spell(sn_lookup("curse"),
                LVL(ch) + 10, ch, ch->fighting, obj);
        else
            obj_cast_spell(sn_lookup("energy drain"),
                LVL(ch) * 10, ch, ch->fighting, obj);
    }
    return 0;
}

int fight_prog_haste_boots(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    int nhits;

    if (ch->fighting == NULL)
        return 0;

    if (get_eq_char(ch, WEAR_FEET) != obj)
        return 0;

    switch(number_bits(2))
    {
    case 0:
    case 1:
        act("$n .", ch, NULL, NULL, TO_ROOM);
        char_act("    !", ch);

        nhits = UMAX(1, LVL(ch)/30);

        while (nhits--)
        {
            one_hit(ch, ch->fighting, TYPE_UNDEFINED, WEAR_WIELD);
        }
        break;
    }
    return 0;
}

int fight_prog_crimson_banner(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{

    if (ch->fighting == NULL)
        return 0;

    if (get_eq_char(ch,WEAR_LIGHT) == obj)
    {
        if (ch->hit * 2 < ch->max_hit)
        {
            act("Your $p glows {Wwhite{x!", ch, obj, NULL, TO_CHAR);
            act("$n's $p glows {Wwhite{x!", ch, obj, NULL, TO_ROOM);

            ch->hit += LVL(ch) * 4;
            ch->hit = UMIN(ch->hit, ch->max_hit);
            return 0;
        }
        else if (number_percent() > 40
        && !IS_AFFECTED(ch->fighting, AFF_SLOW))
        {
            act("Your $p glows {rred{x!", ch, obj, NULL, TO_CHAR);
            act("$n's $p glows {rred{x!", ch, obj, NULL, TO_ROOM);

            obj_cast_spell(gsn_slow, LVL(ch)+10, ch, ch->fighting, NULL);
        } else
        {
            if (number_percent () < get_curr_stat(ch->fighting, STAT_LCK)
            && !IS_NPC(ch->fighting))
                return 0;

            act("Your $p glows {Ddark {rred{x!", ch, obj, NULL, TO_CHAR);
            act("$n's $p glows {Ddark {rred{x!", ch, obj, NULL, TO_ROOM);
            if (!IS_NPC(ch->fighting))
                obj_cast_spell(sn_lookup("lightning bolt"),
                    LVL(ch) * 3 / 2, ch, ch->fighting, NULL);
            else
                obj_cast_spell(sn_lookup("lightning bolt"),
                    LVL(ch) * 2, ch, ch->fighting, NULL);
        }
    }
    return 0;
}

int fight_prog_horn_of_ages(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (get_eq_char(ch, WEAR_HOLD) != obj)
        return 0;

    if (number_percent() < 10)
    {
        act("Your ballyhoo in $p!", ch, obj, NULL, TO_CHAR);
        act("$n ballyhoo in its $p!", ch, obj, NULL, TO_ROOM);
        if (ch->level < 75)
            obj_cast_spell(gsn_cure_critical, (ch->level*3)/2, ch, ch, obj);
        else if (number_bits(1) == 0)
            obj_cast_spell(sn_lookup("group heal"), ch->level, ch, ch, obj);
        else
            obj_cast_spell(sn_lookup("superior heal"), ch->level/10, ch, ch, obj);
    }
    return 0;
}

int fight_prog_plazma_cannon(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (ch->fighting == NULL)
        return 0;

    if (obj->wear_loc == WEAR_NONE)
        return 0;
    
    if (ch->hit < ch->max_hit / 2)
        obj_cast_spell(sn_lookup("superior heal"), LVL(ch) / 3 * 2, ch, ch, obj);
    else
    {
        if (number_percent () < get_curr_stat(ch->fighting, STAT_LCK) * 3
        && !IS_NPC(ch->fighting))
            return 0;

        act("Your $p seeking target!", ch, obj, NULL, TO_CHAR | ACT_VERBOSE);
        act("$n $p seeking target!", ch, obj, NULL, TO_ROOM | ACT_VERBOSE);
        spell_plasma_web(gsn_plasma_web, LVL(ch) / 3 * 2, ch, ch->fighting, TARGET_CHAR);
    }
    return 0;
}

int fight_prog_miniplazma_cannon(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    OBJ_DATA *gems;

    if (ch->fighting == NULL)
        return 0;

    if (obj->wear_loc == WEAR_NONE)
        return 0;

    for (gems = ch->carrying; gems != NULL; gems = gems->next_content)
        if (gems->pIndexData->vnum == OBJ_VNUM_GEMS)
            break;

    if (gems == NULL)
    {
        act("You need gems for $p!", ch, obj, NULL, TO_CHAR | ACT_VERBOSE);
        return 0;
    }

    if (ch->hit < ch->max_hit / 2)
        obj_cast_spell(sn_lookup("superior heal"), LVL(ch) / 2, ch, ch, obj);
    else
    {
        if (number_percent () < get_curr_stat(ch->fighting, STAT_LCK) * 3
        && !IS_NPC(ch->fighting))
            return 0;

        act("Your $p seeking target!", ch, obj, NULL, TO_CHAR | ACT_VERBOSE);
        act("$n $p seeking target!", ch, obj, NULL, TO_ROOM | ACT_VERBOSE);
        spell_plasma_web(gsn_plasma_web, LVL(ch) - 10, ch, ch->fighting, TARGET_CHAR);
    }
    if (ch->fighting == NULL)
        return 0;
    if (number_percent() + 10 > get_curr_stat(ch, STAT_LCK) * 3 
    && !IS_NPC(ch->fighting))
    {
        act("Your $p disappears.", ch, gems, NULL, TO_CHAR);
        obj_from_char(gems);
    }
    return 0;
}

int wear_prog_stone_skin(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    AFFECT_DATA af;

    if (!is_affected(ch, sn_lookup("stone skin")))
    {
        af.where     = TO_AFFECTS;
        af.type      = sn_lookup("stone skin");
        af.level     = ch->level;
        af.duration  = -2;
        af.location  = APPLY_AC;
        af.modifier  = -80;
        af.bitvector = 0;
        affect_to_char(ch, &af);
        act("$n's skin turns to stone.", ch, NULL, NULL, TO_ROOM);
        char_act("Your skin turns to stone.", ch);
    }
    return 0;
}

int remove_prog_stone_skin(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (is_affected(ch, sn_lookup("stone skin")))
    {
        affect_strip(ch, sn_lookup("stone skin"));
        char_act("Your skin feels soft again.", ch);
    }
    return 0;
}

int fight_prog_stone_skin(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    AFFECT_DATA af;

    if (obj->wear_loc == WEAR_NONE)
        return 0;

    if (!is_affected(ch, sn_lookup("stone skin"))
    && number_percent() < get_curr_stat(ch, STAT_LCK))
    {
        af.where     = TO_AFFECTS;
        af.type      = sn_lookup("stone skin");
        af.level     = ch->level;
        af.duration  = -2;
        af.location  = APPLY_AC;
        af.modifier  = -80;
        af.bitvector = 0;
        affect_to_char(ch, &af);
        act("$n's skin turns to stone.", ch, NULL, NULL, TO_ROOM);
        char_act("Your skin turns to stone.", ch);
    }
    return 0;
}

int wear_prog_field(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    AFFECT_DATA af;

    if (!is_affected(ch, gsn_field))
    {
        af.where        = TO_AFFECTS;
        af.type         = gsn_field;
        af.level        = ch->level;
        af.duration     = -2;
        af.location     = APPLY_SAVING_SPELL;
        af.bitvector    = 0;
        af.modifier     = -10;
        affect_to_char(ch, &af);
        act("$n   .", ch, NULL, NULL, TO_ROOM);
        char_act("   .", ch);
    }
    return 0;
}

int remove_prog_field(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (is_affected(ch, gsn_field))
    {
      affect_strip(ch, gsn_field);
      char_act("ϣ   .", ch);
    }
    return 0;
}
int wear_prog_shield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    AFFECT_DATA af;

    if (!is_affected(ch, gsn_shield))
    {
        af.where     = TO_AFFECTS;
        af.type      = gsn_shield;
        af.level     = ch->level;
        af.duration  = -2;
        af.location  = APPLY_AC;
        af.modifier  = - ch->level/3;
        af.bitvector = 0;
        affect_to_char(ch, &af);
        act("$n   .", ch, NULL, NULL, TO_ROOM);
        char_act("    .", ch);
    }
    return 0;
}
int remove_prog_shield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (is_affected(ch, gsn_shield))
    {
      affect_strip(ch, gsn_shield);
      char_act("   .", ch);
    }
    return 0;
}

int wear_prog_pshield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    AFFECT_DATA af;

    if (!is_affected(ch, gsn_protective_shield))
    {
        af.where     = TO_AFFECTS;
        af.type      = gsn_protective_shield;
        af.level     = ch->level;
        af.duration  = -2;
        af.location  = APPLY_AC;
        af.modifier  = 20;
        af.bitvector = 0;
        affect_to_char(ch, &af);
        act("$n is surrounded by a protective shield.", ch, NULL, NULL, TO_ROOM);
        char_act("You are surrounded by a protective shield.", ch);
    }
    return 0;
}
int remove_prog_pshield(OBJ_DATA *obj, CHAR_DATA *ch, const void *arg)
{
    if (is_affected(ch, gsn_protective_shield))
    {
      affect_strip(ch, gsn_protective_shield);
      char_act("The protective aura around your body fades away.", ch);
    }
    return 0;
}

