/* $Id: olc.h,v 1.666 2004/09/20 10:50:30 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 
 
/*
 * This is a header file for all the OLC files.  Feel free to copy it into
 * merc.h if you wish.  Many of these routines may be handy elsewhere in
 * the code.  -Jason Dinkel
 */

#ifndef _OLC_H_
#define _OLC_H_

DECLARE_DO_FUN(do_help                );

bool                run_olc_editor        (DESCRIPTOR_DATA *d);

typedef struct olc_cmd_t         olc_cmd_t;

typedef        bool OLC_FUN(CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd);
typedef        bool VALIDATE_FUN(CHAR_DATA *ch, const void *arg);

/*
 * Structure for an OLC editor command.
 */
struct olc_cmd_t
{
        char *                name;
        OLC_FUN *             olc_fun;
        int                   sec;
        void*                 arg1;
};

struct olced_t
{
        const char *        id;
        const char *        name;
        int                 sec;
        olc_cmd_t *         cmd_table;
};

#define DECLARE_OLC_FUN(fun)             OLC_FUN             fun
#define DECLARE_VALIDATE_FUN(fun)        VALIDATE_FUN        fun

#define OLC_FUN(fun)                bool fun(CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd)
#define VALIDATE_FUN(fun)           bool fun(CHAR_DATA *ch, const void *arg)

/* functions all cmd tables must have */
enum {
        FUN_CREATE,
        FUN_EDIT,
        FUN_TOUCH,

        FUN_FIRST = FUN_TOUCH,

        FUN_SHOW,
        FUN_LIST,

        FUN_MAX
};

extern const char ED_AREA       [];
extern const char ED_ROOM       [];
extern const char ED_OBJ        [];
extern const char ED_MOB        [];
extern const char ED_MPCODE     [];
extern const char ED_OPCODE     [];
extern const char ED_RPCODE     [];
extern const char ED_HELP       [];
extern const char ED_CLAN       [];
extern const char ED_MSG        [];
extern const char ED_CLASS      [];
extern const char ED_LANG       [];
extern const char ED_IMPL       [];
extern const char ED_EXPL       [];
extern const char ED_SOC        [];
extern const char ED_RACE       [];
extern const char ED_RELIGION   [];
extern const char ED_HOMETOWN   [];
extern const char ED_SKILL      [];
extern const char ED_COMMAND    [];
extern const char ED_ALIAS      [];
extern const char ED_SKILL_ALIAS[];
extern const char ED_PRICE      [];
extern const char ED_METEOR     [];
extern const char ED_SEC        [];
//extern const char ED_ARTEFACT   [];
extern const char ED_RIDDLE     [];
extern const char ED_IMMORTAL   [];
extern const char ED_MATERIAL   [];
extern const char ED_LIQUID     [];
extern const char ED_TATTOO     [];
extern const char ED_PAINT      [];
extern const char ED_RITUAL     [];

#define OLCED(ch) (ch->desc->olced)
#define IS_EDIT(ch, ed_id) (OLCED(ch) && OLCED(ch)->id == ed_id)

/*
 * Interpreter Table Prototypes
 */
extern olc_cmd_t        olc_cmds_area[];
extern olc_cmd_t        olc_cmds_room[];
extern olc_cmd_t        olc_cmds_obj[];
extern olc_cmd_t        olc_cmds_mob[];
extern olc_cmd_t        olc_cmds_mpcode[];
extern olc_cmd_t        olc_cmds_opcode[];
extern olc_cmd_t        olc_cmds_rpcode[];
extern olc_cmd_t        olc_cmds_help[];
extern olc_cmd_t        olc_cmds_clan[];
extern olc_cmd_t        olc_cmds_msg[];
extern olc_cmd_t        olc_cmds_class[];
extern olc_cmd_t        olc_cmds_lang[];
extern olc_cmd_t        olc_cmds_impl[];
extern olc_cmd_t        olc_cmds_expl[];
extern olc_cmd_t        olc_cmds_soc[];
extern olc_cmd_t        olc_cmds_race[];
extern olc_cmd_t        olc_cmds_religion[];
extern olc_cmd_t        olc_cmds_hometown[];
extern olc_cmd_t        olc_cmds_skill[];
extern olc_cmd_t        olc_cmds_command[];
extern olc_cmd_t        olc_cmds_alias[];
extern olc_cmd_t        olc_cmds_skill_alias[];
extern olc_cmd_t        olc_cmds_price[];
extern olc_cmd_t        olc_cmds_meteor[];
extern olc_cmd_t        olc_cmds_sec[];
//extern olc_cmd_t        olc_cmds_artefact[];
extern olc_cmd_t        olc_cmds_riddle[];
extern olc_cmd_t        olc_cmds_immortal[];
extern olc_cmd_t        olc_cmds_material[];
extern olc_cmd_t        olc_cmds_liquid[];
extern olc_cmd_t        olc_cmds_tattoo[];
extern olc_cmd_t        olc_cmds_ritual[];
extern olc_cmd_t        olc_cmds_paint[];

/*
 * Editor Commands.
 */
DECLARE_DO_FUN(do_alist         );
DECLARE_DO_FUN(do_asave         );
DECLARE_DO_FUN(do_ashow         );
DECLARE_DO_FUN(do_edit          );
DECLARE_DO_FUN(do_create        );
DECLARE_DO_FUN(do_resets        );

bool olced_obj_busy     (CHAR_DATA *ch);
bool olced_busy         (CHAR_DATA *ch, const char *id, void *edit, void *edit2);

/*
 * Generic data edit functions
 */
DECLARE_OLC_FUN(olced_spell_out);
DECLARE_OLC_FUN(olced_dummy);

bool olced_number            (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, int*);
bool olced_double            (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, double *pDbl);
bool olced_name              (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, const char**pStr);
bool olced_str               (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, const char**pStr);
bool olced_str_text          (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, const char **pStr);
bool olced_mlstr             (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, mlstring**);
bool olced_mlstrnl           (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, mlstring**);
bool olced_mlstr_text        (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, mlstring**);
bool olced_exd               (CHAR_DATA *ch, const char* argument, olc_cmd_t *cmd, ED_DATA**);
bool olced_flag64            (CHAR_DATA *ch, const char* argument, olc_cmd_t *cmd, flag64_t*);
bool olced_flag32            (CHAR_DATA *ch, const char* argument, olc_cmd_t *cmd, flag32_t*);
bool olced_dice              (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, int *dice);
bool olced_clan              (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, int *clan);
bool olced_rulecl            (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, lang_t *l);
bool olced_vform_add         (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, rule_t *r);
bool olced_vform_del         (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, rule_t *r);
bool olced_named_pointer     (CHAR_DATA *ch, const char *argument, olc_cmd_t *cmd, void **pPointer);

DECLARE_VALIDATE_FUN(validate_filename);
DECLARE_VALIDATE_FUN(validate_room_vnum);
DECLARE_VALIDATE_FUN(validate_mob_vnum);
DECLARE_VALIDATE_FUN(validate_obj_vnum);

DECLARE_OLC_FUN(show_commands        );
DECLARE_OLC_FUN(show_version        );

AREA_DATA *get_edited_area(CHAR_DATA *ch);
AREA_DATA *check_range(AREA_DATA *this, int ilower, int iupper);

bool        touch_area        (AREA_DATA*);
bool        touch_vnum        (int vnum);
bool        touch_clan        (clan_t *clan);
bool        touch_class       (class_t *cls);
bool        touch_religion    (religion_t *religion);
bool        touch_hometown    (hometown_t *htn);
void        save_area         (AREA_DATA *pArea);


void               edit_done                (DESCRIPTOR_DATA *d);
extern void        show_obj_values            (BUFFER *output, OBJ_INDEX_DATA *pObj);
olced_t *          olced_lookup            (const char * id);
void               roomed_edit_room    (CHAR_DATA *ch, ROOM_INDEX_DATA *pRoom, bool drop_out);

#define SECURITY_AREA_CREATE        9

#define SECURITY_CLANS              5
#define SECURITY_CLAN_PLIST         9
#define SECURITY_CLASSES            8
#define SECURITY_HOMETOWNS          6
#define SECURITY_RACES              7
#define SECURITY_RELIGIONS          5
#define SECURITY_METEORS            8

#define SECURITY_ALIASES            3
#define SECURITY_PRICES             3
#define SECURITY_COMMANDS           8
#define SECURITY_SOCIALS            5
#define SECURITY_SKILLS             7

#define SECURITY_HELPS              5
#define SECURITY_MSGDB              3
#define SECURITY_LANGS              9
#define SECURITY_RULES              4
#define SECURITY_OLC_OBJ_SHOW       1
#define SECURITY_OLC_METEOR         9
#define SECURITY_SECS               9
#define SECURITY_LANGS              9

typedef struct asave_cmds       ASAVE_CMD;

#define ASAVE_CMD_ALL       (A)
#define ASAVE_CMD_CHANGED   (B)


DECLARE_DO_FUN(asave_help      );
DECLARE_DO_FUN(save_all        );
DECLARE_DO_FUN(save_world      );
DECLARE_DO_FUN(save_changed    );

struct asave_cmds
{
    char        *name          ; // command name
    DO_FUN*      fun           ; // command function
    char        *description   ;
    int          asave_cmd_flag;
};

#endif
