/*  $Id: olc_artefact.c,v 1.666 2004/09/20 10:50:30 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "merc.h"
#include "olc.h"
#include "artefacts.h"

#define EDIT_ARTEFACT(ch, artefact)	(artefact = (ARTEFACT_DATA*) ch->desc->pEdit)

DECLARE_OLC_FUN(artefacted_create       );
DECLARE_OLC_FUN(artefacted_edit         );
DECLARE_OLC_FUN(artefacted_touch        );
DECLARE_OLC_FUN(artefacted_show         );
DECLARE_OLC_FUN(artefacted_list         );

DECLARE_OLC_FUN(artefacted_vnum         );
DECLARE_OLC_FUN(artefacted_char_level   );
DECLARE_OLC_FUN(artefacted_mob_level    );
DECLARE_OLC_FUN(artefacted_chance       );
DECLARE_OLC_FUN(artefacted_partcount    );
DECLARE_OLC_FUN(artefacted_part         );
DECLARE_OLC_FUN(artefacted_partof       );
DECLARE_OLC_FUN(artefacted_forger       );
DECLARE_OLC_FUN(artefacted_info_fee     );
DECLARE_OLC_FUN(artefacted_create_fee   );

olc_cmd_t olc_cmds_artefact[] =
{
    { "create",        artefacted_create,       5},
    { "edit",          artefacted_edit,         5},
    { "touch",         olced_dummy,             5},
    { "show",          artefacted_show,         0},
    { "list",          artefacted_list,         0},

    { "vnum",          artefacted_vnum,         5},
    { "char_level",    artefacted_char_level,   5},
    { "mob_level",     artefacted_mob_level,    5},
    { "chance",        artefacted_chance,       5},
    { "count_part",    artefacted_partcount,    5},
    { "part",          artefacted_part,         5},
    { "partof",        artefacted_partof,       5},
    { "forger",        artefacted_forger,       5},
    { "info_fee",      artefacted_info_fee,     5},
    { "create_fee",    artefacted_create_fee,   5},
    
    { "commands",      show_commands,           0},
    { NULL}
};


OLC_FUN(aretefacted_edit)
{
    ARTEFACT_DATA *artefact;
    char arg[MAX_INPUT_LENGTH];
    int value;

    if (!char_security(ch, "OLC_ARTEFACT_SEC"))
    {
        char_puts("ArtefactEd: Insufficient security.\n", ch);
        return FALSE;
    }
    
    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC EDIT'");
        return FALSE;
    }

    value = atoi(arg);
    
    artefact = get_artefact_by_vnum(value, artefactList);

    if (artefact == NULL)
    {
        char_puts("ArtfactEd: Artefact Vnum  does not exist.\n", ch);
        return FALSE;
    }

    ch->desc->pEdit = (void*) artefact;
    OLCED(ch)   = olced_lookup(ED_ARTEFACT);
    return FALSE;
}

OLC_FUN(artefacted_create)
{
    char arg[MAX_STRING_LENGTH];
    
    one_argument(argument, arg, sizeof(arg));
    if (arg[0] =='\0')
    {
        do_help(ch, "'OLC Artefact'");
        return FALSE;
    }

    return FALSE;
}

OLC_FUN(artefacted_create_fee)
{
    ARTEFACT_DATA *artefact;
    
    EDIT_ARTEFACT(ch, artefact);
    return olced_number(ch, argument, cmd, &artefact->create_fee);
}

OLC_FUN(artefacted_info_fee)
{
    ARTEFACT_DATA *artefact;
    
    EDIT_ARTEFACT(ch, artefact);
    return olced_number(ch, argument, cmd, &artefact->info_fee);
}

OLC_FUN(artefacted_char_level)
{
    ARTEFACT_DATA *artefact;
    
    EDIT_ARTEFACT(ch, artefact);
    return olced_number(ch, argument, cmd, &artefact->char_level);
}

OLC_FUN(artefacted_mob_level)
{
    ARTEFACT_DATA *artefact;
    
    EDIT_ARTEFACT(ch, artefact);
    return olced_number(ch, argument, cmd, &artefact->mob_level);
}

OLC_FUN(artefacted_vnum)
{
    ARTEFACT_DATA *artefact;
    
    EDIT_ARTEFACT(ch, artefact);
    return olced_number(ch, argument, cmd, &artefact->vnum);
}


OLC_FUN(artefacted_forger)
{
    ARTEFACT_DATA *artefact;
    
    EDIT_ARTEFACT(ch, artefact);
    return olced_number(ch, argument, cmd, &artefact->forger);
}

OLC_FUN(artefacted_partcount)
{
    ARTEFACT_DATA *artefact;
    
    EDIT_ARTEFACT(ch, artefact);
    return olced_number(ch, argument, cmd, &artefact->parts_count);
}

OLC_FUN(artefacted_partof)
{
    ARTEFACT_DATA *artefact;
    
    EDIT_ARTEFACT(ch, artefact);
    return olced_number(ch, argument, cmd, &artefact->part_of);
}
// Shrike:   
OLC_FUN(artefacted_chance)
{
    ARTEFACT_DATA *artefact;
    
    EDIT_ARTEFACT(ch, artefact);
    return olced_number(ch, argument, cmd, &artefact->chance);
}
