/* $Id: olc_hometown.c,v 1.666 2004/09/20 10:50:30 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 
#include <stdio.h>
#include <string.h>

#include "merc.h"
#include "olc.h"

#define EDIT_HOMETOWN(ch, hometown) (hometown = (hometown_t*) ch->desc->pEdit)

DECLARE_OLC_FUN(hometowned_create    );
DECLARE_OLC_FUN(hometowned_edit      );
DECLARE_OLC_FUN(hometowned_show      );
DECLARE_OLC_FUN(hometowned_list      );

DECLARE_OLC_FUN(hometowned_area      );

static DECLARE_VALIDATE_FUN(validate_hometown_name);

olc_cmd_t olc_cmds_hometown[] =
{
    { "create",         hometowned_create,       0                         },
    { "edit",           hometowned_edit,         0                         },
    { "touch",          olced_dummy,             0                         },
    { "show",           hometowned_show,         0                         },
    { "list",           hometowned_list,         0                         },

    { "name",           hometowned_area,         0, validate_hometown_name },


    { "commands",       show_commands,           0                          },
    { NULL}
};

OLC_FUN(hometowned_create)
{
    int         htn;
    hometown_t *hometown;
    char        arg[MAX_STRING_LENGTH];

    if (ch->pcdata->security < SECURITY_HOMETOWNS)
    {
        char_puts("HometownEd: Insufficient security for creating hometowns\n", ch);
        return FALSE;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC CREATE'");
        return FALSE;
    }

    if ((htn = htn_lookup(arg)) >= 0)
    {
        char_printf(ch, "HometownEd: %s: already exists.\n", HOMETOWN(htn)->area);
        return FALSE;
    }

    hometown         = hometown_new();
    hometown->area   = str_dup(arg);

    ch->desc->pEdit = (void *) hometown;
    OLCED(ch)   = olced_lookup(ED_HOMETOWN);
    char_puts("Hometown created.\n",ch);
    return FALSE;
}

OLC_FUN(hometowned_edit)
{
    int  htn;
    char arg[MAX_STRING_LENGTH];

    if (ch->pcdata->security < SECURITY_HOMETOWNS)
    {
        char_puts("HometownEd: Insufficient security.\n", ch);
        return FALSE;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC EDIT'");
        return FALSE;
    }

    if ((htn = htn_lookup(arg)) < 0)
    {
        char_printf(ch, "HometownEd: %s: No such hometown.\n", arg);
        return FALSE;
    }

    ch->desc->pEdit = HOMETOWN(htn);
    OLCED(ch)   = olced_lookup(ED_HOMETOWN);
    return FALSE;
}

OLC_FUN(hometowned_touch)
{
      hometown_t *hometown;
      EDIT_HOMETOWN(ch, hometown);
      return touch_hometown(hometown);
}

OLC_FUN(hometowned_show)
{
    char        arg[MAX_STRING_LENGTH];
    int         i;
    BUFFER     *output;
    hometown_t *hometown;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        if (IS_EDIT(ch, ED_HOMETOWN))
            EDIT_HOMETOWN(ch, hometown);
        else
        {
            do_help(ch, "'OLC ASHOW'");
            return FALSE;
        }
    }
    else
    {
        if ((i = htn_lookup(arg)) < 0)
        {
            char_printf(ch, "HometownEd: %s: No such hometown.\n", arg);
            return FALSE;
        }
            hometown = HOMETOWN(i);
    }

    output = buf_new(-1);

                                                                        buf_printf(output, "Area:              [%s]\n", hometown->area);
    for (i = 0; i < MAX_ANUM; i++) if (hometown->recall[i] != NULL)     buf_printf(output, "Recall %-10s       [%d]\n",    flag_string(align_names, i), hometown->recall[i]->vnum);
    for (i = 0; i < MAX_ANUM; i++) if (hometown->map[i] != NULL)        buf_printf(output, "Map    %-10s       [%d]\n",    flag_string(align_names, i), hometown->map[i]->vnum);
    for (i = 0; i < MAX_ANUM; i++)
    {
            buf_printf(output, "Altar  %-10s       [%d %d]\n",
                              flag_string(align_names, i),
                              hometown->altar[i].room ? hometown->altar[i].room->vnum : -1,
                              hometown->altar[i].pit ? hometown->altar[i].pit->vnum: -1);
      }
      if (hometown->restrict_race)                                      buf_printf(output, "RestrictRace       [%s]\n", hometown->restrict_race);
      if (hometown->restrict_class)                                     buf_printf(output, "RestrictClass      [%s]\n", hometown->restrict_class);
      if (hometown->restrict_align)                                     buf_printf(output, "RestrictAlign      [%s]\n", flag_string(ralign_names, hometown->restrict_align));


    page_to_char(buf_string(output), ch);
    buf_free(output);

    return FALSE;
}

OLC_FUN(hometowned_list)
{
    int i;
    for (i = 0; i < hometowns.nused; i++)
            char_printf(ch, "[%d] %s\n", i, HOMETOWN(i)->area);
    return FALSE;
}

OLC_FUN(hometowned_area)
{
    hometown_t *hometown;
    EDIT_HOMETOWN(ch, hometown);
    return olced_str(ch, argument, cmd, &hometown->area);
}

bool touch_hometown(hometown_t *hometown)
{
      SET_BIT(hometown->flags, HOMETOWN_CHANGED);
      return FALSE;
}

static VALIDATE_FUN(validate_hometown_name)
{
      int i;
      hometown_t *hometown;
      EDIT_HOMETOWN(ch, hometown);

      for (i = 0; i < hometowns.nused; i++)
      {
            if (HOMETOWN(i) != hometown && !str_cmp(HOMETOWN(i)->area, arg))
            {
                  char_printf(ch, "HometownEd: %s: duplicate hometown name.\n", arg);
                  return FALSE;
            }
      }
    return TRUE;
}


