/*  $Id: olc_lang.c,v 1.666 2004/09/20 10:50:30 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/
 
#include <stdio.h>
#include <string.h>

#include "merc.h"
#include "olc.h"
#include "db/lang.h"

#define EDIT_LANG(ch, l)      (l = (lang_t*) (ch->desc->pEdit))

DECLARE_OLC_FUN(langed_create );
DECLARE_OLC_FUN(langed_edit   );
DECLARE_OLC_FUN(langed_touch  );
DECLARE_OLC_FUN(langed_show   );
DECLARE_OLC_FUN(langed_list   );

DECLARE_OLC_FUN(langed_name   );
DECLARE_OLC_FUN(langed_flags  );
DECLARE_OLC_FUN(langed_slangof      );
DECLARE_OLC_FUN(langed_filename     );
DECLARE_OLC_FUN(langed_rulecl   );

DECLARE_VALIDATE_FUN(validate_langname);

olc_cmd_t olc_cmds_lang[] =
{
      { "create",     langed_create,    0                        },
      { "edit",       langed_edit,      0                        },
      { "touch",      langed_touch,     0                        },
      { "show",       langed_show,      0                        },
      { "list",       langed_list,      0                        },

      { "name",       langed_name,      0,    validate_langname  },
      { "flags",      langed_flags,     0,    lang_flags         },
      { "slangof",    langed_slangof,   0                        },
      { "filename",   langed_filename,  0,     validate_filename },
      { "ruleclass",  langed_rulecl,    0                        },

      { "commands",   show_commands,    0                        },
      { NULL }
};

OLC_FUN(langed_create)
{
      lang_t *l;
      char arg[MAX_INPUT_LENGTH];

      if (ch->pcdata->security < SECURITY_LANGS)
      {
            char_puts("LangEd: Insufficient security.\n", ch);
            return FALSE;
      }

      one_argument(argument, arg, sizeof(arg));
      if (arg[0] == '\0')
      {
            do_help(ch, "'OLC CREATE'");
            return FALSE;
      }

      if (lang_lookup(arg) >= 0)
      {
            char_puts("LangEd: lang already exists.\n", ch);
            return FALSE;
      }

      l            = lang_new();
      l->name      = str_dup(arg);
      l->file_name = str_printf("lang%02d.lang", langs.nused-1);

      ch->desc->pEdit = l;

      OLCED(ch)   = olced_lookup(ED_LANG);
      char_puts("LangEd: lang created.\n", ch);
      SET_BIT(l->flags, LANG_CHANGED);
      return FALSE;
}

OLC_FUN(langed_edit)
{
      int lang;
      char arg[MAX_INPUT_LENGTH];

      if (ch->pcdata->security < SECURITY_LANGS)
      {
            char_puts("LangEd: Insufficient security", ch);
            return FALSE;
      }

      one_argument(argument, arg, sizeof(arg));
      if (arg[0] == '\0')
      {
            do_help(ch, "'OLC EDIT'");
            return FALSE;
      }

      if ((lang = lang_lookup(arg)) < 0)
      {
            char_puts("LangEd: language not found.\n", ch);
            return FALSE;
      }

      ch->desc->pEdit = VARR_GET(&langs, lang);
      OLCED(ch)   = olced_lookup(ED_LANG);
      return FALSE;
}

OLC_FUN(langed_touch)
{
      lang_t *l;

      EDIT_LANG(ch, l);
      SET_BIT(l->flags, LANG_CHANGED);
      return FALSE;
}

OLC_FUN(langed_show)
{
      int i;
      char arg[MAX_INPUT_LENGTH];
      lang_t *l;
      lang_t *sl;

      one_argument(argument, arg, sizeof(arg));

      if (arg[0] == '\0')
      {
            if (IS_EDIT(ch, ED_LANG))
                  EDIT_LANG(ch, l);
            else {
                  do_help(ch, "'OLC ASHOW'");
                  return FALSE;
            }
      }
      else
      {
            int lang;

            if ((lang = lang_lookup(arg)) < 0)
            {
                  char_puts("LangEd: language not found.\n", ch);
                  return FALSE;
            }
            l = VARR_GET(&langs, lang);
      }

                                                            char_printf(ch, "Name:     [%s]\n", l->name);
                                                            char_printf(ch, "Filename: [%s]\n", l->file_name);
      if ((sl = varr_get(&langs, l->slang_of)))             char_printf(ch, "Slang of: [%s]\n", sl->name);
      if (l->flags)                                         char_printf(ch, "Flags:    [%s]\n", flag_string(lang_flags, l->flags));

      for (i = 0; i < MAX_RULECL; i++)
      {
            rulecl_t *rcl = l->rules + i;

            if (IS_NULLSTR(rcl->file_expl) &&  IS_NULLSTR(rcl->file_impl))
                  continue;

            char_printf(ch, "\nRule Class: [%s]\n"
                        "Expl file: [%s]\n"
                        "Impl file: [%s]\n"
                        "Flags: [%s]\n",
                      flag_string(rulecl_names, i),
                      rcl->file_expl,
                      rcl->file_impl,
                      flag_string(rulecl_flags, rcl->flags));
      }

      return FALSE;
}

OLC_FUN(langed_list)
{
      int lang;

      for (lang = 0; lang < langs.nused; lang++)
      {
            lang_t *l = VARR_GET(&langs, lang);
            char_printf(ch, "[%d] %s\n", lang, l->name);
      }

      return FALSE;
}

OLC_FUN(langed_name)
{
      lang_t *l;

      if (ch->pcdata->security < SECURITY_LANGS)
      {
            char_puts("LangEd: Insufficient security", ch);
            return FALSE;
      }

      EDIT_LANG(ch, l);
      return olced_str(ch, argument, cmd, &l->name);
}

OLC_FUN(langed_flags)
{
      lang_t *l;
      EDIT_LANG(ch, l);
      return olced_flag64(ch, argument, cmd, &l->flags);
}

OLC_FUN(langed_slangof)
{
      char arg[MAX_STRING_LENGTH];
      lang_t *l;
      int lang;

      one_argument(argument, arg, sizeof(arg));
      if (arg[0] == '\0')
      {
            do_help(ch, "'OLC LANG SLANG'");
            return FALSE;
      }

      if ((lang = lang_lookup(arg)) < 0)
      {
            char_puts("LangEd: language not found.\n", ch);
            return FALSE;
      }

      EDIT_LANG(ch, l);
      l->slang_of = lang;
      return TRUE;
}

OLC_FUN(langed_filename)
{
      lang_t *l;
      EDIT_LANG(ch, l);
      return olced_str(ch, argument, cmd, &l->file_name);
}

OLC_FUN(langed_rulecl)
{
    lang_t *l;
    EDIT_LANG(ch, l);
    return olced_rulecl(ch, argument, cmd, l);
}

/* local functions */

VALIDATE_FUN(validate_langname)
{
      if (lang_lookup(arg) >= 0)
      {
            char_printf(ch, "%s: language already exists.\n", OLCED(ch)->name);
            return FALSE;
      }
      return TRUE;
}

bool touch_lang(lang_t *l)
{
    return FALSE;
}

