/* $Id: olc_opcode.c,v 1.666 2004/09/20 10:50:30 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <sys/types.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"
#include "olc.h"

#define EDIT_OPCODE(ch, opcode)   (opcode = (MPCODE*) ch->desc->pEdit)

extern MPCODE *get_prog_index(int vnum, int type);

/* Mobprog editor */
DECLARE_OLC_FUN(oped_create     );
DECLARE_OLC_FUN(oped_edit       );
DECLARE_OLC_FUN(oped_touch      );
DECLARE_OLC_FUN(oped_show       );
DECLARE_OLC_FUN(oped_list       );
DECLARE_OLC_FUN(oped_code       );

olc_cmd_t olc_cmds_opcode[] =
{
/*	{ command	function	}, */

    { "create", oped_create,    5},
    { "edit",   oped_edit,      0},
    { "touch",  oped_touch,     0},
    { "show",   oped_show,      0},
    { "list",   oped_list,      0},

    { "code",   oped_code,      5},

    { "commands",   show_commands,  0},

    { NULL}
};

OLC_FUN(oped_create)
{
    MPCODE *opcode;
    int value;
    AREA_DATA *pArea;
    char arg[MAX_STRING_LENGTH];

    one_argument(argument, arg, sizeof(arg));
    value = atoi(arg);
    if (!value)
    {
        do_help(ch, "'OLC CREATE'");
        return FALSE;
    }

    pArea = area_vnum_lookup(value);
    if (!pArea)
    {
        char_puts("OPEd: That vnum is not assigned an area.\n", ch);
        return FALSE;
    }

    if (!IS_BUILDER(ch, pArea))
    {
        char_puts("OPEd: Insufficient security.\n", ch);
        return FALSE;
    }

    if (opcode_lookup(value))
    {
        char_puts("OPEd: vnum already exists.\n", ch);
        return FALSE;
    }

    opcode              = opcode_new();
    opcode->vnum        = value;
    opcode_add(opcode);

    ch->desc->pEdit     = (void *)opcode;
    OLCED(ch) = olced_lookup(ED_OPCODE);
    touch_area(pArea);
    char_puts("OPEd: opcode created.\n", ch);
    return FALSE;
}

OLC_FUN(oped_edit)
{
    MPCODE *opcode;
    AREA_DATA *pArea;
    int value;
    char arg[MAX_INPUT_LENGTH];

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC EDIT'");
        return FALSE;
    }

    value = atoi(arg);
    opcode = opcode_lookup(value);
    if (!opcode)
    {
        char_puts("OPEd: Vnum does not exist.\n", ch);
        return FALSE;
    }

    pArea = area_vnum_lookup(opcode->vnum);
    if (!IS_BUILDER(ch, pArea))
    {
        char_puts("OPEd: Insufficient security.\n", ch);
        return FALSE;
    }

    ch->desc->pEdit = (void*) opcode;
    OLCED(ch)   = olced_lookup(ED_OPCODE);
    return FALSE;
}

OLC_FUN(oped_touch)
{
    MPCODE *opcode;
    EDIT_OPCODE(ch, opcode);
    return touch_vnum(opcode->vnum);
}

OLC_FUN(oped_show)
{
    MPCODE *opcode;
    char arg[MAX_INPUT_LENGTH];

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        if (IS_EDIT(ch, ED_OPCODE))
            EDIT_OPCODE(ch, opcode);
        else
        {
            do_help(ch, "'OLC ASHOW'");
            return FALSE;
        }
    }
    else
    {
        int value = atoi(arg);
        opcode = opcode_lookup(value);
        if (!opcode)
        {
            char_puts("OPEd: Vnum does not exist.\n", ch);
            return FALSE;
        }
    }

    char_printf(ch, "Vnum:       [%d]\n" "Code:\n%s\n", opcode->vnum, opcode->code);

    return FALSE;
}

OLC_FUN(oped_list)
{
    int count = 1;
    MPCODE *opcode;
    BUFFER *buffer;
    bool fAll = !str_cmp(argument, "all");
    char blah;
    AREA_DATA *ad;

    buffer = buf_new(-1);

    for (opcode = opcode_list; opcode !=NULL; opcode = opcode->next)
        if (fAll || ENTRE(ch->in_room->area->min_vnum, opcode->vnum, ch->in_room->area->max_vnum))
        {
            ad = area_vnum_lookup(opcode->vnum);

            if (ad == NULL)
                blah = '?';
            else
                if (IS_BUILDER(ch, ad))
                blah = '*';
            else
                blah = ' ';

            buf_printf(buffer, "[%6d] (%c) %5d\n", count, blah, opcode->vnum);
            count++;
        }

    if (count == 1)
    {
        if (fAll)
            buf_add(buffer, "No objprogs found.\n");
        else
            buf_add(buffer, "No objprogs found in this area.\n");
    }

    page_to_char(buf_string(buffer), ch);
    buf_free(buffer);

    return FALSE;
}

OLC_FUN(oped_code)
{
    MPCODE *opcode;
    EDIT_OPCODE(ch, opcode);
    return olced_str_text(ch, argument, cmd, &opcode->code);
}

