/* $Id: olc_religion.c,v 1.666 2004/09/20 10:50:30 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "merc.h"
#include "olc.h"

#define EDIT_RELIGION(ch, religion)        (religion = (religion_t*) ch->desc->pEdit)

DECLARE_OLC_FUN(religioned_create        );
DECLARE_OLC_FUN(religioned_edit          );
DECLARE_OLC_FUN(religioned_touch         );
DECLARE_OLC_FUN(religioned_show          );
DECLARE_OLC_FUN(religioned_list          );

DECLARE_OLC_FUN(religioned_name          );
DECLARE_OLC_FUN(religioned_filename      );
DECLARE_OLC_FUN(religioned_recall        );
DECLARE_OLC_FUN(religioned_msg_prays     );
DECLARE_OLC_FUN(religioned_msg_vanishes  );
DECLARE_OLC_FUN(religioned_rtalk_self    );
DECLARE_OLC_FUN(religioned_rtalk_other   );

DECLARE_OLC_FUN(religioned_flags         );
DECLARE_OLC_FUN(religioned_skill         );
DECLARE_OLC_FUN(religioned_race          );
DECLARE_OLC_FUN(religioned_class         );
DECLARE_OLC_FUN(religioned_stats         );
DECLARE_OLC_FUN(religioned_tattoo        );
DECLARE_OLC_FUN(religioned_tattoo_master );
DECLARE_OLC_FUN(religioned_altar         );
DECLARE_OLC_FUN(religioned_skill_add     );
DECLARE_OLC_FUN(religioned_skill_del     );
DECLARE_OLC_FUN(religioned_race_add      );
DECLARE_OLC_FUN(religioned_race_del      );
DECLARE_OLC_FUN(religioned_class_add     );
DECLARE_OLC_FUN(religioned_class_del     );
DECLARE_OLC_FUN(religioned_stats_add     );
DECLARE_OLC_FUN(religioned_stats_del     );
DECLARE_OLC_FUN(religioned_align_restrict);
DECLARE_OLC_FUN(religioned_ethos_restrict);
DECLARE_OLC_FUN(religioned_sex_restrict  );

static DECLARE_VALIDATE_FUN(validate_name );
static DECLARE_VALIDATE_FUN(validate_altar);

olc_cmd_t olc_cmds_religion[] =
{
    { "create",        religioned_create,         5                              },
    { "edit",          religioned_edit,           5                              },
    { "touch",         religioned_touch,          5                              },
    { "show",          religioned_show,           0                              },
    { "list",          religioned_list,           0                              },

    { "name",          religioned_name,           5, validate_name               },
    { "filename",      religioned_filename,       5, validate_filename           },
    { "recall",        religioned_recall,         0, validate_room_vnum          },
    { "msgp",          religioned_msg_prays,      0                              },
    { "msgv",          religioned_msg_vanishes,   0                              },
    { "rtself",        religioned_rtalk_self,     0                              },
    { "rtother",       religioned_rtalk_other,    0                              },

    { "alignrestrict", religioned_align_restrict, 0, ralign_names                },
    { "ethosrestrict", religioned_ethos_restrict, 0, ethos_table                 },
    { "sexrestrict",   religioned_sex_restrict,   0, restrict_sex_table          },

    { "flags",         religioned_flags,          5, religion_flags              },
    { "skill",         religioned_skill,          0                              },
    { "race",          religioned_race,           0                              },
    { "class",         religioned_class,          0                              },
    { "stats",         religioned_stats,          0                              },
    { "tattoo",        religioned_tattoo,         5                              },
    { "master",        religioned_tattoo_master,  5, validate_mob_vnum           },
    
    { "altar",         religioned_altar,          5, validate_altar              },

    { "commands",      show_commands,             0                              },
    { NULL}
};

OLC_FUN(religioned_create)
{
    int rln;
    religion_t *religion;
    char arg[MAX_STRING_LENGTH];

    if (ch->pcdata->security < SECURITY_RELIGIONS)
    {
        char_puts("ReligionEd: Insufficient security for editing religions\n", ch);
        return FALSE;
    }

    first_arg(argument, arg, sizeof(arg), FALSE);
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC CREATE'");
        return FALSE;
    }

    if ((rln = rln_lookup(arg)) >= 0)
    {
        char_printf(ch, "ReligionEd: %s: already exists.\n",
                    RELIGION(rln)->name);
        return FALSE;
    }

    religion                = religion_new();
    religion->name          = str_dup(arg);
    religion->file_name     = str_printf("%s.religion", arg);

    ch->desc->pEdit     = (void *)religion;
    OLCED(ch)   = olced_lookup(ED_RELIGION);                              
    touch_religion(religion);
    char_puts("Religion created.\n",ch);
    return FALSE;
}

OLC_FUN(religioned_edit)
{
    int rln;
    char arg[MAX_STRING_LENGTH];

    if (ch->pcdata->security < SECURITY_RELIGIONS)
    {
        char_puts("ReligionEd: Insufficient security.\n", ch);
        return FALSE;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC EDIT'");
        return FALSE;
    }

    rln = 0;

    if (is_number(arg))
    {
        if (!str_cmp(religion_name(atoi(arg)),"None"))
        {
            char_printf(ch, "ReligionEd: %s: No such religion.\n", arg);
            return FALSE;
        }
        else
            ch->desc->pEdit     = RELIGION(atoi(arg));
    }
    else
    {

        if ((rln = rln_lookup(arg)) < 0)
        {
            char_printf(ch, "ReligionEd: %s: No such religion.\n", argument);
            return FALSE;
        }
        else
            ch->desc->pEdit     = RELIGION(rln);
    }

    OLCED(ch)   = olced_lookup(ED_RELIGION);
    return FALSE;
}

OLC_FUN(religioned_touch)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return touch_religion(religion);
}

OLC_FUN(religioned_show)
{
    char arg[MAX_STRING_LENGTH];
    int i;
    int j;
    BUFFER *output;
    religion_t *religion;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        if (IS_EDIT(ch, ED_RELIGION))
            EDIT_RELIGION(ch, religion);
        else
        {
            do_help(ch, "'OLC ASHOW'");
            return FALSE;
        }
    }
    else
    {
        if (is_number(arg))
        {
            if (!str_cmp(religion_name(atoi(arg)),"None"))
            {
                char_printf(ch, "ReligionEd: %s: No such religion.\n", arg);
                return FALSE;
            }
            else
                religion = RELIGION(atoi(arg));
        }
        else
        {
            if ((i = rln_lookup(arg)) < 0)
            {
                char_printf(ch, "ReligionEd: %s: No such religion.\n", arg);
                return FALSE;
            }
            religion = RELIGION(i);
        }
    }

    output = buf_new(-1);
    buf_printf(output, "Name:              [%s]\n" 
                       "Filename:          [%s]\n", religion->name, religion->file_name);
    buf_printf(output, "Flags:             [%s]\n", flag_string(religion_flags, religion->flags));
    buf_printf(output, "Recall:            [%d]\n", religion->recall_vnum);
    buf_printf(output, "Tattoo:            [%d]\n", religion->tattoo_vnum);         //       
    buf_printf(output, "Tattoo master:     [%d]\n", religion->tattoo_master_vnum);
    buf_printf(output, "Altar:             [%d]\n", religion->altar);               //    ...
    buf_printf(output, "MsgPrays:          [%s]\n", religion->msg_prays);
    buf_printf(output, "MsgVanishes:       [%s]\n", religion->msg_vanishes);
    buf_printf(output, "RTalk self:        [%s]\n", religion->rtalk_self);
    buf_printf(output, "RTalk other:       [%s]\n", religion->rtalk_other);
    buf_printf(output, "Align restrict:    [%s]\n", flag_string(ralign_names, religion->restrict_align));
    buf_printf(output, "Ethos restrict:    [%s]\n", flag_string(ethos_table, religion->restrict_ethos));
    buf_printf(output, "Sex restrict:      [%s]\n", flag_string(restrict_sex_table, religion->restrict_sex));
    buf_printf(output, "Skill:             [");

    j=0;
    for (i = 0; i < religion->skills.nused; i++)
    {
        religion_skill_t *rls = VARR_GET(&religion->skills, i);
        skill_t *sk;

        if (rls->sn <= 0
            ||  (sk = skill_lookup(rls->sn)) == NULL)
            continue;
        if (j > 0)
            buf_printf(output, "\n                       '%s' (level %d, %d%%) ", sk->name, rls->level, rls->percent);
        else
            buf_printf(output, " '%s' (level %d, %d%%) ", sk->name, rls->level, rls->percent);
        j++;
    }
    buf_printf(output, "]\n");

    j=0;
    buf_printf(output, "Races:             [");
    for (i = 0; i < religion->races.nused; i++)
    {
        rlrace_t *race = varr_get(&religion->races, i);
        if (race == NULL)
        {
            continue;
        }
        if (j > 0)
        {
            buf_printf(output, "\n                     %s %s ", race->name, flag_string(status_table, race->status));
        }
        else
            buf_printf(output, " %s %s ", race->name, flag_string(status_table, race->status));

        j++;
    }
    buf_printf(output, "]\n");

    j=0;
    buf_printf(output, "Classes:           [");
    for (i = 0; i < religion->classes.nused; i++)
    {
        rlclass_t *classes = varr_get(&religion->classes, i);
        if (classes == NULL)
        {
            continue;
        }
        if (j > 0)
        {
            buf_printf(output, "\n                     %s %s ", classes->name, flag_string(status_table, classes->status));
        }
        else
            buf_printf(output, " %s %s ", classes->name, flag_string(status_table, classes->status));

        j++;
    }
    buf_printf(output, "]\n");

    buf_printf(output, "Stats:             [");
    for (i = 0; i < religion->stats.nused; i++)
    {
        restrict_stat_t *stats = varr_get(&religion->stats, i);
        if (stats == NULL)
        {
            continue;
        }

        buf_printf(output, " %s: %d ", flag_string(stat_names, stats->stat), stats->min);
    }
    buf_printf(output, "]\n");

    page_to_char(buf_string(output), ch);
    buf_free(output);

    return FALSE;
}

OLC_FUN(religioned_list)
{
    int i;

    for (i = 0; i < religions.nused; i++)
        char_printf(ch, "[%d] %s\n", i, RELIGION(i)->name);
    return FALSE;
}

OLC_FUN(religioned_name)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_str(ch, argument, cmd, &religion->name);
    /*       <argument>.religion -  */
}

OLC_FUN(religioned_filename)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_str(ch, argument, cmd, &religion->file_name);
}

OLC_FUN(religioned_recall)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_number(ch, argument, cmd, &religion->recall_vnum);
}

OLC_FUN(religioned_tattoo)
{
    char arg[MAX_STRING_LENGTH];
    religion_t *religion;

    one_argument(argument, arg, sizeof(arg));

    if (!str_cmp(arg, "?"))
    {
        do_showtattoo(ch);
        return FALSE;
    }

    EDIT_RELIGION(ch, religion);
    return olced_number(ch, argument, cmd, &religion->tattoo_vnum);
}

OLC_FUN(religioned_tattoo_master)
{
    char arg[MAX_STRING_LENGTH];
    religion_t *religion;

    one_argument(argument, arg, sizeof(arg));

    EDIT_RELIGION(ch, religion);
    return olced_number(ch, argument, cmd, &religion->tattoo_master_vnum);
}

OLC_FUN(religioned_altar)
{
    religion_t *religion;
    
    EDIT_RELIGION(ch, religion);
    return olced_number(ch, argument, cmd, &religion->altar);
}

OLC_FUN(religioned_msg_prays)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_str(ch, argument, cmd, &religion->msg_prays);
}

OLC_FUN(religioned_msg_vanishes)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_str(ch, argument, cmd, &religion->msg_vanishes);
}

OLC_FUN(religioned_rtalk_self)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_str(ch, argument, cmd, &religion->rtalk_self);
}

OLC_FUN(religioned_rtalk_other)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_str(ch, argument, cmd, &religion->rtalk_other);
}

OLC_FUN(religioned_flags)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_flag64(ch, argument, cmd, &religion->flags);
}

OLC_FUN(religioned_align_restrict)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_flag64(ch, argument, cmd, &religion->restrict_align);          
}

OLC_FUN(religioned_ethos_restrict)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_flag64(ch, argument, cmd, &religion->restrict_ethos);          
}

OLC_FUN(religioned_sex_restrict)
{
    religion_t *religion;
    EDIT_RELIGION(ch, religion);
    return olced_flag64(ch, argument, cmd, &religion->restrict_sex);          
}

OLC_FUN(religioned_skill)
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument(argument, arg, sizeof(arg));
    if (!str_prefix(arg, "add"))
        return religioned_skill_add(ch, argument, cmd);
    else if (!str_prefix(arg, "delete"))
        return religioned_skill_del(ch, argument, cmd);

    do_help(ch, "'OLC RELIGION SKILL'");
    return FALSE;
}

OLC_FUN(religioned_skill_add)
{
    int sn;
    int percent;
    religion_skill_t *rlsk;
    char    arg1[MAX_STRING_LENGTH];
    char    arg2[MAX_STRING_LENGTH];
    char    arg3[MAX_STRING_LENGTH]; 
    religion_t *religion;
    EDIT_RELIGION(ch, religion);

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    one_argument(argument, arg3, sizeof(arg3));

    if (arg1[0] == '\0' || arg2[0] == '\0' /*|| arg3[0] == '\0'*/)
    {
        do_help(ch, "'OLC RELIGION SKILL'");
        return FALSE;
    }

    if ((sn = sn_lookup(arg1)) <= 0)
    {
        char_printf(ch, "ReligionEd: %s: unknown skill.\n", arg1);
        return FALSE;
    }

    if ((rlsk = religion_skill_lookup(religion, sn)))
    {
        char_printf(ch, "ReligionEd: %s: already there.\n", SKILL(sn)->name);
        return FALSE;
    }

    percent = atoi(arg3);
    if (percent < 1 || percent > 100)
    {
        char_puts("ReligionEd: percent value must be in range 1..100.\n", ch);
        return FALSE;
    }

    rlsk = varr_enew(&religion->skills);
    rlsk->sn = sn;
    rlsk->level = atoi(arg2);
    rlsk->percent = percent;
    varr_qsort(&religion->skills, cmpint);

    return TRUE;
}

OLC_FUN(religioned_skill_del)
{
    char    arg[MAX_STRING_LENGTH];
    religion_skill_t *rlsk;
    religion_t *religion;
    EDIT_RELIGION(ch, religion);

    one_argument(argument, arg, sizeof(arg)); 
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC RELIGION SKILL'");
        return FALSE;
    }

    if ((rlsk = skill_vlookup(&religion->skills, arg)) == NULL)
    {
        char_printf(ch, "ReligionEd: %s: not found in religion skill list.\n", arg);
        return FALSE;
    }
    rlsk->sn = 0;
    varr_qsort(&religion->skills, cmpint);
    return TRUE;
}

OLC_FUN(religioned_race)
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument(argument, arg, sizeof(arg));
    if (!str_prefix(arg, "add"))
        return religioned_race_add(ch, argument, cmd);
    else if (!str_prefix(arg, "delete"))
        return religioned_race_del(ch, argument, cmd);

    do_help(ch, "'OLC RELIGION RACE'");
    return FALSE;
}

OLC_FUN(religioned_race_add)
{
    int race;
    int status;
    rlrace_t *rlrace;
    char    name[MAX_STRING_LENGTH];
        const char *tmp;
    religion_t *religion;
    EDIT_RELIGION(ch, religion);

    argument = one_argument(argument, name, sizeof(name));

    if (IS_NULLSTR(name) || IS_NULLSTR(argument))
    {
        do_help(ch, "'OLC RELIGION RACE'");
        return FALSE;
    }

    if ((race = rn_lookup(name)) <= 0)
    {
        char_printf(ch, "ReligionEd: %s: unknown race.\n", name);
        return FALSE;
    }

    if ((status = flag_value(status_table, argument)) == 0)
    {
        char_printf(ch, "ReligionEd: %s: unknown flag.\n", argument);
        return FALSE;
    }

        tmp = str_dup(race_name(race));
    if ((rlrace = religion_race_lookup (religion, tmp)) != NULL)
    {
        char_printf(ch, "ReligionEd: %s: already there.\n", race_name(race));
                free_string(tmp);
        return FALSE;
    }
    free_string(tmp);

    rlrace = varr_enew(&religion->races);
    rlrace->name = str_dup(race_name(race));
    rlrace->status = status; 
    varr_qsort(&religion->races, cmpstr);

    return TRUE;
}

OLC_FUN(religioned_race_del)
{
     const char *name;
     religion_t *religion;
     rlrace_t   *rlrace;
     int         i;
     int         size;
     char       *mem;
     rlrace_t   *array;
     int         race;
     
          EDIT_RELIGION(ch, religion);
    
    if (IS_NULLSTR(argument))
    {
        do_help(ch, "'OLC RELIGION RACE'");
        return FALSE;
    }

    if ((race = rn_lookup(argument)) <= 0)
    {
        char_printf(ch, "ReligionEd: %s: unknown race.\n", name);
        return FALSE;
    }

    name = str_dup(race_name(race));
 
    if ((rlrace = religion_race_lookup(religion, name)) == NULL)
    {
        char_printf(ch, "ReligionEd: %s: it's currently deleted.\n", name);
        return FALSE;
    }
    
        array = (rlrace_t*)religion->races.p;

        for (i = 0; i < religion->races.nused; i++)
        {
        if (strcmp(name,array[i].name)==0)
        {
            size = sizeof(rlrace_t);
            mem = (char*)religion->races.p;
            memcpy(mem+i*size,mem+(i+1)*size, (religion->races.nused-i)*size  );
            religion->races.nused--;

            varr_qsort(&religion->races, cmpstr);
            char_printf(ch, "ReligionEd: delete race %s.\n", name);

            return TRUE;
        }
  }

    varr_qsort(&religion->races, cmpstr);
    return TRUE;
  
}

OLC_FUN(religioned_stats)
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument(argument, arg, sizeof(arg));
    if (!str_prefix(arg, "add"))
        return religioned_stats_add(ch, argument, cmd);
    else if (!str_prefix(arg, "delete"))
        return religioned_stats_del(ch, argument, cmd);
    

    do_help(ch, "'OLC RELIGION STATS'");
    return FALSE;
}

OLC_FUN(religioned_stats_add)
{
    int stat;
    restrict_stat_t *rlstats;
    char    arg1[MAX_STRING_LENGTH];
    char    arg2[MAX_STRING_LENGTH];
    religion_t *religion;
    EDIT_RELIGION(ch, religion);

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));
    

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        do_help(ch, "'OLC RELIGION STAT'");
        return FALSE;
    }

    if ((stat = flag_value(stat_names, arg1)) == -1)
    {
        char_printf(ch, "ReligionEd: %s: unknown stat.\n", arg1);
        return FALSE;
    }

    if (!is_number(arg2) || atoi(arg2) < 1 || atoi(arg2) > 25)
    {
        char_printf(ch, "ReligionEd: value must be number between 1 .. 25 not %s.\n", arg2);
        return FALSE;
    }

    if ((rlstats = religion_stat_lookup(religion, stat)) != NULL)
    {
        char_printf(ch, "ReligionEd: %s: already there.\n", arg1);
        return FALSE;
    }

    rlstats = varr_enew(&religion->stats);
    rlstats->stat = flag_value(stat_names, arg1);
    rlstats->min = atoi(arg2);
    varr_qsort(&religion->stats, cmpint);

    return TRUE;
}

OLC_FUN(religioned_stats_del)
{
     char             arg[MAX_STRING_LENGTH];
     restrict_stat_t *array;
     religion_t      *religion;
     int              stat;
     int              i;
     int              size;
     char            *mem;

     EDIT_RELIGION(ch, religion);

     one_argument(argument, arg, sizeof(arg)); 

     if (arg[0] == '\0')
     {
          do_help(ch, "'OLC RELIGION SKILL'");
          return FALSE;
     }

     if ((stat = flag_value(stat_names, arg)) == -1)
     {
          char_printf(ch, "ReligionEd: %s: unknown stat.\n", arg);
          return FALSE;
     }

     array = (restrict_stat_t*)religion->stats.p;
     
     for (i = 0; i<religion->stats.nused; i++)
     {
          if (stat == array[i].stat)
          {
               size = sizeof(restrict_stat_t);
               mem = (char*)religion->stats.p;
               memcpy(mem+i*size,mem+(i+1)*size, (religion->stats.nused-i)*size  );
               religion->stats.nused--;

               varr_qsort(&religion->stats, cmpint);
               char_printf(ch, "ReligionEd: delete stat.\n", arg);

               return TRUE;
           }
     }

     char_printf(ch, "ReligionEd: stat not in religion.\n", arg);
     return FALSE;
}

OLC_FUN(religioned_class)
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument(argument, arg, sizeof(arg));
    
    if (!str_prefix(arg, "add"))
        return religioned_class_add(ch, argument, cmd);
    else if (!str_prefix(arg, "delete"))
        return religioned_class_del(ch, argument, cmd);
    
    do_help(ch, "'OLC RELIGION CLASS'");
    return FALSE;
}

OLC_FUN(religioned_class_add)
{
    int         classes;
    int         status;
    rlclass_t  *rlclass;
    char        name[MAX_STRING_LENGTH];
    const char *tmp;
    religion_t *religion;
    
    EDIT_RELIGION(ch, religion);

    argument = one_argument(argument, name, sizeof(name));

    if (IS_NULLSTR(name) || IS_NULLSTR(argument))
    {
        do_help(ch, "'OLC RELIGION CLASS'");
        return FALSE;
    }

    if ((classes = cn_lookup(name)) < 0)
    {
        char_printf(ch, "ReligionEd: %s: unknown class.\n", name);
        return FALSE;
    }

    if ((status = flag_value(status_table, argument)) == 0)
    {
        char_printf(ch, "ReligionEd: %s: unknown flag.\n", argument);
        return FALSE;
    }
     
    tmp = str_dup(cl_name(classes));
     
    if ((rlclass = religion_class_lookup(religion, tmp)) != NULL)
    {
         char_printf(ch, "ReligionEd: %s: already there.\n", cl_name(classes));
         free_string(tmp);
         
         return FALSE;
    }
     
    free_string(tmp);
     
    rlclass = varr_enew(&religion->classes);
    rlclass->name = cl_name(classes);
    rlclass->status=status;
    varr_qsort(&religion->classes, cmpstr);

    return TRUE;
}

OLC_FUN(religioned_class_del)
{
     const char *name;
     religion_t *religion;
     rlclass_t  *rlclass;
     int         i;
     int         size;
     char       *mem;
     rlclass_t  *array;
     int         classes;
     
     EDIT_RELIGION(ch, religion);
    
    if (IS_NULLSTR(argument))
    {
        do_help(ch, "'OLC RELIGION CLASS'");
        return FALSE;
    }

    if ((classes = cn_lookup(argument)) < 0)
    {
        char_printf(ch, "ReligionEd: %s: unknown class for deleting.\n", argument);
        return FALSE;
    }

    name = str_dup(cl_name(classes));

    if ((rlclass = religion_class_lookup(religion, name)) == NULL)
    {
        char_printf(ch, "ReligionEd: %s: it's currently deleted.\n", name);
        return FALSE;
    }

     array = (rlclass_t*)religion->classes.p;
     for (i = 0; i<religion->classes.nused; i++)
     {
          if (strcmp(name,array[i].name)==0)               
          {
               size = sizeof(rlclass_t);
               mem = (char*)religion->classes.p;
               memcpy(mem+i*size,mem+(i+1)*size, (religion->classes.nused-i)*size  );
               religion->classes.nused--;
     
          varr_qsort(&religion->skills, cmpstr);
          char_printf(ch, "ReligionEd: delete class %s.\n", name);
     
          return TRUE;
          }
     }
    
    varr_qsort(&religion->skills, cmpstr);
    return TRUE;
}

bool touch_religion(religion_t *religion)
{
    SET_BIT(religion->flags, RELIGION_CHANGED);
    return FALSE;
}

static VALIDATE_FUN(validate_name)
{
    int i;
    religion_t *religion;
    EDIT_RELIGION(ch, religion);

    for (i = 0; i < religions.nused; i++)
        if (RELIGION(i) != religion &&  !str_cmp(RELIGION(i)->name, arg))
        {
            char_printf(ch, "ReligionEd: %s: duplicate religion name.\n", arg);
            return FALSE;
        }

    return TRUE;
}


static VALIDATE_FUN(validate_altar)
{
    OBJ_INDEX_DATA *obj;
    int vnum = *(int*) arg;
    
    
    if (vnum && get_obj_index(vnum) == NULL)
    {
        char_printf(ch, "ReligionEd: %d: no such obj.\n", vnum);
        return FALSE;
    }
    
    obj = get_obj_index(vnum);
    
    if (vnum && obj->item_type != ITEM_RALTAR)
    {
        char_printf(ch, "ReligionEd: %d: not religion altar.\n", vnum);
        return FALSE;
    }

    return TRUE;
}


/*
void *stat_vlookup(varr *v, const char *name)
{
    int i;
        restrict_stat_t *stats;

    if (IS_NULLSTR(name))
        return NULL;

        log_printf("stat_vlookup argument: %s: .\n", name);
    for (i = 0; i < v->nused; i++) 
        {
        int *psn = (int*) VARR_GET(v, i);
                log_printf("stat_vlookup: %d: %d.\n", stats->stat, psn);

        if (stats = religion_stat_lookup(&v, *psn))
            return psn;
    }

    return NULL;
}
*/
