/*  $Id: olc_riddle.c,v 1.666 2004/09/20 10:50:30 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "merc.h"
#include "olc.h"
#include "riddle.h"

#define EDIT_RIDDLE(ch, riddle)	(riddle = (riddle_t*) ch->desc->pEdit)

DECLARE_OLC_FUN(riddleed_create       );
DECLARE_OLC_FUN(riddleed_edit         );
DECLARE_OLC_FUN(riddleed_touch        );
DECLARE_OLC_FUN(riddleed_show         );
DECLARE_OLC_FUN(riddleed_list         );

DECLARE_OLC_FUN(riddleed_question     );
DECLARE_OLC_FUN(riddleed_answer       );

olc_cmd_t olc_cmds_riddle[] =
{
    { "create",        riddleed_create,       5},
    { "edit",          riddleed_edit,         5},
    { "touch",         olced_dummy,           5},
    { "show",          riddleed_show,         0},
    { "list",          riddleed_list,         0},

    { "question",      riddleed_question,     5},
    { "answer",        riddleed_answer,       5},
    
    { "commands",      show_commands,         0},
    { NULL}
};

OLC_FUN(riddleed_create)
{
    riddle_t *riddle;

    if (!char_security(ch,"SECURITY_RIDDLE"))
    {
        char_puts("RiddleEd: Insufficient security for editing riddles\n", ch);
        return FALSE;
    }

    riddle              = riddle_new();
    
    ch->desc->pEdit     = (void *)riddle;
    OLCED(ch)   = olced_lookup(ED_RIDDLE);                              
    char_puts("Riddle created.\n",ch);
    return FALSE;
}

OLC_FUN(riddleed_edit)
{
    char arg[MAX_STRING_LENGTH];

    if (!char_security(ch,"SECURITY_RIDDLE"))
    {
        char_puts("RiddleEd: Insufficient security for editing riddles.\n", ch);
        return FALSE;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC EDIT'");
        return FALSE;
    }

    if (is_number(arg))
    {
        if(atoi(arg) < 0 || atoi(arg) > riddles.nused - 1 )
        {
            char_printf(ch, "RiddleEd: Number must be between %d and %d.\n", 0, riddles.nused - 1 );
            return FALSE;
        }

        ch->desc->pEdit     = RIDDLE(atoi(arg));
    }
    else
    {
        char_printf(ch, "RiddleEd: Number must be between %d and %d.\n", 0, riddles.nused - 1 );
        return FALSE;
    }

    OLCED(ch)   = olced_lookup(ED_RIDDLE);
    return FALSE;
}

OLC_FUN(riddleed_list)
{
    int i;

    for (i = 0; i < riddles.nused; i++)
        char_printf(ch, "[%d] %s\n", i, mlstr_cval(RIDDLE(i)->question, ch));
    return FALSE;
}


OLC_FUN(riddleed_question)
{
        riddle_t *riddle;

        EDIT_RIDDLE(ch, riddle);
        return olced_mlstr_text(ch, argument, cmd, &riddle->question);
}

OLC_FUN(riddleed_answer)
{
        riddle_t *riddle;

        EDIT_RIDDLE(ch, riddle);
        return olced_str(ch, argument, cmd, &riddle->answer);
}


OLC_FUN(riddleed_show)
{
    BUFFER *output;
    riddle_t *riddle;
    char arg[MAX_STRING_LENGTH];
    
    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        if (IS_EDIT(ch, ED_RIDDLE))
            EDIT_RIDDLE(ch, riddle);
        else
        {
            do_help(ch, "'OLC ASHOW'");
            return FALSE;
        }
    }
    else
    {
        if (is_number(arg))
        {
            if(atoi(arg) < 0 || atoi(arg) > riddles.nused - 1)
            {
                char_printf(ch, "RiddleEd: Number must be between %d and %d.\n", 0, riddles.nused -1 );
                return FALSE;
            }
            
            riddle = RIDDLE(atoi(arg));
        }
        else
        {
            char_printf(ch, "RiddleEd: Number must be between %d and %d.\n", 0, riddles.nused -1 );
            return FALSE;
        }
    }

    output = buf_new(ch->lang);

    //buf_printf(output, "Question:\n\n\r[%s]\n", riddle->question);
    mlstr_dump(output, "Question:\n", riddle->question);
    buf_printf(output, "Answer:             [%s]\n", riddle->answer);
    
    page_to_char(buf_string(output), ch);
    buf_free(output);
    
    return FALSE;
}
