/* $Id: olc_rpcode.c,v 1.666 2004/09/20 10:50:30 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <sys/types.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"
#include "olc.h"

#define EDIT_RPCODE(ch, rpcode)   (rpcode = (MPCODE*) ch->desc->pEdit)

extern MPCODE *get_prog_index(int vnum, int type);

/* Mobprog editor */
DECLARE_OLC_FUN(rped_create		);
DECLARE_OLC_FUN(rped_edit		);
DECLARE_OLC_FUN(rped_touch		);
DECLARE_OLC_FUN(rped_show		);
DECLARE_OLC_FUN(rped_list		);
DECLARE_OLC_FUN(rped_code		);

olc_cmd_t olc_cmds_rpcode[] =
{
/*	{ command	function	}, */

	{ "create",	rped_create,	5	},
	{ "edit",	rped_edit,      0	},
	{ "touch",	rped_touch,	    0	},
	{ "show",	rped_show,	    0	},
	{ "list",	rped_list,	    0	},

	{ "code",	rped_code,	    5	},

	{ "commands",	show_commands,	0	},

	{ NULL }
};

OLC_FUN(rped_create)
{
	MPCODE *rpcode;
	int value;
	AREA_DATA *pArea;
	char arg[MAX_STRING_LENGTH];

	one_argument(argument, arg, sizeof(arg));
	value = atoi(arg);
	if (!value) 
	{
		do_help(ch, "'OLC CREATE'");
		return FALSE;
	}

	pArea = area_vnum_lookup(value);
	if (!pArea) 
	{
		char_puts("RPEd: That vnum is not assigned an area.\n", ch);
		return FALSE;
	}

	if (!IS_BUILDER(ch, pArea)) 
	{
		char_puts("RPEd: Insufficient security.\n", ch);
		return FALSE;
	}

	if (rpcode_lookup(value)) 
	{
		char_puts("RPEd: vnum already exists.\n", ch);
		return FALSE;
	}

	rpcode			    = rpcode_new();
	rpcode->vnum		= value;
	rpcode_add(rpcode);

	ch->desc->pEdit		= (void *)rpcode;
	OLCED(ch) = olced_lookup(ED_RPCODE);
	touch_area(pArea);
	char_puts("RPEd: rpcode created.\n", ch);
	return FALSE;
}

OLC_FUN(rped_edit)
{
	MPCODE *rpcode;
	AREA_DATA *pArea;
	int value;
	char arg[MAX_INPUT_LENGTH];

	one_argument(argument, arg, sizeof(arg));
	if (arg[0] == '\0') {
		do_help(ch, "'OLC EDIT'");
		return FALSE;
	}

	value = atoi(arg);
	rpcode = rpcode_lookup(value);
	if (!rpcode) 
	{
		char_puts("RPEd: Vnum does not exist.\n", ch);
		return FALSE;
	}

	pArea = area_vnum_lookup(rpcode->vnum);
	if (!IS_BUILDER(ch, pArea)) 
	{
		char_puts("RPEd: Insufficient security.\n", ch);
	       	return FALSE;
	}

	ch->desc->pEdit = (void*) rpcode;
	OLCED(ch)   = olced_lookup(ED_RPCODE);
	return FALSE;
}

OLC_FUN(rped_touch)
{
	MPCODE *rpcode;
	EDIT_RPCODE(ch, rpcode);
	return touch_vnum(rpcode->vnum);
}

OLC_FUN(rped_show)
{
	MPCODE *rpcode;
	char arg[MAX_INPUT_LENGTH];

	one_argument(argument, arg, sizeof(arg));
	if (arg[0] == '\0') 
	{
		if (IS_EDIT(ch, ED_RPCODE))
			EDIT_RPCODE(ch, rpcode);
		else 
		{
			do_help(ch, "'OLC ASHOW'");
			return FALSE;
		}
	}
	else 
	{
		int value = atoi(arg);
		rpcode = rpcode_lookup(value);
		if (!rpcode) 
		{
			char_puts("RPEd: Vnum does not exist.\n", ch);
			return FALSE;
		}
	}

	char_printf(ch, "Vnum:       [%d]\n" "Code:\n%s\n", rpcode->vnum, rpcode->code);

	return FALSE;
}

OLC_FUN(rped_list)
{
	int count = 1;
	MPCODE *rpcode;
	BUFFER *buffer;
	bool fAll = !str_cmp(argument, "all");
	char blah;
	AREA_DATA *ad;

	buffer = buf_new(-1);

	for (rpcode = rpcode_list; rpcode !=NULL; rpcode = rpcode->next)
		if (fAll || ENTRE(ch->in_room->area->min_vnum, rpcode->vnum, ch->in_room->area->max_vnum)) 
	    {
			ad = area_vnum_lookup(rpcode->vnum);

			if (ad == NULL)
				blah = '?';
			else
			if (IS_BUILDER(ch, ad))
				blah = '*';
			else
				blah = ' ';

			buf_printf(buffer, "[%6d] (%c) %5d\n", count, blah, rpcode->vnum);
			count++;
		}

	if (count == 1) {
		if (fAll)
			buf_add(buffer, "No roomprogs found.\n");
		else
			buf_add(buffer, "No roomprogs found in this area.\n");
	}

	page_to_char(buf_string(buffer), ch);
	buf_free(buffer);

	return FALSE;
}

OLC_FUN(rped_code)
{
	MPCODE *rpcode;
	EDIT_RPCODE(ch, rpcode);
	return olced_str_text(ch, argument, cmd, &rpcode->code);
}

