/* $Id: olc_social.c,v 1.666 2004/09/20 10:50:31 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <stdio.h>
#include <string.h>

#include "merc.h"
#include "olc.h"
#include "db/socials.h"

#define EDIT_SOC(ch, soc)	(soc = (social_t*) ch->desc->pEdit)

DECLARE_OLC_FUN(soced_create        );
DECLARE_OLC_FUN(soced_edit          );
DECLARE_OLC_FUN(soced_show          );
DECLARE_OLC_FUN(soced_list          );

DECLARE_OLC_FUN(soced_name          );
DECLARE_OLC_FUN(soced_min_pos       );
DECLARE_OLC_FUN(soced_found_char    );
DECLARE_OLC_FUN(soced_found_vict    );
DECLARE_OLC_FUN(soced_found_notvict );
DECLARE_OLC_FUN(soced_noarg_char    );
DECLARE_OLC_FUN(soced_noarg_room    );
DECLARE_OLC_FUN(soced_self_char     );
DECLARE_OLC_FUN(soced_self_room     );
DECLARE_OLC_FUN(soced_notfound_char );
DECLARE_OLC_FUN(soced_all_char      );
DECLARE_OLC_FUN(soced_all_room      );
DECLARE_OLC_FUN(soced_all_self      );
DECLARE_OLC_FUN(soced_level         );
DECLARE_OLC_FUN(soced_age           );
DECLARE_OLC_FUN(soced_alias         );
DECLARE_OLC_FUN(soced_description   );

static DECLARE_VALIDATE_FUN(validate_name);

olc_cmd_t olc_cmds_soc[] =
{
    { "create",         soced_create,       0                     },
    { "edit",           soced_edit,         0                     },
    { "touch",          olced_dummy,        0                     },
    { "show",           soced_show,         0                     },
    { "list",           soced_list,         0                     },

    { "name",           soced_name,         0,      validate_name },
    { "alias",          soced_alias,        0                     },
    { "description",    soced_description,  0                     },
    { "min_pos",        soced_min_pos,      0,      position_table},

    { "found_char",     soced_found_char,   0                     },
    { "found_vict",     soced_found_vict,   0                     },
    { "found_notvict",  soced_found_notvict,0                     },

    { "noarg_char",     soced_noarg_char,   0                     },
    { "noarg_room",     soced_noarg_room,   0                     },

    { "all_char",       soced_all_char,     0                     },
    { "all_room",       soced_all_room,     0                     },
    { "all_self",       soced_all_self,     0                     },
            
    { "self_char",      soced_self_char,    0                     },
    { "self_room",      soced_self_room,    0                     },
    
    { "notfound_char",  soced_notfound_char,0                     },

    { "age",            soced_age,          0                     },
    { "level",          soced_level,        0                     },

    { "commands",       show_commands,      0                     },
    { NULL}
};

OLC_FUN(soced_create)
{
    social_t *soc;
    char arg[MAX_STRING_LENGTH];

    if (!char_security(ch, "SECURITY_SOCIALS"))
    {
        char_puts("SocEd: Insufficient security for creating socials\n",
                  ch);
        return FALSE;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC CREATE'");
        return FALSE;
    }

    if ((soc = social_lookup(arg, str_cmp)))
    {
        char_printf(ch, "SocEd: %s: already exists.\n", soc->name);
        return FALSE;
    }

    soc     = social_new();
    soc->name   = str_dup(arg);

    ch->desc->pEdit = (void *) soc;
    OLCED(ch)   = olced_lookup(ED_SOC);
    char_puts("Social created.\n",ch);
    return FALSE;
}

OLC_FUN(soced_edit)
{
    social_t *soc;
    char arg[MAX_STRING_LENGTH];

    if (!char_security(ch, "SECURITY_SOCIALS"))
    {
        char_puts("SocEd: Insufficient security.\n", ch);
        return FALSE;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_help(ch, "'OLC EDIT'");
        return FALSE;
    }

    if ((soc = social_lookup(arg, str_cmp)) == NULL)
    {
        char_printf(ch, "SocEd: %s: No such social.\n", arg);
        return FALSE;
    }

    ch->desc->pEdit = soc;
    OLCED(ch)   = olced_lookup(ED_SOC);
    return FALSE;
}

#define SOC_SHOW(format, s)			\
	if (!IS_NULLSTR(s))			\
		buf_printf(output, format, s);

OLC_FUN(soced_show)
{
    char arg[MAX_STRING_LENGTH];
    BUFFER *output;
    social_t *soc;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        if (IS_EDIT(ch, ED_SOC))
            EDIT_SOC(ch, soc);
        else
        {
            do_help(ch, "'OLC ASHOW'");
            return FALSE;
        }
    }
    else
    {
        if ((soc = social_lookup(arg, str_prefix)) == NULL)
        {
            char_printf(ch, "SocEd: %s: No such social.\n", arg);
            return FALSE;
        }
    }

    output = buf_new(-1);

    buf_printf(output,"name:          [%s]\n",soc->name);
    buf_printf(output,"alias:         [%s]\n",soc->alias);
    buf_printf(output,"description:   [%s]\n",soc->description);
    buf_printf(output,"min_pos:       [%s]\n",flag_string(position_table, soc->min_pos));

    SOC_SHOW("found_char:    [%s]\n", soc->found_char);
    SOC_SHOW("found_vict:    [%s]\n", soc->found_vict);
    SOC_SHOW("found_notvict: [%s]\n", soc->found_notvict);
    SOC_SHOW("noarg_char:    [%s]\n", soc->noarg_char);
    SOC_SHOW("noarg_room:    [%s]\n", soc->noarg_room);
    SOC_SHOW("self_char:     [%s]\n", soc->self_char);
    SOC_SHOW("self_room:     [%s]\n", soc->self_room);
    SOC_SHOW("all_char:      [%s]\n", soc->all_char);
    SOC_SHOW("all_room:      [%s]\n", soc->all_room);
    SOC_SHOW("all_self:      [%s]\n", soc->all_self);
    buf_printf(output,"age:           [%d]\n", soc->age);
    buf_printf(output,"level:         [%d]\n", soc->level);

    page_to_char(buf_string(output), ch);
    buf_free(output);

    return FALSE;
}

OLC_FUN(soced_list)
{
    int i;
    int col = 0;
    char arg[MAX_STRING_LENGTH];

    one_argument(argument, arg, sizeof(arg));

    for (i = 0; i < socials.nused; i++)
    {
        social_t *soc = (social_t*) VARR_GET(&socials, i);

        if (arg[0] && str_prefix(arg, soc->name))
            continue;

        char_printf(ch, "%-12s", soc->name);
        if (++col % 6 == 0)
            char_puts("\n", ch);
    }

    if (col % 6)
        char_puts("\n", ch);

    return FALSE;
}

OLC_FUN(soced_name)
{
    social_t *soc;
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->name);
}

OLC_FUN(soced_min_pos)
{
    social_t *soc;
    EDIT_SOC(ch, soc);
    return olced_flag32(ch, argument, cmd, &soc->min_pos);
}

OLC_FUN(soced_found_char)
{
    social_t *soc;
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->found_char);
}

OLC_FUN(soced_found_vict)
{
    social_t *soc;
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->found_vict);
}

OLC_FUN(soced_found_notvict)
{
    social_t *soc;
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->found_notvict);
}

OLC_FUN(soced_noarg_char)
{
    social_t *soc;
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->noarg_char);
}

OLC_FUN(soced_noarg_room)
{
    social_t *soc;
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->noarg_room);
}

OLC_FUN(soced_self_char)
{
    social_t *soc;
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->self_char);
}

OLC_FUN(soced_self_room)
{
    social_t *soc;
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->self_room);
}

OLC_FUN(soced_all_char)
{
    social_t *soc;
    
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->all_char);
}

OLC_FUN(soced_all_self)
{
    social_t *soc;
    
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->all_self);
}

OLC_FUN(soced_all_room)
{
    social_t *soc;
    
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->all_room);
}

OLC_FUN(soced_notfound_char)
{
    social_t *soc;

    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->notfound_char);
}

OLC_FUN(soced_level)
{
    social_t *soc;

    EDIT_SOC(ch, soc);
    return olced_number(ch, argument, cmd, &soc->level);
}
OLC_FUN(soced_age)
{
    social_t *soc;

    EDIT_SOC(ch, soc);
    return olced_number(ch, argument, cmd, &soc->age);
}

OLC_FUN(soced_alias)
{
        social_t *soc;

        EDIT_SOC(ch, soc);
        return olced_name(ch, argument, cmd, &soc->alias);
}

static VALIDATE_FUN(validate_name)
{
    const char *name = (const char*) arg;
    social_t *soc, *soc2;
    EDIT_SOC(ch, soc);

    if (strpbrk(name, " \t"))
    {
        char_printf(ch,
                    "SocEd: %s: illegal character in social name.\n",
                    arg);
        return FALSE;
    }

    if ((soc2 = social_lookup(name, str_cmp))
        &&  soc2 != soc)
    {
        char_printf(ch, "SocEd: %s: duplicate social name.\n", arg);
        return FALSE;
    }

    return TRUE;
}

OLC_FUN(soced_description)
{
    social_t *soc;
    
    EDIT_SOC(ch, soc);
    return olced_str(ch, argument, cmd, &soc->description);
}
