/* $Id: planets.c,v 1.666 2004/09/20 10:49:52 shrike Exp $ */
 
/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <math.h>


extern int     SUN_RISE_TIME;
extern int     SUN_SET_TIME;
extern void	   log_printf	  (const char *str, ...);
extern int     abs(int j);

double myint(double x){
	if (x>=0)
		x=floor(x);
	else
		x=ceil(x);
	return x    ;
}

/*
 * ID - day
 * ID - month
 * ID - year YYYY format
 * ID - day
 */

void sunrise(int day, int month, int year, double breadth, double longitude,int tz) 
{
	double P1,P2,DR,F,J;
	double Z0, G, J3, D1, S, A, T, TT, T0, SM, L, V, U, W, AA1, DA1, R5, AA2, DA2, Z1, C, Z, M8, W8, A0;
	double D0, DA, DD, C0, P, A2, D2, K1, L0, L2, H0, H2, H1, V0, V1, V2, B, D, EE, T3, H3, M3, H7, N7, D7;
	double AZ;

        V0 = 0;

	P1=3.14159265;
	P2=2.*P1;
	DR=P1/180.;

	longitude=longitude/360.;
	Z0=tz/24.;

	G=1;
	J3=0;
	if (year<1583)
	{
		G=0;
	}

	D1=myint(day);
	F=day-D1-.5;
	J=-myint(7*(myint((month+9)/12)+year)/4);
	if (G != 0)
	{
		S=((month-9)<0?-1:1);
		A=abs(month-9);
		J3=myint(year+S*myint(A/7));
		J3=-myint((myint(J3/100)+1)*3/4);
	}

	J=J+myint(275*month/9)+D1+G*J3;
	J=J+1721027+2*G+367*year;
	if (F<0)
	{
		F=F+1;
		J=J-1;
	}

	T=(J-2451545.)+F;
	TT=T/36525.+1.;
	T0=T/36525.;
	S=24110.5+8640184.813*T0;
	S=S+86636.6*Z0+86400.*longitude;
	S=S/86400.;
	SM=myint(S);
	S=S-myint(S);
	T0=S*360.*DR;
	T=T+Z0;
// funarg 1
	L=.779072+.00273790931*T;
	G=.993126+.0027377785*T;
	L=L-myint(L);
	G=G-myint(G);
	L=L*P2;
	G=G*P2;
	V=.39785*sin(L);
	V=V-.01000*sin(L-G);
	V=V+.00333*sin(L+G);
	V=V-.00021*TT*sin(L);
	U=1-.03349*cos(G);
	U=U-.00014*cos(2*L);
	U=U+.00008*cos(L);
	W=-.00010-.04129*sin(2*L);
	W=W+.03211*sin(G);
	W=W+.00104*sin(2*L-G);
	W=W-.00035*sin(2*L+G);
	W=W-.00008*TT*sin(G);
	S=W/sqrt(U-V*V);
	AA1=L+atan(S/sqrt(1-S*S));
	S=V/sqrt(U);
	DA1=atan(S/sqrt(1-S*S));
	R5=1.00021*sqrt(U);
	T=T+1;

// funarg 2
	L=.779072+.00273790931*T;
	G=.993126+.0027377785*T;
	L=L-myint(L);
	G=G-myint(G);
	L=L*P2;
	G=G*P2;
	V=.39785*sin(L);
	V=V-.01000*sin(L-G);
	V=V+.00333*sin(L+G);
	V=V-.00021*TT*sin(L);
	U=1-.03349*cos(G);
	U=U-.00014*cos(2*L);
	U=U+.00008*cos(L);
	W=-.00010-.04129*sin(2*L);
	W=W+.03211*sin(G);
	W=W+.00104*sin(2*L-G);
	W=W-.00035*sin(2*L+G);
	W=W-.00008*TT*sin(G);
	S=W/sqrt(U-V*V);
	AA2=L+atan(S/sqrt(1-S*S));
	S=V/sqrt(U);
	DA2=atan(S/sqrt(1-S*S));
	R5=1.00021*sqrt(U);
	if (AA2 < AA1)
	{
		AA2=AA2+P2;
	}

	Z1=DR*(90.833);

	S=sin(breadth*DR);
	C=cos(breadth*DR);
	Z=cos(Z1);
	M8=0.;
	W8=0.;
	A0=AA1;
	D0=DA1;
	DA=AA2-AA1;
	DD=DA2-DA1;
	for (C0=0;C0<=23;C0++)
	{
		P=(C0+1.)/24.;
		A2=AA1+P*DA;
		D2=DA1+P*DD;
		K1=15.*DR*1.0027379;
		L0=T0+C0*K1;
		L2=L0+K1;
		H0=L0-A0;
		H2=L2-A2;
		H1=(H2+H0)/2.;
		D1=(D2+D0)/2.;
		if (C0<=0.)
		{
			V0=S*sin(D0)+C*cos(D0)*cos(H0)-Z;
		}
		V2=S*sin(D2)+C*cos(D2)*cos(H2)-Z;

		if ((V0<0?-1:1)==(V2<0?-1:1))
		{
			A0=A2;
			D0=D2;
			V0=V2;

			continue;
		}
		V1=S*sin(D1)+C*cos(D1)*cos(H1)-Z;
		A=2.*V2-4.*V1+2.*V0;
		B=4.*V1-3.*V0-V2;
		D=B*B-4.*A*V0;
		if (D<0)
		{
			A0=A2;
			D0=D2;
			V0=V2;
			continue;
		}
		D=sqrt(D);
		EE=(-B+D)/(2.*A);
		if (EE>1 || EE<0.)
		{
			EE=(-B-D)/(2.*A);
		}
		T3=C0+EE+1./120.;
		H3=myint(T3);
		M3=myint((T3-H3)*60.);
		if (V0<0. && V2>0.)
		{
			if ((int)M3 > 30 )
				SUN_RISE_TIME = (int)H3 + 1;
			else
				SUN_RISE_TIME = (int)H3;

			log_printf("Sun_RISE_TIME: %02d", SUN_RISE_TIME);
			
			M8=1.;
		}
		if (V0>0. && V2<0.)
		{

			if ((int)M3 > 30 )
				SUN_SET_TIME = (int)H3 + 1;
			else
				SUN_SET_TIME = (int)H3;

			log_printf("Sun_SET_TIME: %02d", SUN_SET_TIME);

			W8=1.;
		}
		H7=H0+EE*(H2-H0);
		N7=-cos(D1)*sin(H7);
		D7=C*sin(D1)-S*cos(D1)*cos(H7);
		AZ=atan(N7/D7)/DR;
		if (D7<0.)
		{
			AZ=AZ+180.;
		}
		if (AZ<0.)
		{
			AZ=AZ+360.;
		}
		if (AZ>360)
		{
			AZ=AZ-360.;
		}

		A0=A2;
		D0=D2;
		V0=V2;

	}


	if (M8+W8==0)
	{
		if (V2<0)
		{
			log_printf(" ");
		}
		if (V2>0)
		{
			log_printf(" ");
		}
	}
	if (M8+W8!=0)
	{
		if (M8==0)
		{
			log_printf("  ");
		}
		if (W8==0)
		{
			log_printf("  ");
		}
	}


}
