/* $Id: price.c,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "merc.h"
#include "price.h"

//static char *price_string_converter(const char *s);

varr prices = { sizeof(price_t), 4 };

price_t *price_new()
{
	price_t *price;
	price = varr_enew(&prices);
	return price;
}

void price_free(price_t *price)
{
	free_string(price->name);
        free_string(price->descriptor);
	price->amount = 0;
        price->amount_type = 0;
}

price_t *price_lookup(const char *name,
			int (*cmpfun)(const char *s1, const char *s2))
{
	int i;

    for (i = 0; i < prices.nused; i++) 
    {
		price_t *price = VARR_GET(&prices, i);
        if (!cmpfun(name, price->name))
			return price;
	}

	return NULL;
}

/*
 * Check char on have need ammount for pay
 */

bool char_have_amount(CHAR_DATA *ch, const char *name)
{
  price_t *price;
  
  price = price_lookup(name, str_cmp);

  if (price == NULL)
  {
      log_printf("ERROR: In price table not record for price name: %s", name);
      return FALSE;
  }
  
  switch(price->amount_type){
  case PRICE_GOLD:
         if (price->amount > (ch->gold + ch->pcdata->bank_g))
             return FALSE;
         else
             return TRUE;
  case PRICE_QP:
         if (price->amount > ch->pcdata->questpoints)
             return FALSE;
         else
             return TRUE;
  case PRICE_BP:
      if (price->amount > ch->pcdata->bonuspoints)
             return FALSE;
      else
             return TRUE;
  case PRICE_RP:
      if (price->amount > ch->pcdata->religionpoints)
             return FALSE;
      else
             return TRUE;
  default:
     log_printf("Unknown price type %d in price %s", price->amount_type, price->name);
     return FALSE;
  }
  return FALSE;
}


/*
 * get payment from char.
 */

bool  get_amount_from_char(CHAR_DATA *ch, const char *name)
{
    price_t *price;

    price = price_lookup(name, str_cmp);

     if (price == NULL)
     {
         log_printf("ERROR: In price table not record for price name: %s", name);
         return FALSE;
     }

    switch (price->amount_type)
    {
      case PRICE_GOLD:
            if (ch->pcdata->bank_g < price->amount)
            {
                  ch->gold = ch->gold - (price->amount - ch->pcdata->bank_g);
                  ch->pcdata->bank_g = 0;
            } else
                  ch->pcdata->bank_g = ch->pcdata->bank_g - price->amount;
            break;
      case PRICE_QP:
            ch->pcdata->questpoints = ch->pcdata->questpoints - price->amount;
            break;
      case PRICE_BP:
            ch->pcdata->bonuspoints = ch->pcdata->bonuspoints - price->amount;
            break;
      case PRICE_RP:
            ch->pcdata->religionpoints = ch->pcdata->religionpoints - price->amount;
            break;
      default: 
            log_printf("Unknown price type: %d in price name: %s", price->amount_type, name);
            return FALSE;
            break;
    }
    return TRUE;
}

/*
 * Return cost for price name
 */

int   get_price_cost(const char *name)
{
    price_t *price;

    price = price_lookup(name, str_cmp);

     if (price == NULL)
     {
         log_printf("ERROR: In price table not record for price name: %s", name);
         return -1;
     }

    if (price->amount > 0)
        return price->amount;
    else
        return 0;
}

/*
 * Return type payment for price
 */

int  get_price_type(const char *name)
{
    price_t  *price;

    price = price_lookup(name, str_cmp);

    if (price == NULL)
    {
        log_printf("ERROR: In price table not record for price name: %s", name);
        return -1;
    }
    return price->amount_type;
}

void do_price(CHAR_DATA *ch, const char *argument)
{
	int i;

	for (i = 0; i < prices.nused; i++)
	{
        price_t *price = (price_t*) VARR_GET(&prices, i);
        char_printf(ch, "[%3d] %-15s %-30s [%5d] %d\n", i, price->name, price->descriptor, price->amount, price->amount_type);
	}
}

/*
static char *price_string_converter(const char *s)
{
	static char buf[MAX_STRING_LENGTH];
	const char *p;
    const char *temp;
    char from[] = "qwertyuiopasdfghjklzxcvbnm";
    char   to[] = "QWERTYUIOPASDFGHJKLZXCVBNM";
    char nahren[] = "";

	for (temp = s; *temp != '\0'; temp++)
	{
   		if (strchr(nahren, *temp) != NULL)
			continue;

		if ((p = strchr(from, *temp)) != NULL)
			*(buf + (temp-s)) = * (to + (p - from));
		else
           *(buf+(temp-s)) = *temp;
    }
	*(buf+(temp-s)) = '\0';
    return buf;
}*/
	
