/* $Id: price.h,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#ifndef _PRICE_H_
#define _PRICE_H_

#define        PRICE_GOLD   0
#define        PRICE_QP     1
#define        PRICE_BP     2
#define        PRICE_RP     3

typedef struct price_t price_t;

/*
 * Structure for price
 */

struct price_t
{
    const char 	*name;
    const char 	*descriptor;
    int         amount;
    flag64_t    amount_type;      /*  int*/
};


#define PRICE(i)	((price_t *) VARR_GET(&prices, i))

extern varr prices;

price_t *    price_new();
void	      price_free(price_t *price);
price_t *    price_lookup(const char *name,
			      int (*cmpfun)(const char *s1, const char *s2));

bool         char_have_amount       (CHAR_DATA *ch, const char *name);
bool         get_amount_from_char   (CHAR_DATA *ch, const char *name);
bool         get_cost_from_char     (CHAR_DATA *ch, int count, int type, bool use_bank);
int          char_amount            (CHAR_DATA *ch, const char *name);
int          get_price_cost         (const char *name);
int          get_price_type         (const char *name);
const char*  price_to_char          (const char *name);
#endif

