/* $Id: prog.h,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 
/************************************************************************************
 *  Original code by DalekenMUD 1.12 (C) 2000                                       *
 *  Adapted for current codebase by Shrike aka Sauron at 2004                       *
 ************************************************************************************/

#ifndef _H_PROGRAM_
#define _H_PROGRAM_
/*
 * Mud program information
 */

  #define PROG_ERROR              -1

  /* universal programs */
  #define GLOBAL_PROG             0       /* A global mud prog            */
  #define SUB_PROG                1       /* Sub procedure, no trigger    */
  #define ACT_PROG                2       /* On act message               */
  #define SPEECH_PROG             3       /* On speech                    */
  #define RAND_PROG               4       /* At random time               */
  #define GREET_PROG              5       /* When player enters           */
  #define ALL_GREET_PROG          6       /* When player enters inc. sneak */
  #define LEAVE_PROG              7       /* Just before a player leaves  */
  #define TIME_PROG               8       /* At specified time(s)         */
  #define REPOP_PROG              9       /* When loaded                  */
  #define LOOK_PROG               10      /* explicitly look at           */
  #define COMMAND_PROG            11      /* explicitly look at           */

  /* mob only programs */
  #define FIGHT_PROG              12      /* Every round when fighting        */
  #define DEATH_PROG              13      /* When killed, before corpse       */
  #define HITPRCNT_PROG           14      /* When below %age hps, every round */
  #define ENTRY_PROG              15      /* When it walks into a room        */
  #define GIVE_PROG               16      /* When an item is given to it      */
  #define BRIBE_PROG              17      /* When gold is given               */
  #define ATTACK_PROG             18      /* When someone attacks it          */
  #define DELAY_PROG              19      /* When it finishes being delayed   */
  #define CAST_PROG               20      /* When someone casts a spell at it */

  /* object programs */
  #define WEAR_PROG               21      /* When worn                    */
  #define REMOVE_PROG             22      /* When taken off               */
  #define SAC_PROG                23      /* Just before sacrifice        */
  #define EXAMINE_PROG            24      /* Examine or "look in"         */
  #define USE_PROG                25      /* Wands, staves, scrolls, potions.. */
  #define GET_PROG                26      /* When picked up               */
  #define DROP_PROG               27      /* When put back down           */
  #define DAMAGE_PROG             28      /* When damaged                 */
  #define REPAIR_PROG             29      /* When repaired                */
  #define OPEN_PROG               30      /* When opened (container)      */
  #define CLOSE_PROG              31      /* When closed (container)      */
  #define LOOT_PROG               32      /* When items are taken out     */
  #define PUTIN_PROG              33      /* Placing an item in a contain.*/

  /* room programs */
  #define SLEEP_PROG              34      /* When a player goes to sleep  */
  #define REST_PROG               35      /* When a player rests          */

  #define MPROG_GLOBAL_HASH       16

  #define MPROG_GLOBAL_MOB        1       /* Allow mobs to use the prog.  */
  #define MPROG_GLOBAL_OBJ        2       /* Allow objects to use the prog. */
  #define MPROG_GLOBAL_ROOM       4       /* Allow rooms to use the prog. */

#endif
