/* $Id: psionics.c,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "merc.h"
#include "fight.h"
#include "quest.h"
#include "rating.h"
#include "fight.h"
#include "cyborg.h"
#include "skills.h"
#include "update.h"
#include "psionics.h"
#include "war.h"

int last_power_score; //global variable
extern const char *target_name;
extern const char *extra_arguments;

extern bool check_recovery(CHAR_DATA *ch, CHAR_DATA *victim);
extern bool check_jammer(CHAR_DATA *ch);
extern bool check_trust(CHAR_DATA *ch, CHAR_DATA *victim);
extern void do_cast_org(CHAR_DATA *ch, const char *argument, int type);
extern bool target_ioga(CHAR_DATA *ch, int sn, int *ptarget, void **pvo, int *poff, int *pdoor);
extern bool can_cast(CHAR_DATA *ch, CHAR_DATA *victim);
extern bool check_components(CHAR_DATA *ch, int sn, int chance);


DECLARE_DO_FUN(do_track     );

int* psi_defense [6] =
{
  &gsn_power_shift,
  &gsn_mind_defence,
  &gsn_defence_aura,
  &gsn_prudence_shield,
  &gsn_subjective_reality,
  NULL
};

int* psi_attack [6] =
{
  &gsn_mental_trance,
  &gsn_mind_attack,
  &gsn_attack_aura,
  &gsn_battle_trance,
  &gsn_martial_trance,
  NULL
};

int psi_att_vs_def [6][6] =
{
  {  5, -2, -4, -4, -5, 5},
  {  5,  0, -3, -4, -3, 5},
  { -3,  2,  4, -1, -3, 5},
  {  1, -3, -1, -3, -4, 5},
  {  2,  3,  0, -1, -2, 5},
  {  0,  0,  0,  0,  0, 2}
}; 

/*
 *  DF level -> ADnD level
 */
int psionic_level(CHAR_DATA *ch)
{
    return URANGE(1, (ch->level - 11) / 4, 20);
}

/*
 * Maximum number of disciplines, psionic sciences, devotions 
 *                   and defense modes allowed.
 */

int total_disciplines(CHAR_DATA *ch)
{
   return URANGE(1, (psionic_level(ch)+6)/4, 6);
}

int total_sciences(CHAR_DATA *ch)
{
   return URANGE(1, (psionic_level(ch)+1)/2, 10);
}

int total_devotions(CHAR_DATA *ch)
{
   switch (psionic_level(ch))
   {
     case 1: return 3;
     case 2: return 5;
     case 3: return 7;
     default: return (psionic_level(ch)+5);
   }
}

int total_defense_modes(CHAR_DATA *ch)
{
    return URANGE(1, (psionic_level(ch)+1)/2, 5);
}

/*
 * Psionic power points stuff
 */
int psp_base_score(CHAR_DATA *ch)
{
    int base, int_mod, con_mod;
    base = URANGE(1, 2 * (get_curr_stat(ch, STAT_WIS) - 12), 26);
    con_mod = URANGE(0, get_curr_stat(ch, STAT_CON) - 22, 3);
    int_mod = URANGE(0, get_curr_stat(ch, STAT_INT) - 22, 3);
    return base + con_mod + int_mod;
}

int psp_per_level(CHAR_DATA *ch)
{
   return 10 + URANGE(0, get_curr_stat(ch, STAT_WIS) - 22, 3);
}

int psp_max(CHAR_DATA *ch)
{
    return psp_base_score(ch) + (psionic_level(ch) - 1) * psp_per_level(ch) * 10;
}

/*
 * Used in farsight.
 */

ROOM_INDEX_DATA * check_place(CHAR_DATA *ch, const char *argument)
{
    EXIT_DATA *pExit;
    ROOM_INDEX_DATA *dest_room;
    int number,door;
    int range = (ch->level / 10) + 1;
    char arg[MAX_INPUT_LENGTH];

    number = number_argument(argument, arg, sizeof(arg));
    if ((door = check_exit(arg)) == -1) return NULL;

    dest_room = ch->in_room;
    while (number > 0)
    {
    number--;
    if (--range < 1) return NULL;
    if ((pExit = dest_room->exit[door]) == NULL
    || (dest_room = pExit->to_room.r) == NULL
    || IS_SET(pExit->exit_info,EX_CLOSED))
        break;
    if (number < 1) return dest_room;
    }
    return NULL;
}

/*
 * Power Score is a maximal value you can roll for a successful power check.
 */
int power_score(CHAR_DATA *ch, int sn)
{
  skill_t *sk;
  int score;
  if (sn < 0)
    sn = gsn_psionics;
  sk = SKILL(sn);
  if (sk == NULL)    // this shouldn't happen
     return 10;      // something average

  score =  (sk->stat1 == -1) ? 20 : get_curr_stat(ch, sk->stat1);
    //     normal spectre of PC stat values is  3-18 for ADnD
    //                                     and 10-25 for DF,
    // so let's shift at -7      /evil. G
    // Actually, human psionicists max stat is just 23 -> 16
  score -= 7;
  score = URANGE(3, score, 18);
  score += sk->bonus;
  if (has_discipline(ch, sk->discipline))
      score++;
  
  // Actually, we could throw away wish mindblank and the following penalty.
  if (!IS_NPC(ch) && sn == gsn_psionics)
  {
      if(!(IS_SET(ch->pcdata->wishes, WISH_MINDBLANK)))
     score = UMIN(score, 10);
  }

  return score;
  // NB:
  // Reasonable values of score is from 1 to 19
  // If score < 2, power check succeeds only when dice is 1 --
  //               the so-called minimal success with various penalties.
  // If score > 18, power check fails only when dice is 20.
}

int power_check(CHAR_DATA *ch, int sn)
{
  int dice, score;
  dice = number_range(1, 20);
  last_power_score = dice;
  score = power_score(ch, sn);
  if (dice == 20)
    return 0;
  if (dice == 1)
    return 1;
  if (dice > score)
    return 0;
  if (number_percent() >= get_skill(ch, sn))
  {
     char_act("Your concentration is broken.", ch);
     return 0;
  }
  return dice;
}

bool psychic_contest(CHAR_DATA *ch, CHAR_DATA *victim, int sn)
{
    int att, def, bonus, att_score, def_score, sn2;
    sn2 = -1;
    for (att=0;att<5;att++)
    if (*psi_attack[att] == sn)
        break;
    for (def=0;def<5;def++)
    if (*psi_defense[def] == victim->psi_def)
        break;
    if (def<5)
    sn2 = victim->psi_def;
    bonus = psi_att_vs_def[att][def]; // varies from -5 to 5
                                  // this modifier used only when
                                  // establishing new contact     
    // GM added for PK
    // - nice idea, but I fixed def_score to bonus, 
    //   so we'll not ruin special values checks
    //   (it's analog of minimal success chance in saves) /evil G.
    if (!IS_NPC(victim))
    bonus += (LVL(ch) - LVL(victim));  // too much, but let's try.
    else
    bonus += (LVL(ch) - LVL(victim))/2; // so
    
    resists_modify(&bonus, check_immune(victim, DAM_MENTAL),
            bonus > 0 ? TRUE : FALSE); 

    // NB:
    // 1. If bonus < -17, then attacks succeeds <-> 
    //    defender failed power check AND attacker not failed power check.
    // 2. If bonus > 18, then attack fails <-> attacker failed power check. 

    // the order of next two lines is important, so we set
    // last_power_score to attacker's value
    def_score = power_check(victim, sn2); // from 0 to min(19, power_score)
    att_score = power_check(ch, sn);      // from 0 to min(19, power_score)
    act("Your score is $j,",
        ch, (const void *) att_score, victim, 
        TO_CHAR | ACT_NOLF);
    act("$N's score is $j,",
        ch, (const void *) def_score, victim,
        TO_CHAR | ACT_NOLF);
    act("Bonus is $j.", ch, (const void *) bonus, victim, TO_CHAR | ACT_NOLF);
    if (is_immune(victim, DAM_MENTAL))
    {
    act("$N is immune to mental attacks.", ch, NULL, victim, TO_CHAR);
    return FALSE;
    }
    if (att_score == 0)
    {
    char_act("You lose the psychic contest.", ch);
    return FALSE;
    }
    if (def_score == 0)
    {
    char_act("You win the psychic contest.", ch);
    return TRUE;
    }
    if (att_score + bonus > def_score)
    {
    char_act("You win the psychic contest.", ch);
    return TRUE;
    }
    char_act("You lose the psychic contest.", ch);
    return FALSE;
}

// Check if ch is contacted with victim
bool is_contacted(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int i;
    if (ch == NULL || victim == NULL)
    return FALSE;
    if (ch == victim)
    return TRUE;
    for (i=0; i<MAX_CONTACTS; i++)
    {
    if (ch->contact[i] == NULL)
        continue;
    if (victim == ch->contact[i])
        return TRUE;
    }
    return FALSE;
}

// Check if someone is contacted with ch
// return the first one contacted, or NULL if noone.
CHAR_DATA* Contacted(CHAR_DATA *ch)
{
    CHAR_DATA *wch;
    for (wch = char_list; wch; wch = wch->next)
        if (is_contacted(wch, ch) && ch != wch)
            return wch;
    return NULL;
}

bool add_contact(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int i;
    if (ch == NULL || victim == NULL)
        return FALSE;
    if (ch == victim)
        return TRUE;
    for (i=0; i < MAX_CONTACTS; i++)
    {
        if (ch->contact[i] == NULL)
        {
            ch->contact[i] = victim;
            return TRUE;
        }
    }
    act("You haven't any empty contact slots.", ch, NULL, NULL, TO_CHAR);
    return FALSE;
}

void remove_contact(CHAR_DATA *ch, CHAR_DATA *victim)
{
    int i;
    if (ch == NULL || victim == NULL)
        return;
    for (i=0;i<MAX_CONTACTS;i++)
    if (ch->contact[i] == victim)
        ch->contact[i] = NULL;
    if (ch->tangent == victim)
    {
        ch->tangent = NULL;
        ch->tangents = 0;
    }
    if (IS_AFFECTED(victim, AFF_CHARM) && (victim->master == ch)
    && is_affected(victim, sn_lookup("mind control")))
        affect_strip(victim, sn_lookup("mind control"));
}

void free_contacts(CHAR_DATA *ch)
{
    int i;
    if (ch == NULL)
        return;
    ch->tangent = NULL;
    for (i=0; i < MAX_CONTACTS; i++)
        ch->contact[i] = NULL;
}

void do_ejection(CHAR_DATA *ch, const char* argument)
{
    CHAR_DATA *wch;
    if (ch->psp >= 10)
        ch->psp -= 10;
    else
    {
        if (ch->mana < ch->max_mana * 2 / 3)
        {
            char_act("You should restore your psi power or mana before you could attempt ejection.", ch);
            return;
        }
        char_act("You are mentally exhausted.", ch);
        ch->psp = 0;
        ch->mana -= number_range(1, ch->mana);
    }
    if ((wch = Contacted(ch)) == NULL)
    {
        char_act("You have nothing to eject.", ch);
        return;
    }
    spell_ejection(sn_lookup("ejection"), LVL(ch), ch, wch, TARGET_CHAR);
}

void do_maintain(CHAR_DATA *ch, const char* argument)
{
    AFFECT_DATA *af, *af_next;
    skill_t *sk;
    int sn, i, pos;
    bool found = FALSE;
    CHAR_DATA *victim;

    if (IS_NPC(ch))
        return;

    if (ch->pcdata->security < 1)
        return;
    
    act_puts3("You have $j psionic power points from $J total.",
        ch, (const void *) ch->psp, NULL,
            (const void *) (psp_max(ch)), TO_CHAR, POS_DEAD);
/* Show defense mode if any */
    for (i=0; i < 5; i++)
    if (*psi_defense[i] == ch->psi_def)
        break;
    if (i < 5)
    {
        sn = ch->psi_def;
        act("You're in $t defense mode.",
            ch, SKILL(sn)->name, NULL, TO_CHAR);
    }
/* Show attack mode if any */
    for (i=0; i < 5; i++)
    if (*psi_attack[i] == ch->psi_att)
        break;
    if (i < 5)
    {
        sn = ch->psi_att;
        act("You're in $t attack mode.",
            ch, SKILL(sn)->name, NULL, TO_CHAR);
    }
/* Show contacts and tangents, if any */    
    for (i=0, pos=0; i < MAX_CONTACTS; i++)
    {
        if (ch->contact[i] == NULL)
            continue;
        if (pos == 0)
            act("You have established the following contacts:",
                ch, NULL, NULL, TO_CHAR);
        if (i > pos)
            ch->contact[pos] = ch->contact[i];
        victim = ch->contact[pos];
        act("$j. $N", ch, (const void *) (pos+1), victim, TO_CHAR);
        if (IS_AFFECTED(victim, AFF_CHARM) && (victim->master == ch)
        && is_affected(victim, sn_lookup("mind control")))
            act("(dominated, maintenance cost is $j PSP/hour",
                ch, (const void *) (2 * psionic_level(victim)), victim, TO_CHAR);
        pos++;
    }
    if (pos == 0)
        act("You haven't established any contacts.",
            ch, NULL, NULL, TO_CHAR);
    if (pos == MAX_CONTACTS)
        act("And that's the maximal number of contacts allowed to you.",
            ch, NULL, NULL, TO_CHAR);
    else
        act("And you can establish $j new contacts.",
            ch, (const void *) (MAX_CONTACTS - pos), NULL, TO_CHAR);
    if (ch->tangent != NULL && ch->tangents > 0 && ch->tangents < 3)
        act("You have $j-finger contact with $N.",
            ch, (const void *) ch->tangents, ch->tangent, TO_CHAR);

    for (af = ch->affected; af != NULL; af = af_next) 
    {
        af_next = af->next;
        sn = af->type;
        if ((sk=SKILL(sn)) == NULL)
            continue;
        if (sk->maintain == 0)
            continue;
        if (!found)
        {
            found = TRUE;
            char_act("You're maintaining the following powers:", ch);
        }
        act("$FL30{$T:}$j PSP/hour", ch, (const void *) sk->maintain, sk->name, TO_CHAR);
    }
    if (!found)
        char_act("You're not maintaining any psionic powers.", ch);
}

/* disciplines specialization */
bool has_discipline(CHAR_DATA * ch, flag32_t disc)
{
    int i;
    flag32_t *d;
    if (IS_NPC(ch))
        return TRUE;
    d = ch->pcdata->disciplines;
    for (i=0;i<6;i++)
    {
        if (IS_SET(d[i], disc))
            return TRUE;
    }
    return FALSE;
}

void do_disciplines (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH];
    int i;
    flag32_t * d, disc = 0;
    if (IS_NPC(ch) || !HAS_SKILL(ch, gsn_psionics))
    {
        act("You don't know anything about psionics.", ch, NULL, NULL, TO_CHAR);
        return;
    }
    d = ch->pcdata->disciplines;
    one_argument(argument, arg, sizeof(arg));

    // display help
    if (arg[0] == '\0')
    {
        int diff;
        if (d[0] == 0)
            act("You haven't access to any psionic disciplines.",
                ch, NULL, NULL, TO_CHAR);
        else
            act("You have access to the following disciplines (in order of majority):", 
                ch, NULL, NULL, TO_CHAR);
        for (i=0;i<6;i++)
        {
            disc |= d[i];
            if (d[i] == 0)
                break;
            act("$t", ch, flag_string(psi_disciplines,d[i]), NULL, TO_CHAR);
        }
        if ((diff = (ch->level + 30)/20-i)> 0)
        {
            act("You can learn $j more $qj{disciplines} from the following: ", 
                ch, (const void *) diff, NULL, TO_CHAR);
            disc = -1 - disc;
            act("$t", ch, flag_string(psi_disciplines,disc), NULL, TO_CHAR);
        }
        return;
    }
  
    disc = flag_value(psi_disciplines, arg);
  
    if (disc == 0)
    {
        act("No such discipline '$t'", ch, arg, NULL, TO_CHAR);
        return;
    }
  
    for (i=0; i < 6; i++)
    {
        if (IS_SET(d[i], disc))
        {
            act("You already have access to discipline $t.",
                ch, flag_string(psi_disciplines,disc), NULL, TO_CHAR);
            return;
        }
        if (d[i] == 0)
        {
            if ((ch->level + 30) / 20 - i <= 0)
            {
                act("You can't learn any more psionic disciplines yet.",
                    ch, NULL, NULL, TO_CHAR);
                return;
            }
            d[i] = disc;
            act("You learned new discipline - $t.",
                ch, flag_string(psi_disciplines,disc), NULL, TO_CHAR);
            return;
        }
    }
}

DO_FUN(do_concentrate)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    void *vo;
    int psp, mana, sn = -1, target, door, slevel, chance = 0;
    bool cast_far = FALSE, offensive = FALSE;
    skill_t *psi;
    pcskill_t *ps;

    one_argument(argument, arg, sizeof(arg));
    if (!str_cmp(arg,"on") || !str_cmp(arg,""))
        argument = one_argument(argument, arg, sizeof(arg));

    if (IS_NPC(ch) /*|| !HAS_SKILL(ch, gsn_psionics)*/)
    {
        do_cast_org(ch, argument, TYPE_POWER);
        return;
    } 

    target_name = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0') 
    {
        char_act("  ?", ch);
        return;
    }

    if ((ps = skill_vlookup_type(&ch->pcdata->learned, arg, TYPE_POWER))
    && skill_level(ch, sn = ps->sn) <= ch->level)
      chance = ps->percent;

    if (sn < 0)
    {
        char_act("No such psionic power.", ch);
        return;
    }

    psi = SKILL(sn);

    if (!check_components(ch, sn, chance))
        return;

    psp = UMAX(0, psi->initial);
    if (ch->psp < psp) 
    {
        char_act("Too low on psi energy.", ch);
        return;
    }

    mana = mana_cost(ch, sn);
    if (ch->mana < mana) 
    {
        char_act("   .", ch);
        return;
    }

    if (!target_ioga(ch, sn, &target, &vo, &offensive, &door))
    {
        WAIT_STATE(ch, MISSING_TARGET_DELAY);
        return;
    }

    victim = NULL;
    if (target == TARGET_CHAR)
    {
        victim = (CHAR_DATA *) vo;
        cast_far = victim->in_room != ch->in_room;
        if (victim && !can_cast(ch, victim))
            return;
        if (victim->in_room
        && (IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA) 
        || (victim->in_war && victim->war_status == PS_ALIVE ))
        && IS_SET(psi->flags, SKILL_NOARENA))
        {
            char_act("You can't use it versus people at the battle arena.", ch);
            return;
        }

        if (IS_SET(psi->flags, SKILL_CONTACT_REQUIRED)
        && !is_contacted(ch, victim))
        {
            act_puts("You should establish a contact with $gN{him} first.", 
                ch, NULL, victim, TO_CHAR, POS_DEAD);
            return;
        }
    }

    if (ch->pcdata
    && (psi->target == TAR_CHAR_DEFENSIVE
    || psi->target == TAR_CHAR_SELF
    || psi->target == TAR_OBJ_CHAR_DEF))
    {
        if (IS_SET(ch->pcdata->wishes, WISH_SPELLUP2))
            WAIT_STATE(ch, psi->beats / 4);
        else if (IS_SET(ch->pcdata->wishes, WISH_SPELLUP1))
            WAIT_STATE(ch, psi->beats / 2);
        else
            WAIT_STATE(ch, psi->beats);
    } else
        WAIT_STATE(ch, psi->beats);

/*
    if (!power_check(ch, ps->sn)) 
    {
        char_act("You failed the power.", ch);
        check_improve(ch, sn, FALSE, 1);
        ch->psp -= psp / 2;
        if (cast_far) 
            cast_far = FALSE;
        check_improve(ch, gsn_psionics, FALSE, 4);
    } else 
    {
        slevel = LVL(ch);
*/

    if (ch->daze >= 16) 
       chance = URANGE(0, chance, 10); 
    else if (ch->daze >=  8) 
       chance = URANGE(0, chance, 25); 
    else if (ch->daze >=  4) 
       chance = URANGE(0, chance, 50);

    if (number_percent() > chance)
    {
        char_act("You failed the power.", ch);
        check_improve(ch, sn, FALSE, 1);
        ch->psp -= psp / 2;
        ch->mana -= mana / 2;
        if (cast_far) 
            cast_far = FALSE;
        check_improve(ch, gsn_psionics, FALSE, 4);
    } else
    {
        slevel = LVL(ch);

        slevel += (UMAX(0, get_curr_stat(ch, STAT_INT)-21) +
                    UMAX(0,get_curr_stat(ch, STAT_WIS)-21) +
                    UMAX(0,get_curr_stat(ch, STAT_CON)-21)) / 2;

        if (number_percent() < get_skill(ch, gsn_psionics) / 2)
        {
            slevel += number_range(8, 10);
            check_improve(ch, gsn_psionics, TRUE, 3);
        } else
        {
            slevel += number_range(4, 6);
            check_improve(ch, gsn_psionics, FALSE, 3);
        }

        if (victim && is_contacted(ch, victim))
            slevel += slevel / 6;

        ch->psp -= psp;
        ch->mana -= mana;
        psi->spell_fun(sn, slevel, ch, vo, target);
        check_improve(ch, sn, TRUE, 1);
    }
    
    if (target != TARGET_CHAR || JUST_KILLED(ch) || JUST_KILLED(victim))
        return;

    if (cast_far && door != -1)
    {
        path_to_track(ch, victim, door);
        return;
    }
  
    if (offensive && victim != ch && victim->master != ch
    && victim->fighting == NULL && IS_AWAKE(victim)
    && victim->in_room == ch->in_room)
        multi_hit(victim, ch, TYPE_UNDEFINED);
}

/* Now basic psionic powers */

/* contact */
SPELL_FUN(spell_contact)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int psp;
    psp = psionic_level(victim);
    if (is_contacted(ch, victim))
    {
        act("You are already established a contact with $N!",
            ch, NULL, victim, TO_CHAR);
        return;
    }
    if (ch->psp < psp)
    {
        act("You need $j psi power $qj{points} to establish contact with $gN{him}.", 
            ch, (const void *) psp, victim, TO_CHAR);
        return;
    }
    if (!IS_NPC(victim)
    && check_trust(ch, victim))
    {
        ch->psp -= psp;
        if (add_contact(ch, victim))
            act("You established mind contact with $N.",
                ch, NULL, victim, TO_CHAR);
        return;
    }
    ch->psp -= psp;
    if (add_contact(ch, victim))
        act("You established mind contact with $N.",
            ch, NULL, victim, TO_CHAR);
}

SPELL_FUN(spell_forced_contact)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam, i, attempts = 1;

    if (ch == victim)
    {
        return;
    }
    
    if (ch->tangent == NULL)
        ch->tangents = 0;
    else if (ch->tangent != victim)
    {
        if (ch->tangents == 1 || ch->tangents == 2)
            act("You broke your $j-finger contact with $N.",
                ch, (const void *) ch->tangents, ch->tangent, TO_CHAR);
        ch->tangents = 0;
    }
    ch->tangent = victim;       

    if (!is_contacted(ch, victim))
    {
        for(i=0 ; i < attempts; i++)
        { 
            if (psychic_contest(ch, victim, sn))
            { 
                switch (++(ch->tangents)) 
                {
                case 1:
                    act("You established one-finger contact with $N.",
                        ch, NULL, victim, TO_CHAR);
                    act("$n established one-finger contact with you.",
                        ch, NULL, victim, TO_VICT);
                    break;
                case 2:
                    act("You established two-finger contact with $N.",
                        ch, NULL, victim, TO_CHAR);
                    act("$n established two-finger contact with you.",
                        ch, NULL, victim, TO_VICT);
                    break;
                default:
                    if (add_contact(ch, victim)) 
                    {
                        act("You established mind contact with $N.",
                            ch, NULL, victim, TO_CHAR);
                        act("$n established mind contact with you.",
                            ch, NULL, victim, TO_VICT);
                    }
                    return;
                }
            }
        }
        return;
    } else
    {
        dam = number_range(level * 14, level * 18);
        if (saves_spell(level, victim, DAM_MENTAL))
            dam /= 2;
        damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);
    }
    return;
}

SPELL_FUN(spell_recall_pain)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    dam = number_range(level, level * 7) + 10;
    if (saves_spell(level, victim, DAM_MENTAL))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);

    return;
}

SPELL_FUN(spell_recall_agony)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    dam = number_range(level*6, level*8);
    if (saves_spell(level, victim, DAM_MENTAL))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);

    return;
}

SPELL_FUN(spell_recall_death)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam, chance = 100;

    chance -= (level - LVL(victim));
    chance -= get_skill(ch, gsn_psionics);

    chance = UMAX (4, chance);

    if (number_range(1, chance) == 1 
    && victim->level < (level + (level / 4))
    && !IS_CLAN_GUARD(victim)
    && !IS_IMMORTAL(victim)
    && IS_NPC(victim)) 
    {
        act("Your recall death criticaly hits $N's head!",
            ch, NULL, victim, TO_CHAR);
        act("$n's recall death criticaly hits $N's head!",
            ch, NULL, victim, TO_NOTVICT);
        act("$n's recall death criticaly hits your head!",
            ch, NULL, victim, TO_VICT);
        victim->position = POS_DEAD;
        handle_death(ch, victim);
        return;
    }

    dam = number_range(level * 14, level * 18);
    if (saves_spell(level, victim, DAM_MENTAL))
        dam /= 2;
    damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);

    return;
}

/* 
 * attack modes :
 * mental trance
 * mind attack
 * attack aura
 * battle trance
 * martial trance
 */
SPELL_FUN(spell_psionic_attack)
{
//    ch->psi_def = -1;
    ch->psi_att = sn;
    act("You concentrate on $t attack mode.", ch, SKILL(sn)->name, NULL, TO_CHAR);
}

/*
 * defense modes:
 * power shift
 * mind defence
 * defence aura
 * shield of prudence
 * subjective reality
 */
SPELL_FUN(spell_psionic_defense)
{
    ch->psi_def = sn;
//    ch->psi_att = -1;
    act("You concentrate on $t defense mode.", ch, SKILL(sn)->name, NULL, TO_CHAR);
}

/* Derived powers */
SPELL_FUN(spell_mind_wrack)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    dam = dice(level, 7);
    if (!psychic_contest(ch, victim, sn))
        dam /= 2;
    act("$n stares intently at $N, causing $N to seem very lethargic.",
        ch,NULL,victim,TO_NOTVICT);
    damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);
}

SPELL_FUN(spell_mind_wrench)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    dam = number_range(level*8, level*12);
    if (!psychic_contest(ch, victim, sn))
        dam /= 2;
    act("    $N, $n  $N   .",
        ch, NULL, victim, TO_NOTVICT);
    damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);
}

SPELL_FUN(spell_psionic_storm)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    CHAR_DATA *vch, *last_vict, *next_vict;
    bool found;
    int dam;

    /* first strike */

    act("$n  .      .",
                ch, NULL, victim, TO_ROOM);
    act("    $n    $N.",
    ch,NULL,victim,TO_ROOM);
    act("         $N.",
    ch,NULL,victim,TO_CHAR);
    act("    $n    !",
    ch,NULL,victim,TO_VICT);

    dam = dice(level,25);
    if (!psychic_contest(ch, victim, sn))
    dam /= 2;
    damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);

    last_vict = victim;
    level -= 10;   /* decrement damage */

    /* new targets */
    while (level > 0) {
    found = FALSE;
    for (vch = ch->in_room->people; vch; vch = next_vict) {
        next_vict = vch->next_in_room;

        if (vch == last_vict)
            continue;

        if (is_safe_spell(ch, vch, TRUE)) {
            act("    $n.",
                ch, NULL, NULL, TO_ROOM);
            act("    .",
                ch, NULL, NULL, TO_CHAR);
            continue;
        }

        found = TRUE;
        last_vict = vch;
        act("   $n!", vch, NULL, NULL, TO_ROOM);
        act("   !", vch, NULL, NULL, TO_CHAR);
        dam = dice(level,25);

        if (!psychic_contest(ch, vch, sn))
            dam /= 2;
        damage(ch, vch, dam, sn, DAM_LIGHTNING, TRUE);
        level -= 10;  /* decrement damage */
    }   /* end target searching loop */

    if (found)
        continue;

    /* no target found, hit the caster */
    if (ch == NULL)
        return;

    if (last_vict == ch) { /* no double hits */
        act(" .",
            ch, NULL, NULL, TO_ROOM);
        act("      .",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    last_vict = ch;
    act("  $n... !", ch, NULL, NULL, TO_ROOM);
    char_act("   !", ch);
    dam = dice(level,15);
    if (power_check(ch, sn))
        dam /= 2;
    damage(ch, ch, dam, sn, DAM_MENTAL, TRUE);
    level -= 4;  /* decrement damage */
    } /* now go back and find more targets */
}

SPELL_FUN(spell_mana_boom)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (!psychic_contest(ch, victim, sn)) 
    {
        char_act(".     ! ---!", ch);
        dam = ch->mana / 2;
        ch->mana = ch->mana / 2;
        damage(victim, ch, dam, sn, DAM_NEGATIVE, TRUE);
    } else 
    {
        char_act("  !", victim);
        act("      $N.", ch, NULL, victim, TO_CHAR);
        dam = victim->mana / 2;
        victim->mana = victim->mana / 2;
        if (IS_NPC(victim))
            dam /= 2;
        damage(ch, victim, dam, sn, DAM_NEGATIVE, TRUE);
    }
}

SPELL_FUN(spell_emp_shockwave)
{
    EXIT_DATA *pExit;
    ROOM_INDEX_DATA *dest_room;
    CHAR_DATA *vch, *vch_next;
    int door,chance,i,dam;
    int range = (ch->level / 30) + 1;
    int wait = 0;
    bool saves;

    if ((door = check_exit(target_name)) == -1) 
    {
        char_act("What direction (west south east north down up)?.", ch);
        return;
    }
    
    dest_room = ch->in_room;
    
    for (i=0;i<range;i++)
    {
    // dest_room - current room
    for (vch = dest_room->people; vch != NULL; vch = vch_next)
    {
        vch_next = vch->next_in_room;

        if (!IS_NPC(vch)) char_act("    .", vch);

        if (is_safe_spell(ch,vch,TRUE) ||
            (IS_NPC(vch)  && vch->in_room != ch->in_room  && IS_SET(vch->pIndexData->act, ACT_NOTRACK)))
                            continue;
        
        dam = dice(level, 17);
        if (!psychic_contest(ch, vch, sn))
            dam /= 2;
        if (IS_CYBORG(vch))
            dam*=2;
// Shield's Out                     

    saves = !psychic_contest(ch, vch, sn);

    if (!saves && is_affected(vch, gsn_protective_shield)) {
    if (number_percent() < 45) {
        act_puts("    ,  $N.", ch, NULL, vch, TO_CHAR, POS_FIGHTING);
        act_puts(" $n    .", ch, NULL, vch, TO_VICT, POS_FIGHTING);
        act_puts(" $n     $N.", ch, NULL, vch, TO_NOTVICT, POS_FIGHTING);
        affect_strip(vch, gsn_protective_shield);
    }
    return;
    }

    if (!saves && is_affected(vch, gsn_shield)) {
    if (number_percent() < 60) {
        act_puts("    ,  $N.", ch, NULL, vch, TO_CHAR, POS_FIGHTING);
        act_puts(" $n    .", ch, NULL, vch, TO_VICT, POS_FIGHTING);
        act_puts(" $n     $N.", ch, NULL, vch, TO_NOTVICT, POS_FIGHTING);
        affect_strip(vch, gsn_shield);
    }
    return;
    }

    if (!saves && is_affected(vch, gsn_field)) {
    if (number_percent() < 30) {
        act_puts("    ,  $N.", ch, NULL, vch, TO_CHAR, POS_FIGHTING);
        act_puts(" $n  ϣ  .", ch, NULL, vch, TO_VICT, POS_FIGHTING);
        act_puts(" $n     $N.", ch, NULL, vch, TO_NOTVICT, POS_FIGHTING);
        affect_strip(vch, gsn_field);
    }
    return;
    }

// No nore shields (gig)
    damage(ch,vch,dam,sn,DAM_ENERGY,TRUE);

    if (!IS_NPC(vch))
    {
      chance = 25;
    chance += (23-get_curr_stat(vch, STAT_STR))*3;
    chance += (22-get_curr_stat(vch,STAT_DEX))*3;
    if (is_affected(vch, gsn_protective_shield))
      chance/=2;
            
    if (number_percent() < chance)
      if (vch->position > POS_RESTING)
        {
          char_act("   .", vch);
            vch->position=POS_RESTING;
            wait = 3;
            if(check_recovery(vch, ch))
              wait /= 2;
            if(check_jammer(vch))
              wait /= 2;
            if (IS_CYBORG(vch))
              wait *= 2;
            DAZE_STATE(vch, PULSE_VIOLENCE * wait);
            if (wait > 0) {
                AFFECT_DATA af;
                af.where = TO_AFFECTS;
                af.type = gsn_bash;
                af.level = level;
                af.duration = 2;
                af.modifier = LVL(vch);
                af.location = APPLY_AC;
                af.bitvector = 0;

                affect_to_char(vch, &af);
      }
        }
    }
    else
    {
        if (IS_NPC(vch) && vch->position != POS_DEAD    &&  vch->in_room != ch->in_room) 
        {
            vch->last_fought = ch;
            do_track(vch, str_empty);
        }
    }
    }

    //end direction or closed door
    if ((pExit = dest_room->exit[door]) == NULL || 
    (dest_room = pExit->to_room.r) == NULL || 
    IS_SET(pExit->exit_info,EX_CLOSED))
    return;
    }
}

SPELL_FUN(spell_virtual_food)
{
    if (!IS_NPC(ch)) {
    gain_condition(ch, COND_HUNGER, level/2);
    gain_condition(ch, COND_THIRST, level/2);
    char_act("       ţ.", ch);
    }
}

SPELL_FUN(spell_mana_transfer)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (victim == ch)
    {
      char_act("    .", ch);
      return;
    }
    if (ch->mana < 100)
    {
    char_act("You have no mana to transfer.", ch);
    return;
    }

    victim->mana += number_range(100, ch->mana);
    ch->mana -= number_range(100, ch->mana);

    damage(ch, ch, 50, sn, DAM_NONE, TRUE);
}

SPELL_FUN(spell_block_vision)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_BLIND))
    {
      if (ch == victim)
    char_act("  ?    !", ch);
      else
    act("$N  !",ch,NULL,victim,TO_CHAR);
      return;
    }

    if (!psychic_contest(ch, victim, sn) || IS_UNDEAD(victim))
    {
      char_act("   .", ch);
      return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.location  = APPLY_HITROLL;
    af.modifier  = 0 - number_fuzzy(level/3);
    af.duration  = UMAX(3, last_power_score);
    af.bitvector = AFF_BLIND;
    affect_to_char(victim, &af);
    char_act(" !", victim);
    act("$n .",victim,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_mind_terror)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_UNDEAD(victim))
    {
    act("$N       $gN{}!",
            ch,NULL,victim,TO_CHAR);
    return;
    }

    if (IS_SAMURAI(victim))
    {
    char_act("    .", ch);
    return;
    }

    if (IS_AFFECTED(victim, AFF_FEAR) || 
    !psychic_contest(ch, victim, sn))
    return;

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = level / 10;
    af.location  = 0;
    af.modifier  = 0;
    af.bitvector = AFF_FEAR;
    affect_to_char(victim, &af);
    char_act("     .", victim);
    act("$n    .",victim,NULL,NULL,TO_ROOM);
    return;
}

SPELL_FUN(spell_terangreal)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;
    AFFECT_DATA af2;

    if (IS_NPC(victim))
        return;

    if (IS_AFFECTED(victim, AFF_SLEEP))
    {
        act("$N      !",ch,NULL,victim,TO_CHAR);
        return;
    }

    if (IS_UNDEAD(victim))
    {
        act("$N       !", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (!IS_NPC(victim) && (level + level/10 < victim->level))
    {
        char_act("-  ,    !", ch);
        return;
    }

    if (is_affected (victim, gsn_insomnia)
    || IS_IMMORTAL(victim))
    {
        act(" $N   .", ch, NULL, victim, TO_CHAR);
        return;
    }   

    if (is_affected(ch, sn))
    {
        char_act("     !", ch);
        return;
    }

    if (victim->fighting)
    {
        char_act("   ,  .", ch);
        return;
    }

    af2.where     = TO_AFFECTS;
    af2.type      = sn;
    af2.level     = level;
    af2.duration  = IS_IMMORTAL(ch) ? 0 : 30;
    af2.location  = 0;
    af2.modifier  = 0;
    af2.bitvector = 0;
    affect_to_char(ch, &af2);

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = 0;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_SLEEP;
    affect_join(victim, &af);

    if (IS_AWAKE(victim))
    {
        char_act("    ...", victim);
        act("$n    .", victim, NULL, NULL, TO_ROOM);
        victim->position = POS_SLEEPING;
    }

    return;
}

SPELL_FUN(spell_forcecage)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_PROTECTION))
    {
        if (is_affected(victim, sn))
        {
            if (victim == ch)
                act("You already have a forcecage around you.",
                        ch, NULL, NULL, TO_CHAR);
            else
                act("$N already has a forcecage around $gN{himself}.",
                        ch, NULL, victim, TO_CHAR);
        } else
        {
            if (victim == ch)
                act("You already have another protection around you.",
                        ch, NULL, NULL, TO_CHAR);
            else
                act("$N already has another protection around $gN{himself}.",
                        ch, NULL, victim, TO_CHAR);
        }
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = level;
    af.duration  = -1;
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_PROTECTION;
    affect_to_char( victim, &af );
    act("$n used the Force to build a cage of power around $gn{himself}.", 
                victim, NULL, NULL, TO_ROOM );
    act("You used the Force to build a cage of power around you.", 
                victim, NULL, NULL, TO_CHAR );
    return;
}

SPELL_FUN(spell_infravision)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;

    if (IS_AFFECTED(victim, AFF_INFRARED)) 
    {
        if (victim == ch)
            char_act("    .", ch);
        else
            act("$N    .\n",
                ch, NULL, victim,TO_CHAR);
        return;
    }
    act(" $n  {R {x.\n", ch, NULL, NULL, TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = level;
    af.duration     = -1;
    af.location     = APPLY_NONE;
    af.modifier     = 0;
    af.bitvector    = AFF_INFRARED;
    affect_to_char(victim, &af);
    char_act("   {R {x.", victim);
}

SPELL_FUN(spell_farsight)
{
    ROOM_INDEX_DATA *room,*oldr;
    int mount;

    if ((room = check_place(ch,target_name)) == NULL)
    {
        char_act("     .", ch);
        return;
    }

    if (ch->in_room == room)
        do_look(ch, "auto");
    else
    {
        if (!IS_NPC(ch))
            SET_BIT(ch->plr_flags, PLR_GHOST);
        mount = MOUNTED(ch) ? 1 : 0;
        oldr = ch->in_room;
        char_from_room(ch);
        char_to_room(ch, room);
        do_look(ch, "auto");
        char_from_room(ch);
        char_to_room(ch, oldr);
        if (!IS_NPC(ch))
            REMOVE_BIT(ch->plr_flags, PLR_GHOST);
        if (mount)
        {
            ch->riding = TRUE;
            MOUNTED(ch)->riding = TRUE;
        }
    }
}

SPELL_FUN(spell_amnesia)
{
    int i;
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (IS_NPC(victim))
        return;

    // Let's check the psychic contest, and if we pass it,
    // we'll have some last_power_score determined for further computations
    if (!psychic_contest(ch, victim, sn)
    || number_bits(1) == 1)
    {
        act("$N resists your psychic crush.", ch, NULL, victim, TO_CHAR);
        return;
    }

    for (i = 0; i < victim->pcdata->learned.nused; i++)
    {
        pcskill_t *ps = VARR_GET(&victim->pcdata->learned, i);
        // GM : 0-9 % to forget each skill
        if ((number_percent() < last_power_score / 2
        || IS_IMMORTAL(ch)) && !IS_SET(ps->xs_flags, XS_FORGOT)
        && ps->percent > 1)
        {
            SET_BIT(ps->xs_flags, XS_FORGOT);
            act("He forgot '$t'.",
                ch, SKILL(ps->sn)->name, NULL, TO_CHAR);
            act("You forgot '$t'.",
                victim, SKILL(ps->sn)->name, NULL, TO_CHAR);
        }
    }
    act("     .", victim, NULL, NULL, TO_CHAR);
    act("$n ,     .", victim, NULL, NULL, TO_ROOM);
}

SPELL_FUN(spell_memento)
{
    int i;
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (IS_NPC(victim))
        return;

    if (!power_check(ch, sn))
    {
        char_act("You failed to reveal anything.", ch);
        return;
    }

    for (i = 0; i < victim->pcdata->learned.nused; i++)
    {
        pcskill_t *ps = VARR_GET(&victim->pcdata->learned, i);
        // 4*(0-19) % to remember each skill
        if ((number_percent() < 4 * last_power_score
        || IS_IMMORTAL(ch)) && IS_SET(ps->xs_flags, XS_FORGOT))
        {
            REMOVE_BIT(ps->xs_flags, XS_FORGOT);
            act("He remembered '$t'.",
                ch, SKILL(ps->sn)->name, NULL, TO_CHAR);
            act("You remembered '$t'.",
                victim, SKILL(ps->sn)->name, NULL, TO_CHAR);
        }
    }
    act("   $n.", victim, NULL, NULL, TO_ROOM);
    char_act("   .", victim);
}

SPELL_FUN(spell_mind_focusing)
{
    AFFECT_DATA af;

    if (is_affected(ch, sn)) 
    {
        char_act("You are already as focused as possible.", ch);
        return;
    }

    af.where      = TO_RESIST;
    af.type       = sn;
    af.level      = level;
    af.duration   = -1;
    af.location   = APPLY_NONE;
    af.modifier   = 40;
    af.bitvector  = DAM_MENTAL;
    affect_to_char(ch, &af);
    char_act("You feel your mind more focused.", ch);
}

SPELL_FUN(spell_combat_mind)
{
    AFFECT_DATA af;

    if (MOUNTED(ch)) 
    {
        char_act("       !", ch);
        return;
    }

    if (is_affected(ch, sn)) 
    {
        char_act("    .", ch);
        return;
    }

    do_sit(ch, str_empty);

    char_act("   ,    !", ch);
    act_puts("$n    .", 
        ch, NULL, NULL, TO_ROOM, POS_FIGHTING);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = LVL(ch);
    af.duration     = -1;
    af.modifier     = UMAX(1, LVL(ch)/8);
    af.bitvector    = 0;

    af.location     = APPLY_HITROLL;
    affect_to_char(ch,&af);

    af.location     = APPLY_DAMROLL;
    affect_to_char(ch,&af);

    af.modifier     = - UMAX(1,LVL(ch));
    af.location     = APPLY_AC;
    affect_to_char(ch,&af);
    char_act("You feel your mind sharpened for combat.", ch);
}

SPELL_FUN(spell_ejection)
{
   CHAR_DATA *victim = (CHAR_DATA *) vo;
   bool result;

   if (!is_contacted(victim, ch))
   {
       act("But $N is not contacted with you.", ch, NULL, victim, TO_CHAR);
       return;
   }
   ch->psp -= 2 * power_score(victim, sn_lookup("contact"));

   result = power_check(ch, sn);

   // check penalties first
   switch (last_power_score)
   {
    case 1: // Lose access to all sciences
        {
          int i;
          char_act("You forgot everything.", ch);
          for (i = 0; i < victim->pcdata->learned.nused; i++)
          {
            pcskill_t *ps = VARR_GET(&victim->pcdata->learned, i);
            SET_BIT(ps->xs_flags, XS_FORGOT);
          }
        }
        break;
    case 2: // Lose access to one discipline
        {
          int i;
          pcskill_t *ps;
          i = number_range(0,victim->pcdata->learned.nused - 1);
          ps = VARR_GET(&victim->pcdata->learned, i);
          SET_BIT(ps->xs_flags, XS_FORGOT);
          act("You forgot $t.", ch, SKILL(ps->sn)->name, NULL, TO_CHAR);
        }
        break;
    case 3: // Lose 1d10 +10 additional PSPs
        ch->psp -= dice(1,10) + 10;
        update_pos(ch);
        break;
    case 4: // Lose 1d10 additional PSPs
        ch->psp -= dice(1,10);
        update_pos(ch);
        break;
    case 5: // Lose 1 point of Constitution permanently
        -- ch->perm_stat[STAT_CON];
        char_act("This ejection traumatizes your health.", ch);
        break;
    case 6: // Lose 1d10 hit points
        ch->hit -= dice(1,10) * LVL(ch);
        update_pos(ch); 
        break;
    case 7: // Sever only one portion of contact 
        // (one successful attack reestablishes it)
        if (result)
        {
            victim->tangent = ch;
            victim->tangents = 2;
        // Let's hide the fact, that contact is not broken fully.
        //  act("You broke only one tangent of contact with $N",
                act("You ejected $N from your mind.",       
                ch, NULL, victim, TO_CHAR);
            act("$n broke one tangent of your contact.",
                ch, NULL, victim, TO_VICT);
            return;
        }
        break;
    case 8: //Sever only two portions of contact 
        // (two successful attacks reestablish it)
        if (result)
        {
            victim->tangent = ch;
            victim->tangents = 1;
        // Let's hide the fact, that contact is not broken fully.
        //  act("You broke only two tangents of contact with $N",
            act("You ejected $N from your mind.",
                ch, NULL, victim, TO_CHAR);
            act("$n broke two tangents of your contact.",
                ch, NULL, victim, TO_VICT);
            return;
        }
        break;
    default: break;
   }

   if (result)
   {
       act("You ejected $N from your mind.", ch, NULL, victim, TO_CHAR);
       act("$n broken contact with you.", ch, NULL, victim, TO_VICT);
       remove_contact(victim, ch);
   } else
   {
       act("You failed attempt to broke contact with $N", ch, NULL, victim, TO_CHAR);
   }
}

SPELL_FUN(spell_endure)
{
    AFFECT_DATA af;

    if (is_affected(ch, sn)) 
    {
        char_act("       .", ch);
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = LVL(ch);
    af.duration     = LVL(ch) / 4 + 5;
    af.location     = APPLY_SAVING_SPELL;
    af.modifier     = -1 * (get_skill(ch, sn) / 10 + get_skill(ch, gsn_psionics) / 20);
    af.bitvector    = 0;

    affect_to_char(ch, &af);

    char_act("      .", ch);
    act("$n   ,   .",
    ch, NULL, NULL, TO_ROOM);
}


SPELL_FUN(spell_subjective_reality)
{
}

// Use the Force.
//  :
// 1. concentrate on 'project force' east.Vasya drag
//       
// (,  ,      ).
// 2. concentrate on 'project force' east.Vasya push
// 
// 2. concentrate on 'project force' east.Vasya push east
//        .
// 3. concentrate on 'project force' east.Vasya push north
//   ,    ,    ,...
// 4. concentrate on 'project force' east.Vasya push west
//      ,    ,
//         .
// (    drag)
//        .
//       ,     .
//    ,    
// ( ,   ,    ),
//    .
//      ,     .
//      ,       ,
//     .
//  ,         ,
//     , ,  -  
//  .
// ,        ,   .
// ,     ... 
//               /sg, , 16  2004 . 04:55:08 (MSK)

SPELL_FUN(spell_project_force)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    ROOM_INDEX_DATA *dest_room;
    EXIT_DATA *pExit, *pExit_rev;
    char dir_victim[MAX_STRING_LENGTH]; // direction.victim
    char action[MAX_STRING_LENGTH];  // drag / push / shove
    char direction[MAX_STRING_LENGTH]; // direction
    const char *point;
    char *p;
    int range, door = -1, dam = 0, wait = 1, daze = 1;
    bool is_drag = FALSE;


    one_argument(target_name, dir_victim, sizeof(dir_victim));
                       // just victim's dir.name; we know it already
                       //      

    point = one_argument(extra_arguments, action, sizeof(action));
                               // what we'll do with victim
    point = one_argument(point, direction, sizeof(direction));
                              // force direction

    //      
    if ((p = strchr(dir_victim, '.')) != NULL)
    {
        char buf[MAX_STRING_LENGTH];
        strnzncpy(buf, sizeof(buf), dir_victim, p - dir_victim);
        door = check_exit(buf);
    }

    //      .
    //    ,    .
    //      .
    dam = level * victim->size / 6;
    range = (level * (5 + last_power_score) / 300);
    range = range * 6 / UMAX(2, victim->size);
    range = URANGE(1, range, 12); //    12 .


    if (!str_cmp(action, "drag"))
    {
        if (ch->in_room == victim->in_room)
        {
            act("$N is already here.", ch, NULL, victim, TO_CHAR);
            return;
        }
        door = opposite_door(door);
        is_drag = TRUE;
    } else // "if (!str_cmp(action, "push"))"
    {
        int door2;
        door2 = check_exit(direction);
        if (door2 >= 0)
            door = door2;
    }

    if (door < 0)
    {
        do_help(ch, "'PROJECT FORCE'");
        return;
    }

    act("     -  $t.",
            victim, dir_name[door], NULL, TO_CHAR);

    for (dest_room = victim->in_room; range > 0; range--)
    {
        if (is_drag && victim->in_room == ch->in_room)
            break;

        if ((pExit = dest_room->exit[door]) == NULL
        || (dest_room = pExit->to_room.r) == NULL)
        {
            damage(victim, victim, range * dam, sn, DAM_BASH, TRUE);
            break;
        }

        if (!can_see_room(victim, dest_room) 
        || room_is_private(dest_room))
            break;

        if (IS_SET(pExit->exit_info, EX_CLOSED)
        && (!IS_AFFECTED(ch, AFF_PASS_DOOR) 
        || IS_SET(pExit->exit_info, EX_NOPASS)))
        {
            int success_level = 3;

            if (!IS_SET(pExit->exit_info, EX_LOCKED))
                success_level = 1;
            else if (IS_SET(pExit->exit_info, EX_PICKPROOF))
                success_level = 6;
            else if (IS_SET(pExit->exit_info, EX_INFURIATING))
                success_level = 5;
            else if (IS_SET(pExit->exit_info, EX_HARD))
                success_level = 4;
            else if (IS_SET(pExit->exit_info, EX_EASY))
                success_level = 2;

            if (number_range(1,6) <= success_level)
            {
                act("  $gn{}  $d,    .",
                    victim, NULL, pExit->keyword, TO_CHAR);
                DAZE_STATE(victim, daze * PULSE_VIOLENCE);
                WAIT_STATE(victim, wait * PULSE_VIOLENCE);
                damage(victim, victim, (range + success_level) * dam, sn, DAM_BASH, TRUE);
                break;
            }

            REMOVE_BIT(pExit->exit_info, EX_CLOSED | EX_LOCKED);

            act("  $d.", victim, NULL, pExit->keyword, TO_CHAR);
            act("$n  $d    $t.",
                victim, dir_name[door], pExit->keyword, TO_ROOM);
            if ((pExit_rev = dest_room->exit[opposite_door(door)]) != NULL
            && pExit_rev->to_room.r == victim->in_room)
            {
                CHAR_DATA *rch;

                REMOVE_BIT(pExit_rev->exit_info, EX_CLOSED | EX_LOCKED);
                for (rch = dest_room->people; rch != NULL; rch = rch->next_in_room)
                    act("$d ,  $c4{$i}.", 
                        rch, victim, pExit_rev->keyword, TO_CHAR);
            }
            DAZE_STATE(victim, daze * PULSE_VIOLENCE);
            WAIT_STATE(victim, wait * PULSE_VIOLENCE / 2);
            damage(victim, victim, (1 + success_level) / 2 * dam, sn, DAM_BASH, TRUE);
            if (victim == NULL || JUST_KILLED(victim))
                return;
        }
        act("$n   $t.",
                victim, dir_name[door], NULL, TO_ROOM);
        char_from_room(victim);
        char_to_room(victim, dest_room);
        char_act("   .", victim);
        act("$n   $t.",
            victim, dir_name[opposite_door(door)], NULL, TO_ROOM);
        if (!power_check(ch, sn))
            break;
    }

    if (victim == NULL || JUST_KILLED(victim))
        return;
    char_act("   $gn{}.", victim);
}

SPELL_FUN(spell_confuse)
{
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    AFFECT_DATA af;
    CHAR_DATA *rch;

    if (is_affected(victim, sn))
    {
        act("$N    .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (!psychic_contest(ch, victim, sn))
    {
        af.where        = TO_AFFECTS;
        af.type         = sn;
        af.level        = level;
        af.duration     = 10;
        af.modifier     = 0;
        af.location     = 0;
        af.bitvector    = 0;
        affect_to_char(victim,&af);
    }

    for (rch = victim->in_room->people; rch; rch = rch->next_in_room)
    {
        if (rch != ch && can_see(victim, rch)
        && (number_range(level/2,3*level) >= (victim->level - victim->saving_throw)))
            break;
    }

    if (rch == NULL)
        rch = ch;
    do_murder(victim, rch->name);
}

void check_confuse(CHAR_DATA *ch)
{
    CHAR_DATA *rch;

    if (!is_affected(ch, gsn_confuse))
        return;
    if ((ch->fighting != NULL) && number_percent() < 20)
    {
        do_flee(ch, str_empty);
        return;
    }
    if ((ch->fighting == NULL) && number_percent() < 15)
    {
        for (rch = ch->in_room->people; rch; rch = rch->next_in_room) 
        {
            if (rch != ch && can_see(ch, rch) && number_percent() < 40)
                break;
        }
        if (rch != NULL)
            do_murder(ch, rch->name);
    }
}

SPELL_FUN(spell_disgrace)
{
    AFFECT_DATA af;
    CHAR_DATA *victim = (CHAR_DATA *) vo;

    if (is_affected(victim, sn))
    {
        act("$N     $gN{}  .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (!psychic_contest(ch, victim, sn))
    {
        af.where          = TO_AFFECTS;
        af.type               = sn;
        af.level              = level;
        af.duration           = level;
        af.location           = APPLY_CHA;
        af.modifier           = -15;
        af.bitvector          = 0;
        affect_to_char(victim,&af);

        char_act("    .", victim);
        act("$n    !", victim, NULL, NULL, TO_ROOM);
    } else
        char_act("   .", ch);
}

SPELL_FUN(spell_mental_knife)
{
    AFFECT_DATA af;
    CHAR_DATA *victim = (CHAR_DATA *) vo;
    int dam;

    if (!is_affected(victim, sn)
    && !psychic_contest(ch, victim, sn))
    {
        af.where      = TO_AFFECTS;
        af.type       = sn;
        af.level      = level;
        af.duration   = level;
        af.location   = APPLY_INT;
        af.modifier   = -7;
        af.bitvector  = 0;
        affect_to_char(victim, &af);

        af.location = APPLY_WIS;
        affect_to_char(victim, &af);
        act("     $N!",
            ch, NULL, victim, TO_CHAR);
        act("  $n   !",
            ch, NULL, victim, TO_VICT);
        act("  $n   $N!",
            ch, NULL, victim, TO_NOTVICT);
    }

    dam = number_range(level * 6, level * 10);

    if (!psychic_contest(ch, victim, sn))
        dam /= 2;

    damage(ch, victim, dam, sn, DAM_MENTAL, TRUE);
}

