/* $Id: race.c,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "merc.h"

varr races = { sizeof(race_t), 8 };

race_t *race_new(void)
{
    race_t *race;
    int i;

    race = varr_enew(&races);

    race->immunes = 0;
    for (i = 0; i < MAX_DAM; i++)
        race->resists[i] = 0;

    for (i = 0; i < MAX_WEAR; i++)
                race->wear_loc[i] = 1;
    race->wear_loc[WEAR_PLUG_IN] = 0;
    race->wear_loc[WEAR_TAIL] = 0;

    return race;
}

pcrace_t *race_pcdata_new(void)
{
    pcrace_t *pcr;

    pcr = calloc(1, sizeof(*pcr));

    pcr->skills.nsize = sizeof(race_skill_t);
    pcr->skills.nstep = 2;
    pcr->classes.nsize = sizeof(rclass_t);
    pcr->classes.nstep = 4;

    return pcr;
}

void race_free(race_t *r)
{
    if (r->pcdata)
        race_pcdata_free(r->pcdata);
    free_string(r->name);
    free_string(r->file_name);
}

void race_pcdata_free(pcrace_t *pcr)
{
    int i;

    for (i = 0; i < pcr->classes.nused; i++) {
        rclass_t *rcl = VARR_GET(&pcr->classes, i);
        free_string(rcl->name);
    }
    varr_free(&pcr->classes);
    varr_free(&pcr->skills);
    free_string(pcr->bonus_skills);
    free(pcr);
}

const char *race_name(int i)
{
    race_t *r = race_lookup(i);

    if (r == NULL)
        return "unique";
    return r->name;
}

int rn_lookup(const char *name)
{
    int num;
 
    for (num = 0; num < races.nused; num++) 
    {
        race_t *r = RACE(num);

        if (LOWER(name[0]) == LOWER(r->name[0])
        &&  !str_prefix(name, (r->name)))
            return num;
    }
 
    return -1;
}

int race_can_wear(CHAR_DATA *ch, int location)
{
        race_t *r;

        if (((r = race_lookup(ORG_RACE(ch))) == NULL)
        || IS_IMMORTAL(ch))
            return 1;
                
                if (location < 0 || location >= MAX_WEAR)
                        return 0;

        return r->wear_loc[location];
}

int race_dodge(CHAR_DATA *ch)
{
    race_t *race;

    if ((race = race_lookup(ch->race)) == NULL)
        return 0;
        
    return race->dodge;
}
