/* $Id: raffects.c,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#if !defined (WIN32)
#include <sys/time.h>
#endif

#include <stdio.h>
#include <math.h>

#include "merc.h"
#include "raffects.h"
#include "fight.h"
#include "cyborg.h"

#include "war.h"

DECLARE_DO_FUN(do_wake      );

extern bool check_grounding(CHAR_DATA *ch);

//
// apply or remove an affect to a room
//
void affect_modify_room (ROOM_INDEX_DATA* room, AFFECT_DATA* paf, bool fAdd)
{
    int mod = paf->modifier ;

    if (fAdd)
    {
        switch (paf->where)
        {
        case TO_ROOM_AFFECTS: SET_BIT (room->affected_by, paf->bitvector); break ;
        case TO_ROOM_FLAGS:   SET_BIT (room->room_flags,  paf->bitvector); break ;
        case TO_ROOM_CONST:                                                 break ;
        }
    }
    else
    {
        switch (paf->where)
        {
        case TO_ROOM_AFFECTS: REMOVE_BIT (room->affected_by, paf->bitvector); break ;
        case TO_ROOM_FLAGS:   REMOVE_BIT (room->room_flags,  paf->bitvector); break ;
        case TO_ROOM_CONST:                                                    break ;
        }

        mod = 0 - mod ;
    }

    switch (paf->location)
    {
    default:
        bug ("affect_modify_room: unknown location %d.", paf->location);
        return ;

    case APPLY_ROOM_NONE:                          break ;
    case APPLY_ROOM_HEAL: room->heal_rate += mod ; break ;
    case APPLY_ROOM_MANA: room->mana_rate += mod ; break ;
    }

    return ;
}

//
// give an affect to a room
//
void affect_to_room (ROOM_INDEX_DATA* room, AFFECT_DATA* paf)
{
    AFFECT_DATA     * paf_new    ;
    ROOM_INDEX_DATA * pRoomIndex ;

    if (!room->affected)
    {
        if (top_affected_room)
        {
            for (pRoomIndex = top_affected_room ;
                 pRoomIndex->aff_next != NULL ;
                 pRoomIndex = pRoomIndex->aff_next) continue ;

            pRoomIndex->aff_next = room ;
        }
        else top_affected_room = room ;

        room->aff_next = NULL ;
    }

    paf_new = aff_new ();

    *paf_new       = *paf;
    paf_new->next  = room->affected ;
    room->affected = paf_new ;

    affect_modify_room (room, paf_new, TRUE);
    return ;
}

void affect_check_room (ROOM_INDEX_DATA* room, int where, int vector)
{
    AFFECT_DATA* paf ;

    if (vector == 0) return ;

    for (paf = room->affected ; paf != NULL ; paf = paf->next)
    {
        if (paf->where == where && paf->bitvector == vector)
        {
            switch (where)
            {
            case TO_ROOM_AFFECTS: SET_BIT (room->affected_by, vector); break ;
            case TO_ROOM_FLAGS:   SET_BIT (room->room_flags,  vector); break ;
            case TO_ROOM_CONST:                                         break ;
            }

            return ;
        }
    }
}

//
// remove an affect from a room
//
void affect_remove_room (ROOM_INDEX_DATA* room, AFFECT_DATA* paf)
{
    int where  ;
    int vector ;

    if (room->affected == NULL)
    {
        bug ("Affect_remove_room: no affect.", 0);
        return ;
    }

    affect_modify_room (room, paf, FALSE);
    where  = paf->where ;
    vector = paf->bitvector ;

    if (paf == room->affected)
    {
        room->affected = paf->next ;
    }
    else
    {
        AFFECT_DATA* prev ;

        for (prev = room->affected ; prev != NULL ; prev = prev->next)
        {
            if (prev->next == paf)
            {
                prev->next = paf->next ;
                break ;
            }
        }

        if (prev == NULL)
        {
            bug ("Affect_remove_room: cannot find paf.", 0);
            return ;
        }
    }

    if (!room->affected)
    {
        ROOM_INDEX_DATA* prev ;

        if (top_affected_room == room)
        {
            top_affected_room = room->aff_next ;
        }
        else
        {
            for (prev = top_affected_room ; prev->aff_next ; prev = prev->aff_next)
            {
                if (prev->aff_next == room)
                {
                    prev->aff_next = room->aff_next ;
                    break ;
                }
            }

            if (prev == NULL)
            {
                bug ("Affect_remove_room: cannot find room.", 0);
                return ;
            }
        }

        room->aff_next = NULL ;
    }

    aff_free (paf);
    affect_check_room (room, where, vector);
    return ;
}

//
// strip all affects of a given sn
//
void affect_strip_room (ROOM_INDEX_DATA* room, int sn)
{
    AFFECT_DATA* paf ;
    AFFECT_DATA* paf_next ;

    for (paf = room->affected ; paf != NULL ; paf = paf_next)
    {
        paf_next = paf->next ;
        if (paf->type == sn) affect_remove_room (room, paf);
    }

    return ;
}

//
// return true if a room is affected by a spell
//
bool is_affected_room (ROOM_INDEX_DATA* room, int sn)
{
    AFFECT_DATA* paf ;

    for (paf = room->affected ; paf != NULL ; paf = paf->next)
        if (paf->type == sn) return TRUE ;

    return FALSE ;
}

//
// add or enhance an affect
//
void affect_join_room (ROOM_INDEX_DATA* room, AFFECT_DATA* paf)
{
    AFFECT_DATA* paf_old ;
    bool found ;

    found = FALSE ;
    for (paf_old = room->affected ; paf_old != NULL ; paf_old = paf_old->next)
    {
        if (paf_old->type == paf->type)
        {
            paf->level     = (paf->level += paf_old->level) / 2 ;
            paf->duration += paf_old->duration ;
            paf->modifier += paf_old->modifier ;
            affect_remove_room (room, paf_old);
            break ;
        }
    }

    affect_to_room (room, paf);
    return ;
}

bool is_safe_rspell_nom (int level, CHAR_DATA* victim)
{
    if (victim->in_war && victim->war_status == PS_ALIVE)
        return FALSE;

    // ghosts are safe
    if (!IS_NPC (victim) && IS_SET (victim->plr_flags, PLR_GHOST)) return TRUE ;
 
    // link dead players who do not have rushing adrenalin are safe
    if (!IS_NPC (victim) && !IS_PUMPED (victim) && victim->desc == NULL) return TRUE ;

    // small players
    if (!IS_NPC (victim) && victim->level < 10) return TRUE ;

    // PK range
    return !in_PK_level (level, victim);
}

bool is_safe_rspell (int level, CHAR_DATA *victim)
{
    if (is_safe_rspell_nom (level, victim))
    {
        act("  .", victim, NULL, NULL, TO_CHAR);
        act("  $n    .", victim, NULL, NULL, TO_ROOM);
        return TRUE ;
    }
    else return FALSE ;
}

// Added for no-msg act in trap-room...
bool is_safe_traproom (int level, CHAR_DATA *victim)
{
    if (is_safe_rspell_nom (level, victim))
    {
//        act("  .", victim, NULL, NULL, TO_CHAR);
//        act("  $n    .", victim, NULL, NULL, TO_ROOM);
        return TRUE ;
    }
    else return FALSE ;
}
        
void raffect_to_char (ROOM_INDEX_DATA* room, CHAR_DATA* ch)
{
    AFFECT_DATA* paf ;
    int perc_chance  ;

    if (IS_ROOM_AFFECTED (room, RAFF_SLOW) || IS_ROOM_AFFECTED (room, RAFF_SLEEP))
        char_act("   ,  .", ch);

    if (IS_ROOM_AFFECTED (room, RAFF_FWALL))
        char_act("    .", ch);

    if (IS_ROOM_AFFECTED (room, RAFF_RADIATION))
    {
        int level ;

        if ((paf = affect_find (room->affected, gsn_radiation)) == NULL)
        {
            bug ("Bad paf for radiation", 0);
            return ;
        }

        char_act("{y  {Y{y  {Y {y .{x", ch);

        level = number_range (paf->level / 2, paf->level);

        if (!saves_spell    (level, ch, DAM_RADIATION) && 
            !IS_IMMORTAL    (ch)                       &&
            !is_safe_rspell (paf->level, ch)           && 
            number_bits (3) == 0) radiation_effect (ch, level, TARGET_CHAR);
    }

    // calculate trap detection chance
    perc_chance  = (get_skill (ch, gsn_perception)) + (get_skill (ch, gsn_awareness) / 5);
    perc_chance /= 3 ;

    // add small chance of detection for everyone as well
    if (perc_chance > 0) perc_chance += (get_curr_stat (ch, STAT_DEX) - 16) * 5 ;
    else                 perc_chance +=  get_curr_stat (ch, STAT_DEX) - 16 ;

    if (is_affected(ch, sn_lookup("force sense")))
        perc_chance += get_curr_stat(ch, STAT_LCK) / 2;

    if (IS_NPC(ch)) perc_chance = 101;

    if (IS_ROOM_AFFECTED (room, RAFF_LSHIELD))
    {
        int        sn  ;
        CHAR_DATA* vch ;

        if ((sn = sn_lookup ("lightning shield")) == -1)
        {
            bug ("Bad sn for lightning shield", 0);
            return ;
        }

        for (vch = room->people ; vch ; vch=vch->next_in_room)
            if (is_room_owner (vch, room)) break ;

        if (!vch)
        {
            bug ("Owner of lightning shield left the room.", 0);
            free_string (room->owner);
            room->owner = str_dup (str_empty);
            affect_strip_room (room, sn);
        }
        else 
        {
            char_act(" ,  ,  .", ch);
            act("$N   .", vch, NULL, ch, TO_CHAR);
            do_wake   (vch, str_empty);

            if ((paf = affect_find (room->affected, sn)) == NULL)
            {
                bug ("Bad paf for lightning shield", 0);
                return ;
            }

            if (!is_safe_traproom (paf->level, ch))
            {
                if (perc_chance >= number_percent ())
                {
                    char_act("    !", ch);
                    check_improve (ch, gsn_perception, 2, TRUE);
                    check_improve (ch, gsn_awareness,  2, TRUE);
                }
                else
                if (!check_grounding (ch) && in_PK (ch, vch))
                {
                    do_visible (ch, str_empty);
                    multi_hit (vch, ch, TYPE_UNDEFINED);
                    damage    (vch, ch, dice (paf->level, 4) + 12, sn, DAM_LIGHTNING, TRUE);

                    free_string (room->owner);
                    room->owner = str_dup (str_empty);
                    affect_remove_room (room, paf);

                    check_improve (ch, gsn_perception, 2, FALSE);
                    check_improve (ch, gsn_awareness,  2, FALSE);
                }
            }
        }
    }

    if (IS_ROOM_AFFECTED (room, RAFF_SHOCKING))
    {
        int sn ;

        if ((sn = sn_lookup ("shocking trap")) == -1)
        {
            bug ("Bad sn for shocking shield", 0);
            return ;
        }

        char_act(" ,  ,  .", ch);

        if ((paf = affect_find (room->affected, sn)) == NULL)
        {
            bug ("Bad paf for shocking shield", 0);
            return ;
        }

        if (!is_safe_traproom (paf->level, ch))
        {
            if (perc_chance >= number_percent ())
            {
                char_act("    !", ch);
                check_improve (ch, gsn_perception, 2, TRUE);
                check_improve (ch, gsn_awareness,  2, TRUE);
            }
            else
            {
                if (!is_immune(ch, DAM_LIGHTNING))
                    damage (ch, ch, dice (paf->level, 4) + 12, TYPE_HUNGER, DAM_TRAP_ROOM, TRUE);

                affect_remove_room (room, paf);
                WAIT_STATE (ch, 2 * PULSE_VIOLENCE);
                do_visible (ch, str_empty);

                check_improve (ch, gsn_perception, 2, FALSE);
                check_improve (ch, gsn_awareness,  2, FALSE);
            }
        }
    }

    if (IS_ROOM_AFFECTED (room, RAFF_THIEF_TRAP))
    {
        char_act(",  -,  .", ch);

        if ((paf = affect_find (room->affected, gsn_settraps)) == NULL)
        {
            bug ("Bad paf for settraps", 0);
            return ;
        }

        if (!is_safe_traproom (paf->level, ch))
        {
            if (perc_chance >= number_percent ())
            {
                char_act("    !", ch);
                check_improve (ch, gsn_perception, 2, TRUE);
                check_improve (ch, gsn_awareness,  2, TRUE);
            }
            else
            {
                int fallen = 1 ;

                // 30% chance for mounted person to fall off the horse
                if (ch->mount != NULL
                && number_percent () > 70 * (get_skill (ch, gsn_riding)
                    + get_skill (ch, gsn_dragon_riding)
                    + get_skill (ch, gsn_animal_riding)) / 100)
                {
                    act_puts("$N      .", ch, NULL, ch->mount, TO_CHAR, POS_DEAD);

                    act("$n     $N.", ch, NULL, ch->mount, TO_NOTVICT);

                    if (is_affected  (ch, gsn_mount_fighting))
                        affect_strip (ch, gsn_mount_fighting);

                    if (is_affected  (ch, gsn_mount_control))
                        affect_strip (ch, gsn_mount_control);

                    ch->riding        = FALSE ;
                    ch->mount->riding = FALSE ;

                    // force dismount for act_move.c
                    ch->mount = NULL ;

                    fallen = 2 ;
                }

                if (!is_immune (ch, DAM_PIERCE))
                    damage (ch, ch, dice (paf->level, 7) + 12, TYPE_HUNGER, DAM_TRAP_ROOM, TRUE);

                affect_remove_room (room, paf);
                WAIT_STATE (ch, fallen * 2 * PULSE_VIOLENCE);
                do_visible (ch, str_empty);

                check_improve (ch, gsn_perception, 2, FALSE);
                check_improve (ch, gsn_awareness,  2, FALSE);
            }
        }
    }

    if (IS_ROOM_AFFECTED (room, RAFF_RANGER_TRAP))
    {
        char_act(",  -,  .", ch);

        if ((paf = affect_find (room->affected, gsn_snare)) == NULL)
        {
            bug ("Bad paf for settraps", 0);
            return ;
        }

        if (!is_safe_traproom (paf->level, ch))
        {
            if (perc_chance >= number_percent ())
            {
                char_act("    !", ch);
                check_improve (ch, gsn_perception, 2, TRUE);
                check_improve (ch, gsn_awareness,  2, TRUE);
            }
            else
            {
                AFFECT_DATA af ;
                int fallen = 2 ;

                // 30% chance for mounted person to fall off the horse
                if (ch->mount != NULL
                && number_percent () > 70 * (get_skill (ch, gsn_riding)
                    + get_skill (ch, gsn_dragon_riding)
                    + get_skill (ch, gsn_animal_riding)) / 100)
                {
                    act_puts("$N        .", 
                        ch, NULL, ch->mount, TO_CHAR, POS_DEAD);
                    act("$n     $N.", ch, NULL, ch->mount, TO_NOTVICT);

                    if (is_affected  (ch, gsn_mount_fighting))
                        affect_strip (ch, gsn_mount_fighting);

                    if (is_affected  (ch, gsn_mount_control))
                        affect_strip (ch, gsn_mount_control);

                    ch->riding        = FALSE ;
                    ch->mount->riding = FALSE ;

                    // force dismount for act_move.c
                    ch->mount = NULL ;

                    fallen = 2 ;
                }

                af.where     = TO_AFFECTS ;
                af.type      = gsn_web ;
                af.level     = paf->level ;
                af.duration  = paf->level / 10 ;
                af.location  = APPLY_DEX ;
                af.modifier  = -3 ;
                af.bitvector = AFF_WEB ;
                affect_to_char (ch, &af);

                char_act("   .", ch);
                act_puts("$n   .", ch, NULL, NULL, TO_ROOM, POS_RESTING);
            
                affect_remove_room (room, paf);
                WAIT_STATE (ch, fallen * 2 * PULSE_VIOLENCE);
                do_visible (ch, str_empty);

                check_improve (ch, gsn_perception, 2, FALSE);
                check_improve (ch, gsn_awareness,  2, FALSE);
            }
        }
    }
}

void raffect_back_char (ROOM_INDEX_DATA* room, CHAR_DATA* ch)
{
    if (IS_ROOM_AFFECTED (room, RAFF_LSHIELD))
    {
        int sn ;

        if ((sn = sn_lookup ("lightning shield")) == -1)
        {
            bug ("Bad sn for lightning shield", 0);
            return ;
        }

        if (is_room_owner (ch, room)) 
        {
            free_string (room->owner);
            room->owner = str_dup (str_empty);
            affect_strip_room (room, sn);
        }
    }
}

void do_raffects(CHAR_DATA* ch, const char* argument)
{
    AFFECT_DATA* paf, * paf_last = NULL ;

    if (IS_AFFECTED(ch, AFF_BLIND))
    {
        char_act("  .", ch);
        return ;
    }
    if (IS_AFFECTED(ch, AFF_SLEEP))
    {
        char_act("   .", ch);
        return ;
    }
    if (ch->in_room->affected == NULL)
    {
        char_act("      .", ch);
        return ;
    }

    char_act("     :", ch);

    for (paf = ch->in_room->affected ; paf != NULL ; paf = paf->next)
    {
        if (paf_last != NULL && paf->type == paf_last->type)
        {
            if (ch->level >= 20) char_act("                      ", ch);
            else                 continue ;
        }
        else
            act_puts("Spell: {c$t{x", ch, fmt_color_str(skill_name (paf->type), 15), NULL, TO_CHAR | ACT_NOLF, POS_DEAD);

        if (ch->level >= 20)
        {
            act_puts(":  {c$T{x  {c$j{x ", ch, (const void *) paf->modifier, flag_string (rapply_flags, paf->location), TO_CHAR | ACT_NOLF, POS_DEAD);

            if (paf->duration == -1 || paf->duration == -2)
                 char_act(".", ch);
            else 
                act_puts("  {c$j{x .", ch, (const void *) paf->duration, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
        }

        if (IS_IMMORTAL (ch)) 
            act_puts(" Level {c$j{x.", ch, (const void *) paf->level, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
        char_act(str_empty, ch);
        paf_last = paf ;
    }
}
