/* $Id: religion.c,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#include <stdio.h>
#include <stdlib.h>

#include "merc.h"

/* TODO: 
 :

1.       item_raltar,     ,  (    )
2.     rpoints         , , , 
3.            (   )
4.    -  1(2)  ,       -    
5.  -     -   
6.    -      ....

*/
varr religions = { sizeof (religion_t), 4} ;

char *      fread_word      (FILE * fp);
void        fread_to_eol    (FILE * fp);
int         fread_religion  (FILE * fp);
int         fread_number    (FILE * fp);

/*
 * create new religion
 */
religion_t * religion_new ()
{
     religion_t * religion ;

     religion = varr_enew (&religions);
     religion->skills.nsize          = sizeof (religion_skill_t);
     religion->skills.nstep          = 4;
     religion->classes.nsize         = sizeof (rlclass_t);
     religion->classes.nstep         = 4;
     religion->races.nsize           = sizeof (rlrace_t);
     religion->races.nstep           = 4;
     religion->stats.nsize           = sizeof (restrict_stat_t);
     religion->stats.nstep           = 4;
     religion->msg_prays             = str_empty;
     religion->msg_vanishes          = str_empty;
     religion->rtalk_self            = str_empty;
     religion->rtalk_other           = str_empty;

     religion->tattoo_vnum           = 0;
     religion->tattoo_master_vnum    = 0;
     
     religion->altar                 = 0;

     return religion ;
}

/*
 * reset religion
 */
void religion_free (religion_t * religion)
{
     int i;

     for (i = 0; i < religion->classes.nused; i++)
     {
               rlclass_t *rlcl = VARR_GET(&religion->classes, i);
               free_string(rlcl->name);
     }
     for (i = 0; i < religion->races.nused; i++)
     {
               rlrace_t *rlr = VARR_GET(&religion->races, i);
               free_string(rlr->name);
     }

     free_string(religion->name);
     free_string(religion->file_name);
     free_string(religion->msg_prays);
     free_string(religion->msg_vanishes);
     free_string(religion->rtalk_self);
     free_string(religion->rtalk_other);
     varr_free (&religion->skills);
     varr_free (&religion->stats);
     varr_free (&religion->classes);
     varr_free (&religion->races);
}

/*
 * lookup religion by name
 */
int rln_lookup (const char * name)
{
     int rln;

     if (IS_NULLSTR(name))
               return -1;

     for (rln = 0; rln < religions.nused; rln++)
               if (!str_cmp(name, RELIGION(rln)->name))
                    return rln;

     return -1;
}

/*
 * get religion name by index
 */
const char * religion_name (int rln)
{
     religion_t * religion = religion_lookup (rln);
     if (religion) return religion->name ;
     return "None" ;
} 

void do_showtattoo( CHAR_DATA *ch)
{
    extern int top_obj_index;
    char buf[MAX_STRING_LENGTH];
    OBJ_INDEX_DATA *pObjIndex = NULL;
    int vnum = -1;
    int nMatch = 0;
    bool fAll = FALSE;
    bool found = FALSE;
    int intFind = 0;
    int intFound = -1;
    BUFFER *output;
    
    if (ch == NULL)
    {
        bug( "*BUG* File: religion.c | Function:  do_showtatto | Error: ch = NULL",0 );
        return;
    }

    output = buf_new(-1);

    for (intFind = 0; wear_flags[intFind].name != NULL; intFind++)
    {
        snprintf(buf, sizeof(buf), "%s ",wear_flags[intFind].name);
        if (!str_cmp (wear_flags[intFind].name, "tattoo"))
            intFound = intFind;
    }  
    
    if (intFound < 0)
    {
        send_to_char( "BUG: not wearlocation for tattoo.\n\r", ch );
        return;
    }

    for (vnum = 0; nMatch < top_obj_index; vnum++)
    {
        if (( pObjIndex = get_obj_index( vnum ) ) != NULL)
        {
            nMatch++;
            if (fAll || CAN_WEAR(pObjIndex, wear_flags[intFound].bit))
            {
                found = TRUE;
                buf_printf(output, "{x[%6d] %-50s \n\r",pObjIndex->vnum, fmt_color_str(mlstr_mval(pObjIndex->short_descr),50) );
            }
        }
    }
    buf_printf(output,"\n\r");
    page_to_char(buf_string(output), ch);
    buf_free(output);
    
    if (!found)
        send_to_char( "No objects with this wear location found.\n\r", ch );

    return;
}
