/* $Id: repair.c,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <stdio.h>
#include "merc.h"

DECLARE_DO_FUN(do_say       );

void damage_to_obj(CHAR_DATA *ch, OBJ_DATA *wield, OBJ_DATA *worn, int damage)
{

    if (damage == 0 || IS_OBJ_STAT(worn,ITEM_INDESTRUCTABLE)) return;

    if (IS_OBJ_STAT(worn,ITEM_HIDURABILITY))
        worn->condition -= damage / 2;
    else
        worn->condition -= damage;

    act_puts("{g$p  {r$P{g!{x", ch, wield, worn, TO_ROOM, POS_RESTING);

    if (worn->condition < 1) {
        act_puts("{g{r$P{g   .{x", ch, wield, worn, TO_ROOM, POS_RESTING);
        extract_obj(worn);
        return;
    }

    if (IS_SET(wield->extra_flags, ITEM_ANTI_EVIL)
    &&  IS_SET(wield->extra_flags, ITEM_ANTI_NEUTRAL)
    &&  IS_SET(worn->extra_flags, ITEM_ANTI_EVIL)
    &&  IS_SET(worn->extra_flags, ITEM_ANTI_NEUTRAL)) {
        act_puts("$p     $P.", ch, wield, worn, TO_ROOM, POS_RESTING);
        act_puts("$p    !", ch, wield, worn, TO_CHAR, POS_RESTING);
        act_puts("$p    $n.", ch, wield, worn, TO_ROOM, POS_RESTING);
        unequip_char(ch, wield);
        return;
    }

    if (IS_SET(wield->extra_flags, ITEM_ANTI_EVIL)
    &&  IS_SET(worn->extra_flags, ITEM_ANTI_EVIL)) {
        act_puts("The $p worries for the damage to $P.", ch, wield, worn, TO_ROOM, POS_RESTING);
        return;
    }
}

DO_FUN(do_repair)
{
    CHAR_DATA *mob;
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int cost;

    for (mob = ch->in_room->people; mob; mob = mob->next_in_room)
        if (IS_NPC(mob)
        && IS_SET(mob->pIndexData->act, ACT_REPAIRMAN))
            break;

    if (mob == NULL)
    {
        char_act("     .", ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0') {
        do_say(mob,"    ,   .");
        char_act("   .", ch);
        return;
    }
    if ((obj = get_obj_carry(ch, arg)) == NULL) {
        do_say(mob,"   .");
        return;
    }

    if (obj->pIndexData->vnum == OBJ_VNUM_HAMMER) {
        do_say(mob,"     .");
        return;
    }

    if (obj->condition >= 100) {
    do_say(mob,"     !");
        return;
    }

    if (obj->cost == 0) {
        act_say(mob, "$p   .", obj);
        return;
    }

    cost = ((obj->level * 10) +
        ((obj->cost * (100 - obj->condition)) /100)   );
    cost /= 100;

    if (cost > ch->gold) {
        act_say(mob, "        .", NULL);
        return;
    }

    WAIT_STATE(ch,PULSE_VIOLENCE);

    ch->gold -= cost;
    mob->gold += cost;
        act_puts("$n   $N $p,    .", mob, obj, ch, TO_ROOM, POS_RESTING);
    obj->condition = 100;
}

DO_FUN(do_estimate)
{
    OBJ_DATA *obj, *part;
    CHAR_DATA *mob;
    char arg[MAX_INPUT_LENGTH];
    int cost;

    // check parts for created golem
    if (!str_cmp (argument, "golem"))
    {
        if (number_percent() > get_skill(ch, sn_lookup("create golem")))
        {
            char_act ("You try to estimate body parts but can't properly calculate their values.", ch);
            return;
        }
        for (part = ch->carrying ; part != NULL ; part = part->next_content)
        {
            // skip non_body_parts
            if ((part->pIndexData->vnum != OBJ_VNUM_SLICED_ARM)
                && (part->pIndexData->vnum != OBJ_VNUM_SLICED_LEG)
                && (part->pIndexData->vnum != OBJ_VNUM_SEVERED_HEAD)
                && (part->pIndexData->vnum != OBJ_VNUM_TORN_HEART)
                && (part->pIndexData->vnum != OBJ_VNUM_GUTS)
                && (part->pIndexData->vnum != OBJ_VNUM_BRAINS))

                continue;

            if ((ch->level < LEVEL_HERO) && part->level > (LVL (ch) + LVL (ch)/10))
                char_printf (ch, "%s: {Rlevel is too high.{x\n", fix_short(mlstr_cval(part->short_descr, ch)));                
            else
                char_printf (ch, "%s: {GOk!{x\n", fix_short(mlstr_cval(part->short_descr, ch)));
        }
        return;
    }

    for (mob = ch->in_room->people; mob; mob = mob->next_in_room)
        if (IS_NPC(mob)
        && IS_SET(mob->pIndexData->act, ACT_REPAIRMAN))
            break;

    if (mob == NULL)
    {
            char_act("     .", ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
    do_say(mob,"  estimate <>");
    return;
    }
    if ((obj = (get_obj_carry(ch, arg))) == NULL)
    {
    do_say(mob,"     .");
    return;
    }
    if (obj->pIndexData->vnum == OBJ_VNUM_HAMMER)
    {
        do_say(mob,"     .");
        return;
    }
    if (obj->condition >= 100)
    {
    do_say(mob,"     !");
    return;
    }
    if (obj->cost == 0)
    {
    do_say(mob,"   .");
        return;
    }

    cost = ((obj->level * 10) +
        ((obj->cost * (100 - obj->condition)) /100)   );
    cost /= 100;

    act_say(mob, "    $j $qj{} $qj{}.", (const void *) cost);
}

DO_FUN(do_restring)
{
    CHAR_DATA *mob;
#if 0
    char arg  [MAX_INPUT_LENGTH];
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int cost = 2000;
#endif

    for (mob = ch->in_room->people; mob; mob = mob->next_in_room)
    {
        if (IS_NPC(mob) && IS_SET(mob->pIndexData->act, ACT_HEALER))
            break;
    }

#if 0
    if (mob == NULL) {
#endif
        char_act("     .", ch);
        return;
#if 0
    /* XXX */
    }

    argument = one_argument(argument, arg, sizeof(arg));
    argument = one_argument(argument, arg1, sizeof(arg1));
    strnzcpy(arg2, sizeof(arg2), argument);

    if (arg[0] == '\0' || arg1[0] == '\0' || arg2[0] == '\0')
    {
        char_act(":", ch);
        char_act("  restring <obj> <field> <string>", ch);
        char_act("    fields: name short long", ch);
        return;
    }

    if ((obj = (get_obj_carry(ch, arg))) == NULL) {
        do_say(mob, "    .");
        return;
    }

    cost += (obj->level * 1500);

    if (cost > ch->gold) {
        act("$N : '       .",
          ch,NULL,mob,TO_CHAR);
        return;
    }

    if (!str_prefix(arg1, "name")) {
        free_string(obj->name);
        obj->name = str_dup(arg2);
    }
    else
    if (!str_prefix(arg1, "short")) {
        free_string(obj->short_descr);
        obj->short_descr = str_dup(arg2);
    }
    else
    if (!str_prefix(arg1, "long")) {
        free_string(obj->description);
        obj->description = str_dup(arg2);
    }
    else {
        char_act("  'Field'.", ch);
        return;
    }

    WAIT_STATE(ch,PULSE_VIOLENCE);

    ch->gold -= cost;
    mob->gold += cost;
    act("$N   $n $p,  ,   $gp{} .", ch, obj, mob, TO_ROOM);
    act("$N    $p,  ,   $gp{} .", ch, obj, mob, TO_CHAR);
    char_act(",   ,        ,    !", ch);
    char_act("    .", ch);
#endif
}

DO_FUN(do_smithing)
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *hammer;
    int sn;
    int chance;

    if ((sn = sn_lookup("smithing")) < 0
    ||  (chance = get_skill(ch, sn)) == 0) {
        char_act("Huh?", ch);
        return;
    }

    if (ch->fighting) {
        char_act("   .", ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0') {
        char_act("    ?", ch);
        return;
    }

    if ((obj = get_obj_carry(ch, arg)) == NULL) {
        char_act("    .", ch);
        return;
    }

    if (obj->condition >= 100) {
        char_act(" ,     .", ch);
        return;
    }

    if ((hammer = get_eq_char(ch, WEAR_HOLD)) == NULL) {
        char_act("   .", ch);
        return;
    }

    if (hammer->pIndexData->vnum != OBJ_VNUM_HAMMER) {
        char_act("  .", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);
    if (number_percent() > chance) {
        check_improve(ch, sn, FALSE, 8);
                act_puts("$n   $p   ,   .", ch, obj, NULL, TO_ROOM, POS_RESTING);
        act_puts("     $p.", ch, obj, NULL, TO_CHAR, POS_RESTING);
        hammer->condition -= 25;
    }
    else {
        check_improve(ch, sn, TRUE, 4);
        act_puts("$n  $p   .", ch, obj, NULL, TO_ROOM, POS_RESTING);
        act_puts("  $p.", ch, obj, NULL, TO_CHAR, POS_RESTING);
        obj->condition = UMAX(100, obj->condition + (chance / 2));
        hammer->condition -= 25;
    }

    if (hammer->condition < 1)
        extract_obj(hammer);
}

/*----------------------------------------------------------------------------
 * eq damage functions
 *  - the third parameter is the location of wielded weapon
 *    (must be WEAR_WIELD or WEAR_SECOND_WIELD), not the
 *    location of damaged eq
 */

void check_eq_damage(CHAR_DATA *ch, CHAR_DATA *victim, int loc)
{
        OBJ_DATA *wield, *destroy;
        int skill, chance=0, sn, i;

        if (IS_NPC(victim) || number_percent() < 94)
                return;

        if ((wield = get_eq_char(ch, loc)) == NULL)
                return;
        sn = get_weapon_sn(wield);
        skill = get_skill(ch, sn);
        if (ch->level < (victim->level - 10))
                return;

        for (i = 0; i < WEAR_TATTOO; i++) 
        {
                if ((destroy = get_eq_char(victim,i)) == NULL
                ||  number_percent() > 95
                ||  number_percent() > 94
//                ||  check_material(destroy,"platinum")
                ||  destroy->pIndexData->limit != -1
                ||  i == WEAR_WIELD)
                        continue;

                if (is_metal(wield)) {
                        if (number_percent() > skill)
                                continue;

                        chance += 20;
                        if (check_material(wield, "platinium")
                        ||  check_material(wield, "titanium"))
                                chance += 5;

                        if (is_metal(destroy))
                                chance -= 20;
                        else
                                chance += 20;

                        chance += ((ch->level - victim->level) / 5);
                        chance += ((wield->level - destroy->level) / 2);
                }
                else {
                        if (number_percent() < skill)
                                continue;

                        chance += 10;

                        if (is_metal(destroy))
                                chance -= 20;
                        chance += (ch->level - victim->level);
                        chance += (wield->level - destroy->level);
                }

                /* sharpness */
                if (IS_WEAPON_STAT(wield, WEAPON_SHARP))
                        chance += 10;

                if (sn == gsn_axe)
                        chance += 10;

                /* spell affects */
                if (IS_OBJ_STAT(destroy, ITEM_BLESS))
                        chance -= 10;
                if (IS_OBJ_STAT(destroy, ITEM_MAGIC))
                        chance -= 20;

                chance += skill - 85;
                chance += get_curr_stat(ch, STAT_STR);

                if (number_percent() < chance && chance > 50) {
                        damage_to_obj(ch, wield, destroy, chance / 5);
                        break;
                }
        }
}

void check_shield_damage(CHAR_DATA *ch, CHAR_DATA *victim, int loc)
{
    OBJ_DATA *wield, *destroy;
    int skill, chance=0, sn;

    if (IS_NPC(victim) || number_percent() < 94)
        return;

    if ((wield = get_eq_char(ch, loc)) == NULL)
        return;
    sn = get_weapon_sn(wield);
    skill = get_skill(ch, sn);

    if ((destroy = get_eq_char(victim, WEAR_SHIELD)) == NULL
    ||  number_percent() > 94
    ||  ch->level < (victim->level - 10)
//        ||  check_material(destroy, "platinum")
        ||  destroy->pIndexData->limit != -1)
        return;

    if (is_metal(wield)) {
        if (number_percent() > skill)
            return;

        chance += 20;
        if (check_material(wield, "platinium")
        ||  check_material(wield, "titanium"))
            chance += 5;

        if (is_metal(destroy))
            chance -= 20;
        else
            chance += 20;

        chance += ((ch->level - victim->level) / 5);
        chance += ((wield->level - destroy->level) / 2);
    }
    else {
        if (number_percent() < skill)
            return;

        chance += 10;
        if (is_metal(destroy))
            chance -= 20;

        chance += (ch->level - victim->level);
        chance += (wield->level - destroy->level);
    }

    /* sharpness */
    if (IS_WEAPON_STAT(wield, WEAPON_SHARP))
        chance += 10;

    if (sn == gsn_axe)
        chance += 10;

    /* spell affects */
    if (IS_OBJ_STAT(destroy, ITEM_BLESS))
        chance -= 10;
    if (IS_OBJ_STAT(destroy, ITEM_MAGIC))
        chance -= 20;

    chance += skill - 85;
    chance += get_curr_stat(ch, STAT_STR);

    if (number_percent() < chance && chance > 20)
        damage_to_obj(ch, wield, destroy, chance / 4);
}

void check_weapon_damage(CHAR_DATA *ch, CHAR_DATA *victim, int loc)
{
    OBJ_DATA *wield, *destroy;
    int skill, chance=0, sn;

    if (IS_NPC(victim) || number_percent() < 94)
        return;

    if ((wield = get_eq_char(ch, loc)) == NULL)
        return;
    sn = get_weapon_sn(wield);
    skill = get_skill(ch, sn);

    if ((destroy = get_eq_char(victim, WEAR_WIELD)) == NULL
    || number_percent() > 94
    || ch->level < (victim->level - 10)
//    ||  check_material(destroy, "platinum")
    || IS_OBJ_STAT(destroy, ITEM_INDESTRUCTABLE)
    || IS_WEAPON_STAT(destroy, WEAPON_KATANA)
    || destroy->pIndexData->limit != -1)
        return;

    if (is_metal(wield)) 
    {
        if (number_percent() > skill)
            return;

        chance += 20;
        if (check_material(wield, "platinium")
        || check_material(wield, "titanium"))
            chance += 5;

        if (is_metal(destroy))
            chance -= 20;
        else
            chance += 20;

        chance += ((ch->level - victim->level) / 5);
        chance += ((wield->level - destroy->level) / 2);
    } else 
    {
        if (number_percent() < skill)
            return;

        chance += 10;

        if (is_metal(destroy))
            chance -= 20;

        chance += (ch->level - victim->level);
        chance += (wield->level - destroy->level);
    }

    /* sharpness */
    if (IS_WEAPON_STAT(wield, WEAPON_SHARP))
        chance += 10;

    if (sn == gsn_axe)
        chance += 10;

    /* spell affects */
    if (IS_OBJ_STAT(destroy, ITEM_BLESS))
        chance -= 10;
    if (IS_OBJ_STAT(destroy, ITEM_MAGIC))
        chance -= 20;

    chance += skill - 85 ;
    chance += get_curr_stat(ch, STAT_STR);

    if (IS_OBJ_STAT(destroy, ITEM_HIDURABILITY))
        chance /= 10;

    if (number_percent() < (chance / 2) && chance > 20)
        damage_to_obj(ch, wield, destroy, chance / 4);
}

