/* $Id: riddle.c,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "merc.h"
#include "riddle.h"

extern bool    p_percent_trigger (CHAR_DATA *mob, OBJ_DATA *obj, ROOM_INDEX_DATA *room, 
	       CHAR_DATA *ch, const void *arg1, const void *arg2, int type);
extern void    p_greet_trigger   (CHAR_DATA *ch, int type);

varr riddles = {sizeof (riddle_t), 4};

riddle_t * riddle_new ()
{
        riddle_t * riddle;

        riddle                         = varr_enew (&riddles);
        riddle->question               = NULL;
        riddle->answer                 = str_empty;
        
        return riddle;
}

void riddle_free(riddle_t *riddle)
{
    mlstr_free (riddle->question);
    free_string (riddle->answer);

    free(riddle);
}

#define PULSE_RIDDLE 15
static int pulse_riddle = 0;
extern OBJ_INDEX_DATA *	obj_index_hash	[MAX_KEY_HASH];

int get_random_riddle(int min_num, int max_num);

//------------------------------------------------------------------------------
void riddle_update(CHAR_DATA * ch)
{
    OBJ_INDEX_DATA * pObj;
    int iHash;

    if (ch)
        char_printf(ch, "Total riddles: %d.\n", riddles.nused);
    if (ch || (--pulse_riddle <= 0))
    {
        pulse_riddle = PULSE_RIDDLE;
        for (iHash = 0; iHash < MAX_KEY_HASH; iHash++)
            for (pObj = obj_index_hash[iHash]; pObj; pObj = pObj->next)
            {
                if (pObj->item_type == ITEM_RIDDLE)
                {
                    pObj->value[2] = get_random_riddle(pObj->value[0], pObj->value[1]);
                    if (ch)
                        char_printf(ch, "Riddle obj vnum: %d (%d-%d), set: %d.\n", pObj->vnum, 
                            pObj->value[0], pObj->value[1], pObj->value[2]);   
                }
            }
    }
}
//-------------------------------------------------------------------------------
int get_random_riddle(int min_num, int max_num)
{
    //if (max_num == 0) 
    //    max_num = riddles.nused - 1;
    max_num = URANGE (0, max_num, riddles.nused - 1);
    min_num = URANGE (0, min_num, riddles.nused - 1);
    if (min_num > max_num)
        min_num = max_num;

    return number_range(min_num, max_num);
}

void enter_portal(CHAR_DATA * ch, OBJ_DATA *portal)
// Note to do: it would be nice to combine this function with do_enter
{
    ROOM_INDEX_DATA *location;
    ROOM_INDEX_DATA *old_room;
    CHAR_DATA *fch, *fch_next, *mount;


    if (ch->fighting != NULL)
        return;

    old_room = ch->in_room;

    if (IS_SET(portal->value[2], GATE_NOCURSE)
    && !IS_TRUSTED(ch, ANGEL)
    && (IS_AFFECTED(ch, AFF_CURSE)
    || IS_SET(old_room->room_flags, ROOM_NORECALL)
    || IS_RAFFECTED(old_room, RAFF_CURSE)))
    {
        char_act("    ...", ch);
        return;
    }

    if (IS_SET(portal->value[2], GATE_RANDOM) || portal->value[3] == -1)
    {
        location = get_random_room(ch);
        portal->value[3] = location->vnum; /* keeps record */
    }
    else if (IS_SET(portal->value[2], GATE_BUGGY) && (number_percent() < 5))
        location = get_random_room(ch);
    else
        location = get_room_index(portal->value[3]);

    if (location == NULL
        ||  location == old_room
        ||  !can_see_room(ch, location)
        ||  (room_is_private(location) && !IS_TRUSTED(ch, IMPLEMENTOR)))
    {
        act("$p doesn't seem to go anywhere.", ch, portal,NULL,TO_CHAR);
        return;
    }

    if (IS_NPC(ch) && IS_SET(ch->pIndexData->act, ACT_AGGRESSIVE)
        &&  IS_SET(location->room_flags, ROOM_LAW))
    {
        char_act("    ...", ch);
        return;
    }

    act(MOUNTED(ch) ? "$n   $p,    $N." :
        "$n   $p.",
        ch, portal, MOUNTED(ch), TO_ROOM);

    act(IS_SET(portal->value[2], GATE_NORMAL_EXIT) ?
        "   $p." :
        "   $p        !",
        ch, portal, NULL, TO_CHAR);

    mount = MOUNTED(ch);
    char_from_room(ch);
    char_to_room(ch, location);

    if (IS_SET(portal->value[2], GATE_GOWITH))
    {/* take the gate along */
        obj_from_room(portal);
        obj_to_room(portal, location);
    }

    if (IS_SET(portal->value[2], GATE_NORMAL_EXIT))
        act(mount ? "$n  ,   $N" : "$n .",
            ch, portal, mount, TO_ROOM);
    else
        act(mount ? "$n   $p,   $N." :
            "$n   $p.",
            ch, portal, mount, TO_ROOM);

    if (!JUST_KILLED(ch))
        do_look(ch,"auto");

    if (mount)
    {
        char_from_room(mount);
        char_to_room(mount, location);
        ch->riding = TRUE;
        mount->riding = TRUE;
    }

    /* charges */
    if (portal->value[0] > 0)
    {
        portal->value[0]--;
        if (portal->value[0] == 0)
            portal->value[0] = -1;
    }

    /* protect against circular follows */
    if (old_room == location)
        return;

    for (fch = old_room->people; fch != NULL; fch = fch_next)
    {
        fch_next = fch->next_in_room;

        /* no following through dead portals */
        if (portal == NULL || portal->value[0] == -1)
            continue;

        if (fch->master != ch || fch->position != POS_STANDING)
            continue;

        if (IS_SET(ch->in_room->room_flags,ROOM_LAW)
            &&  IS_NPC(fch)
            &&  IS_SET(fch->pIndexData->act, ACT_AGGRESSIVE))
        {
            act("    $N  .",
                ch, NULL, fch, TO_CHAR);
            act("    .",
                fch, NULL, NULL, TO_CHAR);
            continue;
        }

        act("   $N.", fch, NULL, ch, TO_CHAR);
        enter_portal(fch,portal);
    }

    if (portal != NULL && portal->value[0] == -1)
    {
        act("$p   .", ch, portal, NULL, TO_CHAR);
        if (ch->in_room == old_room)
            act("$p   .",
                ch, portal, NULL, TO_ROOM);
        else if (old_room->people != NULL)
        {
            act("$p   .",
                old_room->people, portal, NULL, TO_CHAR);
            act("$p   .",
                old_room->people,portal,NULL,TO_ROOM);
        }
        extract_obj(portal);
    }

    if (JUST_KILLED(ch))
        return;

    /*
     * If someone is following the char, these triggers get
     * activated for the followers before the char,
     * but it's safer this way...
     */
    if (IS_NPC(ch) && HAS_TRIGGER_MOB(ch, TRIG_ENTRY))
        p_percent_trigger(ch, NULL, NULL, NULL, NULL, NULL, TRIG_ENTRY);

    if (!IS_NPC(ch))
    {
        p_greet_trigger( ch, PRG_MPROG );
        p_greet_trigger( ch, PRG_OPROG );
        p_greet_trigger( ch, PRG_RPROG );
    }
}
