/* $Id: riddle.h,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#ifndef _RIDDLE_H_
#define _RIDDLE_H_

typedef struct riddle_t  riddle_t;

struct riddle_t
{
    mlstring * question;  // Question key
    const char * answer;    // Answer key
};

riddle_t *      riddle_new    (void);
void            riddle_free   (riddle_t*);


extern varr riddles;


#define RIDDLE(rdn)        ((riddle_t*) VARR_GET(&riddles, rdn))
#define riddle_lookup(rdn) ((riddle_t*) varr_get(&riddles, rdn))

void riddle_update(CHAR_DATA * ch);
void enter_portal(CHAR_DATA * ch, OBJ_DATA *portal);

#endif
