/* $Id: room_cmds.h,v 1.666 2004/09/20 10:49:52 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include "typedef.h"

struct room_cmd_type
{
    char * const        name;
    ROOM_FUN *          room_fun;
};

extern bool damage        (CHAR_DATA * ch, CHAR_DATA * victim, int dam, int dt, int dam_type, int dam_flags);
extern void stop_fighting (CHAR_DATA *ch, bool fBoth);

/*
 * ROOMcommand functions
 * Defined in mob_cmds.c
 */
DECLARE_ROOM_FUN( do_rpasound    );
DECLARE_ROOM_FUN( do_rpgecho     );
DECLARE_ROOM_FUN( do_rpzecho     );
DECLARE_ROOM_FUN( do_rpecho      );
DECLARE_ROOM_FUN( do_rpechoaround);
DECLARE_ROOM_FUN( do_rpechoat    );
DECLARE_ROOM_FUN( do_rpmload     );
DECLARE_ROOM_FUN( do_rpoload     );
DECLARE_ROOM_FUN( do_rppurge     );
DECLARE_ROOM_FUN( do_rptransfer  );
DECLARE_ROOM_FUN( do_rpgtransfer );
DECLARE_ROOM_FUN( do_rpotransfer );
DECLARE_ROOM_FUN( do_rpforce     );
DECLARE_ROOM_FUN( do_rpgforce    );
DECLARE_ROOM_FUN( do_rpvforce    );
DECLARE_ROOM_FUN( do_rpdamage    );
DECLARE_ROOM_FUN( do_rpremember  );
DECLARE_ROOM_FUN( do_rpforget    );
DECLARE_ROOM_FUN( do_rpdelay     );
DECLARE_ROOM_FUN( do_rpcancel    );
DECLARE_ROOM_FUN( do_rpcall      );
DECLARE_ROOM_FUN( do_rpremove    );


