/* $Id: save.c,v 1.666 2004/09/20 10:49:52 shrike Exp $                             */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <limits.h>
#include <stdlib.h>

#include "merc.h"
#include "quest.h"
#include "wanderers.h"
#include "db/db.h"
#include "db/lang.h"

#define PFILE_VERSION 6

/*
 * Array of containers read for proper re-nesting of objects.
 */
#define MAX_NEST    100
static OBJ_DATA *rgObjNest[MAX_NEST];

char DEFAULT_PROMPT[] = "{R%h{c/{W%H{chp{x {C%m{c/{W%M{cm{x {c%vmv{x {C%X{c:tnl {R%y{W({R%L{W) {wvs {R%o {D| {C%q{W%Q {cqtime%l {Y%t {R-{G> {W%e{x";
char OLD_DEFAULT_PROMPT[] = "<%n: {M%h{xhp {C%m{xm {W%v{xmv Opp:%o> ";

extern void toast_evil_cheating_bastards(int id);
extern void stop_fighting(CHAR_DATA *ch, bool fBoth);
/*
 * Local functions.
 */
void fwrite_char (CHAR_DATA * ch, FILE * fp, bool reboot, bool is_quit);
void fwrite_obj(CHAR_DATA * ch, OBJ_DATA * obj, FILE * fp, int iNest, bool is_quit, const char * header);
void fwrite_pet (CHAR_DATA * pet, FILE * fp);
void fwrite_affect(AFFECT_DATA *paf, FILE *fp);
void fread_char (CHAR_DATA * ch, FILE * fp, bool check);
void fread_pet  (CHAR_DATA * ch, FILE * fp);
OBJ_DATA * fread_obj  (CHAR_DATA * ch, FILE * fp);

void check_obj(CHAR_DATA *ch, OBJ_DATA *obj);
CHAR_DATA * char_load(const char *name, bool check);
void fread_golem(CHAR_DATA * ch, FILE * fp);
void fread_undead(CHAR_DATA * ch, FILE * fp);
void fwrite_golem (CHAR_DATA *golem, FILE * fp, bool is_quit);
void fwrite_undead (CHAR_DATA *undead, FILE * fp);
void nuke_slaves (CHAR_DATA *ch);

void fread_explored (CHAR_DATA * ch, FILE * fp);
void fwrite_explored (CHAR_DATA * ch, FILE * fp);
void ValidateExplored(CHAR_DATA * ch);

static CHAR_DATA * loaded_golem;
/*
 * Save a character and inventory.
 * Would be cool to save NPC's too for quest purposes,
 * some of the infrastructure is provided.
 */

void save_char_obj (CHAR_DATA * ch, bool reboot, bool is_quit)
{
    FILE       * fp   ;
    const char * name ;
    OBJ_DATA   * mobj ;
    bool         ok   ;
    /* for golems, undeads etc */
    CHAR_DATA  *gch;
    const char * ptr ;

    // do not save NPC or players of the first level
    if (IS_NPC (ch) || ch->level < 1)
        return ;

    // restore descriptor
    if (ch->desc != NULL && ch->desc->original != NULL)
        ch = ch->desc->original ;

    // make proper name (first letter capitalized)
    name = capitalize (ch->name) ;

    // make sure name is proper - do not create bad filenames
    // check also for long filenames to prevent long loops in the case
    // name is not proper zero-terminated string
    for (ptr = name ; *ptr && (ptr - name < 64) ; ptr++)
    {
        if (!isalpha (*ptr))
        {
            bug ("Save_char_obj: IMPROPER PLAYER NAME", 0) ;
            return ;
        }
    }

    if (*ptr != 0)
    {
        bug ("Save_char_obj: PLAYER NAME IS TOO LONG", 0) ;
        return ;
    }

    // create god log (for non-implementors)
    if (ch != NULL)
    {
        if (ch->pcdata)
        {
            if ((IS_IMMORTAL (ch) || (!IS_NPC(ch) && !IS_NULLSTR(ch->pcdata->granted))))
            {
                fclose (fpReserve) ;

                if ((fp = dfopen(GODS_PATH, name, "w")) == NULL)
                {
                    bug ("Save_char_obj: fopen GODS_PATH", 0) ;
                    perror (ch->name) ;
                }
                else
                {
                    fprintf (fp, "Lev: %2d, RealLev: %2d, Name: %s%s\n",
                             ch->level, ch->pcdata->real_level,
                             ch->name, ch->pcdata->title) ;

                    if (!IS_NULLSTR(ch->pcdata->granted))
                        fprintf(fp, "Granted: %s\n", ch->pcdata->granted);

                    fprintf(fp, "Security: %d\n", ch->pcdata->security);
                    fclose (fp) ;
                }

                fpReserve = fopen (NULL_FILE, "r") ;
                if (fpReserve == NULL)
                    bug ("save_char_obj: Can't open null file.", 0) ;
            }
        }
    }
    fclose (fpReserve) ;

    // create temporary file
    if ((fp = dfopen (PLAYER_PATH, TMP_FILE, "w")) == NULL)
    {
        bug ("Save_char_obj: fopen", 0) ;
        perror (TMP_FILE) ;
        return ;
    }
    else
    {
        // check objects carried by character if it wants to quit
        if (ch->carrying != NULL && is_quit && !IS_IMMORTAL(ch))
            check_obj (ch, ch->carrying) ;

        // save player data
        fwrite_char (ch, fp, reboot, is_quit) ;

        // if carries something - save objects
        if (ch->carrying != NULL)
            fwrite_obj (ch, ch->carrying, fp, 0, is_quit, "#O") ;

        fwrite_explored (ch, fp);

        // save the pets if the same room only
        if (ch->pet != NULL && ch->pet->in_room == ch->in_room)
            fwrite_pet (ch->pet, fp) ;

        // save golems and undeads
        for (gch = char_list; gch != NULL; gch = gch->next)
        {
            if (IS_NPC(gch)
                && IS_AFFECTED(gch,AFF_CHARM)
                && (gch->master == ch))
            {
                if ((gch->pIndexData->vnum == MOB_VNUM_LESSER_GOLEM)     ||
                    (gch->pIndexData->vnum == MOB_VNUM_IRON_GOLEM)       ||
                    (gch->pIndexData->vnum == MOB_VNUM_STONE_GOLEM)      ||
                    (gch->pIndexData->vnum == MOB_VNUM_ADAMANTITE_GOLEM) ||
                    (gch->pIndexData->vnum == MOB_VNUM_DIAMOND_GOLEM)    ||
                    (gch->pIndexData->vnum == MOB_VNUM_ARCHON)           ||
                    (gch->pIndexData->vnum == MOB_VNUM_FOREST_GIANT)     ||
                    (gch->pIndexData->vnum == MOB_VNUM_DRAGON)           ||
                    (gch->pIndexData->vnum == MOB_VNUM_SUM_SHADOW)       ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_MIN)     ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_NECK)    ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_SHIELD)  ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_FLOAT)   ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_HANDS)   ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_ARMS)    ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_LEGS)    ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_FEET)    ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_PLUG_IN) ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_BODY)    ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_WEAPON)  ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_OTHER)   ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_HELM)    ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANIMATED_MAX)     ||
                    (gch->pIndexData->vnum == MOB_VNUM_VAMPIRE_BAT)      ||
                    (gch->pIndexData->vnum == MOB_VNUM_CREATED_GOLEM)    ||
                    (gch->pIndexData->vnum == MOB_VNUM_LION)             ||
                    (gch->pIndexData->vnum == MOB_VNUM_ANGEL)            ||
                    (gch->pIndexData->vnum == MOB_VNUM_DEVIL)            ||
                    (gch->pIndexData->vnum == MOB_VNUM_SQUIRE)           ||
                    (gch->pIndexData->vnum == MOB_VNUM_TREANT)           ||
                    (gch->pIndexData->vnum == MOB_VNUM_BEAR)             ||
                    (gch->pIndexData->vnum == MOB_VNUM_UNDEAD)           ||
                    IS_SET(gch->abilities, EA_SAVE)) // for improved undeads
                {
                    fwrite_golem (gch, fp, is_quit);
                }
/*                else
                {
                    if (gch->pIndexData->vnum == MOB_VNUM_UNDEAD)
                        fwrite_undead (gch, fp);
                }*/
            }
        }

        if (is_quit)
            nuke_slaves(ch);
        /* end saving golems and undeads */

        // end of the file
        fprintf (fp, "#END\n") ;

        // message to the player
        char_act("Saving.", ch);
    }

    // close temporary file and rename it to the original file
    fclose (fp) ;
    d2rename (PLAYER_PATH, TMP_FILE, PLAYER_PATH, name) ;

    fpReserve = fopen (NULL_FILE, "r") ;
    if (fpReserve == NULL)
        bug ("save_char_obj: Can't open null file.", 0) ;

    ok = FALSE ; // indicator that limited object is found

    // now check if this character has still limited objects
    for (mobj = ch->carrying ; mobj != NULL ; mobj = mobj->next_content)
    {
        if (mobj->pIndexData->limit <= 0)
            continue ;

        // we have found a limited object at that character
        ok = TRUE ;
        break ;
    }

    // player has limited objects but is not in the "black" list
    if (ok && !ch->pcdata->has_limit)
    {
        // add this player to the list
        if ((fp = dfopen (PLAYER_PATH, HOLDER_LIST, "a")) == NULL)
        {
            bug ("Save_char_obj: unable to open holder.lst", 0) ;
            return ;
        }

        fprintf (fp, "%s\n", ch->name) ;
        fclose  (fp) ;

        ch->pcdata->has_limit = TRUE ;
    }

    // player hasn't limited objects but is still in the "black" list
    if (ch != NULL && ch->pcdata)
    {
        if (!ok && ch->pcdata->has_limit)
        {
            FILE * tfp  ;
            char * word ;

            // remove this player from the list
            if ((fp = dfopen (PLAYER_PATH, HOLDER_LIST, "r")) == NULL)
            {
                bug ("Save_char_obj: unable to open holder.lst", 0) ;
                return ;
            }

            // open temporary file
            if ((tfp = dfopen (PLAYER_PATH, TMP_FILE, "w")) == NULL)
            {
                bug ("Save_char_obj: unable to open temporary file.", 0) ;
                return ;
            }

            while (!feof (fp))
            {
                // copy all names but this character's
                word = fread_word (fp) ;
                if (word && strlen (word) > 0 &&
                        str_cmp (word, capitalize (ch->name)))
                    fprintf (tfp, "%s\n", word) ;
            }

            fclose (tfp) ;
            fclose (fp)  ;

            d2rename (PLAYER_PATH, TMP_FILE, PLAYER_PATH, HOLDER_LIST) ;

            ch->pcdata->has_limit = FALSE ;
        }
    }
}

/*
 * Write the char.
 */
void fwrite_char(CHAR_DATA * ch, FILE * fp, bool reboot, bool is_quit)
{
    AFFECT_DATA * paf;
    int           pos;
    int           i;

    fprintf(fp, "#%s\n", IS_NPC(ch) ? "MOB" : "PLAYER");

    fwrite_string(fp, "Name", ch->name);

    if (ch->imm_name)
        fwrite_string(fp, "ImmName", ch->imm_name);

    fprintf(fp, "Id   %d\n", ch->id);
    fprintf(fp, "LogO %ld\n", (long) current_time);
    fprintf(fp, "Vers %d\n", PFILE_VERSION);
    fprintf(fp, "Ethos %s\n", flag_string(ethos_table, ch->ethos));
    fwrite_string(fp, "Hometown", hometown_name(ch->hometown));

    if (ch->clan)
    {
        fwrite_string(fp, "Clan", clan_name(ch->clan));
        if (!IS_NPC(ch) && ch->pcdata)
            fprintf(fp, "ClanStatus %d\n", ch->pcdata->clan_status);
    }

    fwrite_string(fp, "Desc", mlstr_mval(ch->description));
    fwrite_string(fp, "Immdesc", mlstr_mval(ch->immdesc));

    if (str_cmp(ch->prompt, DEFAULT_PROMPT)   &&  str_cmp(ch->prompt, OLD_DEFAULT_PROMPT))
        fwrite_string(fp, "Prom", ch->prompt);

    fwrite_string(fp, "Race", race_name(ch->race));
    fprintf(fp, "Sex  %s\n", flag_string(sex_table, ch->sex));
    fwrite_string(fp, "Class", class_name(ch));
    fprintf(fp, "Levl %d\n", ch->level);

    if (!IS_NPC(ch) && ch->pcdata)
    {
        // real level saving
        fprintf(fp, "RealLevel %d\n", (ch->pcdata->real_level > ch->level) ?
                ch->pcdata->real_level : ch->level);
        fprintf(fp, "RealSec %d\n", ch->pcdata->real_sec);
        // limit timer
        fprintf(fp, "LTimer %d\n", ch->pcdata->limit_timer);
        fprintf(fp, "TLPlayed %d\n", ch->pcdata->this_level_played);
    }

    fwrite_string(fp, "ExtFlags", ext_format_flags(ch->ext_flags));

    fprintf(fp, "ALevl %d\n", ch->aff_level);
    fprintf(fp, "Scro %d\n", ch->lines);
    fprintf(fp, "Room %d\n",
            (ch->in_room == get_room_index(ROOM_VNUM_LIMBO)
             && ch->was_in_room != NULL)
            ? ch->was_in_room->vnum
            : ch->in_room == NULL ? 3001 : ch->in_room->vnum);

    fprintf(fp, "HMV  %d %d %d %d %d %d\n",
            ch->hit, ch->max_hit, ch->mana, ch->max_mana, ch->move, ch->max_move);
    fprintf(fp, "PSP  %d\n", ch->psp);
    if (ch->gold > 0)
        fprintf(fp, "Gold %d\n", ch->gold);
    else
        fprintf(fp, "Gold %d\n", 0);
    if (ch->silver > 0)
        fprintf(fp, "Silv %d\n", ch->silver);
    else
        fprintf(fp, "Silv %d\n", 0);
    fprintf(fp, "Exp %d\n", ch->exp);
    fprintf(fp, "ExpTL %d\n", ch->exp_tl);

    if (!IS_NPC(ch))
    {
        if(ch->pcdata)
        {
            if (ch->pcdata->freeze != 0)
                fprintf(fp, "Freeze %lu\n", ch->pcdata->freeze);
            if (ch->pcdata->nochan != 0)
                fprintf(fp, "NoChan %lu\n", ch->pcdata->nochan);
            if (ch->pcdata->nocast != 0)
                fprintf(fp, "NoCast %lu\n", ch->pcdata->nocast);
            if (ch->pcdata->notell != 0)
                fprintf(fp, "NoTell %lu\n", ch->pcdata->notell);
            if (ch->pcdata->noemote != 0)
                fprintf(fp, "NoEmot %lu\n", ch->pcdata->noemote);
            if (ch->pcdata->nonote != 0)
                fprintf(fp, "NoNote %lu\n", ch->pcdata->nonote);
            if (ch->pcdata->noquest != 0)
                fprintf(fp, "NoQuest %lu\n", ch->pcdata->noquest);
            if (ch->pcdata->nowar != 0)
                fprintf(fp, "NoWar %lu\n", ch->pcdata->nowar);
            if (ch->pcdata->peaceful !=0)
                fprintf(fp, "Peaceful %lu\n", ch->pcdata->peaceful);
            if (ch->pcdata->wq_mult_join !=0)
                fprintf(fp, "WQMultJoin %d\n", ch->pcdata->wq_mult_join);
            if (ch->pcdata->wq_mult_win !=0)
                fprintf(fp, "WQMultWin %d\n", ch->pcdata->wq_mult_win);
            if (ch->pcdata->wq_personal_join !=0)
                fprintf(fp, "WQPersJoin %d\n", ch->pcdata->wq_personal_join);
            if (ch->pcdata->wq_personal_win !=0)
                fprintf(fp, "WQPersWin %d\n", ch->pcdata->wq_personal_win);
            if (ch->pcdata->wq_next_time !=0)
                fprintf(fp, "WQNext %d\n", ch->pcdata->wq_next_time);
            if (ch->pcdata->quest_hp_gained !=0)
                fprintf(fp, "QHPGained %d\n", ch->pcdata->quest_hp_gained);
            if (ch->pcdata->quest_mana_gained !=0)
                fprintf(fp, "QManaGained %d\n", ch->pcdata->quest_mana_gained);
            if (ch->pcdata->fishes_caught !=0)
                fprintf(fp, "Fishes %d\n", ch->pcdata->fishes_caught);
            for (i = 0; i < 6; ++i)
            {
                if (ch->pcdata->rusnames[i])
                    fprintf(fp, "RusName %d %s~\n", i, ch->pcdata->rusnames[i]);
            }
        }
    }

    if (ch->plr_flags)
        fprintf(fp, "Act %s\n", format_flags(ch->plr_flags));
    if (ch->affected_by)
        fprintf(fp, "AfBy %s\n", format_flags(ch->affected_by));
    if (ch->comm)
        fprintf(fp, "Comm %s\n", format_flags(ch->comm));
    if (ch->comm2)
        fprintf(fp, "Comm2 %s\n", format_flags(ch->comm2));
    if (ch->invis_level)
        fprintf(fp, "Invi %d\n", ch->invis_level);
    if (ch->incog_level)
        fprintf(fp, "Inco %d\n", ch->incog_level);
    fprintf(fp, "Pos  %d\n",
            ch->position == POS_FIGHTING ? POS_STANDING : ch->position);
    if (ch->practice != 0)
        fprintf(fp, "Prac %d\n", ch->practice);
    if (ch->train != 0)
        fprintf(fp, "Trai %d\n", ch->train);
    if (ch->saving_throw != 0)
        fprintf(fp, "Save  %d\n", ch->saving_throw);
    fprintf(fp, "Alig  %d\n", ch->alignment);
    if (ch->hitroll != 0)
        fprintf(fp, "Hit   %d\n", ch->hitroll);
    if (ch->damroll != 0)
        fprintf(fp, "Dam   %d\n", ch->damroll);
    fprintf(fp, "ACs %d %d %d %d\n",
            ch->armor[0], ch->armor[1], ch->armor[2], ch->armor[3]);
    if (ch->wimpy != 0)
        fprintf(fp, "Wimp  %d\n", ch->wimpy);


    fprintf(fp, "Attr %d %d %d %d %d %d %d\n",
            ch->perm_stat[STAT_STR],
            ch->perm_stat[STAT_INT],
            ch->perm_stat[STAT_WIS],
            ch->perm_stat[STAT_DEX],
            ch->perm_stat[STAT_CON],
            ch->perm_stat[STAT_CHA],
            ch->perm_stat[STAT_LCK]);

    fprintf(fp, "AMod %d %d %d %d %d %d %d\n",
            ch->mod_stat[STAT_STR],
            ch->mod_stat[STAT_INT],
            ch->mod_stat[STAT_WIS],
            ch->mod_stat[STAT_DEX],
            ch->mod_stat[STAT_CON],
            ch->mod_stat[STAT_CHA],
            ch->mod_stat[STAT_LCK]);

    fwrite_string(fp, "Religion", religion_name(ch->religion));

    {
        int i;
        if (ch->stat_wars_all)
            fprintf(fp, "WarJoinAll %d\n", ch->stat_wars_all);
        for (i = 0; i < WAR_MAX_TYPE; ++i)
            if (ch->stat_type_wars_all[i])
                fprintf(fp, "WarJoin%d %d\n", i, ch->stat_type_wars_all[i]);
        if (ch->stat_wars_win)
            fprintf(fp, "WarWinAll %d\n", ch->stat_wars_win);
        for (i = 0; i < WAR_MAX_TYPE; ++i)
            if (ch->stat_type_wars_win[i])
                fprintf(fp, "WarWin%d %d\n", i, ch->stat_type_wars_win[i]);
        if (ch->total_war_deaths)
            fprintf(fp, "WarDied %d\n", ch->total_war_deaths);
        if (ch->total_war_kills)
            fprintf(fp, "WarKills %d\n", ch->total_war_kills);
        if (ch->duels_joined)
            fprintf(fp, "DuelJoin %d\n", ch->duels_joined);
        if (ch->duels_provoked)
            fprintf(fp, "DuelProvoke %d\n", ch->duels_provoked);
        if (ch->duels_win)
            fprintf(fp, "DuelWin %d\n", ch->duels_win);
        if (ch->last_duel_time)
            fprintf(fp, "DuelTime %d\n", ch->last_duel_time);
    }

    if (IS_NPC(ch))
    {
        fprintf(fp, "Vnum %d\n", ch->pIndexData->vnum);
    }
    else
    {
        qtrouble_t  *qt;
        PC_DATA *pcdata = ch->pcdata;
        int i;

        if(pcdata)
        {
            if (pcdata->wiznet)
                fprintf(fp, "Wizn %s\n", format_flags(pcdata->wiznet));

            if (pcdata->trust)
                fprintf(fp, "Trust %s\n", format_flags(pcdata->trust));

            if (ch->pcdata->marryed )
            {
                fwrite_string( fp, "Marryed", ch->pcdata->marryed);
                fprintf( fp, "MarryRoom %d\n", ch->pcdata->marry_room);
            }

            if ( ch->pcdata->last_divorce != -1 )
                fprintf( fp, "LastDivorce %ld\n", (long) ch->pcdata->last_divorce );

            if ( ch->pcdata->last_marry != -1 )
                fprintf( fp, "LastMarry %ld\n", (long) ch->pcdata->last_marry );

            for (qt = pcdata->qtrouble; qt; qt = qt->next)
                fprintf(fp, "Qtrouble %d %d\n", qt->vnum, qt->count);

            if (pcdata->race != ch->race)
                fwrite_string(fp, "OrgRace", race_name(pcdata->race));
            if (pcdata->plevels > 0)
                fprintf(fp, "PLev %d\n", pcdata->plevels);
            if (pcdata->petition)
                fprintf(fp, "Peti %d\n", pcdata->petition);
            fprintf(fp, "Plyd %d\n", pcdata->played + (int) (current_time - ch->logon));


            fprintf(fp, "Age %d\n", get_age(ch));
            fprintf(fp, "SkillPercent %d\n", count_skill_percent(ch));
            fprintf(fp, "AllPercent %d\n", count_all_skill_percent(ch));


            fprintf(fp, "Not  %ld %ld %ld %ld %ld\n",
                    (long) pcdata->last_note, (long) pcdata->last_idea,
                    (long) pcdata->last_penalty, (long) pcdata->last_news,
                    (long) pcdata->last_changes);

            fprintf(fp, "Dead %d\n", pcdata->death);

            if (pcdata->bank_s)
                fprintf(fp, "Banks %d\n", pcdata->bank_s);
            if (pcdata->bank_g)
                fprintf(fp, "Bankg %d\n", pcdata->bank_g);
            //      if (pcdata->headprice)
            fprintf(fp, "Headprice %d\n", pcdata->headprice);
            fprintf(fp, "Element %d\n", pcdata->element);
            if (pcdata->security)
                fprintf(fp, "Sec %d\n", pcdata->security);
            fwrite_string(fp, "Pass", pcdata->pwd);
            fwrite_string(fp, "ProgVars", pcdata->prog_vars);
            fwrite_string(fp, "Bin", pcdata->bamfin);
            fwrite_string(fp, "Bout", pcdata->bamfout);
            fwrite_string(fp, "PreTitl", pcdata->pretitle);
            fwrite_string(fp, "Titl", pcdata->title);
            fprintf(fp, "Pnts %d\n", pcdata->points);
            fprintf(fp, "TSex %s\n", flag_string(sex_table, pcdata->true_sex));
            fprintf(fp, "LLev %d\n", pcdata->last_level);
            fprintf(fp, "HMVP %d %d %d\n", pcdata->perm_hit,
                    pcdata->perm_mana,
                    pcdata->perm_move);
            fprintf(fp, "CndC  %d %d %d %d %d %d\n",
                    pcdata->condition[0],
                    pcdata->condition[1],
                    pcdata->condition[2],
                    pcdata->condition[3],
                    pcdata->condition[4],
                    pcdata->condition[5]);

            if(ch->pcdata->specialization[0] != 0)
                fprintf(fp,"Specialization %d %d %d\n",
                        ch->pcdata->specialization[0],
                        ch->pcdata->specialization[1],
                        ch->pcdata->specialization[2]);

            if(ch->pcdata->disciplines[0] != 0)
                fprintf(fp,"Disciplines %d %d %d %d %d %d\n",
                        ch->pcdata->disciplines[0],
                        ch->pcdata->disciplines[1],
                        ch->pcdata->disciplines[2],
                        ch->pcdata->disciplines[3],
                        ch->pcdata->disciplines[4],
                        ch->pcdata->disciplines[5]);

            /* write lang */
            fprintf(fp, "Lang %d\n", ch->lang);

            /* write logon time */
            fprintf(fp, "Login %s from %s~\n", strtime(ch->logon), pcdata->host);

            /* write pc_killed */
            fprintf(fp, "PC_Killed %d\n", pcdata->pc_killed);
            fprintf(fp, "PC_Died %d\n", pcdata->pc_died);

            for (i = 0; i < MAX_TREES; ++i)
                fprintf(fp, "Tree %d\n", ch->marked_tree[i]);

            /* write alias */
            for (pos = 0; pos < MAX_ALIAS; pos++)
            {
                if (pcdata->alias[pos] == NULL ||  pcdata->alias_sub[pos] == NULL)
                    break;

                fprintf(fp, "Alias %s %s~\n", pcdata->alias[pos],  fix_string(pcdata->alias_sub[pos]));
            }
            for (i = 0; i < ch->remembered_rooms.nused; i++)
            {
                memento_t *m = VARR_GET(&ch->remembered_rooms, i);
                if (IS_NULLSTR(m->name) || m->id.r == NULL)
                    continue;
                fprintf(fp, "Place %d '%s'\n", m->id.r->vnum, m->name);
            }
            for (i = 0; i < ch->remembered_objects.nused; i++)
            {
                memento_t *m = VARR_GET(&ch->remembered_objects, i);
                if (IS_NULLSTR(m->name) || m->id.o == NULL)
                    continue;
                fprintf(fp, "Obj %d '%s'\n", m->id.o->vnum, m->name);
            }
            for (i = 0; i < ch->remembered_mobs.nused; i++)
            {
                memento_t *m = VARR_GET(&ch->remembered_mobs, i);
                if (IS_NULLSTR(m->name) || m->id.m == NULL)
                    continue;
                fprintf(fp, "Mob %d '%s'\n", m->id.m->vnum, m->name);
            }
            for (i = 0; i < ch->remembered_people.nused; i++)
            {
                memento_t *m = VARR_GET(&ch->remembered_people, i);
                if (IS_NULLSTR(m->name) || m->id.vnum == 0)
                    continue;
                fprintf(fp, "Player %d '%s'\n", m->id.vnum, m->name);
            }
            for (i = 0; i < pcdata->learned.nused; i++)
            {
                pcskill_t *ps = VARR_GET(&pcdata->learned, i);

                if (ps->percent == 0)
                    continue;

                fprintf(fp, "Sk %d '%s'\n",
                        ps->percent, skill_name(ps->sn));
            }

            if (pcdata->bonuspoints != 0)
                fprintf(fp, "BonusPnts %d\n", pcdata->bonuspoints);
            if (pcdata->religionpoints != 0)
                fprintf(fp, "ReligionPnts %d\n", pcdata->religionpoints);
            if (pcdata->religionlevel != 0)
                fprintf(fp, "ReligionLvl %d\n", pcdata->religionlevel);
            if (pcdata->questpoints != 0)
                fprintf(fp, "QuestPnts %d\n", pcdata->questpoints);
            if (pcdata->qpbalance != 0)
                fprintf(fp, "QpBalance %d\n", pcdata->qpbalance);
            if (pcdata->questtime != 0)
                fprintf(fp, "QuestTime %d\n",
                        reboot ? -abs(pcdata->questtime) :
                        pcdata->questtime);
            if (pcdata->questnumber != 0)
                fprintf(fp, "QuestNumber %d\n", pcdata->questnumber);
            if (pcdata->questcomplete != 0)
                fprintf(fp, "QuestComplete %d\n", pcdata->questcomplete);

            if (pcdata->StatAllGlobalQuests != 0)
                fprintf(fp, "GQAll %d\n", pcdata->StatAllGlobalQuests);
            if (pcdata->StatWinGlobalQuests != 0)
                fprintf(fp, "GQWin %d\n", pcdata->StatWinGlobalQuests);

            if (pcdata->qp_earned != 0)
                fprintf(fp, "QpEarned %d\n", pcdata->qp_earned);
            if (pcdata->bp_earned != 0)
                fprintf(fp, "BpEarned %d\n", pcdata->bp_earned);

            if (pcdata->TotalExploredRooms != 0)
                fprintf(fp, "Explored %d\n", pcdata->TotalExploredRooms);

            if (pcdata->wishes)
                fprintf(fp, "Wishes %s\n", format_flags(pcdata->wishes));

            fprintf(fp, "Haskilled %d\n", pcdata->has_killed);
            fprintf(fp, "Antkilled %d\n", pcdata->anti_killed);
            fwrite_string(fp, "Twitlist", pcdata->twitlist);
            fwrite_string(fp, "Granted", pcdata->granted);
            fwrite_string(fp, "Linked", pcdata->linked_list);
        }
    }

    for (paf = ch->affected; paf != NULL; paf = paf->next)
    {
        if (!IS_NPC(ch) && paf->where == TO_AFFECTS  &&  IS_SET(paf->bitvector, AFF_CHARM))
            continue;

        fwrite_affect(paf, fp);
    }

#ifdef IMC
    imc_savechar(ch, fp);
#endif
#ifdef I3

    i3save_char(ch, fp);
#endif


    fprintf(fp, "End\n\n");
}

/* write a pet */
void
fwrite_pet(CHAR_DATA * pet, FILE * fp)
{
    AFFECT_DATA    *paf;
    fprintf(fp, "#PET\n");

    fprintf(fp, "Vnum %d\n", pet->pIndexData->vnum);
    fwrite_string(fp, "Name", pet->name);
    fprintf(fp, "LogO %ld\n", (long) current_time);
    if (pet->clan)
        fwrite_string(fp, "Clan", clan_name(pet->clan));
    if (mlstr_cmp(pet->short_descr, pet->pIndexData->short_descr) != 0)
        mlstr_fwrite(fp, "ShD", pet->short_descr);
    if (mlstr_cmp(pet->long_descr, pet->pIndexData->long_descr) != 0)
        mlstr_fwrite(fp, "LnD", pet->long_descr);
    if (mlstr_cmp(pet->description, pet->pIndexData->description) != 0)
        mlstr_fwrite(fp, "Desc", pet->description);
    if (pet->race != pet->pIndexData->race) /* serdar ORG_RACE */
        fwrite_string(fp, "Race", race_name(pet->race));
    fprintf(fp, "Sex  %s\n", flag_string(sex_table, pet->sex));
    if (pet->level != pet->pIndexData->level)
        fprintf(fp, "Levl %d\n", pet->level);
    fprintf(fp, "HMV  %d %d %d %d %d %d\n",
            pet->hit, pet->max_hit, pet->mana, pet->max_mana, pet->move, pet->max_move);
    fprintf(fp, "PSP  %d\n", pet->psp);
    if (pet->gold)
        fprintf(fp, "Gold %d\n", pet->gold);
    if (pet->silver)
        fprintf(fp, "Silv %d\n", pet->silver);
    if (pet->exp)
        fprintf(fp, "Exp  %d\n", pet->exp);
    if (pet->affected_by != pet->pIndexData->affected_by)
        fprintf(fp, "AfBy %s\n", format_flags(pet->affected_by));
    if (pet->comm != 0)
        fprintf(fp, "Comm %s\n", format_flags(pet->comm));
    if (pet->comm2 != 0)
        fprintf(fp, "Comm2 %s\n", format_flags(pet->comm2));
    fprintf(fp, "Pos  %d\n", pet->position = POS_FIGHTING ? POS_STANDING : pet->position);
    if (pet->saving_throw)
        fprintf(fp, "Save %d\n", pet->saving_throw);
    if (pet->alignment != pet->pIndexData->alignment)
        fprintf(fp, "Alig %d\n", pet->alignment);
    if (pet->hitroll != pet->pIndexData->hitroll)
        fprintf(fp, "Hit  %d\n", pet->hitroll);
    if (pet->damroll != pet->pIndexData->damage[DICE_BONUS])
        fprintf(fp, "Dam  %d\n", pet->damroll);
    fprintf(fp, "ACs  %d %d %d %d\n",
            pet->armor[0], pet->armor[1], pet->armor[2], pet->armor[3]);
    fprintf(fp, "Attr %d %d %d %d %d %d %d\n",
            pet->perm_stat[STAT_STR], pet->perm_stat[STAT_INT],
            pet->perm_stat[STAT_WIS], pet->perm_stat[STAT_DEX],
            pet->perm_stat[STAT_CON], pet->perm_stat[STAT_CHA],
            pet->perm_stat[STAT_LCK]);
    fprintf(fp, "AMod %d %d %d %d %d %d %d\n",
            pet->mod_stat[STAT_STR], pet->mod_stat[STAT_INT],
            pet->mod_stat[STAT_WIS], pet->mod_stat[STAT_DEX],
            pet->mod_stat[STAT_CON], pet->mod_stat[STAT_CHA],
            pet->perm_stat[STAT_LCK]);

    for (paf = pet->affected; paf != NULL; paf = paf->next)
        fwrite_affect(paf, fp);

    fprintf(fp, "End\n");
}

void check_obj(CHAR_DATA *ch, OBJ_DATA *obj)
{
    OBJ_DATA    *mobj, *next_obj;

    for (mobj = obj; mobj != NULL; mobj = next_obj)
    {
        AREA_DATA *pArea = area_vnum_lookup(mobj->pIndexData->vnum);
        int lev = (mobj->pIndexData->limit > 0) ? mobj->level : mobj->level - 5;
        next_obj = mobj->next_content;

        // condition : Do not write HiLevel obj...
        if ((get_wear_level(ch, mobj) < lev
                && mobj->pIndexData->item_type != ITEM_CONTAINER)
                // condition : Do not write LoLevel limited obj...
                        || (ch->level > mobj->pIndexData->level + 20
                        && mobj->pIndexData->limit > 0)
                // condition : Do not write HiLevel quest obj...
                || (IS_SET(mobj->pIndexData->extra_flags, ITEM_QUEST)
                    && ch->level < mobj->pIndexData->level)
                // condition : Do not write obj from test area...
                || IS_SET(pArea->flags, AREA_UNDER_CONSTRUCTION))
            extract_obj_raw(mobj, X_F_NORECURSE);

        // condition : Do not write obj with owner...
        if (!IS_NULLSTR(mobj->owner)
                && str_cmp(mobj->owner, ch->name)
                && (mobj->pIndexData->vnum != OBJ_VNUM_TORN_HEART
                    && mobj->pIndexData->vnum != OBJ_VNUM_SEVERED_HEAD
                    && mobj->pIndexData->vnum != OBJ_VNUM_SLICED_ARM
                    && mobj->pIndexData->vnum != OBJ_VNUM_SLICED_LEG
                    && mobj->pIndexData->vnum != OBJ_VNUM_GUTS
                    && mobj->pIndexData->vnum != OBJ_VNUM_BRAINS))
        {
            log_printf("%s: '%s' of %s", ch->name, mobj->name, mobj->owner);
            act("$p vanishes!", ch, mobj, NULL, TO_CHAR);
            extract_obj(mobj);
        }
    }
}

/*
 * Write an object and its contents.
 */
void  fwrite_obj(CHAR_DATA * ch, OBJ_DATA * obj, FILE * fp, int iNest, bool is_quit, const char * header)
{
    ED_DATA *ed;
    AFFECT_DATA    *paf;

    /*
     * Slick recursion to write lists backwards, so loading them will load
     * in forwards order.
     */
    if (obj->next_content != NULL)
        fwrite_obj(ch, obj->next_content, fp, iNest, is_quit, header);

    /* don't save clan item */
    if (is_clan_item(obj))
    {
        if (is_quit)
        {
            act("$p vanishes!", ch, obj, NULL, TO_CHAR) ;
            extract_obj (obj) ;
        }
        return ;
    }

    // don't save limited eq for charmies
    if (ch != NULL && obj != NULL)
    {
       if (IS_NPC(ch) && obj->pIndexData->limit > 0)
       {
           if (is_quit)
           {
              act("$p vanishes!", ch, obj, NULL, TO_CHAR) ;
              extract_obj (obj) ;
           }
           return ;
       }
    }

    /*
     * Castrate storage characters.
     */
    if (ch && !IS_IMMORTAL(ch) && is_quit)
    {
        AREA_DATA *pArea = area_vnum_lookup(obj->pIndexData->vnum);
        int lev = (obj->pIndexData->limit > 0) ? obj->level : obj->level - 5;

        if ((get_wear_level(ch, obj) < lev &&
                obj->pIndexData->item_type != ITEM_CONTAINER)
                        ||  (ch->level > obj->pIndexData->level + 20 &&   obj->pIndexData->limit > 0)
                        ||  (IS_SET(ch->comm, PLR_PEACE) && obj->pIndexData->limit > 0)
                        ||  (IS_SET(obj->pIndexData->extra_flags, ITEM_QUEST) &&  ch->level < obj->pIndexData->level)
                        ||   IS_SET(pArea->flags, AREA_UNDER_CONSTRUCTION))
        {
            extract_obj_raw(obj, X_F_NORECURSE);
            return;
        }
    }

    /* do not save named objs if ch is not owner */
    if (ch && !IS_IMMORTAL(ch)
            &&  is_quit
            &&  !IS_NULLSTR(obj->owner)
            &&  str_cmp(obj->owner, ch->name)
            &&  (obj->pIndexData->vnum != OBJ_VNUM_TORN_HEART
                 && obj->pIndexData->vnum != OBJ_VNUM_SEVERED_HEAD
                 && obj->pIndexData->vnum != OBJ_VNUM_SLICED_ARM
                 && obj->pIndexData->vnum != OBJ_VNUM_SLICED_LEG
                 && obj->pIndexData->vnum != OBJ_VNUM_GUTS
                 && obj->pIndexData->vnum != OBJ_VNUM_BRAINS))

    {
        log_printf("%s: '%s' of %s", ch->name, obj->name, obj->owner);
        act("$p vanishes!", ch, obj, NULL, TO_CHAR);
        extract_obj(obj);
        return;
    }

    //fprintf(fp, "#O\n");
    fprintf(fp, "%s\n", header);
    fprintf(fp, "Vnum %d\n", obj->pIndexData->vnum);
    fprintf(fp, "Cond %d\n", obj->condition);

    fprintf(fp, "Nest %d\n", iNest);
    fwrite_string(fp, "Owner", obj->owner);

    if (obj->pIndexData->limit < 0)
    {
        if (str_cmp(obj->name, obj->pIndexData->name))
            fwrite_string(fp, "Name", obj->name);
        if (mlstr_cmp(obj->short_descr, obj->pIndexData->short_descr))
            mlstr_fwrite(fp, "ShD", obj->short_descr);
        if (mlstr_cmp(obj->description, obj->pIndexData->description))
            mlstr_fwrite(fp, "Desc", obj->description);
    }

    if (obj->extra_flags != obj->pIndexData->extra_flags)
        fprintf(fp, "ExtraFlags %s\n", format_flags(obj->extra_flags));

    if (obj->size != obj->pIndexData->size)
        fprintf(fp, "Size %d\n", obj->size);

    fprintf(fp, "Wear %d\n", obj->wear_loc);
    if (obj->level != obj->pIndexData->level)
        fprintf(fp, "Lev  %d\n", obj->level);
    if (obj->timer != 0)
        fprintf(fp, "Time %d\n", obj->timer);
    fprintf(fp, "Cost %d\n", obj->cost);
    if (obj->value[0] != obj->pIndexData->value[0]
            || obj->value[1] != obj->pIndexData->value[1]
            || obj->value[2] != obj->pIndexData->value[2]
            || obj->value[3] != obj->pIndexData->value[3]
            || obj->value[4] != obj->pIndexData->value[4])
        fprintf(fp, "Val  %d %d %d %d %d\n",
                obj->value[0], obj->value[1], obj->value[2], obj->value[3],
                obj->value[4]);

    switch (obj->pIndexData->item_type)
    {
    case ITEM_POTION:
    case ITEM_SCROLL:
        if (obj->value[1] > 0)
        {
            fprintf(fp, "Spell 1 '%s'\n",
                    skill_name(obj->value[1]));
        }
        if (obj->value[2] > 0)
        {
            fprintf(fp, "Spell 2 '%s'\n",
                    skill_name(obj->value[2]));
        }
        if (obj->value[3] > 0)
        {
            fprintf(fp, "Spell 3 '%s'\n",
                    skill_name(obj->value[3]));
        }
        break;

    case ITEM_PILL:
    case ITEM_STAFF:
    case ITEM_WAND:
        if (obj->value[3] > 0)
        {
            fprintf(fp, "Spell 3 '%s'\n",
                    skill_name(obj->value[3]));
        }
        break;
    case ITEM_SHAMAN_TATTOO:
    case ITEM_LEARN_BOOK:
        if (obj->value[2] > 0)
        {
            fprintf(fp, "Spell 2 '%s'\n",
                    skill_name(obj->value[2]));
        }
        break;
    case ITEM_KEYRING:
            save_keyring( fp, obj);
        break;
    }

    for (paf = obj->affected; paf != NULL; paf = paf->next)
        fwrite_affect(paf, fp);

    for (ed = obj->ed; ed != NULL; ed = ed->next)
    {
        if (IS_NULLSTR(ed->keyword))
            continue;
        fwrite_string(fp, "ExDe", ed->keyword);
        mlstr_fwrite(fp, NULL, ed->description);
    }

    fprintf(fp, "End\n\n");

    if (obj->contains != NULL)
        fwrite_obj(ch, obj->contains, fp, iNest + 1, is_quit, header);
}


CHAR_DATA * char_load_special(const char * name)
{
    CHAR_DATA *ch;
    if (IS_NULLSTR(name))
        return NULL;

    ch = char_load(name, FALSE);
    if (IS_SET(ch->plr_flags, PLR_NEW))
    {
        free_char(ch);
        return NULL;
    }
    ch->next = char_list;
    char_list = ch;
    if (ch->in_room != NULL)
    {
        ch->was_in_room = ch->in_room;
        char_to_room(ch, get_room_index(1));
    }
    if (ch->pet != NULL)
        char_to_room(ch->pet, ch->in_room);
    return ch;
}


void char_nuke(CHAR_DATA *ch)
{
    int id;
    if (ch == NULL)
        return;
    if (ch->desc != NULL || IS_NPC(ch))
        return;
    if (ch->was_in_room != NULL)
    {
        char_from_room(ch);
        char_to_room(ch, ch->was_in_room);
        if (ch->pet != NULL)
        {
            char_from_room(ch->pet);
            char_to_room(ch->pet, ch->was_in_room);
        }
    }
    save_char_obj(ch, FALSE, TRUE);
    id = ch->id;
    extract_char_nocount(ch, TRUE);
    toast_evil_cheating_bastards(id);
    return;
}

/*
 * Load a char and inventory into a new ch structure.
 */
void load_char_obj (DESCRIPTOR_DATA * d, const char * name, bool check)
{
    d->character        = char_load(name, check);
    d->character->desc  = d;

}

void reset_pcdata(CHAR_DATA *ch)
{
    ch->desc      = NULL;
    ch->id        = get_pc_id () ;
    ch->race      = rn_lookup ("human") ;

    ch->plr_flags = PLR_NOSUMMON | PLR_AUTOTITLE  | PLR_AUTOASSIST |
                    PLR_AUTOEXIT | PLR_AUTOGOLD | PLR_AUTOSILVER |
                    PLR_AUTOLOOK | PLR_AUTOSAC  | PLR_AUTOSPLIT ;

    ch->comm      = COMM_COMBINE | COMM_PROMPT | COMM_COLOR | COMM_NOSEND;

    ch->lang      = lang_lookup ("rus") ;
    ch->prompt    = str_dup (DEFAULT_PROMPT) ;

    ch->pcdata->race        = ch->race ;
    ch->pcdata->clan_status = CLAN_COMMONER ;
    ch->clan                = 0 ;

    EXT_CLEAN_FLAGS(ch->ext_flags);

    ch->pcdata->condition [COND_THIRST]    = 48 ;
    ch->pcdata->condition [COND_FULL]      = 48 ;
    ch->pcdata->condition [COND_HUNGER]    = 48 ;
    ch->pcdata->condition [COND_BLOODLUST] = 48 ;
    ch->pcdata->condition [COND_DESIRE]    = 48 ;
    if (ch->pcdata->condition[COND_BLOODLUST] < 48
            &&  !HAS_SKILL(ch, gsn_vampire))
        ch->pcdata->condition[COND_BLOODLUST] = 48;

    ch->pcdata->limit_timer = LTIMER_DEFAULT ;
    ch->pcdata->has_limit   = FALSE  ;

    ch->pcdata->StatWinGlobalQuests = 0 ;
    ch->pcdata->StatAllGlobalQuests = 0 ;

    ch->pcdata->real_level = 0;
    ch->pcdata->real_sec = 0;

    ch->pcdata->this_level_played = 0;

    // explored
    ch->pcdata->explored_areas     = 0 ;
    ch->pcdata->last_visited       = 0 ;
    ch->pcdata->TotalExploredRooms = 0 ;
}

CHAR_DATA *char_load(const char *name, bool check)
{
    CHAR_DATA *ch;
    FILE *fp;
    bool found = FALSE;

    // allocate structures
    ch            = new_char();
    ch->pcdata    = new_pcdata();

    name = capitalize (name) ;
    ch->name      = str_dup (name);
    reset_pcdata(ch);
#ifdef IMC

    imc_initchar(ch);
#endif
#ifdef I3

    i3init_char(ch);
#endif

    // open character filename
    fclose (fpReserve) ;

    // unzip
    snprintf (filename, sizeof (filename), "%s%c%s.gz", PLAYER_PATH, PATH_SEPARATOR, name) ;
    if ((fp = fopen (filename, "r")) != NULL)
    {
        char buf [PATH_MAX * 2] ;
        fclose   (fp) ;
        snprintf (buf, sizeof(buf), "gzip -dfq %s", filename) ;
        system   (buf) ;
    }

    if ((fp = dfopen (PLAYER_PATH, name, "r")) != NULL)
    {
        int iNest;
        for (iNest = 0 ; iNest < MAX_NEST ; iNest++)
            rgObjNest[iNest] = NULL ;

        found = TRUE ;

        for (;;)
        {
            char   letter ;
            char * word   ;

            letter = fread_letter (fp) ;

            if (letter == '*')
            {
                fread_to_eol (fp) ;
                continue ;
            }

            if (letter != '#')
            {
                log_printf ("Load_char_obj: # not found in %s.", name) ;
                break ;
            }

            word = fread_word (fp) ;

            if (!str_cmp (word, "PLAYER"))
                fread_char (ch, fp, check) ;
            else if (!str_cmp (word, "OBJECT"))
                fread_obj  (ch, fp) ;
            else if (!str_cmp (word, "O"))
                fread_obj  (ch, fp) ;
            else if (!str_cmp (word, "GOLEM")) // golem, lion
                fread_golem (ch, fp) ;
            else if (!str_cmp (word, "UNDEAD")) // undead
                fread_undead (ch, fp) ;
            else if (!str_cmp (word, "MOBOBJ")) // mob's eq
            {
                OBJ_DATA * obj = fread_obj(loaded_golem, fp);
                if (loaded_golem == NULL)
                    extract_obj(obj);
            }
            else if (!str_cmp (word, "EXPLORED"))  // explored
            {
                fread_explored (ch, fp) ;
                ch->pcdata->last_visited = ch->pcdata->explored_areas ;
            }
            else if (!str_cmp (word, "PET")) // pet
            {
                if (!check)
                    fread_pet (ch, fp) ;
            }
            else if (!str_cmp (word, "END"))
            {
                loaded_golem = NULL;
                break;
            }
            else
            {
                bug ("Load_char_obj: bad section.", 0) ;
                break ;
            }
        }

        fclose (fp) ;
    }

    fpReserve = fopen (NULL_FILE, "r") ;
    if (fpReserve == NULL)
        bug ("load_char: Can't open null file.", 0) ;

    // initialize race
    if (found)
    {
        OBJ_DATA  *mobj;

        reset_char(ch);


        // set current has_limit flag
        for (mobj = ch->carrying ; mobj != NULL ; mobj = mobj->next_content)
        {
            if (mobj->pIndexData->limit <= 0)
                continue ;

            // we have found a limited object at that character
            ch->pcdata->has_limit = TRUE ;
            break ;
        }
    }

    ValidateExplored (ch) ;


    if (!found)
        ch->plr_flags |= PLR_NEW;
    return ch;
}

/*
 * Read in a char.
 */
void fread_char(CHAR_DATA * ch, FILE * fp, bool check)
{
    char           *word = "End";
    bool            fMatch;
    int             count = 0;
    int             lastlogoff = current_time;
    int             percent;
    int dummy;
    int curr_tree = 0;

    ch->pcdata->bank_s = 0;
    ch->pcdata->bank_g = 0;
    ch->pcdata->headprice = 0;
    ch->pcdata->element = 0;

    for (;;)
    {
        word = feof(fp) ? "End" : fread_word(fp);
        fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case '*':
            fMatch = TRUE;
            fread_to_eol(fp);
            break;

        case 'A':
            KEY("Act", ch->plr_flags, fread_flags(fp) &
                ~(PLR_GHOST | PLR_CONFIRM_DELETE |
                  PLR_NEW | PLR_PUMPED | PLR_NOSOUL));
            KEY("AffectedBy", ch->affected_by, fread_flags(fp));
            KEY("AfBy", ch->affected_by, fread_flags(fp) &
                ~AFF_CHARM);
            KEY("Age", dummy, fread_number(fp)); //  into dummy variable
            KEY("Alignment", ch->alignment, fread_number(fp));
            KEY("ALevl", ch->aff_level, fread_number(fp));
            KEY("Alig", ch->alignment, fread_number(fp));
            KEY("AllPercent", dummy, fread_number(fp));
            KEY("AntKilled", ch->pcdata->anti_killed, fread_number(fp));

            if (!str_cmp(word, "Alia"))
            {
                if (count >= MAX_ALIAS)
                {
                    fread_to_eol(fp);
                    fMatch = TRUE;
                    break;
                }
                ch->pcdata->alias[count] = str_dup(fread_word(fp));
                ch->pcdata->alias_sub[count] = str_dup(fread_word(fp));
                count++;
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Alias"))
            {
                if (count >= MAX_ALIAS)
                {
                    fread_to_eol(fp);
                    fMatch = TRUE;
                    break;
                }
                ch->pcdata->alias[count] = str_dup(fread_word(fp));
                ch->pcdata->alias_sub[count] = fread_string(fp);
                count++;
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "AC") || !str_cmp(word, "Armor"))
            {
                fread_to_eol(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "ACs"))
            {
                int             i;
                for (i = 0; i < 4; i++)
                    ch->armor[i] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "AffD"))
            {
                AFFECT_DATA    *paf;
                int             sn;
                paf = aff_new();

                sn = sn_lookup(fread_word(fp));
                if (sn < 0)
                    bug("Fread_char: unknown skill.", 0);
                else
                    paf->type = sn;

                paf->level = fread_number(fp);
                paf->duration = fread_number(fp);
                paf->modifier = fread_number(fp);
                paf->location = fread_number(fp);
                paf->bitvector = fread_flags(fp);
                paf->next = ch->affected;
                ch->affected = paf;
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Affc"))
            {
                AFFECT_DATA    *paf;
                int             sn;
                paf = aff_new();

                sn = sn_lookup(fread_word(fp));
                if (sn < 0)
                    bug("Fread_char: unknown skill.", 0);
                else
                    paf->type = sn;

                paf->where = fread_number(fp);
                paf->level = fread_number(fp);
                paf->duration = fread_number(fp);
                paf->modifier = fread_number(fp);
                paf->location = fread_number(fp);
                paf->bitvector = fread_flags(fp);
                paf->next = ch->affected;
                ch->affected = paf;
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "AttrMod") || !str_cmp(word, "AMod"))
            {
                int             stat;
                for (stat = 0; stat < MAX_STATS; stat++)
                    ch->mod_stat[stat] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "AttrPerm") || !str_cmp(word, "Attr"))
            {
                int             stat;
                for (stat = 0; stat < MAX_STATS; stat++)
                    ch->perm_stat[stat] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            break;

        case 'B':
            SKEY("Bamfin", ch->pcdata->bamfin);
            KEY("Banks", ch->pcdata->bank_s, fread_number(fp));
            KEY("Bankg", ch->pcdata->bank_g, fread_number(fp));
            SKEY("Bamfout", ch->pcdata->bamfout);
            SKEY("Bin", ch->pcdata->bamfin);
            SKEY("Bout", ch->pcdata->bamfout);
            KEY("BonusPnts", ch->pcdata->bonuspoints, fread_number(fp));
            KEY("BpEarned", ch->pcdata->bp_earned, fread_number(fp));
            break;

        case 'C':
            if (!str_cmp(word, "Class"))
            {
                const char *cl = fread_string(fp);
                ch->class = cn_lookup(cl);
                free_string(cl);
                fMatch = TRUE;
                break;
            }
            KEY("Cla", ch->class, fread_number(fp));
            KEY("Clan", ch->clan, fread_clan(fp));
            KEY("ClanStatus", ch->pcdata->clan_status,
                fread_number(fp));
            if (!str_cmp(word, "Condition")
                    || !str_cmp(word, "Cond"))
            {
                ch->pcdata->condition[0] = fread_number(fp);
                ch->pcdata->condition[1] = fread_number(fp);
                ch->pcdata->condition[2] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "CndC"))
            {
                ch->pcdata->condition[0] = fread_number(fp);
                ch->pcdata->condition[1] = fread_number(fp);
                ch->pcdata->condition[2] = fread_number(fp);
                ch->pcdata->condition[3] = fread_number(fp);
                ch->pcdata->condition[4] = fread_number(fp);
                ch->pcdata->condition[5] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Cnd"))
            {
                ch->pcdata->condition[0] = fread_number(fp);
                ch->pcdata->condition[1] = fread_number(fp);
                ch->pcdata->condition[2] = fread_number(fp);
                ch->pcdata->condition[3] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            KEY("Comm", ch->comm, fread_flags(fp) & ~COMM_AFK);
            KEY("Comm2", ch->comm2, fread_flags(fp));

            break;

        case 'D':
            KEY("Damroll", ch->damroll, fread_number(fp));
            KEY("Dam", ch->damroll, fread_number(fp));
            MLSKEY("Desc", ch->description);
            KEY("Dead", ch->pcdata->death, fread_number(fp));
            if ( !str_cmp( word, "Disciplines") )
            {
                ch->pcdata->disciplines[0] = fread_number(fp);
                ch->pcdata->disciplines[1] = fread_number(fp);
                ch->pcdata->disciplines[2] = fread_number(fp);
                ch->pcdata->disciplines[3] = fread_number(fp);
                ch->pcdata->disciplines[4] = fread_number(fp);
                ch->pcdata->disciplines[5] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            KEY("DuelJoin", ch->duels_joined, fread_number(fp));
            KEY("DuelProvoke", ch->duels_provoked, fread_number(fp));
            KEY("DuelWin", ch->duels_win, fread_number(fp));
            KEY("DuelTime", ch->last_duel_time, fread_number(fp));
            break;

        case 'E':
            if (!str_cmp(word, "End"))
            {
                /*
                 * adjust hp mana move up  -- here for speed's
                 * sake
                 */
                percent = (current_time - lastlogoff)
                          * 25 / (2 * 60 * 60);

                percent = UMIN(percent, 100);

                if (percent > 0 && !IS_AFFECTED(ch, AFF_POISON)
                        && !IS_AFFECTED(ch, AFF_PLAGUE))
                {
                    ch->hit += (ch->max_hit - ch->hit)
                               * percent / 100;
                    ch->mana += (ch->max_mana - ch->mana)
                                * percent / 100;
                    ch->move += (ch->max_move - ch->move)
                                * percent / 100;
                    if (!IS_NPC(ch))
                        ch->pcdata->questtime =
                            -abs(ch->pcdata->questtime *
                                 (100 - UMIN(5 * percent, 100))
                                 / 100);
                }
                ch->played = ch->pcdata->played;
                if (ch->lines < SCROLL_MIN-2)
                    ch->lines = SCROLL_MAX-2;

                if (IS_SET(ch->plr_flags, PLR_COLOR))
                {
                    REMOVE_BIT(ch->plr_flags, PLR_COLOR);
                    SET_BIT(ch->comm, COMM_COLOR);
                }

                return;
            }
            KEY("Exp", ch->exp, fread_number(fp));
            KEY("ExpTL", ch->exp_tl, fread_number(fp));
            KEY("Etho", ch->ethos, fread_number(fp));
            KEY("Ethos", ch->ethos, fread_fword(ethos_table, fp));
            KEY("Explored", ch->pcdata->TotalExploredRooms, fread_number(fp));
            KEY("Element", ch->pcdata->element, fread_number(fp));

            if (!str_cmp(word, "ExtFlags"))
            {
                const char* flag_buff;
                flag_buff = fread_string(fp);
                ext_read_flags(flag_buff, ch->ext_flags);
                free_string(flag_buff);
                fMatch = TRUE;
            }

            break;

        case 'F':
            KEY("Form", ch->form, fread_flags(fp));
            KEY("Freeze", ch->pcdata->freeze, fread_number(fp));
            KEY("Fishes", ch->pcdata->fishes_caught, fread_number(fp));
            break;

        case 'G':
            KEY("Gold", ch->gold, fread_number(fp));
            KEY("GQAll", ch->pcdata->StatAllGlobalQuests, fread_number(fp));
            KEY("GQWin", ch->pcdata->StatWinGlobalQuests, fread_number(fp));
            SKEY("Granted", ch->pcdata->granted);
            if (!str_cmp(word, "Group") || !str_cmp(word, "Gr"))
            {
                fread_word(fp);
                fMatch = TRUE;
            }
            break;

        case 'H':
            if (!str_cmp(word, "Hometown"))
            {
                const char *s = fread_string(fp);
                ch->hometown = htn_lookup(s);
                free_string(s);
                fMatch = TRUE;
            }

            if (!str_cmp(word, "HomeXY"))
            {
                fread_number(fp);
                fread_number(fp);
                fMatch = TRUE;
                break;
            }

            KEY("Hitroll", ch->hitroll, fread_number(fp));
            KEY("Hit", ch->hitroll, fread_number(fp));
            KEY("Home", ch->hometown, fread_number(fp));
            KEY("Haskilled", ch->pcdata->has_killed, fread_number(fp));
            KEY("Headprice", ch->pcdata->headprice, fread_number(fp));

            if (!str_cmp(word, "HpManaMove") || !str_cmp(word, "HMV"))
            {
                ch->hit = fread_number(fp);
                ch->max_hit = fread_number(fp);
                ch->mana = fread_number(fp);
                ch->max_mana = fread_number(fp);
                ch->move = fread_number(fp);
                ch->max_move = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "HpManaMovePerm") || !str_cmp(word, "HMVP"))
            {
                ch->pcdata->perm_hit = fread_number(fp);
                ch->pcdata->perm_mana = fread_number(fp);
                ch->pcdata->perm_move = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            break;

        case 'I':
#ifdef IMC

            if ((fMatch = imc_loadchar(ch, fp, word)))
                break;
#endif
#ifdef I3

            if ((fMatch = i3load_char(ch, fp, word)))
                break;
#endif

            KEY("Id", ch->id, fread_number(fp));
            KEY("InvisLevel", ch->invis_level, fread_number(fp));
            KEY("Inco", ch->incog_level, fread_number(fp));
            KEY("Invi", ch->invis_level, fread_number(fp));
            KEY("I_Lang", ch->lang, fread_number(fp));
            SKEY("ImmName", ch->imm_name);
            MLSKEY("Immdesc", ch->immdesc);
            break;

        case 'L':

            if (!str_cmp(word, "LocationXY"))
            {
                fread_number(fp);
                fread_number(fp);
                fread_number(fp);
                fMatch = TRUE;
                break;
            }

            KEY("LastLevel", ch->pcdata->last_level, fread_number(fp));
            KEY("LastDivorce", ch->pcdata->last_divorce, fread_number(fp));
            KEY("LastMarry", ch->pcdata->last_marry, fread_number(fp));
            KEY("LLev", ch->pcdata->last_level, fread_number(fp));
            KEY("Level", ch->level, fread_number(fp));
            KEY("Lev", ch->level, fread_number(fp));
            KEY("Levl", ch->level, fread_number(fp));
            KEY("LTimer", ch->pcdata->limit_timer, fread_number(fp));
            KEY("LogO", lastlogoff, fread_number(fp));
            KEY("Lang", ch->lang, fread_number(fp));
            KEY("Login", ch->pcdata->last_login, fread_string(fp));
            SKEY("Linked", ch->pcdata->linked_list);
            break;

        case 'M':
            SKEY("Marryed",   ch->pcdata->marryed);
            KEY("MarryRoom",  ch->pcdata->marry_room,  fread_number(fp));
            if (str_cmp(word, "Mob") == 0)
            {
                const char *name;
                int vnum;
                vnum = fread_number(fp);
                name = fread_word(fp);
                memento_set(ch, name, vnum, TYPE_MOB);
                fMatch = TRUE;
            }

            break;
        case 'N':
            KEY("NoChan", ch->pcdata->nochan,  fread_number(fp));
            KEY("NoEmot", ch->pcdata->noemote, fread_number(fp));
            KEY("NoQuest", ch->pcdata->noquest,  fread_number(fp));
            KEY("NoNote", ch->pcdata->nonote,  fread_number(fp));
            KEY("NoCast", ch->pcdata->nocast, fread_number(fp));
            KEY("NoTell", ch->pcdata->notell,  fread_number(fp));
            KEY("NoWar", ch->pcdata->nowar,  fread_number(fp));
            SKEY("Name", ch->name);
            KEY("Note", ch->pcdata->last_note, fread_number(fp));
            if (!str_cmp(word, "Not"))
            {
                ch->pcdata->last_note = fread_number(fp);
                ch->pcdata->last_idea = fread_number(fp);
                ch->pcdata->last_penalty = fread_number(fp);
                ch->pcdata->last_news = fread_number(fp);
                ch->pcdata->last_changes = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            break;

        case 'O':
            if (!str_cmp(word, "OrgRace"))
            {
                const char *race = fread_string(fp);
                ch->pcdata->race = rn_lookup(race);
                free_string(race);
                fMatch = TRUE;
                break;
            }
            if (str_cmp(word, "Obj") == 0)
            {
                const char *name;
                int vnum;
                vnum = fread_number(fp);
                name = fread_word(fp);
                memento_set(ch, name, vnum, TYPE_OBJ);
                fMatch = TRUE;
            }
            break;
        case 'P':
            KEY("Peti", ch->pcdata->petition, fread_number(fp));
            KEY("PLev", ch->pcdata->plevels, fread_number(fp));
            SKEY("Password", ch->pcdata->pwd);
            SKEY("Pass", ch->pcdata->pwd);
            KEY("PC_Killed", ch->pcdata->pc_killed, fread_number(fp));
            KEY("PC_Died", ch->pcdata->pc_died, fread_number(fp));
            KEY("Played", ch->pcdata->played, fread_number(fp));
            KEY("Plyd", ch->pcdata->played, fread_number(fp));
            KEY("Points", ch->pcdata->points, fread_number(fp));
            KEY("Pnts", ch->pcdata->points, fread_number(fp));
            KEY("Position", ch->position, fread_number(fp));
            KEY("Pos", ch->position, fread_number(fp));
            KEY("Practice", ch->practice, fread_number(fp));
            KEY("Prac", ch->practice, fread_number(fp));
            SKEY("Prompt", ch->prompt);
            SKEY("Prom", ch->prompt);
            SKEY("ProgVars", ch->pcdata->prog_vars);
            KEY("PSP", ch->psp, fread_number(fp));
            if (!str_cmp(word, "PreTitle") || !str_cmp(word, "PreTitl"))
            {
                const char *p = fread_string(fp);
                set_pretitle(ch, p);
                free_string(p);
                fMatch = TRUE;
                break;
            }
            if (str_cmp(word, "Place") == 0)
            {
                const char *name;
                int vnum;
                vnum = fread_number(fp);
                name = fread_word(fp);
                memento_set(ch, name, vnum, TYPE_ROOM);
                fMatch = TRUE;
            }
            if (str_cmp(word, "Player") == 0)
            {
                const char *name;
                int vnum;
                vnum = fread_number(fp);
                name = fread_word(fp);
                memento_set(ch, name, vnum, TYPE_PC);
                fMatch = TRUE;
            }
            break;

        case 'Q':
            KEY("QpBalance", ch->pcdata->qpbalance, fread_number(fp));
            KEY("QuestComplete", ch->pcdata->questcomplete, fread_number(fp));
            KEY("QuestNumber", ch->pcdata->questnumber, fread_number(fp));
            KEY("QuestTime", ch->pcdata->questtime, fread_number(fp));
            KEY("QuestPnts", ch->pcdata->questpoints, fread_number(fp));
            KEY("QpEarned", ch->pcdata->qp_earned, fread_number(fp));
            KEY("QHPGained", ch->pcdata->quest_hp_gained, fread_number(fp));
            KEY("QManaGained", ch->pcdata->quest_mana_gained, fread_number(fp));

            if (str_cmp(word, "Qtrouble") == 0)
            {
                int             vnum;
                int             count;
                vnum = fread_number(fp);
                count = fread_number(fp);
                qtrouble_set(ch, vnum, count);
                fMatch = TRUE;
            }
            break;


        case 'R':
            KEY("Relig", ch->religion, fread_number(fp));
            KEY("ReligionPnts", ch->pcdata->religionpoints, fread_number(fp));
            KEY("ReligionLvl",  ch->pcdata->religionlevel, fread_number(fp));
            KEY("RealLevel", ch->pcdata->real_level, fread_number(fp));
            KEY("RealSec", ch->pcdata->real_sec, fread_number(fp));
            if (!str_cmp(word, "Race"))
            {
                const char *race = fread_string(fp);
                ch->race = rn_lookup(race);
                ch->pcdata->race = ch->race;
                free_string(race);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Religion"))
            {
                const char *relig = fread_string(fp);
                ch->religion = rln_lookup(relig);
                free_string(relig);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Room"))
            {
                ch->in_room = get_room_index(fread_number(fp));
                if (ch->in_room == NULL)
                    ch->in_room = get_room_index(ROOM_VNUM_LIMBO);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "RusName"))
            {
                int num = fread_number(fp);
                const char * name = fread_string(fp);
                if (num > -1 && num < 6)
                    ch->pcdata->rusnames[num] = name;
                fMatch = TRUE;
                break;
            }
            break;

        case 'S':
            KEY("SavingThrow", ch->saving_throw, fread_number(fp));
            KEY("Save", ch->saving_throw, fread_number(fp));
            KEY("Scro", ch->lines, fread_number(fp));
            KEY("Sex", ch->sex, fread_fword(sex_table, fp));
            MLSKEY("ShortDescr", ch->short_descr);
            MLSKEY("ShD", ch->short_descr);
            KEY("Sec", ch->pcdata->security, fread_number(fp));
            KEY("Silv", ch->silver, fread_number(fp));
            if ( !str_cmp( word, "Specialization") )
            {
                ch->pcdata->specialization[0] = fread_number(fp);
                ch->pcdata->specialization[1] = fread_number(fp);
                ch->pcdata->specialization[2] = fread_number(fp);
                fMatch = TRUE;
                break;
            }

            if (!str_cmp(word, "Skill") || !str_cmp(word, "Sk"))
            {
                int             sn;
                int             value;
                char           *temp;
                value = fread_number(fp);
                temp = fread_word(fp);
                sn = sn_lookup(temp);
                if (sn < 0)
                {
                    fprintf(stderr, "%s", temp);
                    bug("Fread_char: unknown skill. ", 0);
                }
                else
                    set_skill(ch, sn, value);
                fMatch = TRUE;
            }
            KEY("SkillPercent", dummy, fread_number(fp));
            break;

        case 'T':
            KEY("TLPlayed", ch->pcdata->this_level_played, fread_number(fp));
            KEY("TrueSex", ch->pcdata->true_sex, fread_fword(sex_table, fp));
            KEY("TSex", ch->pcdata->true_sex, fread_fword(sex_table, fp));
            KEY("Trai", ch->train, fread_number(fp));
            if (!str_cmp(word, "Tree"))
            {
                if (curr_tree >= MAX_TREES)
                {
                    bug("Marked tree #%d exeeds MAX_TREES", curr_tree+1);
                    fread_number(fp);
                }
                else
                {
                    ch->marked_tree[curr_tree++] = fread_number(fp);
                }
                fMatch = TRUE;
                break;
            }
            KEY("Trust", ch->pcdata->trust, fread_flags(fp));
            SKEY("Twitlist", ch->pcdata->twitlist);
            if (!str_cmp(word, "Title") || !str_cmp(word, "Titl"))
            {
                const char *p = fread_string(fp);
                set_title(ch, p);
                free_string(p);
                fMatch = TRUE;
                break;
            }
            break;

        case 'V':
            KEY("Version", ch->version, fread_number(fp));
            KEY("Vers", ch->version, fread_number(fp));
            if (!str_cmp(word, "Vnum"))
            {
                ch->pIndexData = get_mob_index(fread_number(fp));
                fMatch = TRUE;
                break;
            }
            break;

        case 'W':
            KEY("WarJoinAll", ch->stat_wars_all, fread_number(fp));
            KEY("WarJoin0", ch->stat_type_wars_all[0], fread_number(fp));
            KEY("WarJoin1", ch->stat_type_wars_all[1], fread_number(fp));
            KEY("WarJoin2", ch->stat_type_wars_all[2], fread_number(fp));
            KEY("WarJoin3", ch->stat_type_wars_all[3], fread_number(fp));
            KEY("WarJoin4", ch->stat_type_wars_all[4], fread_number(fp));
            KEY("WarJoin5", ch->stat_type_wars_all[5], fread_number(fp));
            KEY("WarJoin6", ch->stat_type_wars_all[6], fread_number(fp));

            KEY("WarWinAll", ch->stat_wars_win, fread_number(fp));
            KEY("WarWin0", ch->stat_type_wars_win[0], fread_number(fp));
            KEY("WarWin1", ch->stat_type_wars_win[1], fread_number(fp));
            KEY("WarWin2", ch->stat_type_wars_win[2], fread_number(fp));
            KEY("WarWin3", ch->stat_type_wars_win[3], fread_number(fp));
            KEY("WarWin4", ch->stat_type_wars_win[4], fread_number(fp));
            KEY("WarWin5", ch->stat_type_wars_win[5], fread_number(fp));
            KEY("WarWin6", ch->stat_type_wars_win[6], fread_number(fp));

            KEY("WarDied", ch->total_war_deaths, fread_number(fp));
            KEY("WarKills", ch->total_war_kills, fread_number(fp));

            KEY("Wimpy", ch->wimpy, fread_number(fp));
            KEY("Wimp", ch->wimpy, fread_number(fp));
            KEY("Wishes", ch->pcdata->wishes, fread_flags(fp));
            KEY("Wizn", ch->pcdata->wiznet, fread_flags(fp));
            KEY("WQMultJoin", ch->pcdata->wq_mult_join, fread_number(fp));
            KEY("WQMultWin", ch->pcdata->wq_mult_win, fread_number(fp));
            KEY("WQPersJoin", ch->pcdata->wq_personal_join, fread_number(fp));
            KEY("WQPersWin", ch->pcdata->wq_personal_win, fread_number(fp));
            KEY("WQNext", ch->pcdata->wq_next_time, fread_number(fp));
            break;
        }

        if (!fMatch)
        {
            log_printf("fread_char: %s: no match", word);
            fread_to_eol(fp);
        }
    }

    if (!check && ch->level != MAX_LEVEL)
        log_printf("Loading %s.", ch->name);

}

/* load a pet from the forgotten reaches */
void
fread_pet(CHAR_DATA * ch, FILE * fp)
{
    char           *word;
    CHAR_DATA      *pet;
    bool            fMatch;
    int             lastlogoff = current_time;
    int             percent;
    /* first entry had BETTER be the vnum or we barf */
    word = feof(fp) ? "END" : fread_word(fp);
    if (!str_cmp(word, "Vnum"))
    {
        int             vnum;
        vnum = fread_number(fp);
        if (get_mob_index(vnum) == NULL)
        {
            bug("Fread_pet: bad vnum %d.", vnum);
            pet = create_mob(get_mob_index(MOB_VNUM_FIDO));
        }
        else
            pet = create_mob(get_mob_index(vnum));
    }
    else
    {
        bug("Fread_pet: no vnum in file.", 0);
        pet = create_mob(get_mob_index(MOB_VNUM_FIDO));
    }

    for (;;)
    {
        word = feof(fp) ? "END" : fread_word(fp);
        fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case '*':
            fMatch = TRUE;
            fread_to_eol(fp);
            break;

        case 'A':
            KEY("AfBy", pet->affected_by, fread_flags(fp));
            KEY("Alig", pet->alignment, fread_number(fp));

            if (!str_cmp(word, "ACs"))
            {
                int             i;
                for (i = 0; i < 4; i++)
                    pet->armor[i] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "AffD"))
            {
                AFFECT_DATA    *paf;
                int             sn;
                paf = aff_new();

                sn = sn_lookup(fread_word(fp));
                if (sn < 0)
                    bug("Fread_char: unknown skill.", 0);
                else
                    paf->type = sn;

                paf->level = fread_number(fp);
                paf->duration = fread_number(fp);
                paf->modifier = fread_number(fp);
                paf->location = fread_number(fp);
                paf->bitvector = fread_flags(fp);
                paf->next = pet->affected;
                pet->affected = paf;
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Affc"))
            {
                AFFECT_DATA    *paf;
                int             sn;
                paf = aff_new();

                sn = sn_lookup(fread_word(fp));
                if (sn < 0)
                    bug("Fread_char: unknown skill.", 0);
                else
                    paf->type = sn;

                paf->where = fread_number(fp);
                paf->level = fread_number(fp);
                paf->duration = fread_number(fp);
                paf->modifier = fread_number(fp);
                paf->location = fread_number(fp);
                paf->bitvector = fread_flags(fp);
                paf->next = pet->affected;
                pet->affected = paf;
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "AMod"))
            {
                int             stat;
                for (stat = 0; stat < MAX_STATS; stat++)
                    pet->mod_stat[stat] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Attr"))
            {
                int             stat;
                for (stat = 0; stat < MAX_STATS; stat++)
                    pet->perm_stat[stat] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            break;

        case 'C':
            KEY("Clan", pet->clan, fread_clan(fp));
            KEY("Comm", pet->comm, fread_flags(fp));
            KEY("Comm2", pet->comm2, fread_flags(fp));
            break;

        case 'D':
            KEY("Dam", pet->damroll, fread_number(fp));
            MLSKEY("Desc", pet->description);
            break;

        case 'E':
            if (!str_cmp(word, "End"))
            {
                pet->leader = ch;
                pet->master = ch;
                ch->pet = pet;
                /*
                 * adjust hp mana move up  -- here for speed's
                 * sake
                 */
                percent = (current_time - lastlogoff) * 25 / (2 * 60 * 60);

                if (percent > 0 && !IS_AFFECTED(pet, AFF_POISON)
                        && !IS_AFFECTED(pet, AFF_PLAGUE))
                {
                    percent = UMIN(percent, 100);
                    pet->hit += (pet->max_hit - pet->hit) * percent / 100;
                    pet->mana += (pet->max_mana - pet->mana) * percent / 100;
                    pet->move += (pet->max_move - pet->move) * percent / 100;
                }
                return;
            }
            KEY("Exp", pet->exp, fread_number(fp));
            break;

        case 'G':
            KEY("Gold", pet->gold, fread_number(fp));
            break;

        case 'H':
            KEY("Hit", pet->hitroll, fread_number(fp));

            if (!str_cmp(word, "HMV"))
            {
                pet->hit = fread_number(fp);
                pet->max_hit = fread_number(fp);
                pet->mana = fread_number(fp);
                pet->max_mana = fread_number(fp);
                pet->move = fread_number(fp);
                pet->max_move = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            break;

        case 'L':
            MLSKEY("LnD",  pet->long_descr);
            KEY("Levl", pet->level, fread_number(fp));
            KEY("LogO", lastlogoff, fread_number(fp));
            break;

        case 'N':
            SKEY("Name", pet->name);
            break;

        case 'P':
            KEY("Pos", pet->position, fread_number(fp));
            KEY("PSP", ch->psp, fread_number(fp));
            break;

        case 'R':
            if (!str_cmp(word, "Race"))
            {
                const char *race = fread_string(fp);
                pet->race = rn_lookup(race);
                free_string(race);
                fMatch = TRUE;
                break;
            }
            break;

        case 'S':
            KEY("Save", pet->saving_throw, fread_number(fp));
            KEY("Sex", pet->sex, fread_fword(sex_table, fp));
            MLSKEY("ShD", pet->short_descr);
            KEY("Silv", pet->silver, fread_number(fp));
            break;

            if (!fMatch)
            {
                bug("Fread_pet: no match.", 0);
                fread_to_eol(fp);
            }
        }
    }
}

extern  OBJ_DATA    *obj_free;

//void
OBJ_DATA *fread_obj(CHAR_DATA * ch, FILE * fp)
{
    OBJ_DATA       *obj;
    char           *word;
    int             iNest;
    bool            fMatch;
    bool            fNest;
    bool            fVnum;
    bool            first;
    bool        enchanted = FALSE;
    fVnum = FALSE;
    obj = NULL;
    first = TRUE;       /* used to counter fp offset */

    word = feof(fp) ? "End" : fread_word(fp);
    if (!str_cmp(word, "Vnum"))
    {
        int             vnum;
        first = FALSE;  /* fp will be in right place */

        vnum = fread_number(fp);
        if (get_obj_index(vnum) == NULL)
            bug("Fread_obj: bad vnum %d.", vnum);
        else
            obj = create_obj_nocount(get_obj_index(vnum), 0);
    }
    if (obj == NULL)
    {  /* either not found or old style */
        obj = new_obj();
        obj->name = str_dup(str_empty);
    }
    fNest = FALSE;
    fVnum = TRUE;
    iNest = 0;

    for (;;)
    {
        if (first)
            first = FALSE;
        else
            word = feof(fp) ? "End" : fread_word(fp);
        fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case '*':
            fMatch = TRUE;
            fread_to_eol(fp);
            break;

        case 'A':
            if (!str_cmp(word, "AffD"))
            {
                AFFECT_DATA    *paf;
                int             sn;
                paf = aff_new();

                sn = sn_lookup(fread_word(fp));
                if (sn < 0)
                    bug("Fread_obj: unknown skill.", 0);
                else
                    paf->type = sn;

                paf->level = fread_number(fp);
                paf->duration = fread_number(fp);
                paf->modifier = fread_number(fp);
                paf->location = fread_number(fp);
                paf->bitvector = fread_flags(fp);
                paf->next = obj->affected;
                obj->affected = paf;
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Affc"))
            {
                AFFECT_DATA    *paf;
                int             sn;
                paf = aff_new();

                sn = sn_lookup(fread_word(fp));
                if (sn < 0)
                    bug("Fread_obj: unknown skill.", 0);
                else
                    paf->type = sn;

                paf->where = fread_number(fp);
                paf->level = fread_number(fp);
                paf->duration = fread_number(fp);
                paf->modifier = fread_number(fp);
                paf->location = fread_number(fp);
                paf->bitvector = fread_flags(fp);
                paf->next = obj->affected;
                obj->affected = paf;
                fMatch = TRUE;
                break;
            }
            break;

        case 'C':
            KEY("Cond", obj->condition, fread_number(fp));
            KEY("Cost", obj->cost, fread_number(fp));
            break;

        case 'D':
            MLSKEY("Description", obj->description);
            MLSKEY("Desc", obj->description);
            break;


        case 'E':
            if (!str_cmp(word, "Enchanted"))
            {
                enchanted = TRUE;
                fMatch = TRUE;
                break;
            }

            KEY("ExtraFlags", obj->extra_flags, fread_flags(fp));
            KEY("ExtF", obj->extra_flags, fread_number(fp));

            if (!str_cmp(word, "ExtraDescr") || !str_cmp(word, "ExDe"))
            {
                ed_fread(fp, &obj->ed);
                fMatch = TRUE;
                break;
            }

            if (!str_cmp(word, "End"))
            {
                if (enchanted)
                    SET_BIT(obj->extra_flags,
                            ITEM_ENCHANTED);
                if (!fNest
                        ||  (fVnum && obj->pIndexData == NULL))
                {
                    bug("Fread_obj: incomplete object.", 0);
                    free_obj(obj);
                    return NULL;
                }

                if (!fVnum)
                {
                    free_obj(obj);
                    obj = create_obj(get_obj_index(OBJ_VNUM_DUMMY), 0);
                }

                if (IS_SET(obj->pIndexData->extra_flags,
                           ITEM_QUEST)
                        &&  IS_NULLSTR(obj->owner))
                {
                    free_string(obj->owner);
                    obj->owner = str_dup(ch->name);
                }

                // Welesh : castrate overpowered wands
                if (IS_SET (muddy_mode, MUDDY_SCRIBE_NEW))
                {
                    if (   obj->pIndexData->vnum == OBJ_VNUM_WAND_EMPOWERED
                        || obj->pIndexData->vnum == OBJ_VNUM_STAFF_EMPOWERED
                        || obj->pIndexData->vnum == OBJ_VNUM_SCROLL_SCRIBED)
                    {
                        obj->value[0] = UMIN (obj->value[0], obj->level + obj->level/10);
                        if (ch != NULL)
                            log_printf ("Scribed EQ castrated for %s.", ch->name);
                    }
                }

                if (iNest == 0 || rgObjNest[iNest - 1] == NULL)
                {
                    if (ch)
                        obj_to_char(obj, ch);
                    return obj;
                }
                else
                {
                    obj_to_obj(obj, rgObjNest[iNest - 1]);
                    return NULL;
                }

            }
            break;

        case 'K':
            if ( !str_cmp( word, "Keyring" ) )
            {
            // load list of key vnums from pfile
                  load_keyring(fp, obj);
                  fMatch = TRUE;
            }
            break;

        case 'L':
            KEY("Level", obj->level, fread_number(fp));
            KEY("Lev", obj->level, fread_number(fp));
            break;

        case 'N':
            SKEY("Name", obj->name);

            if (!str_cmp(word, "Nest"))
            {
                iNest = fread_number(fp);
                if (iNest < 0 || iNest >= MAX_NEST)
                {
                    bug("Fread_obj: bad nest %d.", iNest);
                }
                else
                {
                    rgObjNest[iNest] = obj;
                    fNest = TRUE;
                }
                fMatch = TRUE;
            }
            break;

        case 'O':
            SKEY("Owner", obj->owner);
            break;

        case 'Q':
            KEY("Quality", obj->condition, fread_number(fp));
            break;

        case 'S':
            KEY("Size", obj->size, fread_number(fp));
            MLSKEY("ShortDescr", obj->short_descr);
            MLSKEY("ShD", obj->short_descr);

            if (!str_cmp(word, "Spell"))
            {
                int             iValue;
                int             sn;
                iValue = fread_number(fp);
                sn = sn_lookup(fread_word(fp));
                if (iValue < 0 || iValue > 3)
                {
                    bug("Fread_obj: bad iValue %d.", iValue);
                }
                else if (sn < 0)
                {
                    bug("Fread_obj: unknown skill.", 0);
                }
                else
                {
                    obj->value[iValue] = sn;
                }
                fMatch = TRUE;
                break;
            }
            break;

        case 'T':
            KEY("Timer", obj->timer, fread_number(fp));
            KEY("Time", obj->timer, fread_number(fp));
            break;

        case 'V':
            if (!str_cmp(word, "Values") || !str_cmp(word, "Vals"))
            {
                obj->value[0] = fread_number(fp);
                obj->value[1] = fread_number(fp);
                obj->value[2] = fread_number(fp);
                obj->value[3] = fread_number(fp);
                if (obj->pIndexData->item_type == ITEM_WEAPON && obj->value[0] == 0)
                    obj->value[0] = obj->pIndexData->value[0];
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Val"))
            {
                obj->value[0] = fread_number(fp);
                obj->value[1] = fread_number(fp);
                obj->value[2] = fread_number(fp);
                obj->value[3] = fread_number(fp);
                obj->value[4] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Vnum"))
            {
                int             vnum;
                vnum = fread_number(fp);
                if ((obj->pIndexData = get_obj_index(vnum)) == NULL)
                    bug("Fread_obj: bad vnum %d.", vnum);
                else
                    fVnum = TRUE;
                fMatch = TRUE;
                break;
            }
            break;

        case 'W':
            KEY("WearLoc", obj->wear_loc, fread_number(fp));
            KEY("Wear", obj->wear_loc, fread_number(fp));
            break;

        }

        if (!fMatch)
        {
            bug("Fread_obj: no match.", 0);
            fread_to_eol(fp);
        }
    }

    return NULL;
}

void fwrite_affect(AFFECT_DATA *paf, FILE *fp)
{
    skill_t *sk;

    if (paf->type == gsn_doppelganger
            ||  (sk = skill_lookup(paf->type)) == NULL)
        return;

    fprintf(fp, "Affc '%s' %3d %3d %3d %3d %3d %s\n",
            sk->name,
            paf->where, paf->level, paf->duration, paf->modifier,
            paf->location, format_flags(paf->bitvector));
}


//**************************************************************************
// save and load golems and undeads
//**************************************************************************

// write a golem
void fwrite_golem(CHAR_DATA *golem, FILE *fp, bool is_quit)
{
    AFFECT_DATA * paf;

    fprintf(fp, "#GOLEM\n");

    fprintf(fp, "Vnum %d\n", golem->pIndexData->vnum);
    fwrite_string(fp, "Name", golem->name);

    fprintf(fp, "Levl %d\n", golem->level);

    mlstr_fwrite(fp, "ShD", golem->short_descr);
    mlstr_fwrite(fp, "LnD", golem->long_descr);
    mlstr_fwrite(fp, "Desc", golem->description);

    fprintf(fp, "Rank %d\n", golem->mob_rank);
    fprintf(fp, "Abilities %s\n", format_flags(golem->abilities));
    fprintf(fp, "Actions %s\n", format_flags(golem->actions));
    fprintf(fp, "KillsLeft %d\n", golem->mob_tnl);
    fprintf(fp, "ExtraAtt %d\n", golem->extra_attacks);

    if (golem->in_room)
        fprintf(fp, "Room %d\n", golem->in_room->vnum);

    fprintf(fp, "HMV  %d %d %d %d %d %d\n",
            golem->hit, golem->max_hit, golem->mana, golem->max_mana, golem->move, golem->max_move);
    if (golem->gold)
        fprintf(fp, "Gold %d\n", golem->gold);
    if (golem->silver)
        fprintf(fp, "Silv %d\n", golem->silver);

    if (golem->affected_by != golem->pIndexData->affected_by)
    {
        fprintf(fp, "AfBy %s\n", format_flags(golem->affected_by));
    }

    if (golem->form != golem->pIndexData->form)
        fprintf(fp, "Form %s~\n", flag_string (form_flags, golem->form));

    fprintf(fp, "Pos  %d\n", golem->position = POS_FIGHTING ? POS_STANDING : golem->position);
    if (golem->saving_throw != 0)
        fprintf(fp, "Save %d\n", golem->saving_throw);
    fprintf(fp, "Hit  %d\n", golem->hitroll);
    fprintf(fp, "Dam  %d\n", golem->damroll);

    fprintf(fp, "AllDam %d %d %d\n",
            golem->damage[DICE_NUMBER],
            golem->damage[DICE_TYPE],
            golem->damage[DICE_BONUS]);
    fprintf(fp, "Alig  %d\n", golem->alignment);

    fprintf(fp, "ACs  %d %d %d %d\n",
            golem->armor[0], golem->armor[1], golem->armor[2], golem->armor[3]);
    fprintf(fp, "Attr %d %d %d %d %d %d %d\n",
            golem->perm_stat[STAT_STR], golem->perm_stat[STAT_INT],
            golem->perm_stat[STAT_WIS], golem->perm_stat[STAT_DEX],
            golem->perm_stat[STAT_CON], golem->perm_stat[STAT_CHA],
            golem->perm_stat[STAT_LCK]);
    fprintf(fp, "AMod %d %d %d %d %d %d %d\n",
            golem->mod_stat[STAT_STR], golem->mod_stat[STAT_INT],
            golem->mod_stat[STAT_WIS], golem->mod_stat[STAT_DEX],
            golem->mod_stat[STAT_CON], golem->mod_stat[STAT_CHA],
            golem->perm_stat[STAT_LCK]);

    for (paf = golem->affected; paf != NULL; paf = paf->next)
        fwrite_affect(paf, fp);

    fprintf(fp, "End\n\n");

    // if carries something - save objects
    if (golem->carrying != NULL)
        fwrite_obj (golem, golem->carrying, fp, 0, is_quit, "#MOBOBJ") ;

}

// load a golem from pfile
void fread_golem(CHAR_DATA *ch, FILE *fp)
{
    char           *word;
    CHAR_DATA      *golem;
    bool            fMatch;
    int             lastlogoff = current_time;
    int             percent;
    AFFECT_DATA    *paf;
    AFFECT_DATA    *paf_next;
    int             room_vnum = 0;
    ROOM_INDEX_DATA * room;

    // first entry had BETTER be the vnum or we barf
    word = feof(fp) ? "END" : fread_word(fp);

    // in the case of any error create fido instead of golem
    if (!str_cmp(word, "Vnum"))
    {
        int             vnum;

        vnum = fread_number(fp);
        if (get_mob_index(vnum) == NULL)
        {
            bug("Fread_golem: bad vnum %d.", vnum);
            golem = create_mob(get_mob_index(MOB_VNUM_FIDO));
        }
        else // no errors - create golem
            golem = create_mob(get_mob_index(vnum));
    }
    else
    {
        bug("Fread_golem: no vnum in file.", 0);
        golem = create_mob(get_mob_index(MOB_VNUM_FIDO));
    }

    // remove all affects: this section is needed for removing "double" affects
    // those, which are created by function create_mob and those, which are stored
    // in the PFile. An example of double affects can be seen in fread_pet function
    for (paf = golem->affected; paf; paf = paf_next)
    {
        paf_next = paf->next;
        affect_remove(golem, paf);
    }


    // restoring golem's parameters
    for (;;)
    {
        word = feof(fp) ? "END" : fread_word(fp);
        fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case '*': // comment
            fMatch = TRUE;
            fread_to_eol(fp);
            break;

        case 'A':
            KEY("Abilities", golem->abilities, fread_flags(fp));
            KEY("Actions", golem->actions, fread_flags(fp));
            KEY("AfBy", golem->affected_by, fread_flags(fp));

            if (!str_cmp(word, "ACs"))
            {
                int             i;
                for (i = 0; i < 4; i++)
                    golem->armor[i] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            KEY("Alig", golem->alignment, fread_number(fp));
            if (!str_cmp(word, "AllDam"))
            {
                golem->damage[DICE_NUMBER] = fread_number(fp);
                golem->damage[DICE_TYPE] = fread_number(fp);
                golem->damage[DICE_BONUS] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "AffD"))
            {
                AFFECT_DATA    *paf;
                int             sn;
                paf = aff_new();

                sn = sn_lookup(fread_word(fp));
                if (sn < 0)
                    bug("Fread_golem: unknown skill.", 0);
                else
                    paf->type = sn;

                paf->level = fread_number(fp);
                paf->duration = fread_number(fp);
                paf->modifier = fread_number(fp);
                paf->location = fread_number(fp);
                paf->bitvector = fread_flags(fp);
                paf->next = golem->affected;
                golem->affected = paf;
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Affc"))
            {
                AFFECT_DATA    *paf;
                int             sn;
                paf = aff_new();

                sn = sn_lookup(fread_word(fp));
                if (sn < 0)
                    bug("Fread_golem: unknown skill.", 0);
                else
                    paf->type = sn;

                paf->where = fread_number(fp);
                paf->level = fread_number(fp);
                paf->duration = fread_number(fp);
                paf->modifier = fread_number(fp);
                paf->location = fread_number(fp);
                paf->bitvector = fread_flags(fp);
                paf->next = golem->affected;
                golem->affected = paf;
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "AMod"))
            {
                int             stat;
                for (stat = 0; stat < MAX_STATS; stat++)
                    golem->mod_stat[stat] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            if (!str_cmp(word, "Attr"))
            {
                int             stat;
                for (stat = 0; stat < MAX_STATS; stat++)
                    golem->perm_stat[stat] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            break;

        case 'D':
            KEY("Dam", golem->damroll, fread_number(fp));
            MLSKEY("Desc", golem->description);
            break;

        case 'E':
            if (!str_cmp(word, "End"))
            {
                golem->leader = golem->master = ch;
                SET_BIT(golem->affected_by, AFF_CHARM);
                room = get_room_index (room_vnum);
                if (room != NULL)
                    char_to_room (golem,room);
                else
                    char_to_room (golem,ch->in_room);
                // adjust hp mana move up  -- here for speed's sake
                percent = (current_time - lastlogoff) * 25 / (2 * 60 * 60);

                if (percent > 0 && !IS_AFFECTED(golem, AFF_POISON)
                        && !IS_AFFECTED(golem, AFF_PLAGUE))
                {
                    percent = UMIN(percent, 100);
                    golem->hit += (golem->max_hit - golem->hit) * percent / 100;
                    golem->mana += (golem->max_mana - golem->mana) * percent / 100;
                    golem->move += (golem->max_move - golem->move) * percent / 100;
                }
                loaded_golem = golem;
                return;
            }
            KEY("ExtraAtt", golem->extra_attacks, fread_number(fp));
            break;

        case 'F':
            KEY("Form", golem->form, fread_fstring(form_flags, fp));
            break;

        case 'G':
            KEY("Gold", golem->gold, fread_number(fp));
            break;

        case 'H':
            KEY("Hit", golem->hitroll, fread_number(fp));

            if (!str_cmp(word, "HMV"))
            {
                golem->hit = fread_number(fp);
                golem->max_hit = fread_number(fp);
                golem->mana = fread_number(fp);
                golem->max_mana = fread_number(fp);
                golem->move = fread_number(fp);
                golem->max_move = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            break;

        case 'K':
            KEY("KillsLeft", golem->mob_tnl, fread_number(fp));
            break;

        case 'L':
            KEY("Levl", golem->level, fread_number(fp));
            MLSKEY("LnD",  golem->long_descr);
            break;

        case 'N':
            SKEY("Name", golem->name);
            break;

        case 'P':
            KEY("Pos", golem->position, fread_number(fp));
            break;

        case 'R':
            KEY("Rank", golem->mob_rank, fread_number(fp));
            KEY("Room", room_vnum, fread_number(fp));
            break;

        case 'S':
            KEY("Save", golem->saving_throw, fread_number(fp));
            KEY("Silv", golem->silver, fread_number(fp));
            MLSKEY("ShD", golem->short_descr);
            break;

            if (!fMatch)
            {
                bug("Fread_golem: no match.", 0);
                fread_to_eol(fp);
            }
        }
    }
}
/*************************************************************************/
/* write an undead */
void fwrite_undead(CHAR_DATA *undead, FILE *fp)
{
    fprintf(fp, "#UNDEAD\n");

    fprintf(fp, "Vnum %d\n", undead->pIndexData->vnum);
    fwrite_string(fp, "Name", undead->name);

    fprintf(fp, "Levl %d\n", undead->level);

    if (undead->gold)
        fprintf(fp, "Gold %d\n", undead->gold);
    if (undead->silver)
        fprintf(fp, "Silv %d\n", undead->silver);

    mlstr_fwrite(fp, "ShD", undead->short_descr);
    mlstr_fwrite(fp, "LnD", undead->long_descr);
    mlstr_fwrite(fp, "Desc", undead->description);

    fprintf(fp, "Pos  %d\n", undead->position = POS_FIGHTING ? POS_STANDING : undead->position);
    fprintf(fp, "Attr %d %d %d %d %d %d %d\n",
            undead->perm_stat[STAT_STR], undead->perm_stat[STAT_INT],
            undead->perm_stat[STAT_WIS], undead->perm_stat[STAT_DEX],
            undead->perm_stat[STAT_CON], undead->perm_stat[STAT_CHA],
            undead->perm_stat[STAT_LCK]);

    fprintf(fp, "End\n\n");
}

// load an undead from pfile 
void fread_undead(CHAR_DATA *ch, FILE *fp)
{
    char           *word;
    CHAR_DATA      *undead;
    bool            fMatch;
    int             u_level;
    int             i;

    /* first entry had BETTER be the vnum or we barf */
    word = feof(fp) ? "END" : fread_word(fp);

    /* in the case of any error create fido instead of undead */
    if (!str_cmp(word, "Vnum"))
    {
        int             vnum;
        vnum = fread_number(fp);
        if (get_mob_index(vnum) == NULL)
        {
            bug("Fread_undead: bad vnum %d.", vnum);
            undead = create_mob(get_mob_index(MOB_VNUM_FIDO));
        }
        else /* no errors - create undead */

            undead = create_mob(get_mob_index(MOB_VNUM_UNDEAD));
    }
    else
    {
        bug("Fread_undead: no vnum in file.", 0);
        undead = create_mob(get_mob_index(MOB_VNUM_FIDO));
    }

    /* restoring undead parameters */
    for (;;)
    {
        word = feof(fp) ? "END" : fread_word(fp);
        fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case '*':
            fMatch = TRUE;
            fread_to_eol(fp);
            break;

        case 'A':
            if (!str_cmp(word, "Attr"))
            {
                int             stat;
                for (stat = 0; stat < MAX_STATS; stat++)
                    undead->perm_stat[stat] = fread_number(fp);
                fMatch = TRUE;
                break;
            }
            break;

        case 'D':
            MLSKEY("Desc", undead->description);
            break;

        case 'E':
            if (!str_cmp(word, "End"))
            {
                u_level = undead->level;
                undead->max_hit = dice(20,u_level*2)+u_level*20;
                undead->hit = undead->max_hit;
                undead->max_mana = dice(u_level,10)+100;
                undead->mana = undead->max_mana;
                undead->alignment = -1000;

                for (i = 0; i < 3; i++)
                    undead->armor[i] = interpolate(undead->level,100,-100);
                undead->armor[3] = interpolate(undead->level, 50, -200);
                undead->sex = ch->sex;
                undead->gold = 0;
                undead->damage[DICE_NUMBER] = 11;
                undead->damage[DICE_TYPE]   = 5;
                undead->damage[DICE_BONUS]  = u_level/2 +10;

                undead->leader = undead->master = ch;
                SET_BIT(undead->affected_by, AFF_CHARM);
                char_to_room(undead,ch->in_room);
                return;
            }
            break;

        case 'G':
            KEY("Gold", undead->gold, fread_number(fp));
            break;

        case 'L':
            MLSKEY("LnD",  undead->long_descr);
            KEY("Levl", undead->level, fread_number(fp));
            break;

        case 'N':
            SKEY("Name", undead->name);
            break;

        case 'P':
            KEY("Pos", undead->position, fread_number(fp));
            break;

        case 'S':
            MLSKEY("ShD", undead->short_descr);
            KEY("Silv", undead->silver, fread_number(fp));
            break;

            if (!fMatch)
            {
                bug("Fread_undead: no match.", 0);
                fread_to_eol(fp);
            }
        }
    }
}

void nuke_slaves (CHAR_DATA *ch)
{
    CHAR_DATA *gch, *victim;
    // nuke golems, undeads etc
    for (gch = char_list; gch != NULL; )
    {
        victim = gch;
        gch = gch->next;
        if (IS_NPC(victim) && IS_AFFECTED(victim,AFF_CHARM)
                && victim->master == ch
                && ((victim->pIndexData->vnum == MOB_VNUM_LESSER_GOLEM)     ||
                    (victim->pIndexData->vnum == MOB_VNUM_IRON_GOLEM)       ||
                    (victim->pIndexData->vnum == MOB_VNUM_STONE_GOLEM)      ||
                    (victim->pIndexData->vnum == MOB_VNUM_ADAMANTITE_GOLEM) ||
                    (victim->pIndexData->vnum == MOB_VNUM_DIAMOND_GOLEM)    ||
                    (victim->pIndexData->vnum == MOB_VNUM_UNDEAD)           ||
                    (victim->pIndexData->vnum == MOB_VNUM_ARCHON)           ||
                    (victim->pIndexData->vnum == MOB_VNUM_FOREST_GIANT)     ||
                    (victim->pIndexData->vnum == MOB_VNUM_DRAGON)           ||
                    (victim->pIndexData->vnum == MOB_VNUM_SUM_SHADOW)       ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_MIN)     ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_NECK)    ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_SHIELD)  ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_FLOAT)   ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_HANDS)   ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_ARMS)    ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_LEGS)    ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_FEET)    ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_PLUG_IN) ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_BODY)    ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_WEAPON)  ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_OTHER)   ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_HELM)    ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANIMATED_MAX)     ||
                    (victim->pIndexData->vnum == MOB_VNUM_VAMPIRE_BAT)      ||
                    (victim->pIndexData->vnum == MOB_VNUM_CREATED_GOLEM)    ||
                    (victim->pIndexData->vnum == MOB_VNUM_LION)             ||
                    (victim->pIndexData->vnum == MOB_VNUM_ANGEL)            ||
                    (victim->pIndexData->vnum == MOB_VNUM_DEVIL)            ||
                    (victim->pIndexData->vnum == MOB_VNUM_SQUIRE)           ||
                    (victim->pIndexData->vnum == MOB_VNUM_TREANT)           ||
                    (victim->pIndexData->vnum == MOB_VNUM_BEAR)             ||
                    (IS_SET(victim->abilities, EA_SAVE))
                    ))
        {
            //stop_follower(victim);
            //                if (victim->in_room != NULL)
            //                    act("$N   .",ch,NULL,victim,TO_NOTVICT);
            if (IS_AFFECTED(victim, AFF_CHARM))
            {
                REMOVE_BIT(victim->affected_by, AFF_CHARM);
                affect_bit_strip(victim, TO_AFFECTS, AFF_CHARM);
            }

            victim->master = NULL;
            victim->leader = NULL;
            if (IS_NPC(victim) && victim->fighting != NULL)
                stop_fighting(victim, FALSE);

            extract_char_nocount(victim,TRUE);
        }
    }
    return;
}

void fread_explored (CHAR_DATA * ch, FILE * fp)
{
    char           *word;
    bool            fMatch;
    int             i;
    CHAR_EXPLORED_DATA *curr_area;
    int             count   = 0;
    int            *exvnums = 0;
    const char     *name    = 0;
    int            att_good = 0, att_evil = 0, att_neutral = 0;
    int bribes = 0, bribe_gold = 0, bribe_gems = 0, donations = 0, donate_gold = 0, donate_gems = 0;

    /* restoring explored */
    for (;;)
    {
        word = feof(fp) ? "END" : fread_word(fp);
        fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case '*':
            fMatch = TRUE;
            fread_to_eol(fp);
            break;

        case 'A':
            KEY("AttitudeGood", att_good, fread_number(fp));
            KEY("AttitudeEvil", att_evil, fread_number(fp));
            KEY("AttitudeNeutral", att_neutral, fread_number(fp));
            break;

        case 'B':
            KEY("Bribes", bribes, fread_number(fp));
            KEY("BribeGold", bribe_gold, fread_number(fp));
            KEY("BribeGems", bribe_gems, fread_number(fp));
            break;

        case 'C':
            if (!str_cmp(word, "Count"))
            {
                count = fread_number(fp);
                exvnums = (int *) calloc (count, sizeof(int));
                for (i = 0; i < count; ++i)
                    exvnums[i] = fread_number(fp);
                fMatch = 1 ;
            }
            break;

        case 'D':
            KEY("Donations", donations, fread_number(fp));
            KEY("DonateGold", donate_gold, fread_number(fp));
            KEY("DonateGems", donate_gems, fread_number(fp));
            break;

        case 'E':
            if (!str_cmp(word, "End"))
            {
                CHAR_EXPLORED_DATA * ptr ;
                int i, j, area_found, vnum_found ;
                AREA_DATA * area;
                ROOM_INDEX_DATA * room;
                bool empty;

                area_found = 0 ;

                for (ptr = ch->pcdata->explored_areas ; ptr ; ptr = ptr->next)
                {
                    if (str_cmp (ptr->name, name))
                        continue ;

                    area_found = 1 ;

                    for (i = 0 ; i < count ; ++i)
                    {
                        vnum_found = 0 ;

                        for (j = 0 ; j < ptr->explored_room_count ; ++j)
                        {
                            if (exvnums [i] == ptr->explored_room_vnums [j])
                            {
                                vnum_found = 1 ;
                                break ;
                            }
                        }

                        if (vnum_found)
                            continue ;

                        // fixme: can overflow array here :((
                        if (ptr->explored_room_count > MAX_AREA_ROOMS)
                        {
                            bug ("fread_explored: overflow in explored array.", 0) ;
                            continue ;
                        }

                        ptr->explored_room_vnums [++ptr->explored_room_count] = exvnums [i] ;
                    }

                    break ;
                }

                // here we try to find appropriate AREA_DATA
                // to skip deleted areas
                for (area = area_first; area; area = area->next)
                    if (!strcmp (area->name, name))
                        break;

                // skip empty areas
                empty = (count == 0) && (att_good == 0)
                        && (att_evil == 0) && (att_neutral == 0);

                // todo:  AREA_NOATTITUDE
                if (!area_found && area && !empty)
                {
                    curr_area = new_char_explored_data () ;
                    curr_area->next = ch->pcdata->explored_areas ;
                    ch->pcdata->explored_areas = curr_area ;

                    curr_area->name = name ;
                    // curr_area->explored_room_count = count ;

                    curr_area->attitude_good = att_good;
                    curr_area->attitude_evil = att_evil;
                    curr_area->attitude_neutral = att_neutral;
                    curr_area->bribes = bribes;
                    curr_area->bribe_gold = bribe_gold;
                    curr_area->bribe_gems = bribe_gems;
                    curr_area->donations = donations;
                    curr_area->donate_gold = donate_gold;
                    curr_area->donate_gems = donate_gems;


                    // fixme: can overflow array here :((
                    if (count >= MAX_AREA_ROOMS)
                    {
                        bug ("fread_explored: overflow in explored array.", 0) ;
                        free (exvnums) ;
                        return ;
                    }

                    //for (i = 0 ; i < count ; ++i)
                    //    curr_area->explored_room_vnums [i] = exvnums [i] ;
                    curr_area->explored_room_count = 0;
                    if (!IS_SET (area->flags, AREA_UNDER_CONSTRUCTION))
                    {
                        for (i = 0 ; i < count ; ++i)
                        {
                            room = get_room_index (exvnums [i]);
                            if (room && !IS_SET (room->room_flags, ROOM_NOEXPLORE))
                                curr_area->explored_room_vnums [curr_area->explored_room_count++] = exvnums [i] ;
                        }
                    }
                }
                else
                {
                    ; // if (name) free (name) ;
                }

                free (exvnums) ;
                return ;
            }

            break;

        case 'N':
            SKEY("Name", name);
            break;
        }

        if (!fMatch)
        {
            bug("Fread_explored: no match.", 0);
            fread_to_eol(fp);
        }
    }

    free (exvnums) ;
    // if (name) free (name) ;
}

void fwrite_explored (CHAR_DATA * ch, FILE * fp)
{
    CHAR_EXPLORED_DATA *curr_area;
    int i;

    if (!ch->pcdata || !ch->pcdata->explored_areas)
        return;

    for (curr_area = ch->pcdata->explored_areas; curr_area; curr_area=curr_area->next)
    {
        fprintf(fp, "#EXPLORED\n");
        fwrite_string(fp, "Name", curr_area->name);
        fprintf(fp, "Count %d\n", curr_area->explored_room_count);
        for (i = 0; i < curr_area->explored_room_count; i++)
            fprintf(fp, "%d ", curr_area->explored_room_vnums[i]);
        fprintf(fp, "\n");

        if (curr_area->attitude_good)
            fprintf(fp, "AttitudeGood %d\n", curr_area->attitude_good);
        if (curr_area->attitude_evil)
            fprintf(fp, "AttitudeEvil %d\n", curr_area->attitude_evil);
        if (curr_area->attitude_neutral)
            fprintf(fp, "AttitudeNeutral %d\n", curr_area->attitude_neutral);

        if (curr_area->bribes)
            fprintf(fp, "Bribes %d\n", curr_area->bribes);
        if (curr_area->bribe_gold)
            fprintf(fp, "BribeGold %d\n", curr_area->bribe_gold);
        if (curr_area->bribe_gems)
            fprintf(fp, "BribeGems %d\n", curr_area->bribe_gems);
        if (curr_area->donations)
            fprintf(fp, "Donations %d\n", curr_area->donations);
        if (curr_area->donate_gold)
            fprintf(fp, "DonateGold %d\n", curr_area->donate_gold);
        if (curr_area->donate_gems)
            fprintf(fp, "DonateGems %d\n", curr_area->donate_gems);

        fprintf(fp, "\nEnd\n\n");
    }
}

void ValidateExplored(CHAR_DATA * ch)
{
    CHAR_EXPLORED_DATA *curr_area;
    int Count;

    if (!ch->pcdata)
        return;

    Count = 0;
    for (curr_area = ch->pcdata->explored_areas; curr_area; curr_area=curr_area->next)
        Count += curr_area->explored_room_count;

    if(Count != ch->pcdata->TotalExploredRooms)
    {
        log_printf("BUG! For char %s TotalExploredRooms = %d, real count = %d",
                   ch->name, ch->pcdata->TotalExploredRooms, Count);
        ch->pcdata->TotalExploredRooms = Count;
    }
}
