/* $Id: security.c,v 1.666 2004/09/20 10:49:53 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "merc.h"
#include "security.h"


varr securitys = { sizeof(security_t), 4 };

security_t *security_new()
{
      security_t *security;
      security = varr_enew(&securitys);
      return security;
}

void security_free(security_t *security)
{
      free_string(security->name);
    security->level = 0;
}

security_t *security_lookup(const char *name,
                  int (*cmpfun)(const char *s1, const char *s2))
{
      int i;

    for (i = 0; i < securitys.nused; i++)
    {
            security_t *security = VARR_GET(&securitys, i);
        if (!cmpfun(name, security->name))
                  return security;
      }

      return NULL;
}

/*
 * Check char for security
 */

bool char_security(CHAR_DATA *ch, const char *name)
{
  security_t *security;

  security = security_lookup(name, str_cmp);

  if (security == NULL)
  {
      log_printf("ERROR: In security table not record for security name: %s", name);
      return FALSE;
  }

  if (ch->pcdata->security < security->level)
      return FALSE;

  return TRUE;
}

