/*  $Id: security.h,v 1.666 2004/09/20 10:49:53 shrike Exp $ */
 
/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#ifndef _SECURITY_H_
#define _SECURITY_H_

#define        PRICE_GOLD   0
#define        PRICE_QP     1
#define        PRICE_BP     2
#define        PRICE_RP     3

typedef struct security_t security_t;

/*
 * Structure for security
 */

struct security_t
{
    const char 	*name;
    int         level;
};


#define SECURITY(i)	((security_t *) VARR_GET(&securitys, i))

extern varr securitys;

security_t *    security_new();
void	        security_free(security_t *security);
security_t *    security_lookup(const char *name,
			      int (*cmpfun)(const char *s1, const char *s2));

bool            char_security(CHAR_DATA *ch, const char *name);
#endif

