/* $Id: set.c,v 1.666 2004/09/20 10:49:53 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
                                                                            
/************************************************************************************
 *   This transfered and paritaly modifed code from act_wiz.c file                  *
 *                    -= Incomplete now =-                                          *
 ************************************************************************************/

#include <sys/types.h>
#if !defined (WIN32)
#include <sys/time.h>
#endif

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#if !defined (WIN32)
#include <unistd.h>
#endif

#include "limited.h"
#include "merc.h"
#include "update.h"
#include "quest.h"
#include "obj_prog.h"
#include "fight.h"
#include "quest.h"
#include "db/cmd.h"
#include "db/db.h"
#include "db/dofun.h"
#include "skills.h"
#include "olc/olc.h"
#include "auction.h"
#include "conquer.h"
#include "set.h"

#define SET_MODE_MOB      1
#define SET_MODE_OBJ      2
#define SET_MODE_ROOM     3
#define SET_MODE_WEATHER  4
#define SET_MODE_TIME     5
#define SET_MODE_SKILL    6
#define SET_MODE_METEOR   7

#define SET_SECURITY      93

#define MSG_OK            "Ok"

flag_t  setmode_flags[]=
{
     { str_empty,        TABLE_INTVAL,                  },
     { "mobile",         SET_MODE_MOB,         TRUE,    },
     { "character",      SET_MODE_MOB,         TRUE,    },
     { "obj",            SET_MODE_OBJ,         TRUE,    },
     { "room",           SET_MODE_ROOM,        TRUE,    },
     { "weather",        SET_MODE_WEATHER,     TRUE,    },
     { "time",           SET_MODE_TIME,        TRUE,    },
     { "skill",          SET_MODE_SKILL,       TRUE,    },
     { "spell",          SET_MODE_SKILL,       TRUE,    },
     { "meteor",         SET_MODE_METEOR,      TRUE,    },

     { NULL }
};

static CMD_DATA set_mob_cmd_table[] =
{
    { "help",        set_mob_help,        POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "str",         set_mob_param,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              CONQCMD_REUSE_ARG},
    { "int",         set_mob_param,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              CONQCMD_REUSE_ARG},
    { "wis",         set_mob_param,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              CONQCMD_REUSE_ARG},
    { "dex",         set_mob_param,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              CONQCMD_REUSE_ARG},
    { "con",         set_mob_param,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              CONQCMD_REUSE_ARG},
    { "cha",         set_mob_param,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              CONQCMD_REUSE_ARG},
    { "lck",         set_mob_param,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              CONQCMD_REUSE_ARG},
    { "sex",         set_mob_sex,         POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "class",       set_mob_class,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "level",       set_mob_level,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "race",        set_mob_race,        POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "gold",        set_mob_gold,        POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "hp",          set_mob_hp,          POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "mana",        set_mob_mana,        POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "move",        set_mob_move,        POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "practice",    set_mob_practice,    POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "align",       set_mob_align,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "train",       set_mob_train,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "thirst",      set_mob_thirst,      POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "drunk",       set_mob_drunk,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "full",        set_mob_full,        POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "hometown",    set_mob_hometown,    POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "ethos",       set_mob_ethos,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "noghost",     set_mob_noghost,     POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "clan",        set_mob_clan,        POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "trouble",     set_mob_trouble,     POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "security",    set_mob_security,    POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "size",        set_mob_size,        POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "questpoints", set_mob_qeustpoint,  POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "questtime",   set_mob_questtime,   POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "religion",    set_mob_religion,    POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "bloodlust",   set_mob_bloodlust,   POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "desire",      set_mob_desire,      POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "title",       set_mob_title,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "pretitle",    set_mob_pretitle,    POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "tester",      set_mob_tester,      POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},

    { NULL }
} ;

static CMD_DATA set_obj_cmd_table[] =
{
    { "help",       set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "value0",     set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "value1",     set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "value2",     set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "value3",     set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "value4",     set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "owner",      set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "level",      set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "cost",       set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "timer",      set_obj_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},

    { NULL }
} ;

static CMD_DATA set_room_cmd_table[] =
{
    { "help",       set_room_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "flags",      set_room_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},
    { "sector",     set_room_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},

    { NULL }
} ;

static CMD_DATA set_weather_cmd_table[] =
{
    { "help",       set_weather_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},

    { NULL }
} ;

static CMD_DATA set_time_cmd_table[] =
{
    { "help",       set_time_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},

    { NULL }
} ;

static CMD_DATA set_skill_cmd_table[] =
{
    { "help",       set_skill_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},

    { NULL }
} ;


static CMD_DATA set_meteor_cmd_table[] =
{
    { "help",       set_meteor_help,       POS_DEAD,      SET_SECURITY,              0,  0,     0,              0},

    { NULL }
} ;


DO_FUN (do_set)
{
    char          arg1[MAX_INPUT_LENGTH];
    CMD_DATA      *set_cmd_table;

    set_cmd_table = NULL;

    argument = one_argument(argument, arg1, sizeof(arg1));

    if (flag_lookup(setmode_flags, arg1) == NULL)
    {
          char_act("Set: invalid argument. Valid syntax: set <command>, where command:", ch);
          show_flags(ch, setmode_flags);
          return;
    }

    switch(flag_value(setmode_flags, arg1))
    {
        case SET_MODE_MOB:       set_cmd_table = set_mob_cmd_table;         break;
        case SET_MODE_OBJ:       set_cmd_table = set_obj_cmd_table;         break;
        case SET_MODE_ROOM:      set_cmd_table = set_room_cmd_table;        break;
        case SET_MODE_WEATHER:   set_cmd_table = set_weather_cmd_table;     break;
        case SET_MODE_TIME:      set_cmd_table = set_time_cmd_table;        break;
        case SET_MODE_SKILL:     set_cmd_table = set_skill_cmd_table;       break;
        case SET_MODE_METEOR:    set_cmd_table = set_meteor_cmd_table;      break;
        default:                                                            break;
    }

    if (!parse_command(ch, argument, set_cmd_table))
    {
        show_command_list (ch, set_cmd_table);
        char_puts (".\nUse {CHELP{x for more information.\n", ch);
    }
}


// set mobile section
void set_mob_help(CHAR_DATA *ch, const char * argument )
{
}

void set_mob_param(CHAR_DATA *ch, const char * argument )
{
      char        arg1[MAX_INPUT_LENGTH];
      char        arg2[MAX_INPUT_LENGTH];
      int         value;
      CHAR_DATA  *victim;
      int         STAT_PARAM;
      int         max_value;

      argument = one_argument(argument, arg1, sizeof(arg1));

      char_act(arg1, ch);
      if (flag_lookup(stat_names, arg1) == NULL)
      {
            char_act("Invalid value.", ch);
            show_flags(ch, stat_names);
            return;
      }

      STAT_PARAM = flag_value(stat_names, arg1);

      argument = one_argument(argument, arg1, sizeof(arg1));
      one_argument(argument, arg2, sizeof(arg2));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      value     = atoi(arg2);
      max_value = get_max_train(victim, STAT_PARAM);

      if (value < 3 || value > max_value)
      {
            char_printf(ch,  "Value range is 3 to %d\n.",  max_value);
            return;
      }

      victim->perm_stat[STAT_PARAM] = value;
      char_act(MSG_OK, ch);
      return;
}

void set_mob_sex(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      one_argument(argument, arg1, sizeof(arg1));

      if (flag_lookup(sex_table, arg1) == NULL)
      {
            char_act("Only the following sex allowed:", ch);
            show_flags(ch, sex_table);
            return;
      }

       victim->sex = flag_value(sex_table, arg1);

       if (!IS_NPC(victim))
            victim->pcdata->true_sex = flag_value(sex_table, arg1);

       char_act(MSG_OK, ch);
}

void set_mob_class(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cl;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Mobiles have no class.", ch);
          return;
      }

      one_argument(argument, arg1, sizeof(arg1));
      cl = cn_lookup(arg1);

      if (cl < 0)
      {
            BUFFER *output;

            output = buf_new(ch->lang);

            buf_add(output, "Possible classes are: ");
            for (cl = 0; cl < classes.nused; cl++)
            {
                if (cl > 0)
                    buf_add(output, " ");
                buf_add(output, CLASS(cl)->name);
            }
            buf_add(output, ".\n");

            send_to_char(buf_string(output), ch);
            buf_free(output);
            return;
     }

     victim->class = cl;
     victim->exp = exp_for_level(victim, victim->level);
     victim->exp_tl = 0;

     update_skills(victim);
     char_act(MSG_OK, ch);
     return;

}

void set_mob_level(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          value;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (!IS_NPC(victim))
      {
          char_act("Not on PC's.", ch);
          return;
      }

      one_argument(argument, arg1, sizeof(arg1));

      value = atoi(arg1);

      if (value < 0 || value > 200)
      {
          char_act("Level range is 0 to 200.", ch);
          return;
      }

      victim->level = value;
      char_act(MSG_OK, ch);
      return;
}

void set_mob_race(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_gold(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_hp(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_mana(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_move(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_practice(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_align(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_train(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_thirst(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_drunk(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_full(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_hometown(CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_ethos (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_noghost (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      REMOVE_BIT(victim->plr_flags, PLR_GHOST);
      char_act(MSG_OK, ch);
      return;
}

void set_mob_clan (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));

      if ((cn = cln_lookup(arg1)) < 0)
      {
          char_act("Incorrect clan name.", ch);
          return;
      }

      victim->clan                = cn;
      victim->pcdata->petition    = cn;
      victim->pcdata->clan_status = CLAN_NEWBIE;

      update_skills(victim);
      char_act(MSG_OK, ch);
      return;
}

void set_mob_trouble (CHAR_DATA *ch, const char * argument )
{
char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_security (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_size (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          value;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument(argument, arg1, sizeof(arg1));
      value =  atoi(arg1);

      if (value < 0 || value > SIZE_GARGANTUAN_MAX)
      {
          char_printf(ch, "Size range is 0 to %d.\n", SIZE_GARGANTUAN_MAX);
          return;
      }

      victim->size = value;
      char_act(MSG_OK, ch);
      return;
}

void set_mob_qeustpoint (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_questtime (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_religion (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_bloodlust (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_desire (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_title (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_pretitle (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_mob_tester (CHAR_DATA *ch, const char * argument )
{
      char         arg1[MAX_INPUT_LENGTH];
      CHAR_DATA   *victim;
      int          cn;

      argument = one_argument(argument, arg1, sizeof(arg1));

      if ((victim = get_char_world(ch, arg1)) == NULL)
      {
            char_act("They aren't here.", ch);
            return;
      }

      if (IS_NPC(victim))
      {
          char_act("Not on NPC.", ch);
          return;
      }

      one_argument (argument, arg1, sizeof(arg1));
}

void set_obj_help (CHAR_DATA *ch, const char * argument )
{
}

void set_room_help (CHAR_DATA *ch, const char * argument )
{
}

void set_weather_help (CHAR_DATA *ch, const char * argument )
{
}

void set_time_help (CHAR_DATA *ch, const char * argument )
{
}

void set_skill_help (CHAR_DATA *ch, const char * argument )
{
}

void set_meteor_help (CHAR_DATA *ch, const char * argument )
{
}

