/* $Id: shamans.h,v 1.666 2004/09/20 10:49:53 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#ifndef __SHAMANS_H
#define __SHAMANS_H

bool check_tattoo (CHAR_DATA * ch, int sn);
bool check_violet_stars (CHAR_DATA * ch);
bool check_tigers_snout (CHAR_DATA * ch, CHAR_DATA * victim);

// --------------------------------------------------------------------------
// TATTOES
// --------------------------------------------------------------------------

// colors for tattooes
// to add a color XXX:
// 1. add F_TATTOO_COLOR_XXX flag
// 2. add TATTOO_COLOR_XXX constant
// 3. add line into paint_color_flags and paint_color_int_flags in tables.c
// 4. add line into tattoo_colors in shamans.c
#define F_TATTOO_COLOR_RED        (A)
#define F_TATTOO_COLOR_BLUE       (B)
#define F_TATTOO_COLOR_GREEN      (C)
#define F_TATTOO_COLOR_MAGENTA    (D)
#define F_TATTOO_COLOR_WHITE      (E)
#define F_TATTOO_COLOR_BLACK      (F)
#define F_TATTOO_COLOR_GOLD       (G)
#define F_TATTOO_COLOR_SILVER     (H)
#define F_TATTOO_COLOR_BROWN      (I)

#define TATTOO_COLOR_RED          0
#define TATTOO_COLOR_BLUE         1
#define TATTOO_COLOR_GREEN        2
#define TATTOO_COLOR_MAGENTA      3
#define TATTOO_COLOR_WHITE        4
#define TATTOO_COLOR_BLACK        5
#define TATTOO_COLOR_GOLD         6
#define TATTOO_COLOR_SILVER       7
#define TATTOO_COLOR_BROWN        8
#define TATTOO_COLOR_MAX          9

// tattoo extra flags
#define TE_PAINT_OTHER            (A) // tattoo can be painted on others
#define TE_ONE_COPY               (B) // only one copy of this tattoo can be painted
#define TE_SPELLUP                (C) // SPELLUP1, SPELLUP2 wishes work for this tattoo

DECLARE_DO_FUN (do_make_tattoo);      // called from do_make
DECLARE_DO_FUN (do_remove_tattoo);    // called from do_remove
DECLARE_DO_FUN (do_examine_tattoo);   // called from do_examine

typedef struct tattoo_t tattoo_t;

extern varr tattooes;

#define MAX_TATTOO_COMP 5
struct tattoo_t
{
    const char * name;                        // must be the same with skill_name
    mlstring   * desc;                        // tattoo's short_desc
    int          paint_comp[MAX_TATTOO_COMP]; // components used for painting
    int          act_comp[MAX_TATTOO_COMP];   // components used for activation
    int          wait_paint;                  // WAIT_STATE for tattooing
    int          wait_act;                    // and for activation 
                                              // NB! overrides skill's wait_state
    flag32_t     wear_loc;                    // body part(s)
    flag32_t     paints;                      // color(s)
    flag32_t     extra;                       // extra flags (e.g. can paint on others)
    int          min_skill;                   // min % of 'tattoo' skill
    int          max_activations;             // max number of activations, -1 - infinite
};

tattoo_t * tattoo_new (void);
void tattoo_free (tattoo_t *);

#define TATTOO(tn)         ((tattoo_t*) VARR_GET(&tattooes, tn))
#define tattoo_lookup(tn)  ((tattoo_t*) varr_get(&tattooes, tn))

int tattoonumber_lookup  (const char * name);
const char * tattoo_name (int tn);

// --------------------------------------------------------------------------
// PAINTS
// --------------------------------------------------------------------------

typedef struct paint_t paint_t;

DECLARE_DO_FUN (do_make_paint); // called from do_make

extern varr paints;

#define MAX_PAINT_COMP 5
struct paint_t
{
    const char * name;                        // name used to identify a paint
    const char * obj_name;                    // name,
    mlstring   * short_desc;                  // short
    mlstring   * desc;                        // and long of created object
    int          components[MAX_PAINT_COMP];  // components used to make a paint
    int          color;                       // color of target paint
    int          min_skill;                   // min % of 'paint craft' skill
    int          mana_cost;                   // mana cost for creation
    int          max_portions;                // max_portions (value can be overwritten in do_make_paint)
    int          power;                       // power (value can be overwritten in do_make_paint)
};

paint_t * paint_new (void);
void paint_free (paint_t *);

#define PAINT(pn)         ((paint_t*) VARR_GET(&paints, pn))
#define paint_lookup(pn)  ((paint_t*) varr_get(&paints, pn))

int paintnumber_lookup  (const char * name);
const char * paint_name (int pn);

// --------------------------------------------------------------------------
// RITUALS
// --------------------------------------------------------------------------

// ritual extra flags
#define RE_NO_ADRENALIN            (A) // char must not be pumped
#define RE_FULL_HP                 (B) // char must have full hp
#define RE_SPELLUP                 (C) // SPELLUP1, SPELLUP2 wishes work for this ritual

typedef struct ritual_t ritual_t;

extern varr rituals;

#define MAX_RITUAL_COMP 5
struct ritual_t
{
    const char * name;                        // must be the same with skill_name
    int          components[MAX_RITUAL_COMP]; // components used to perform a ritual
    flag32_t     sector;                      // sector(s) in which ritual can be performed
    flag32_t     time;                        // time interval(s)
    flag32_t     extra;                       // extra flags (e.g. no_adrenalin)
    int          duration;                    // duration
    int          min_skill;                   // min % of 'ceremonialism' skill
};

ritual_t * ritual_new (void);
void ritual_free (ritual_t *);

#define RITUAL(rn)         ((ritual_t*) VARR_GET(&rituals, rn))
#define ritual_lookup(rn)  ((ritual_t*) varr_get(&rituals, rn))

int ritualnumber_lookup  (const char * name);
const char * ritual_name (int rn);

// flag to int stuff
typedef struct flag_to_int_t flag_to_int_t;
struct flag_to_int_t
{
    flag64_t flag;
    int      n_int;
};
#define FLAG_TO_INT_MAX 999

#endif
