/* $Id: skills.c,v 1.666 2004/09/20 10:49:53 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <sys/types.h>
#if !defined (WIN32)
#include <sys/time.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "merc.h"
#include "update.h"
#include "fight.h"
#include "align.h"

extern bool align_ok(CHAR_DATA *ch, int align);
varr skills = { sizeof(skill_t), 8 };

/* command procedures needed */
DECLARE_DO_FUN(do_help      );
DECLARE_DO_FUN(do_say       );


int ch_skill_nok            (CHAR_DATA *ch , int sn);
void update_special_skills  (CHAR_DATA *ch, bool upd_fishing);
bool is_specialized         (CHAR_DATA *ch, int spec);
bool is_spec                (CHAR_DATA *ch, int sn);

skill_t * skill_new()
{
    skill_t * skill;
    skill = varr_enew(&skills);

    skill->learnmult[0] = 1;
    skill->learnmult[1] = 1;
    skill->gender = 0;

    skill->stat1 = -1;
    skill->stat2 = -1;
    skill->stat3 = -1;

    return skill;
}

void skill_free(skill_t *skill)
{
    free_string(skill->name);
    free_string(skill->noun_damage);
    free_string(skill->noun_rus);
    free_string(skill->msg_off);
    free_string(skill->msg_off_other);
    free_string(skill->msg_obj);
    skill->spell_fun = NULL;
    skill->do_fun    = NULL;

}

/* used to get max % for a skill */
int get_max_skill(CHAR_DATA *ch, int sn)
{
    class_t *cl;
    class_skill_t *cs;
    skill_t *sk;
    int max;

    if (IS_NPC(ch)
       ||  (cl = class_lookup(ch->class)) == NULL)
        return 100;

    /* race & clan skills max at 100% */
    if ((cs = class_skill_lookup(cl, sn)) == NULL)
        return 100;

    if (skill_level(ch, sn) > ch->level
       || (sk = skill_lookup(sn)) == NULL)
        return 0;

    max = cs->max_percent;
/*
*   if (sk->stat1 != -1) max += (ch->perm_stat[sk->stat1]-18) * 4;
*   if (sk->stat2 != -1) max += (ch->perm_stat[sk->stat2]-18) * 2;
*   if (sk->stat3 != -1) max += (ch->perm_stat[sk->stat3]-18) * 1;
*/

    return URANGE(50, max, 200);

}

/* used to converter of prac and train */
DO_FUN(do_gain)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *tr;

    if (IS_NPC(ch))
        return;

    /* find a trainer */
    for (tr = ch->in_room->people; tr; tr = tr->next_in_room)
        if (IS_NPC(tr)  &&  IS_SET(tr->pIndexData->act, ACT_PRACTICE | ACT_TRAIN | ACT_GAIN))
            break;

    if (tr == NULL || !can_see(ch, tr))
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        do_say(tr, "   (convert) 10    1 .");
        do_say(tr, "   (revert) 1   10  .");
        do_say(tr, "  '{Ggain convert{z'  '{Ggain revert{z'.");
        do_say(tr, " '{Ggain experience{z',     .");
        do_say(tr, " '{Ggain questpoints{z',     .");
        return;
    }

    if (!str_prefix(arg, "revert"))
    {
        if (ch->train < 1)
        {
            do_tell_raw(tr, ch, "     .");
            return;
        }

        act("$N        ",  ch, NULL, tr, TO_CHAR);
        ch->practice += 10;
        ch->train -=1 ;
        return;
    }

    if (!str_prefix(arg, "convert"))
    {
        if (ch->practice < 10)
        {
            do_tell_raw(tr, ch, "    .");
            return;
        }

        act("$N        .", ch, NULL, tr, TO_CHAR);
        ch->practice -= 10;
        ch->train +=1 ;
        return;
    }

    if (!str_prefix(arg, "experience"))
    {
        if (ch->pcdata->bonuspoints < 2)
        {
            do_tell_raw(tr, ch, "   .");
            return;
        }

        act("$N       .", ch, NULL, tr, TO_CHAR);
        ch->pcdata->bonuspoints -= 2;
        gain_exp (ch, (ch->level * 100));
        return;
    }

    if (!str_prefix(arg, "questpoints"))
    {
        if (ch->pcdata->bonuspoints < 1)
        {
            do_tell_raw(tr, ch, "   .");
            return;
        }

        act("$N       .",  ch, NULL, tr, TO_CHAR);
        ch->pcdata->bonuspoints -= 1;
        ch->pcdata->questpoints += 300;
        return;
    }

    do_tell_raw(tr, ch, "     ...");
}


// RT spells and skills show the players spells (or skills)
void do_skills_org(CHAR_DATA *ch, const char *argument, int type)
{
    char     spell_list[LEVEL_IMMORTAL+1][MAX_STRING_LENGTH];
    char     spell_columns[LEVEL_IMMORTAL+1];
    char     arg[MAX_INPUT_LENGTH];
    int      lev;
    int      i, verbose, total, every;
    bool     found = FALSE;
    char     buf[MAX_STRING_LENGTH];
    BUFFER  *output;
    char     color;
    flag64_t group = GROUP_NONE;
    char      buf1[MAX_STRING_LENGTH];

    if (IS_NPC(ch))
        return;

    argument = one_argument(argument, arg, sizeof(arg));

    if (!str_cmp(arg,"every"))
    {
        every = 1;
        argument = one_argument(argument, arg, sizeof(arg));
    }
    else
        every = 0;

    if (!str_cmp(arg,"brief"))
    {
        verbose = 0;
        argument = one_argument(argument, arg, sizeof(arg));
    }
    else
        verbose = 1;

    if (!str_cmp(arg,"all") || !str_cmp(arg, ""))
    {
        verbose = 1;
        argument = one_argument(argument, arg, sizeof(arg));
    }


    if (!str_cmp(arg,"total"))
    {
        total = 1;
        argument = one_argument(argument, arg, sizeof(arg));
    }
    else
        total = 0;

    group = flag_value(skill_groups, arg);

    /* initialize data */
    for (lev = 0; lev <= (LEVEL_HERO + IS_IMMORTAL(ch)); lev++)
    {
        spell_columns[lev] = 0;
        spell_list[lev][0] = '\0';
    }

    for (i = 0; i < ch->pcdata->learned.nused; i++)
    {
        pcskill_t *ps = VARR_GET(&ch->pcdata->learned, i);
        skill_t *sk;

        if (ps->percent == 0
        || (sk = skill_lookup(ps->sn)) == NULL
        || ((sk->spell_fun == NULL) && (type == -1))
        || ((sk->type != type) && !total && (type >= 0))
        || (!verbose && ps->percent==100 && (type >= 0))
        || (group && !IS_SET(sk->group, group)))
            continue;

        found = TRUE;
        lev = skill_level(ch, ps->sn);

        if (lev > ((IS_IMMORTAL(ch) && every) ? LEVEL_IMMORTAL : LEVEL_HERO))
            continue;

        if (ps->percent <= 1)
            color = 'r';
        else if (ps->percent <= 50)
            color = 'R';
        else if (ps->percent < 100)
            color = 'Y';
        else if (ps->percent < get_max_skill(ch, ps->sn))
            color = 'W';
        else
            color = 'G';
        if (IS_SET(ps->xs_flags, XS_FORGOT))
            color = 'D';

        if (IS_SET(ch->comm2, COMM2_RUSSKILLS))
            antisubstitute_skill_alias(sk->name, buf1, 22);
        else
            strnzcpy(buf1, 22, sk->name);

        if (ch->level < lev)
            snprintf(buf, sizeof(buf), "%-22s  n/a           ", buf1);
        else
        {
            if (sk->type == TYPE_POWER)
            {
                snprintf(buf, sizeof(buf), "%-22s %2d/%2d/%3d psi {%c%3d%%{z  ",
                    buf1, sk->initial, sk->maintain, mana_cost(ch, ps->sn), color, ps->percent);
            }
            else if (mana_cost(ch, ps->sn) > 0)
                snprintf(buf, sizeof(buf), "%-22s %3d mana {%c%3d%%{z  ",
                     buf1, mana_cost(ch, ps->sn), color, ps->percent);
            else
                snprintf(buf, sizeof(buf), "%-22s %8s {%c%3d%%{z  ",
                    buf1, str_empty, color, ps->percent);
        }

        if (spell_list[lev][0] == '\0')
            snprintf(spell_list[lev], sizeof(spell_list[lev]),
                 "\nLevel %2d: %s", lev, buf);
        else 
        { // append 
            if (++spell_columns[lev] % 2 == 0)
                strnzcat(spell_list[lev], sizeof(spell_list[lev]), "\n          ");
            strnzcat(spell_list[lev], sizeof(spell_list[lev]), buf);
        }
    }

    // return results 

    if (!found) 
    {
        switch(type)
        {
            case TYPE_PROGRAM:
                char_act("      .", ch);
                break;
            case TYPE_MIRACLE:
                char_act("     .", ch);
                break;
            case TYPE_SPELL:
                char_act("    .", ch);
                break;
            case TYPE_POWER:
                char_act("     .", ch);
                break;
            case TYPE_SONG:
                char_act("     .", ch);
                break;
            case TYPE_SKILL:
                char_act("    .", ch);
                break;
            case TYPE_AUTO:
                char_act("    .", ch);
                break;
            case TYPE_LANGUAGE:
                char_act("     .", ch);
                break;
            case TYPE_ABILITY:
                char_act("    .", ch);
                break;
            case TYPE_TATTOO:
                char_act("You don't know how to make tattooes.", ch);
                break;
            case TYPE_RITUAL:
                char_act("You don't know how to perform rituals.", ch);
                break;
            default:
                char_act("    .", ch);
        }
        return;
    }

    output = buf_new(ch->lang);
    for (lev = 0; lev <= LEVEL_IMMORTAL; lev++)
        if (spell_list[lev][0] != '\0')
            buf_add(output, spell_list[lev]);
    buf_add(output, "\n");
    page_to_char(buf_string(output), ch);
    if(type == TYPE_SKILL)
        char_act("  {cautoskills{x  {coskills{x.", ch);
    buf_free(output);
}

DO_FUN(do_spells)
{
    do_skills_org(ch, argument, TYPE_SPELL);
}

DO_FUN(do_miracles)
{
    do_skills_org(ch, argument, TYPE_MIRACLE);
}

DO_FUN(do_powers)
{
    do_skills_org(ch, argument, TYPE_POWER);
}

DO_FUN(do_songs)
{
    do_skills_org(ch, argument, TYPE_SONG);
}

DO_FUN(do_programs)
{
    do_skills_org(ch, argument, TYPE_PROGRAM);
}

DO_FUN(do_skills)
{
    do_skills_org(ch, argument, TYPE_SKILL);
}

DO_FUN(do_autoskills)
{
    do_skills_org(ch, argument, TYPE_AUTO);
}

DO_FUN(do_abilities)
{
    do_skills_org(ch, argument, TYPE_ABILITY);
}

DO_FUN(do_languages)
{
    do_skills_org(ch, argument, TYPE_LANGUAGE);
}

DO_FUN(do_ospells)
{
    do_skills_org(ch, argument, -1);
}

DO_FUN(do_oskills)
{
    char skill_list[LEVEL_IMMORTAL+1][MAX_STRING_LENGTH];
    char skill_columns[LEVEL_IMMORTAL+1];
    int lev;
    int i;
    bool found = FALSE;
    char buf[MAX_STRING_LENGTH];
    BUFFER *output;
    char color;
    char      buf1[MAX_STRING_LENGTH];

    if (IS_NPC(ch))
        return;

    // initialize data
    for (lev = 0; lev <= (LEVEL_HERO + IS_IMMORTAL(ch)); lev++)
    {
        skill_columns[lev] = 0;
        skill_list[lev][0] = '\0';
    }

    for (i = 0; i < ch->pcdata->learned.nused; i++)
    {
        pcskill_t *ps = VARR_GET(&ch->pcdata->learned, i);
        skill_t *sk;

        if (ps->percent == 0 || (sk = skill_lookup(ps->sn)) == NULL  || sk->spell_fun)
            continue;

        found = TRUE;
        lev = skill_level(ch, ps->sn);

        if (lev > (IS_IMMORTAL(ch) ? LEVEL_IMMORTAL : LEVEL_HERO))
            continue;

        if (ps->percent <= 1)
            color = 'r';
        else if (ps->percent <= 50)
            color = 'R';
        else if (ps->percent < 100)
            color = 'Y';
        else if (ps->percent < get_max_skill(ch, ps->sn))
            color = 'W';
        else
//      if (ps->percent = get_max_skill(ch, ps->sn))
            color = 'G';

        if (IS_SET(ps->xs_flags, XS_FORGOT))
            color = 'D';

        if (IS_SET(ch->comm2, COMM2_RUSSKILLS))
            antisubstitute_skill_alias(sk->name, buf1, 22);
        else
            strnzcpy(buf1, 22, sk->name);

        snprintf(buf, sizeof(buf),
             ch->level < lev ?
                "%-22s n/a      " : "%-22s {%c%3d%%{z      ",
             buf1, color, ps->percent);

        if (skill_list[lev][0] == '\0')
            snprintf(skill_list[lev], sizeof(skill_list[lev]),
                 "\n %2d: %s", lev, buf);
        else 
        { // append
            if (++skill_columns[lev] % 2 == 0)
                strnzcat(skill_list[lev], sizeof(skill_list[lev]), "\n            ");
            strnzcat(skill_list[lev], sizeof(skill_list[lev]), buf);
        }
    }

    // return results

    if (!found)
    {
        char_act("    .", ch);
        return;
    }

    output = buf_new(-1);
    for (lev = 0; lev <= LEVEL_IMMORTAL; lev++)
        if (skill_list[lev][0] != '\0')
            buf_add(output, skill_list[lev]);
    buf_add(output, "\n");
    page_to_char(buf_string(output), ch);
    buf_free(output);
}

int base_exp(CHAR_DATA *ch)
{
    int expl;
    class_t *cl;
    race_t *r;
    rclass_t *rcl;

    if (IS_NPC(ch)
    ||  (cl = class_lookup(ch->class)) == NULL
    ||  (r = race_lookup(ch->pcdata->race)) == NULL
    ||  !r->pcdata
    ||  (rcl = race_class_lookup(r, cl->name)) == NULL)
        return 1500;

    expl = 1000 + r->pcdata->points + cl->points;
    return expl * rcl->mult/100;
}

int exp_for_level(CHAR_DATA *ch, int level)
{
    int i = base_exp(ch) * level;
    return i + i * (level-1) / 20;
}

int exp_to_level(CHAR_DATA *ch)
{
    return exp_for_level(ch, ch->level+1) - ch->exp;
}

/* checks for skill improvement */
void check_improve(CHAR_DATA *ch, int sn, bool success, int multiplier)
{
    pcskill_t *ps;
    skill_t *sk;
    class_t *cl;
    class_skill_t *cs;
    CHAR_DATA *victim;
    int chance;
    int rating;
    int max_range, max_worse;
    int max_skill = get_max_skill(ch, sn);
    char buf[MAX_STRING_LENGTH];

    if (IS_NPC(ch)
    || (sk = skill_lookup(sn)) == NULL
    || (cl = class_lookup(ch->class)) == NULL
    || (ps = pc_skill_lookup(ch, sn)) == NULL
    || ps->percent == 0
    || ps->percent >= max_skill
    || skill_level(ch, sn) > ch->level)
        return;

    // alignment stuff
    if (!align_ok (ch, RALIGN (ch)))
        return;

    victim = ch->fighting;
    if (victim
    && victim->level < (2 * ch->level / 3))
        return;

    if (ch->pcdata->security > 8)
        char_printf(ch, "Skill(%s) : %s, difficulty : %d, %d, %d.\n",
            (success) ? "+" : "-", skill_name(sn),
            multiplier, sk->learnmult[0], sk->learnmult[1]);

    //        .
    //   skills.conf  ,  1  1.
    multiplier += (success) ? sk->learnmult[0] : sk->learnmult[1];

    // ,     .   ,
    //     ...   1...
    if ((cs = class_skill_lookup(cl, sn)))
        rating = cs->rating;
    else
        rating = 1;

    if (rating < 1) rating = 1; // ,    0  .

    // check to see if the character has a chance to learn
    // chance   25 = 85, 20 = 49, 10 = 5. LVL = 91
    chance = 10 * int_app[get_curr_stat(ch,STAT_INT)].learn;
    chance /= (multiplier * rating * 4);
//    chance += ch->level;

    if (chance < 10) chance = 10;

    //        ...
    if (HAS_SKILL(ch, gsn_fast_learning))
        chance = chance * 5/4;
    else if (HAS_SKILL(ch, gsn_quick_learning))
        chance = chance * 9/8;

    //    ...  ...
    max_range = 800;

    if (IS_SET(ch->pcdata->wishes, WISH_LEARNUP2))
        max_range -= 400;
    else if (IS_SET(ch->pcdata->wishes, WISH_LEARNUP1))
        max_range -= 150;

    //  max_range == 500
    if (number_range(1, max_range) > chance)
        return;

    //    ,  LCK = 22
    if (ps->percent > 90
    && number_percent() > ((get_curr_stat(ch, STAT_LCK) + ch->played) / 4))
        return;
    else if (ps->percent > 80
    && number_percent() > ((get_curr_stat(ch, STAT_LCK) + ch->played) / 2))
        return;

    max_worse = 12;

    if (is_affected(ch, gsn_negative_luck))
        max_worse = 2;
    if (is_affected(ch, gsn_positive_luck))
        max_worse = 22;

    //     -  :)
    if (ch->level < 10)
        max_worse /= 4;
    else if (ch->level < 30)
        max_worse /= 2;

    if (ps->percent < 40)
        max_worse += 8;

    if (IS_SET(ch->pcdata->wishes, WISH_LEARNUP2))
        max_worse *= 4;
    else if (IS_SET(ch->pcdata->wishes, WISH_LEARNUP1))
        max_worse *= 2;

    // .. MAX = 120, MIN = 2...  ӣ  ... 1  1000
    if (ps->percent > 1
    && ps->percent < 100
    && max_worse < get_curr_stat(ch, STAT_LCK)
    && !success
    && number_bits(999) == 666)
    {
        act("{WYour have become worse in {g$t{z!{x",  ch, skill_name(sn), NULL, TO_CHAR);
        ps->percent--;
        gain_exp(ch, -1000 * rating);
        return;
    }

    //   ޣ   ,    ,
    //     ...  ...
    if (!success)
        chance = URANGE(5, ps->percent, 90);
    else
        chance = URANGE(5, ps->percent, 30);

    if (ch->pcdata->security > 8)
        char_printf(ch, "Max_range : %d, chance %d, max_worse %d.\n", max_range, chance, max_worse);

    if (number_percent() > chance)
        return;

    //       
    if (((get_age(ch) < 18 && ps->percent >= 68)
    || (get_age(ch) < 19 && ps->percent >= 76)
    || (get_age(ch) < 20 && ps->percent >= 84)
    || (get_age(ch) < 21 && ps->percent >= 92))
    && number_bits(1) == 0
    && ch->level < LEVEL_HERO)
    {
        if (!IS_SET(ch->comm, COMM_NOVERBOSE))
            act_puts("{WUnderstanding of {g$t{z sneaks out of you!{x", ch, skill_name(sn), NULL, TO_CHAR, POS_DEAD);
        gain_exp(ch, 1 * rating);
        return;
    }

    if (IS_SET(ch->comm2, COMM2_RUSSKILLS))
        antisubstitute_skill_alias(skill_name(sn), buf, sizeof(buf));
    else
        strnzcpy(buf, sizeof(buf), skill_name(sn));

    if (++ps->percent < max_skill)
    {
        gain_exp(ch, 100 * rating);
        if (success)
        {
            act_puts("{WYou have become better at {g$t{z!{x",  ch, buf, NULL, TO_CHAR, POS_DEAD);
        } else
        {
            act_puts("{WYou learn from your mistakes, and your {g$t{z skill improves.{x", ch, buf, NULL, TO_CHAR, POS_DEAD);
        }
    } else
    {
        act_puts("{WYou mastered {g$t{z!{x", ch, buf, NULL, TO_CHAR, POS_DEAD);
        gain_exp(ch, 1000 * rating);
    }
}

/*
 * simply adds sn to ch's known skills (if skill is not already known).
 */
void set_skill_raw(CHAR_DATA *ch, int sn, int percent, bool replace)
{
    pcskill_t *ps;

    if (sn <= 0)
        return;

    if ((ps = pc_skill_lookup(ch, sn))) 
    {
        if (replace || ps->percent < percent)
            ps->percent = percent;
        return;
    }
    ps = varr_enew(&ch->pcdata->learned);
    ps->sn = sn;
    ps->percent = percent;
    ps->xs_flags = 0;
    ps->level = ch->level;
    varr_qsort(&ch->pcdata->learned, cmpint);
}

/* use for adding/updating all skills available for that ch  */
void update_skills(CHAR_DATA *ch)
{
    int i;
    skill_t *skill;
    class_t *class;
    race_t *race;
    clan_t *clan;
    religion_t *religion;
    const char *p;

/* NPCs do not have skills */
    if (IS_NPC(ch)
    ||  (class = class_lookup(ch->class)) == NULL
    ||  (race = race_lookup(ch->race)) == NULL
    ||  (religion = religion_lookup(ch->religion)) == NULL
    ||  !race->pcdata)
        return;

/* add class skills */
    for (i = 0; i < class->skills.nused; i++)
    {
        class_skill_t *class_skill = VARR_GET(&class->skills, i);
        set_skill_raw(ch, class_skill->sn, 1, FALSE);
    }

/* add race skills */
    for (i = 0; i < race->pcdata->skills.nused; i++)
    {
        race_skill_t *race_skill = VARR_GET(&race->pcdata->skills, i);
        set_skill_raw(ch, race_skill->sn, 100, FALSE);
    }

/* add religion skills */
    for (i = 0; i < religion->skills.nused; i++)
    {
        religion_skill_t *religion_skill = VARR_GET(&religion->skills, i);
        set_skill_raw(ch, religion_skill->sn, 1, FALSE);
    }


    if ((p = race->pcdata->bonus_skills))
        for (;;)
        {
            int sn;
            char name[MAX_STRING_LENGTH];

            p = one_argument(p, name, sizeof(name));
            if (name[0] == '\0')
                break;

            sn = sn_lookup(name);
            if (sn < 0)
                continue;

            set_skill_raw(ch, sn, 100, FALSE);
        }

/* add clan skills */
    if ((clan = clan_lookup(ch->clan)))
    {
        for (i = 0; i < clan->skills.nused; i++)
        {
            clan_skill_t *clan_skill = VARR_GET(&clan->skills, i);
            set_skill_raw(ch, clan_skill->sn, 1, FALSE);
        }
    }

/* remove not matched skills */
    for (i = 0; i < ch->pcdata->learned.nused; i++)
    {
        pcskill_t *ps = VARR_GET(&ch->pcdata->learned, i);
        if (skill_level(ch, ps->sn) > LEVEL_HERO && !IS_IMMORTAL(ch)
             && (((skill = skill_lookup(ps->sn))== NULL)
             || !IS_SET(skill->flags, SKILL_HIDDEN)))
            ps->percent = 0;

        if (ps->percent > 100)
            ps->percent=100;
    }
    update_special_skills(ch, FALSE);
}

bool is_specialized(CHAR_DATA *ch, int spec)
{
    if(IS_NPC(ch))
        return FALSE;
    return (ch->pcdata->specialization[0] == spec) ||
            (ch->pcdata->specialization[1] == spec) ||
            (ch->pcdata->specialization[2] == spec);
}

bool is_spec(CHAR_DATA *ch, int sn)
{
    if(IS_NPC(ch))
        return FALSE;
    if(sn == gsn_sword && is_specialized(ch, SPEC_SWORD))
        return TRUE;
    if(sn == gsn_dagger && is_specialized(ch, SPEC_DAGGER))
        return TRUE;
    if(sn == gsn_axe && is_specialized(ch, SPEC_AXE))
        return TRUE;
    if(sn == gsn_mace && is_specialized(ch, SPEC_MACE))
        return TRUE;
    if(sn == gsn_hand_to_hand && is_specialized(ch, SPEC_HAND))
        return TRUE;
    if(((sn==gsn_whip)||(sn==gsn_flail)) && is_specialized(ch,SPEC_WHIP))
        return TRUE;
    if(((sn==gsn_spear)||(sn==gsn_polearm)||(sn==gsn_lance)) &&
                            is_specialized(ch, SPEC_SPEAR))
        return TRUE;
    return FALSE;
}

void update_special_skills(CHAR_DATA *ch, bool upd_fishing)
{
    if (IS_NPC(ch) || IS_IMMORTAL(ch))
        return;

    // First, fishing auto_gain
    if ((get_percent (ch, gsn_riding) < 2)
         && (get_percent (ch, gsn_animal_riding) < 2)
         && (get_percent (ch, gsn_dragon_riding) < 2)
         && pc_skill_lookup(ch, gsn_mounted_fishing))

        set_skill(ch, gsn_mounted_fishing, 0);
    
    if (upd_fishing)   
    {
        // group 1: mounted, winter, blind, mute, outraging, lore
        // group 2: improved, mastering, expert
        // group 3: craft

        int fp = get_percent(ch, gsn_fishing); 
        int sn; // sn to add
        int g1_skills,   // gained skills count for group 1
            g1_mastered, // mastered skills count for group 1
            g1_80,       // skills count for group 1 (80%)
            g2_skills,   // gained skills count for group 2
            g2_mastered, // mastered skills count for group 2
            g2_80;       // skills count for group 2 (80%)
             
        int g1_max_amount = 5 + (get_percent(ch, gsn_mounted_fishing) > 1);
        int g2_max_amount = 3;
        
        g2_skills =   (get_percent(ch, gsn_improved_fishing) > 1) +
                      (get_percent(ch, gsn_mastering_fishing) > 1) +
                      (get_percent(ch, gsn_expert_fishing) > 1);

        g2_80 =       (get_percent(ch, gsn_improved_fishing) > 80) +
                      (get_percent(ch, gsn_mastering_fishing)> 80) +
                      (get_percent(ch, gsn_expert_fishing) > 80);

        g2_mastered = (get_percent(ch, gsn_improved_fishing) > 99) +
                      (get_percent(ch, gsn_mastering_fishing) > 99) +
                      (get_percent(ch, gsn_expert_fishing) > 99);


        g1_skills =   (get_percent(ch, gsn_mounted_fishing) > 1) +
                      (get_percent(ch, gsn_winter_fishing) > 1) +
                      (get_percent(ch, gsn_blind_fishing) > 1) +
                      (get_percent(ch, gsn_mute_fishing) > 1) +
                      (get_percent(ch, gsn_outraging_fishing) > 1) +
                      (get_percent(ch, gsn_lore_fishing) > 1);

        g1_80 =       (get_percent(ch, gsn_mounted_fishing) > 80) +
                      (get_percent(ch, gsn_winter_fishing) > 80) +
                      (get_percent(ch, gsn_blind_fishing) > 80) +
                      (get_percent(ch, gsn_mute_fishing) > 80) +
                      (get_percent(ch, gsn_outraging_fishing) > 80) +
                      (get_percent(ch, gsn_lore_fishing) > 80);

        g1_mastered = (get_percent(ch, gsn_mounted_fishing) > 99) +
                      (get_percent(ch, gsn_winter_fishing) > 99) +
                      (get_percent(ch, gsn_blind_fishing) > 99) +
                      (get_percent(ch, gsn_mute_fishing) > 99) +
                      (get_percent(ch, gsn_outraging_fishing) > 99) +
                      (get_percent(ch, gsn_lore_fishing) > 99);

        // add skill from group 1
        if (fp >= 90 && g1_skills == g1_80) 
        {
            switch(number_range(1,6)) 
            {
                    
                case 1: if (get_percent(ch, gsn_riding) > 1) 
                        {
                            sn = gsn_mounted_fishing;
                            break;
                        }
                case 2: sn = gsn_winter_fishing;
                        break;
                case 3: sn = gsn_blind_fishing;
                        break;
                case 4: sn = gsn_mute_fishing;
                        break;
                case 5: sn = gsn_outraging_fishing;
                        break;
                case 6: sn = gsn_lore_fishing;
                        break;
                default:sn = gsn_lore_fishing;
                        break;
            }
            set_skill_raw (ch, sn, 2, FALSE);
        }

        // all skills from group 1 mastered - add skill from group 2
        if ((g1_mastered == g1_max_amount) && (fp == 100) && (g2_skills == g2_80))
        {
            switch(number_range(1,3)) 
            {
                case 1: sn = gsn_improved_fishing;
                        break;
                case 2: sn = gsn_mastering_fishing;
                        break;
                case 3: sn = gsn_expert_fishing;
                        break;
                default:sn = gsn_expert_fishing;
                        break;
            }
            set_skill_raw (ch, sn, 2, FALSE);
        }
        if ((g2_mastered == g2_max_amount) && (fp == 100))
            set_skill_raw (ch, gsn_craft_fishing, 2, FALSE);
    } 

/* GM : .   .
extern int *psi_attack[];
extern int *psi_defense[];
    if (HAS_SKILL(ch, gsn_psionics))
    {
        int att = 0, def = 0, i;
        for (i=0; i < 5; i++)
        {
            att += get_percent(ch, *(psi_attack[i])) > 1;
            def += get_percent(ch, *(psi_defense[i])) > 1;
        }
        if (att < (ch->level + 10) / 20)
        {
            i = number_range(0, 4);
            if (get_percent(ch, *(psi_attack[i])) < 2)
                set_skill(ch, *(psi_attack[i]), 2);
        }
        if (def < (ch->level + 10) / 20)
        {
            i = number_range(0, 4);
            if (get_percent(ch, *(psi_defense[i])) < 2)
                set_skill(ch, *(psi_defense[i]), 2);
        }
    }
*/
    if (IS_UNDEAD(ch) && ch->class != CLASS_VAMPIRE
    && !is_affected(ch, gsn_polymorph))
    {
        set_skill(ch, gsn_fast_healing, 0);
    }

    if (ch->class == CLASS_WARRIOR
        || ch->class == CLASS_RANGER
        || ch->class == CLASS_PALADIN
        || ch->class == CLASS_ANTI_PALADIN)
    {
        if (ch->class != CLASS_ANTI_PALADIN && !IS_UNDEAD(ch))
        {
            set_skill(ch, gsn_deathgrip, 0);
        }

        if (!is_specialized(ch, SPEC_SWORD))
        {
            set_skill(ch, gsn_flourentine, 0);
            set_skill(ch, gsn_flurry, 0);
            set_skill(ch, gsn_riposte, 0);
            set_skill(ch, gsn_cross_slice, 0);
        }
        if (!is_specialized(ch, SPEC_AXE))
        {
            set_skill(ch, gsn_axedigging, 0);
            set_skill(ch, gsn_mastering_axe, 0);
            set_skill(ch, gsn_shield_cleave, 0);
            set_skill(ch, gsn_weapon_cleave, 0);
            set_skill(ch, gsn_pincer, 0);
        }
        if (!is_specialized(ch, SPEC_WHIP))
        {
            set_skill(ch, gsn_eyejab, 0);
            set_skill(ch, gsn_strip_weapon, 0);
            set_skill(ch, gsn_choke, 0);
        }
        if (!is_specialized(ch, SPEC_HAND))
        {
            set_skill(ch, gsn_kung_fu, 0);
            set_skill(ch, gsn_throw, 0);
            set_skill(ch, gsn_ground_control, 0);
            set_skill(ch, gsn_hand_block, 0);
        }
        if (!is_specialized(ch, SPEC_DAGGER))
        {
            set_skill(ch, gsn_undercut, 0);
            set_skill(ch, gsn_bleed, 0);
            set_skill(ch, gsn_restrike, 0);
        }
        if (!is_specialized(ch, SPEC_MACE))
        {
            set_skill(ch, gsn_backhand, 0);
            set_skill(ch, gsn_boneshatter, 0);
            set_skill(ch, gsn_drumming_maces, 0);
        }
        if (!is_specialized(ch, SPEC_SPEAR))
        {
            set_skill(ch, gsn_overhead, 0);
            set_skill(ch, gsn_leg_sweep, 0);
            set_skill(ch, gsn_charge_set, 0);
            set_skill(ch, gsn_pugil, 0);
            set_skill(ch, gsn_stand_off, 0);
        }
    }
}

void set_skill(CHAR_DATA *ch, int sn, int percent)
{
    set_skill_raw(ch, sn, percent, TRUE);
}

DO_FUN(do_glist)
{
    char arg[MAX_INPUT_LENGTH];
    int col = 0;
    flag64_t group = GROUP_NONE;
    int sn;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        do_help(ch, "'GLIST SYNTAX'");
        return;
    }

    if (!str_cmp(arg, "?"))
    {
        show_flags(ch, skill_groups);
        return;
    }

    if (str_prefix(arg, "none") &&  (group = flag_value(skill_groups, arg)) == 0)
    {
        char_act(" .", ch);
        do_glist(ch, str_empty);
        return;
    }

    char_printf(ch, "    '%s':\n", flag_string(skill_groups, group));

    for (sn = 0; sn < skills.nused; sn++)
    {
        skill_t *sk = VARR_GET(&skills, sn);
        if (IS_SET(sk->group, group))
        {
            char_printf(ch, "%c%-18s", pc_skill_lookup(ch, sn) ? '*' : ' ', sk->name);
            if (col)
                char_act(str_empty, ch);
            col = 1 - col;
        }
    }

    if (col)
        char_act(str_empty, ch);
}

DO_FUN(do_slook)
{
    int sn = -1;
    char arg[MAX_INPUT_LENGTH];
    skill_t *sk;
    int success = 1, mistake = 1, rating = 1, intellect = 1;
    class_t *cl;
    class_skill_t *cs;
    skill_t *skill;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act(": slook <skill>", ch);
        return;
    }

    if (!str_cmp(arg, "canscribe"))
    {
        int i;
        char_printf(ch, "You can scribe:\n");
        for (i = 0; i < ch->pcdata->learned.nused; i++)
        {
            int *psn = (int*) VARR_GET(&ch->pcdata->learned, i);

            if ((skill = skill_lookup(*psn)) &&  IS_SET(skill->flags, SKILL_SCRIBE))
                    char_printf(ch, "%s\n", skill->name);
        }
        return;

    }

    if (!IS_NPC(ch))
    {
        pcskill_t *ps;
        if ((ps = skill_vlookup(&ch->pcdata->learned, arg)))
            sn = ps->sn;
    }

    if (sn < 0 && (sn = sn_lookup(arg)) < 0)
    {
        char_act("   .", ch);
        return;
    }

    sk = SKILL(sn);

    if (!IS_NPC (ch))
    {
        cl = class_lookup(ch->class);
        if ((cs = class_skill_lookup(cl, sn)))
            rating = cs->rating;
        else
            rating = 1;
        success = sk->learnmult[0];
        mistake = sk->learnmult[1];
        intellect = int_app[get_curr_stat(ch, STAT_INT)].learn;
    }

    char_printf(ch, "'%s'   '%s'   '%s'.\n",
                     sk->name,
                     flag_string(skill_types, sk->type),
                     flag_string(skill_groups, sk->group));
    char_printf(ch, ": [%s] : [%s]\n",
            flag_string(skill_targets, sk->target),
            flag_string(skill_flags, sk->flags));
    char_printf(ch, " : [%d]  : [%d]\n : [%s]  [%d]\n",
            sk->min_mana,
            sk->beats,
            flag_string(position_table, sk->min_pos),
            intellect);
    char_printf(ch, "  : [%d]   : [%d]   : [%d]\n",
            rating, success, mistake);
    if (IS_POWER(sn))
    {
        char_printf(ch, "Discipline: [%s]\nPower score: [%s %c %d (%d)]\n",
            flag_string(psi_disciplines, sk->discipline),
            flag_string(stat_names, sk->stat1),
            sk->bonus >= 0 ? '+' : '-',
            sk->bonus >= 0 ? sk->bonus : -sk->bonus,
            power_score(ch, sn));
        char_printf(ch, "Initial cost: [%d]\nMaintain cost: [%d]\n",
                        sk->initial, sk->maintain);
    }
}

DO_FUN(do_study)
{
    char arg[MAX_INPUT_LENGTH];
    int sn, scroll_sn;
    int adept, number = 1, add_percent, max_percent;
    OBJ_DATA *obj;
    class_t *cl;
    pcskill_t *ps;
    skill_t *sk;

    if (IS_NPC(ch)
    || (cl = class_lookup(ch->class)) == NULL)
        return;

    if (!IS_AWAKE(ch))
    {
        char_act("In your dreams, or what?", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Syntax: {cstudy <scroll> <number>{x", ch);
        char_act("Syntax: {cstudy <learning book>{x", ch);
        return;
    }

    obj = get_obj_carry(ch, arg);
    if (obj == NULL)
    {
        char_act("You don't have this thing.", ch);
        return;
    }

    if (obj->pIndexData->item_type == ITEM_SCROLL)
    {
        argument = one_argument(argument, arg, sizeof(arg));

        if (arg[0] == '\0')
            number = 1;
        else if (!is_number(arg))
            do_study(ch, str_empty);
        else
            number = atoi(arg);

        if (number < 1 || number > 4)
            number = 1;

        scroll_sn = obj->value[number];
        add_percent = 1;
        max_percent = 80;

        adept = cl->skill_adept;
        if (IS_SET(ch->pcdata->wishes, WISH_LEARNUP2))
            adept += 10;

        check_improve(ch, sn_lookup("scrolls"), TRUE, 2);
    }
    else if (obj->pIndexData->item_type == ITEM_LEARN_BOOK)
    {
        scroll_sn = obj->value[2];
        add_percent = obj->value[0];
        max_percent = obj->value[1];
		adept = 0;
    }
    else
    {
        char_act ("You can't learn from this.", ch);
        return;
    }

    if ((ps = pc_skill_lookup(ch, scroll_sn)) == NULL
        ||  ps->percent == 0
        ||  skill_level(ch, sn = ps->sn) > ch->level)
    {
        act("You can't learn that.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    sk = SKILL(sn);

    if (ps->percent >= max_percent)
    {
        char_printf(ch, "You can't learn {W%s{z more from this.\n", sk->name);
        return;
    }

    if ((ps->percent < adept) && (obj->pIndexData->item_type == ITEM_SCROLL))
        ps->percent = adept;
    else
    {
        // Welesh: commented out
/*        if (((get_age(ch) < 18 && ps->percent >= 68)
          || (get_age(ch) < 19 && ps->percent >= 76)
          || (get_age(ch) < 20 && ps->percent >= 84)
          || (get_age(ch) < 21 && ps->percent >= 92))
          && ch->level < LEVEL_HERO)
        {
            act("{WYour age insufficiently to learn {g$t{z!{x",
                ch, skill_name(sn), NULL, TO_CHAR);
            return;
        }*/
        ps->percent += add_percent;
        ps->percent = UMIN (ps->percent, max_percent);
    }
    char_printf (ch, "   {W%s{z  {W%d%%{z.\n", sk->name, ps->percent);
    act("$n reads $p.", ch, obj, NULL, TO_ROOM );
    act("$p burns brightly and is gone.", ch, obj, NULL, TO_ALL );
    extract_obj( obj );
    act("$n is now learned at $T.", ch, NULL, sk->name, TO_ROOM);
}

#define PC_PRACTICER    123

DO_FUN(do_learn)
{
    char arg[MAX_INPUT_LENGTH];
    int sn;
    CHAR_DATA *mob;
    int adept;
    class_t *cl;
    class_skill_t *cs;
    pcskill_t *ps;
    skill_t *sk;
    int rating;

    if (IS_NPC(ch)
    || (cl = class_lookup(ch->class)) == NULL)
        return;

    if (!IS_AWAKE(ch))
    {
        char_act("In your dreams, or what?", ch);
        return;
    }

    if (argument[0] == '\0')
    {
        char_act("Syntax: learn <skill | spell> <player>", ch);
        return;
    }

    if (ch->practice <= 0)
    {
        act("You have no practice sessions left.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if ((ps = skill_vlookup(&ch->pcdata->learned, arg)) == NULL
    ||  ps->percent == 0
    ||  skill_level(ch, sn = ps->sn) > ch->level)
    {
        act("You can't learn that.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    ps = pc_skill_lookup(ch, sn);

    if (sn == gsn_vampire)
    {
        act("You can't practice that, only available at questor.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if ((mob = get_char_room(ch, arg)) == NULL)
    {
        act("Your hero is not here.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_NPC(mob) || mob->level < HERO)
    {
        act("You must find a hero, not an ordinary one.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (mob->status != PC_PRACTICER)
    {
        act("Your hero doesn't want to teach you anything.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (get_skill(mob, sn) < 100)
    {
        act("Your hero doesn't know that skill enough to teach you.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    sk = SKILL(sn);
    adept = cl->skill_adept;

    if (IS_SET(ch->pcdata->wishes, WISH_LEARNUP2))
        adept += 10;

    if (ps->percent >= adept)
    {
        char_printf(ch, "You are already learned at {W%s{z.\n", sk->name);
        return;
    }

    ch->practice--;

    cs = class_skill_lookup(cl, sn);
    rating = cs ? UMAX(cs->rating, 1) : 1;
    ps->percent += ((int_app[get_curr_stat(mob, STAT_INT)].learn
    + int_app[get_curr_stat(ch, STAT_INT)].learn) / (2 * rating));
//       ...     - 
//      ... -    -... :)
//    mob->status = 0;

    act("You teach {W$T{z.", mob, NULL, sk->name, TO_CHAR);
    act("$n teaches {W$T{z.", mob, NULL, sk->name, TO_ROOM);

    if (get_age(ch) < 18 && ps->percent > 68)              ps->percent = 68;
    if (get_age(ch) < 19 && ps->percent > 76)              ps->percent = 76;
    if (get_age(ch) < 20 && ps->percent > 84)              ps->percent = 84;
/*    if (get_age(ch) < 21 && ps->percent > 92)
        ps->percent = 92;
*/
    if (ps->percent < adept)
        ps->percent = adept;
    if (ps->percent > 90)
        ps->percent = 90;

    char_printf (ch, "   {W%s{z  {W%d%%{z.\n", sk->name, ps->percent);
    act("$n is now learned at $T.", ch, NULL, sk->name, TO_ROOM);
}

DO_FUN(do_teach)
{
    if (IS_NPC(ch)
    || ch->level < LEVEL_HERO)
    {
        char_act("You must be a hero.", ch);
        return;
    }
    if (ch->status == PC_PRACTICER)
    {
        char_act("Now, you no more teacher.", ch);
        ch->status = 0;
    } else
    {
        ch->status = PC_PRACTICER;
        char_act("Now, you can teach youngsters your 100% skills.", ch);
    }
}

const char *skill_name(int sn)
{
    skill_t *sk = varr_get(&skills, sn);
    if (sk)
        return sk->name;
    return "none";
}
/* get_skill for coding purposes */
int get_percent(CHAR_DATA *ch, int sn)
{
    pcskill_t *ps;

    if (IS_NPC(ch))
        return 0;
    if ((ps = pc_skill_lookup(ch, sn)) == NULL)
        return 0;

    return ps->percent;
}

/* for returning skill information */
int get_skill(CHAR_DATA *ch, int sn)
{
    int skill;
    skill_t *sk;
    clan_t *clan;

    if ((sk = skill_lookup(sn)) == NULL)
        return 0;

    if (!IS_NPC(ch))
    {
        pcskill_t *ps;

        if ((ps = pc_skill_lookup(ch, sn)) == NULL  || skill_level(ch, sn) > ch->level)
            skill = 0;
        else
            skill = ps->percent;
        if (ps != NULL && IS_SET(ps->xs_flags, XS_FORGOT))
        {
            // GM : Added for FUN remember
            if (number_range(0, 1000) < get_curr_stat(ch, STAT_LCK) / 5)
            {
                REMOVE_BIT(ps->xs_flags, XS_FORGOT);
                act("You remembered '$t'.",  ch, SKILL(ps->sn)->name, NULL, TO_CHAR | ACT_VERBOSE);
                WAIT_STATE(ch, 1);    // just spam protect
            } else
                skill = 0;
        }
        if ((ch->level < LEVEL_IMMORTAL)
        && IS_CLAN_SKILL(sk))
            skill = get_clan_max_percent(ch, sn, skill);

        clan = CLAN(ch->clan);

        if (IS_SET(clan->flags, CLAN_HATE_MAGIC)
        && (sn == gsn_spellbane)
        && (skill == 0))
            skill = 1;

        // alignment stuff
        
        if(!IS_NPC(ch))
        {
            if (!align_ok(ch, RALIGN(ch)))
            {
                skill *= 0.7;
                // char_act ("Skill works much worse!", ch);
            }
        }
    }
    else 
    {
        flag64_t act = ch->pIndexData->act;
        flag64_t off = ch->pIndexData->off_flags;

        // mobiles 
        if (sk->spell_fun)
            skill = 40 + 2 * ch->level;
        else if (sn == gsn_track || sn == gsn_pwipe)
            skill = 100;
        else if ((sn == gsn_sneak || sn == gsn_hide || sn == gsn_pick)  &&  IS_SET(act, ACT_THIEF))
            skill = ch->level * 2 + 20;
        else if (sn == gsn_backstab   &&  (IS_SET(act, ACT_THIEF) || IS_SET(off, OFF_BACKSTAB)))
            skill = ch->level * 2 + 20;
        else if (sn == gsn_dual_backstab  &&  (IS_SET(act, ACT_THIEF) || IS_SET(off, OFF_BACKSTAB)))
            skill = ch->level + 20;
        else if ((sn == gsn_dodge && IS_SET(off, OFF_DODGE)) ||
                 (sn == gsn_parry && IS_SET(off, OFF_PARRY)) ||
                 (sn == gsn_dirt && IS_SET(off, OFF_DIRT_KICK)))
            skill = ch->level * 2;
        else if (sn == gsn_shield_block)
            skill = 10 + 2 * ch->level;
        else if (sn == gsn_second_attack &&
             (IS_SET(act, ACT_WARRIOR | ACT_THIEF | ACT_CLAN_GUARD)))
            skill = 10 + 3 * ch->level;
        else if (sn == gsn_third_attack && IS_SET(act, ACT_WARRIOR | ACT_CLAN_GUARD))
            skill = 4 * ch->level - 40;
        else if (sn == gsn_fourth_attack && IS_SET(act, ACT_WARRIOR | ACT_CLAN_GUARD))
            skill = 4 * ch->level - 60;
        else if (sn == gsn_hand_to_hand)
            skill = 40 + 2 * ch->level;
        else if (sn == gsn_trip && IS_SET(off, OFF_TRIP))
            skill = 10 + 3 * ch->level;
        else if ((sn == gsn_bash || sn == gsn_bash_door) &&
             IS_SET(off, OFF_BASH))
            skill = 10 + 3 * ch->level;
        else if (sn == gsn_kick && IS_SET(off, OFF_KICK))
            skill = 10 + 3 * ch->level;
        else if ((sn == gsn_critical) && IS_SET(act, ACT_WARRIOR))
            skill = ch->level > 30 ? ch->level : 0;
        else if (sn == gsn_disarm &&
             (IS_SET(off, OFF_DISARM) ||
              IS_SET(act, ACT_WARRIOR | ACT_THIEF)))
            skill = 20 + 3 * ch->level;
        else if (sn == gsn_grip &&
             (IS_SET(act, ACT_WARRIOR | ACT_THIEF)))
            skill = ch->level;
        else if ((sn == gsn_berserk || sn == gsn_tiger_power) &&
             IS_SET(off, OFF_BERSERK))
            skill = 3 * ch->level;
        else if (sn == gsn_kick)
            skill = 10 + 3 * ch->level;
        else if (sn == gsn_rescue)
            skill = 40 + ch->level;
        else if (sn == gsn_sword || sn == gsn_dagger ||
             sn == gsn_spear || sn == gsn_mace ||
             sn == gsn_axe || sn == gsn_flail ||
             sn == gsn_whip || sn == gsn_polearm ||
             sn == gsn_bow || sn == gsn_arrow || sn == gsn_lance)
            skill = 40 + 5 * ch->level / 2;
        else if (sn == gsn_crush && IS_SET(off, OFF_CRUSH))
            skill = 10 + 3 * ch->level;
        else
            skill = 0;
    }

    if (ch->daze >= 16)
    {
        if (sk->spell_fun)
            skill = URANGE(0, skill, 1);
        else
            skill = URANGE(0, skill, 40);
    } else if (ch->daze >= 8)
    {
        if (sk->spell_fun)
            skill = URANGE(0, skill, 10);
        else
            skill = URANGE(0, skill, 50);
    } else if (ch->daze >= 4)
    {
        if (sk->spell_fun)
            skill = URANGE(0, skill, 20);
        else
            skill = URANGE(0, skill, 60);
    }

    if (!IS_NPC(ch) && ch->pcdata->condition[COND_DRUNK]  > 10)
        skill = 9 * skill / 10;

    // GM :     .   ,   .
    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
    {
        if (IS_SET(ch->pIndexData->act, ACT_PET))
            skill = skill / 2;
        else
            skill = skill / 3;
    }

    // GM : tattoo Khorne cast. dur: 1.
    if (is_affected(ch, gsn_chaos_combat))
        skill = 3 * skill / 4;

    return URANGE(0, skill, 100);
}


/*
 * Lookup a skill by name.
 */
int sn_lookup(const char *name)
{
    int sn;

    if (IS_NULLSTR(name))
        return -1;

    for (sn = 0; sn < skills.nused; sn++)
        if (LOWER(name[0]) == LOWER(SKILL(sn)->name[0])
        &&  !str_prefix(name, SKILL(sn)->name))
            return sn;

    return -1;
}

int char_sn_lookup(CHAR_DATA *ch, const char *name)
{
    int i;

    if (IS_NULLSTR(name) || IS_NPC(ch))
        return -1;

    for (i = 0; i < ch->pcdata->learned.nused; i++) {
        pcskill_t *ps = VARR_GET(&ch->pcdata->learned, i);
        skill_t *skill;

        if (ps->percent == 0
        ||  (skill = skill_lookup(ps->sn)) == NULL
        ||  skill_level(ch, ps->sn) > ch->level)
            continue;

        if (!str_prefix(name, skill->name))
            return ps->sn;
    }

    return -1;
}

/* for returning weapon information */
int get_weapon_sn(OBJ_DATA *wield)
{
    int sn;

    if (wield == NULL)
        return gsn_hand_to_hand;

    if (wield->pIndexData->item_type != ITEM_WEAPON)
        return 0;

    switch (wield->value[0])
    {
      default :                   sn = -1;                break;
      case(WEAPON_SWORD):         sn = gsn_sword;         break;
      case(WEAPON_DAGGER):        sn = gsn_dagger;        break;
      case(WEAPON_SPEAR):         sn = gsn_spear;         break;
      case(WEAPON_MACE):          sn = gsn_mace;          break;
      case(WEAPON_AXE):           sn = gsn_axe;           break;
      case(WEAPON_FLAIL):         sn = gsn_flail;         break;
      case(WEAPON_WHIP):          sn = gsn_whip;          break;
      case(WEAPON_POLEARM):       sn = gsn_polearm;       break;
      case(WEAPON_BOW):           sn = gsn_bow;           break;
      case(WEAPON_ARROW):         sn = gsn_arrow;         break;
      case(WEAPON_LANCE):         sn = gsn_lance;         break;
      case(WEAPON_LIGHTSABER):    sn = gsn_lightsaber;    break;
    }
    return sn;
}

int get_weapon_skill(CHAR_DATA *ch, int sn)
{
     int sk;

/* -1 is exotic */
    if (sn == -1)
        sk = 3 * ch->level;
    else if (!IS_NPC(ch))
        sk = get_skill(ch, sn);
    else if (sn == gsn_hand_to_hand)
        sk = 40 + 2 * ch->level;
    else
        sk = 40 + 5 * ch->level / 2;

    return URANGE(0, sk, 100);
}

/*
 * Utter mystical words for an sn.
 */
void say_spell(CHAR_DATA *ch, int sn)
{
    const char *buf;
    CHAR_DATA *rch;
    skill_t *spell;
    bool m, v, g;
    int count;

    spell = SKILL(sn);
    count = 0;
    m = IS_SET(spell->flags, SKILL_MENTAL);
    v = IS_SET(spell->flags, SKILL_VERBAL);
    g = IS_SET(spell->flags, SKILL_GEST);
    if (v && g)
    {
        switch (spell->type)
        {
            case TYPE_SONG:
                buf = str_dup("sings and dances");
                break;
            default:
                buf = str_dup("chants and gestures");
        }
    }
    else if (v)
    {
        switch (spell->type)
        {
            case TYPE_SONG:
                buf = str_dup("sings");
                break;
            default:
                buf = str_dup("chants");
        }
    }
    else if (g)
    {
        switch (spell->type)
        {
            case TYPE_SONG:
                buf = str_dup("dances");
                break;
            default:
                buf = str_dup("gestures");
        }
    }
    else if (m)
        buf = str_dup("concentrates for a moment");
    else
        buf = str_dup(str_empty);

    if (v || g || m)
    {
        act("$n $t...", ch, buf, NULL, TO_ROOM | ACT_TRANS);
        free_string (buf);
    }
    else
    {
        free_string (buf);
        return;
    }

    for (rch = ch->in_room->people; rch; rch = rch->next_in_room)
    {
        if (rch == ch)
            continue;
        switch (spell->type)
        {
            case TYPE_SPELL:

            count = URANGE(5, 40*v + 35*g + 20*m, 95);
            if (number_percent() < (10+get_skill(rch, gsn_spell_craft))*count/110)
            {
                act("$n casts '$t'.", ch, spell->name, rch, TO_VICT);
                check_improve(rch, gsn_spell_craft, TRUE, 2);
            }
            break;

            case TYPE_POWER:

            count = URANGE(5, 20*v + 20*g + 50*m , 95);
            if(number_percent() < (5+get_skill(rch, gsn_psionics))*count/105)
            {
                act("$n concentrates on '$t'.", ch, spell->name, rch, TO_VICT);
                check_improve(rch, gsn_psionics, TRUE, 2);
            }
            break;

            case TYPE_MIRACLE:

            count = 20*v + 20*g + 20*m;
            if (ch->religion == rch->religion)
                count = count * 3/2;
            count = URANGE(5, count, 95);
            if (number_percent() < (15 + get_skill(rch, gsn_faith))*count/115)
            {
                act("$n prays for '$t'.", ch, spell->name, rch, TO_VICT);
                check_improve(rch, gsn_faith, TRUE, 2);
            }
            break;

            case TYPE_SONG:

            count = URANGE(5, 60*v + 30*g + 20*m ,95);

            if (number_percent() < (20+get_skill(rch, gsn_singing))*count/120)
            {
                act("$n sings '$t'.", ch, spell->name, rch, TO_VICT);
                check_improve(rch, gsn_singing, TRUE, 2);
            }
            break;

            case TYPE_PROGRAM:

            count = URANGE(5, 30*v + 30*g + 30*m ,95);

            if (number_percent() < (get_skill(rch, gsn_computers))*count/100)
            {
                act("$n executes '$t'.", ch, spell->name, rch, TO_VICT);
                check_improve(rch, gsn_computers, TRUE, 2);
            }
            break;
        }
    }
}

/* find min level of the skill for char */
int skill_level(CHAR_DATA *ch, int sn)
{
    int slevel = LEVEL_IMMORTAL;
    skill_t *skill;
    clan_t *clan;
    clan_skill_t *clan_skill;
    class_t *class;
    class_skill_t *class_skill;
    race_t *race;
    race_skill_t *race_skill;
    religion_t *religion;
    religion_skill_t *religion_skill;

    // noone can use ill-defined skills
    // broken chars can't use any skills 
    if (IS_NPC(ch)
    ||  (skill = skill_lookup(sn)) == NULL
    ||  (class = class_lookup(ch->class)) == NULL
    ||  (race = race_lookup(ch->race)) == NULL
    ||  (religion = religion_lookup(ch->religion)) == NULL
    ||  !race->pcdata)
        return slevel;

    if ((clan = clan_lookup(ch->clan))
    &&  (clan_skill = clan_skill_lookup(clan, sn)))
        slevel = UMIN(slevel, clan_skill->level);

    if ((class_skill = class_skill_lookup(class, sn)))
    {
        slevel = UMIN(slevel, class_skill->level);
        if (is_name(skill->name, race->pcdata->bonus_skills))
            slevel = UMIN(slevel, 1);
    }

    if ((race_skill = race_skill_lookup(race, sn)))
        slevel = UMIN(slevel, race_skill->level);

    if ((religion_skill = religion_skill_lookup(religion, sn)))
        slevel = UMIN(slevel, religion_skill->level);

    if (IS_SET(skill->flags, SKILL_HIDDEN))
    {
        if (get_percent(ch, sn) < 2)
            slevel = LEVEL_IMMORTAL;
        // Welesh: wrong thing, but... I can't understand how we can properly show 
        // hidden skills to char... especially to char with setted skills
        // todo: set 'extraordinary' flag to all psionic powers (!)
        else if (IS_SET (skill->group, GROUP_FISHING) && slevel == LEVEL_IMMORTAL)
            slevel = 1;
    }

    return slevel;
}

/*
 * assumes !IS_NPC(ch) && ch->level >= skill_level(ch, sn)
 */
int mana_cost(CHAR_DATA *ch, int sn)
{
    skill_t *sk;
    int result;

    if ((sk = skill_lookup(sn)) == NULL)
        return 0;

    if((IS_SKILL(sn) || IS_AUTOSKILL(sn)) && (sk->min_mana == 0))
        return 0;
    else
    {
        result = UMAX(sk->min_mana,  100 / UMAX(1, 2 + ch->level - skill_level(ch, sn)) );
        // some ajustments to balance tattooes
        if (IS_SET(sk->group, GROUP_TATTOO | GROUP_RITUAL))
        {
            if (ch->level > 90)
                result *= 4;
            else if (ch->level > 60)
                result *= 3;
            else if (ch->level > 30)
                result *= 2;
        }

        return result;
    }
}
void *skill_vlookup(varr *v, const char *name)
{
   return skill_vlookup_type(v, name, -1);
}

void *skill_vlookup_type(varr *v, const char *name, int type)
{
    int i;

    if (IS_NULLSTR(name))
        return NULL;

    for (i = 0; i < v->nused; i++)
    {
        skill_t *skill;
        int *psn = (int*) VARR_GET(v, i);

        if ((skill = skill_lookup(*psn))
           &&  !str_prefix(name, skill->name)
           &&  (type == -1 || skill->type == type))
            return psn;
    }

    return NULL;
}
