/*  $Id: skills.h,v 1.666 2004/09/20 10:49:53 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#ifndef _SKILLS_H_
#define _SKILLS_H_

/*----------------------------------------------------------------------
 * skills stuff
 */

#define SKILL_CLAN                  (A) // skill is clan power of some clan
#define SKILL_RANGE                 (B) // can be used at distant victims
#define SKILL_AREA_ATTACK           (C) // affects all people in room
#define SKILL_SCRIBE                (D) // can be written on scrolls
#define SKILL_MENTAL                (E) // mental component required
#define SKILL_VERBAL                (F) // verbal component required
#define SKILL_GEST                  (G) // somatic component required
#define SKILL_NODISPEL              (H) // affect can't be dispelled
#define SKILL_QUESTIONABLE          (I) // check for trust(ch, victim)
#define SKILL_EXTRAORDINARY         (J) // don't change with 'set skill all'
#define SKILL_HIDDEN                (K) // char can't see or use it until
                                        // something changes
#define SKILL_CONTACT_REQUIRED      (L) // requires contact with victim
#define SKILL_MINDLINK_REQUIRED     (M) // requires mindlink with victim
#define SKILL_NOARENA               (N) // can't be used on/at the battle arena
#define SKILL_VAMPIRE               (O) // vampires can use it only in vamp. form

struct skill_t
{
      const char         *name;         /* skill name                                         !+ */
      SPELL_FUN          *spell_fun;    /* spell function, for spells/abilities/powers/etc    !+ */
      DO_FUN             *do_fun;       /* do function, for skills/abilities                  !+ */
      flag32_t            target;       /* legal target                                       !+ */
      flag32_t            min_pos;      /* position for caster                                !+ */
      int                *pgsn;         /* pointer to gsn                                     !+ */
      int                 slot;         /* slot for #OBJOLD loading                              */
      int                 min_mana;     /* min mana used                                      !+ */
      int                 initial;      /* initial psi cost                                   !+ */
      int                 maintain;     /* maintain psi cost (per tick)                       !+ */
      int                 clan_energy;  /* cost of clan energey                                  */ //TODO:   
      int                 delay;        /* waiting time before use                            !+ */
      int                 beats;        /* waiting time after use                             !+ */
      const char *        noun_damage;  /* damage message                                     !+ */
      const char *        noun_rus;     /* damage message                                     !+ */
      const char *        msg_off;      /* wear off message                                   !+ */
      const char *        msg_off_other;/* wear off message for others                        !+ */
      const char *        msg_obj;      /* wear off message for obj                           !+ */
      int                 flags;        /* skill flags                                        !+ */
      flag64_t            group;        /* skill group                                        !+ */
      flag32_t            discipline;   /* psionic discipline, in case of powers              !+ */
      int                 learnmult[2]; /* skill improvement multipl.                         !+ */
      int                 gender;       /* msg type 0-, 1-,                           +! */
      int                 stat1;        /* stats that affect                                  !+ */
      int                 stat2;        /* success of this spell/skill                        !+ */
      int                 stat3;        /*                                                    !+ */
      int                 type;         /*                                                    !+ */
      int                 bonus;        /* shift                                              !  */
};

extern varr skills;

#define HAS_SKILL(ch, sn)     (skill_level(ch, sn) < LEVEL_IMMORTAL)

#define SKILL(sn)             ((skill_t*) VARR_GET(&skills, sn))
#define skill_lookup(sn)      ((skill_t*) varr_get(&skills, sn))

skill_t *         skill_new   (void);
void              skill_free  (skill_t *skill);
const char *      skill_name  (int sn);
int               sn_lookup   (const char *name);

/* lookup skill by name in skill list */
void *            skill_vlookup            (varr *v, const char *name);
void *            skill_vlookup_type       (varr *v, const char *name, int type);

int               get_weapon_sn            (OBJ_DATA *obj);
int               get_weapon_skill         (CHAR_DATA *ch, int sn);

int               get_skill                (CHAR_DATA *ch, int sn);
int               get_percent              (CHAR_DATA *ch, int sn);
void              set_skill                (CHAR_DATA *ch, int sn, int value);
void              set_skill_raw            (CHAR_DATA *ch, int sn, int value, bool repl);
int               skill_level              (CHAR_DATA *ch, int sn);

void              update_special_skills    (CHAR_DATA *ch, bool upd_fishing);
void              update_skills            (CHAR_DATA *ch);

int               mana_cost                (CHAR_DATA *ch, int sn);
void              say_spell                (CHAR_DATA *ch, int sn);

int               base_exp                 (CHAR_DATA *ch);
int               exp_to_level             (CHAR_DATA *ch);
int               exp_for_level            (CHAR_DATA *ch, int level);
void              check_improve            (CHAR_DATA *ch, int sn, bool success, int mult);
int               group_lookup             (const char *name);

int               get_max_skill            (CHAR_DATA *ch, int sn);

void              make_spellbane           (CHAR_DATA *ch, CHAR_DATA *victim, int mult);
#endif
