/* $Id: special.c,v 1.666 2004/09/20 10:49:53 shrike Exp $                             */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/
 
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"
#include "fight.h"
#include "obj_prog.h"
#include "wanderers.h"

/* command procedures needed */
DECLARE_DO_FUN(do_yell      );
DECLARE_DO_FUN(do_open      );
DECLARE_DO_FUN(do_close     );
DECLARE_DO_FUN(do_say       );
DECLARE_DO_FUN(do_backstab  );
DECLARE_DO_FUN(do_bandage   );
DECLARE_DO_FUN(do_flee      );
DECLARE_DO_FUN(do_tell      );
DECLARE_DO_FUN(do_track     );
DECLARE_DO_FUN(do_murder    );
DECLARE_DO_FUN(do_kill      );
DECLARE_DO_FUN(do_unlock    );
DECLARE_DO_FUN(do_lock      );
DECLARE_DO_FUN(do_drop      );
DECLARE_DO_FUN(do_eat       );
DECLARE_DO_FUN(do_get       );
DECLARE_DO_FUN(do_north     );
DECLARE_DO_FUN(do_south     );
DECLARE_DO_FUN(do_east      );
DECLARE_DO_FUN(do_west      );
DECLARE_DO_FUN(do_sacrifice );
DECLARE_DO_FUN(do_give      );
DECLARE_DO_FUN(do_rescue    );
DECLARE_DO_FUN(do_assassinate   );
DECLARE_DO_FUN(do_arrest    );
DECLARE_DO_FUN(do_wake      );
DECLARE_DO_FUN(do_quit_count    );
DECLARE_DO_FUN(do_look      );
DECLARE_DO_FUN(find_exit    );
DECLARE_DO_FUN(do_eat       );


void agent_net_printf(CHAR_DATA *ch, CHAR_DATA *victim, int);

/*
 * The following special functions are available for mobiles.
 */

DECLARE_SPEC_FUN(spec_breath_any        );
DECLARE_SPEC_FUN(spec_breath_acid       );
DECLARE_SPEC_FUN(spec_breath_fire       );
DECLARE_SPEC_FUN(spec_breath_frost      );
DECLARE_SPEC_FUN(spec_breath_gas        );
DECLARE_SPEC_FUN(spec_breath_lightning  );
DECLARE_SPEC_FUN(spec_cast_adept        );
DECLARE_SPEC_FUN(spec_cast_cleric       );
DECLARE_SPEC_FUN(spec_cast_judge        );
DECLARE_SPEC_FUN(spec_cast_mage         );
DECLARE_SPEC_FUN(spec_cast_beholder     );
DECLARE_SPEC_FUN(spec_cast_undead       );
DECLARE_SPEC_FUN(spec_cast_seneschal    );
DECLARE_SPEC_FUN(spec_executioner       );
DECLARE_SPEC_FUN(spec_fido              );
DECLARE_SPEC_FUN(spec_guard             );
DECLARE_SPEC_FUN(spec_jailer            );
DECLARE_SPEC_FUN(spec_janitor           );
DECLARE_SPEC_FUN(spec_mayor             );
DECLARE_SPEC_FUN(spec_poison            );
DECLARE_SPEC_FUN(spec_thief             );
DECLARE_SPEC_FUN(spec_nasty             );
DECLARE_SPEC_FUN(spec_troll_member      );
DECLARE_SPEC_FUN(spec_ogre_member       );
DECLARE_SPEC_FUN(spec_patrolman         );
DECLARE_SPEC_FUN(spec_cast_clan         );
DECLARE_SPEC_FUN(spec_stalker           );
DECLARE_SPEC_FUN(spec_special_guard     );
DECLARE_SPEC_FUN(spec_assassinater      );
DECLARE_SPEC_FUN(spec_captain           );
DECLARE_SPEC_FUN(spec_headlamia         );
DECLARE_SPEC_FUN(spec_powerman          );
DECLARE_SPEC_FUN(spec_exterminator      );
DECLARE_SPEC_FUN(spec_r2d2              );
DECLARE_SPEC_FUN(spec_stormtrooper      );
DECLARE_SPEC_FUN(spec_bot               );
DECLARE_SPEC_FUN(spec_cast_animated     );
DECLARE_SPEC_FUN(spec_cast_animated2    );
DECLARE_SPEC_FUN(spec_decap             );
DECLARE_SPEC_FUN(spec_protector         );
DECLARE_SPEC_FUN(spec_horn_prick        );
DECLARE_SPEC_FUN(spec_hydra             );
DECLARE_SPEC_FUN(spec_fire_dragon       );
DECLARE_SPEC_FUN(spec_ice_dragon        );

/* the function table */
const   struct  spec_type    spec_table[] =
{
    { "spec_breath_any",         spec_breath_any          },
    { "spec_breath_acid",        spec_breath_acid         },
    { "spec_breath_fire",        spec_breath_fire         },
    { "spec_breath_frost",       spec_breath_frost        },
    { "spec_breath_gas",         spec_breath_gas          },
    { "spec_breath_lightning",   spec_breath_lightning    },
    { "spec_cast_adept",         spec_cast_adept          },
    { "spec_cast_cleric",        spec_cast_cleric         },
    { "spec_cast_judge",         spec_cast_judge          },
    { "spec_cast_mage",          spec_cast_mage           },
    { "spec_cast_seneschal",     spec_cast_seneschal      },
    { "spec_cast_beholder",      spec_cast_beholder       },
    { "spec_cast_undead",        spec_cast_undead         },
    { "spec_executioner",        spec_executioner         },
    { "spec_fido",               spec_fido                },
    { "spec_guard",              spec_guard               },
    { "spec_jailer",             spec_jailer              },
    { "spec_janitor",            spec_janitor             },
    { "spec_mayor",              spec_mayor               },
    { "spec_poison",             spec_poison              },
    { "spec_thief",              spec_thief               },
    { "spec_nasty",              spec_nasty               },
    { "spec_troll_member",       spec_troll_member        },
    { "spec_ogre_member",        spec_ogre_member         },
    { "spec_patrolman",          spec_patrolman           },
    { "spec_cast_clan",          spec_cast_clan           },
    { "spec_stalker",            spec_stalker             },
    { "spec_special_guard",      spec_special_guard       },
    { "spec_assassinater",       spec_assassinater        },
    { "spec_captain",            spec_captain             },
    { "spec_headlamia",          spec_headlamia           },
    { "spec_powerman",           spec_powerman            },
    { "spec_exterminator",       spec_exterminator        },
    { "spec_r2d2",               spec_r2d2                },
    { "spec_stormtrooper",       spec_stormtrooper        },
    { "spec_bot",                spec_bot                 },
    { "spec_cast_animated",      spec_cast_animated       },
    { "spec_cast_animated2",     spec_cast_animated2      },
    { "spec_decap",              spec_decap               },
    { "spec_protector",          spec_protector           },

    { "spec_wandering_necr",     spec_wandering_necr      },
    { "spec_created_golem",      spec_created_golem       },

    { "spec_horn_prick",         spec_horn_prick          },
    { "spec_hydra",              spec_hydra               },

    { "spec_fire_dragon",        spec_fire_dragon         },
    { "spec_ice_dragon",         spec_ice_dragon          },

    { NULL }
};

static bool dragon(CHAR_DATA *ch, const char *spell_name);
void spec_cast(CHAR_DATA *ch, const char *spell_name, CHAR_DATA *victim);

/*
 * Given a name, return the appropriate spec fun.
 */
SPEC_FUN *spec_lookup(const char *name)
{
     int i;

     for (i = 0; spec_table[i].name != NULL; i++) {
        if (LOWER(name[0]) == LOWER(spec_table[i].name[0])
        &&  !str_prefix(name,spec_table[i].name))
            return spec_table[i].function;
     }

    return 0;
}

char *spec_name(SPEC_FUN *function)
{
    int i;

    for (i = 0; spec_table[i].function != NULL; i++) {
        if (function == spec_table[i].function)
            return spec_table[i].name;
    }

    return NULL;
}

bool spec_troll_member(CHAR_DATA *ch)
{
    CHAR_DATA *vch, *victim = NULL;
    int count = 0;
    char *message;

    if (!IS_AWAKE(ch) || IS_AFFECTED(ch,AFF_CALM) || ch->in_room == NULL
    ||  IS_AFFECTED(ch,AFF_CHARM) || ch->fighting != NULL)
        return FALSE;

    /* find an ogre to beat up */
    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room) {
        if (!IS_NPC(vch) || ch == vch)
            continue;

        if (vch->pIndexData->vnum == MOB_VNUM_PATROLMAN)
            return FALSE;

        if (vch->pIndexData->group == GROUP_VNUM_OGRES
        &&  ch->level > vch->level - 2 && !is_safe(ch,vch)) {
            if (number_range(0,count) == 0)
                victim = vch;

            count++;
        }
    }

    if (victim == NULL)
        return FALSE;

    /* say something, then raise hell */
    switch (number_range(0, 6)) {
    default:message = NULL;
        break;
    case 0: message = "$n  '  , !'";
        break;
    case 1: message = "  , $n  $N.";
        break;
    case 2: message =
        "$n  '    , ?'";
        break;
    case 3: message = "$n     ' ?'";
        break;
    case 4: message = "$n  '  ,       !'";
        break;
    case 5: message = "$n  '       , !'";
        break;
    case 6: message = "$n  '  ,    ?'";
        break;
    }

    if (message)
        act(message,ch,NULL,victim,TO_ALL);
    multi_hit(ch, victim, TYPE_UNDEFINED);
    return TRUE;
}

bool spec_ogre_member(CHAR_DATA *ch)
{
    CHAR_DATA *vch, *victim = NULL;
    int count = 0;
    char *message;

    if (!IS_AWAKE(ch) || IS_AFFECTED(ch,AFF_CALM) || ch->in_room == NULL
    ||  IS_AFFECTED(ch,AFF_CHARM) || ch->fighting != NULL)
        return FALSE;

    /* find an troll to beat up */
    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room) {
        if (!IS_NPC(vch) || ch == vch)
            continue;

        if (vch->pIndexData->vnum == MOB_VNUM_PATROLMAN)
            return FALSE;

        if (vch->pIndexData->group == GROUP_VNUM_TROLLS
        &&  ch->level > vch->level - 2 && !is_safe(ch,vch)) {
            if (number_range(0,count) == 0)
                victim = vch;

            count++;
        }
    }

    if (victim == NULL)
        return FALSE;

    /* say something, then raise hell */
    switch (number_range(0, 6)) {
    default:message = NULL;
        break;
    case 0: message = "$n  '   , !'";
        break;
    case 1: message = "  , $n   $N.'";
        break;
    case 2: message =
        "$n  '    ?'";
        break;
    case 3: message = "$n     '   ?'";
        break;
    case 4: message = "$n  '     ,    !'";
        break;
    case 5: message = "$n  '   , .'";
        break;
    case 6: message = "$n  ' ,   !'";
        break;
    }

    if (message)
        act(message, ch, NULL, victim, TO_ALL);
    multi_hit(ch, victim, TYPE_UNDEFINED);
    return TRUE;
}

bool spec_patrolman(CHAR_DATA *ch)
{
    CHAR_DATA *vch,*victim = NULL;
    OBJ_DATA *obj;
    char *message;
    int count = 0;

    if (!IS_AWAKE(ch) || IS_AFFECTED(ch,AFF_CALM) || ch->in_room == NULL
    ||  IS_AFFECTED(ch,AFF_CHARM) || ch->fighting != NULL)
        return FALSE;

    /* look for a fight in the room */
    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room) {
        if (vch == ch)
            continue;

        if (vch->fighting != NULL) { /* break it up! */
            if (number_range(0,count) == 0)
                victim = (vch->level > vch->fighting->level) ?
                     vch : vch->fighting;
            count++;
        }
    }

    if (victim == NULL
    ||  (IS_NPC(victim) && victim->spec_fun == ch->spec_fun))
        return FALSE;

    if ((obj = get_eq_char(ch,WEAR_NECK_1)) != NULL &&
         obj->pIndexData->vnum == OBJ_VNUM_WHISTLE) {
        act("You blow down hard on $p.", ch, obj, NULL, TO_CHAR);
        act("$n blows on $p, ***WHEEEEEEEEEEEET***",
            ch, obj, NULL, TO_ROOM);

        for (vch = char_list; vch != NULL; vch = vch->next) {
                if (vch->in_room == NULL)
                continue;

            if (vch->in_room != ch->in_room
            &&  vch->in_room->area == ch->in_room->area)
                act("You hear a shrill whistling sound.", vch, NULL, NULL, TO_CHAR);
        }
    }

    switch (number_range(0,6)) {
    default:message = NULL;
        break;
    case 0: message = "$n  ', , !'";
        break;
    case 1: message =
        "$n  'Society's to blame, but what's a bloke to do?'";
        break;
    case 2: message =
        "$n mumbles 'bloody kids will be the death of us all.'";
        break;
    case 3: message = "$n  '! !'  .";
        break;
    case 4: message = "$n pulls out his billy and goes to work.";
        break;
    case 5: message =
        "$n sighs in resignation and proceeds to break up the fight.";
        break;
    case 6: message = "$n  ', !'";
        break;
    }

    if (message)
        act(message, ch, NULL, NULL, TO_ALL);

    multi_hit(ch, victim, TYPE_UNDEFINED);
    return TRUE;
}

/*
 * Special procedures for mobiles.
 */
bool spec_breath_any(CHAR_DATA *ch)
{
    if (ch->position != POS_FIGHTING)
        return FALSE;

    switch (number_bits(3)) {
    case 0: return spec_breath_fire     (ch);
    case 1:
    case 2: return spec_breath_lightning    (ch);
    case 3: return spec_breath_gas      (ch);
    case 4: return spec_breath_acid     (ch);
    case 5:
    case 6:
    case 7: return spec_breath_frost    (ch);
    }

    return FALSE;
}

bool spec_breath_acid(CHAR_DATA *ch)
{
    return dragon(ch, "acid breath");
}

bool spec_breath_fire(CHAR_DATA *ch)
{
    return dragon(ch, "fire breath");
}

bool spec_breath_frost(CHAR_DATA *ch)
{
    return dragon(ch, "frost breath");
}

bool spec_breath_gas(CHAR_DATA *ch)
{
    return dragon(ch, "gas breath");
}

bool spec_breath_lightning(CHAR_DATA *ch)
{
    return dragon(ch, "lightning breath");
}

bool spec_cast_adept(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;

    if (!IS_AWAKE(ch))
        return FALSE;

    for (victim = ch->in_room->people; victim != NULL; victim = v_next) {
        v_next = victim->next_in_room;
        if (victim != ch
        &&  can_see(ch, victim)
        &&  number_bits(1) == 0
        &&  !IS_NPC(victim)
        &&  victim->level < 10)
            break;
    }

    if (victim == NULL)
        return FALSE;

    switch (number_bits(4)) {
    case 0:
        act("$n   '$t'.", ch, "", NULL, TO_ROOM);
        spell_armor(sn_lookup("armor"), ch->level, ch, victim,
                TARGET_CHAR);
        return TRUE;

    case 1:
        act("$n   '$t'.", ch, "", NULL, TO_ROOM);
        spell_bless(sn_lookup("bless"), ch->level, ch, victim,
                TARGET_CHAR);
        return TRUE;

    case 2:
        act("$n   '$t'.",
            ch, " ", NULL, TO_ROOM);
        spell_cure_blindness(sn_lookup("cure blindness"),
                     ch->level, ch, victim, TARGET_CHAR);
        return TRUE;

    case 3:
          act("$n   '$t'.",
              ch, " ", NULL, TO_ROOM);

        victim->hit += (victim->level + (ch->level/4));
        victim->hit = UMIN(victim->hit,victim->max_hit);

        return TRUE;

    case 4:
        act("$n   '$t'.",
            ch, " ", NULL, TO_ROOM);
        spell_cure_poison(sn_lookup("cure poison"),
                  ch->level, ch, victim, TARGET_CHAR);
    return TRUE;

    case 5:
        act("$n   '$t'.",
            ch, "", NULL, TO_ROOM);
        spell_refresh(sn_lookup("refresh"),
                  ch->level, ch, victim, TARGET_CHAR);
        return TRUE;

    case 6:
        act("$n utters the words, '$t'.",
            ch, " ", NULL, TO_ROOM);
        spell_cure_disease(sn_lookup("cure disease"),
                   ch->level, ch, victim, TARGET_CHAR);
    }

    return FALSE;
}

bool spec_stormtrooper(CHAR_DATA *ch) {
    return FALSE;
}

bool spec_r2d2(CHAR_DATA *ch) {
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
    char *spell = NULL;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;
        if ( (ch->master && victim->fighting == ch->master)
        || ch->fighting == victim || victim->fighting == ch)
            break;
    }

    if (victim == NULL)
        return FALSE;

    if (number_bits(3) <= 2) spell="flamestrike";
    else if (number_bits(3) <= 2) spell = "acid arrow";
    if (spell) spec_cast(ch, spell, victim);
    return TRUE;

}

bool spec_cast_cleric(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
    char *spell;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;
        if (victim->fighting == ch && number_bits(2) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    for (;;) {
        int min_level;

        switch (number_bits(4)) {
        case  0: min_level =  0; spell = "blindness";      break;
        case  1: min_level =  3; spell = "cause serious";  break;
        case  2: min_level =  7; spell = "earthquake";     break;
        case  3: min_level =  9; spell = "cause critical"; break;
        case  4: min_level = 10; spell = "dispel evil";    break;
        case  5: min_level = 12; spell = "curse";          break;
        case  6: min_level = 12; spell = "change sex";     break;
        case  7: min_level = 13; spell = "flamestrike";    break;
        case  8: min_level = 13; spell = "flamestrike";    break;
        case  9: 
        case 10: min_level = 15; spell = "harm";           break;
        case 11: min_level = 15; spell = "plague";     break;
        default: min_level = 16; spell = "dispel magic";   break;
        }

        if (ch->level >= min_level)
            break;
    }

    spec_cast(ch, spell, victim);
    return TRUE;
}

bool spec_cast_judge(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;
        if (victim->fighting == ch && number_bits(2) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    spec_cast(ch, "high explosive", victim);
    return TRUE;
}

bool spec_cast_mage(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
    char *spell;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;
        if (victim->fighting == ch && number_bits(2) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    for (;;) {
        int min_level;

        switch (number_bits(4)) {
        case  0: min_level =  0; spell = "blindness";      break;
        case  1: min_level =  3; spell = "chill touch";    break;
        case  2: min_level =  7; spell = "weaken";         break;
        case  3: min_level =  8; spell = "teleport";       break;
        case  4: min_level = 11; spell = "colour spray";   break;
        case  5: min_level = 12; spell = "change sex";     break;
        case  6: min_level = 13; spell = "energy drain";   break;
        case  7: min_level = 14; spell = "shocking grasp"; break;
        case  8: min_level = 14; spell = "burning hands";  break;
        case  9: min_level = 15; spell = "fireball";       break;
        case 10: min_level = 20; spell = "plague";     break;
        default: min_level = 20; spell = "acid blast";     break;
        }

        if (ch->level >= min_level)
            break;
    }

    spec_cast(ch, spell, victim);
    return TRUE;
}

bool spec_cast_seneschal(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
    char *spell;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;
        if ((victim->fighting == ch && number_bits(2) == 0)
        || (ch->fighting == victim && number_bits(1)))
            break;
    }

    if (victim == NULL)
        return FALSE;

    switch (dice(1, 16)) {
    case  0: spell = "blindness";      break;
    case  1: spell = "dispel magic";    break;
    case  2: spell = "weaken";         break;
    case  3: spell = "blindness";      break;
    case  4: spell = "acid arrow";   break;
    case  5: spell = "fireball";     break;
    case  6: spell = "energy drain";   break;
    case  7: spell = "chill touch"; break;
    case  8: spell = "magic missile";  break;
    case  9: spell = "acid blast";       break;
    case 10: spell = "plague";     break;
    case 11: spell = "acid blast";         break;
    case 12: spell = "shocking grasp";   break;
    case 13: spell = "lightning breath";  break;
    case 14: spell = "burning hands"; break;
    case 15: spell = "colour spray";    break;
    default: return FALSE;
    }

    spec_cast(ch, spell, victim);
    return TRUE;
}

bool spec_cast_undead(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
    char *spell;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;
        if (victim->fighting == ch && number_bits(2) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    for (;;) {
        int min_level;

        switch (number_bits(4)) {
        case  0: min_level =  0; spell = "curse";          break;
        case  1: min_level =  3; spell = "weaken";         break;
        case  2: min_level =  6; spell = "chill touch";    break;
        case  3: min_level =  9; spell = "blindness";      break;
        case  4: min_level = 12; spell = "poison";         break;
        case  5: min_level = 15; spell = "energy drain";   break;
        case  6: min_level = 18; spell = "harm";           break;
        case  7: min_level = 21; spell = "teleport";       break;
        case  8: min_level = 20; spell = "plague";     break;
        default: min_level = 18; spell = "harm";           break;
        }

        if (ch->level >= min_level)
            break;
    }

    spec_cast(ch, spell, victim);
    return TRUE;
}

bool spec_executioner(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;

    if (!IS_AWAKE(ch) || ch->fighting != NULL)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;

        if (!IS_NPC(victim) && IS_SET(victim->plr_flags, PLR_WANTED)
        &&  can_see(ch, victim)) 
            break;
    }

    if (victim == NULL)
        return FALSE;

    act_yell(ch, "$i !  !   !!!!", victim, NULL);
    agent_net_printf(ch, victim, ANET_WANTED_FOUND);
    multi_hit(ch, victim, TYPE_UNDEFINED);
    return TRUE;
}

bool spec_fido(CHAR_DATA *ch)
{
    OBJ_DATA *corpse;
    OBJ_DATA *c_next;
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;

    if (IS_AFFECTED(ch, AFF_CHARM))
        return FALSE;

    if (!IS_AWAKE(ch) || ch->fighting != NULL)
        return FALSE;

    for (corpse = ch->in_room->contents; corpse; corpse = c_next) {
        c_next = corpse->next_content;
        if (corpse->pIndexData->item_type != ITEM_CORPSE_NPC)
            continue;

        act("$n  .", ch, NULL, NULL, TO_ROOM);
        for (obj = corpse->contains; obj; obj = obj_next) {
            obj_next = obj->next_content;
            obj_from_obj(obj);
            obj_to_room(obj, ch->in_room);
        }
        extract_obj(corpse);
        return TRUE;
    }

    return FALSE;
}

bool spec_janitor(CHAR_DATA *ch)
{
    OBJ_DATA *trash;
    OBJ_DATA *trash_next;

    if (!IS_AWAKE(ch))
    return FALSE;

    if (IS_AFFECTED(ch, AFF_CHARM))
        return FALSE;

    for (trash = ch->in_room->contents; trash != NULL; trash = trash_next) {
        trash_next = trash->next_content;
        if (!IS_SET(trash->wear_flags, ITEM_TAKE)
        || !can_loot(ch, trash)
        || trash->pIndexData->item_type == ITEM_CORPSE_PC)
            continue;
/*
        if (!can_get_obj(ch, trash, TRUE))
            get_obj(ch, trash, NULL, TRUE);
*/

        if (trash->pIndexData->item_type == ITEM_DRINK_CON
        ||  trash->pIndexData->item_type == ITEM_TRASH
        ||  trash->cost < 10
        ||  trash->weight < 50) {
            act("$n  .", ch, NULL, NULL, TO_ROOM);
            obj_from_room(trash);
            obj_to_char(trash, ch);
            oprog_call(OPROG_GET, trash, ch, NULL);
            return TRUE;
        }
    }

    return FALSE;
}

static void go_luzhki(CHAR_DATA *ch)
{
    ROOM_INDEX_DATA *room;

    room = get_room_index(3138);
    if (room != ch->in_room) {
        interpret(ch, "grin");
        act("$n   .", ch, NULL,NULL, TO_ROOM);
        char_from_room(ch);
        char_to_room(ch, room);
        act("$n   .", ch, NULL, NULL, TO_ROOM);
    }
    return;
}

bool spec_mayor(CHAR_DATA *ch)
{

    static const char open_path[] =
"W3a300300b0c000d111Oe333333Oe00000111Oe11122222222222222333Oe33300022c00112212111f1S.";
/*      "W3a300300b0c000d111Oe333333Oe22c2222112212111a1S.";*/

    static const char close_path[] =
"W3a300300b0c000d111CE333333CE00000111CE11122222222222222333CE33300022c00112212111f1S.";
/*      "W3a300300b0c000d111CE333333CE22c2222112212111a1S.";*/

    static const char *path;
    static int pos;
    static bool move;
    static char *door;
    OBJ_DATA *key;

    if (!move) {
        if (time_info.hour ==  6) {
            path = open_path;
            move = TRUE;
            pos  = 0;
        }

        if (time_info.hour == 20) {
            path = close_path;
            move = TRUE;
            pos  = 0;
        }
    }

    if (!move || ch->position < POS_SLEEPING)
        return FALSE;

    switch (path[pos]) {
    case '0':
    case '1':
    case '2':
    case '3':
        move_char(ch, path[pos] - '0', FALSE);
        break;

    case 'W':
        ch->position = POS_STANDING;
        act("$n    .", ch, NULL, NULL, TO_ROOM);
        break;

    case 'S':
        go_luzhki(ch);
        interpret(ch, "yawn");
        ch->position = POS_SLEEPING;
        act("$n   .", ch, NULL, NULL, TO_ROOM);
        break;

    case 'a':
        act_say(ch, " !", NULL);
        break;

    case 'b':
        act_say(ch, "  !   -    !", NULL);
        break;

    case 'c':
        act_say(ch, "!      !", NULL);
        break;

    case 'd':
        if (ch->in_room->vnum != 3014)
            go_luzhki(ch);
        else
            act_say(ch, " , !", NULL);
        break;

    case 'e':
        act_say(ch, "     !", NULL);
        break;

    case 'f':
        if (ch->in_room->vnum != 3137)
            go_luzhki(ch);
        else
            act_say(ch, ",     ,   !", NULL);
        break;

    case 'E':
        act_say(ch, "     !", NULL);
        break;

    case 'O':
        switch(ch->in_room->vnum) {
            case 3041: door = "east"; break;
            case 3040: door = "west"; break;
            case 3255: door = "south"; break;
            case 3262: door = "north"; break;
            default :   door = NULL;
                    go_luzhki(ch);
                pos = strlen(path);
                move = FALSE;
                break;
        }
        if (!door)
            break;
        for(key = ch->in_room->contents; key; key = key->next_content)
            if (key->pIndexData->vnum == 3379)
                break;

            if (key) {
                SET_BIT(key->wear_flags, ITEM_TAKE);
                obj_from_room(key);
                obj_to_char(key, ch);
                interpret(ch, "emote    .");
            }
            else
                act_say(ch, "  ?!   !", NULL);

        do_open(ch, door);
        break;

    case 'C':
        switch(ch->in_room->vnum) {
            case 3041: door = "east"; break;
            case 3040: door = "west"; break;
            case 3255: door = "south"; break;
            case 3262: door = "north"; break;
            default :   door = NULL;
                    go_luzhki(ch);
                pos = strlen(path);
                move = FALSE;
                break;
        }
        if (!door)
            break;
        for(key = ch->in_room->contents; key; key = key->next_content)
            if (key->pIndexData->vnum == 3379)
                break;
        if (!key) {
            for(key = ch->carrying; key; key = key->next_content)
                if (key->pIndexData->vnum == 3379)
                    break;
            if (!key)
                key = create_obj(get_obj_index(3379), 0);
            else
                obj_from_char(key);
            obj_to_room(key, ch->in_room);
            REMOVE_BIT(key->wear_flags, ITEM_TAKE);
        }
        do_close(ch, door);
        interpret(ch, "emote    .");
        break;

    case '.' :
        move = FALSE;
        break;
    }

    pos++;
    return FALSE;
}

bool spec_poison(CHAR_DATA *ch)
{
    CHAR_DATA *victim;

    if (ch->position != POS_FIGHTING
    ||  (victim = ch->fighting) == NULL
    ||  victim->in_room != ch->in_room
    ||  number_percent() > 2 * ch->level)
        return FALSE;

    act_puts("  $N!", ch, NULL, victim, TO_CHAR, POS_DEAD);
    act("$n bites $N!", ch, NULL, victim, TO_NOTVICT);
    act_puts("$n  !", ch, NULL, victim, TO_VICT, POS_DEAD);
    spell_poison(gsn_poison, ch->level, ch, victim,TARGET_CHAR);
    return TRUE;
}

bool spec_thief(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
    long gold,silver;

    if (ch->position != POS_STANDING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;

        if (IS_NPC(victim)
        ||  victim->level >= LEVEL_IMMORTAL
        ||  number_bits(5) != 0
        ||  !can_see(ch,victim))
            continue;

        if (IS_AWAKE(victim) && number_range(0, ch->level) == 0) {
            act(" ,  $n $gn{}    !",
                ch, NULL, victim, TO_VICT);
            act("$N   $c1{$n}   !",
                ch, NULL, victim, TO_NOTVICT);
            return TRUE;
        }
        else {
            gold = victim->gold * UMIN(number_range(1, 20),
                           ch->level / 2) / 100;
            gold = UMIN(gold, ch->level * ch->level * 10);
            ch->gold     += gold;
            victim->gold -= gold;
            silver = victim->silver * UMIN(number_range(1, 20),
                               ch->level / 2) / 100;
            silver = UMIN(silver, ch->level * ch->level * 25);
            ch->silver     += silver;
            victim->silver -= silver;
            return TRUE;
        }
    }

    return FALSE;
}

bool spec_cast_clan(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;

    if (!IS_AWAKE(ch))
    return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;
        if (victim != ch && can_see(ch, victim) && number_bits(1) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    if (HAS_SKILL(victim, gsn_spellbane)) 
    {
        if (ch->clan != victim->clan)
        return FALSE;
    }

    switch (number_bits(4)) {
    case 0:
        act("$n   '$t'.", ch, "", NULL, TO_ROOM);
        spell_armor(sn_lookup("armor"),
                ch->level, ch, victim, TARGET_CHAR);
        return TRUE;

    case 1:
        act("$n   '$t'.", ch, "", NULL, TO_ROOM);

        if (IS_CYBORG(ch))
        {
            spell_cyber_bless(sn_lookup("cyber_bless"), ch->level, ch, victim, TARGET_CHAR);
        }
        else
        {
            spell_bless(sn_lookup("bless"), ch->level, ch, victim, TARGET_CHAR);
        }
        return TRUE;

    case 2:
        act("$n   '$t'.",
            ch, " ", NULL, TO_ROOM);
        spell_cure_blindness(sn_lookup("cure blindness"),
                     ch->level, ch, victim, TARGET_CHAR);
        return TRUE;

    case 3:
        act("$n   '$t'.",
            ch, " ", NULL, TO_ROOM);

        victim->hit += (victim->level + (ch->level/4));
        victim->hit = UMIN(victim->hit,victim->max_hit);

        return TRUE;

    case 4:
        act("$n   '$t'.",
            ch, " ", NULL, TO_ROOM);
        spell_cure_poison(sn_lookup("cure poison"),
                  ch->level, ch, victim, TARGET_CHAR);
        return TRUE;

    case 5:
        act("$n   '$t'.",
            ch, "", NULL, TO_ROOM);
        spell_refresh(sn_lookup("refresh"),
                  ch->level, ch, victim, TARGET_CHAR);
        return TRUE;
    }

    return FALSE;
}

bool spec_jailer(CHAR_DATA *ch)
{
    ROOM_INDEX_DATA *cell;
    CHAR_DATA *vch;
    bool stat = FALSE;

    cell = get_room_index(ROOM_VNUM_RULER_CELL);

    if (!cell) {
        char_act("CELL NULL!", ch);
        return stat;
    }
    if (ch->fighting) return stat;
    for (vch = cell->people; vch; vch = vch->next_in_room) {
        if (IS_NPC(vch) || IS_IMMORTAL(vch)) 
            continue;
        if (!is_affected(vch, gsn_arrest)) {
            do_unlock(ch, "north");
            do_open(ch, "north");
            do_north(ch, str_empty);
            act_say(ch, "$i,    .  !", vch);
            do_south(vch, str_empty);
            do_south(vch, str_empty);
            do_south(ch, str_empty);
            do_close(ch, "north");
            do_lock(ch, "north");
            stat = TRUE;
        }
    }
    return stat;
}
bool spec_guard(CHAR_DATA *ch)
{
    CHAR_DATA *victim, *v_next;
    CHAR_DATA *ech;
    char *crime;
    int max_evil;

    if (!IS_AWAKE(ch) || ch->fighting != NULL)
        return FALSE;

    if (IS_AFFECTED(ch, AFF_CHARM))
        return FALSE;

    max_evil = 300;
    ech      = NULL;
    crime    = str_empty;

    for (victim = ch->in_room->people; victim != NULL; victim = v_next) {
        v_next = victim->next_in_room;

        if (IS_SET(ch->in_room->area->flags, AREA_HOMETOWN)
            && number_percent() < 2 && !IS_IMMORTAL(victim)) {
            act_say(ch, "  ?", NULL);
            if (str_cmp(ch->in_room->area->name, hometown_name(victim->hometown)))
                act_say(ch, "   ,  !", NULL);
            else {
                act_say(ch, "Ok,    .", NULL);
                interpret(ch, "smile");
            }
        }

        if (!IS_NPC(victim) && IS_SET(victim->plr_flags, PLR_WANTED)) {
            crime = "";
            break;
        }

        if (victim->fighting != NULL
        &&  victim->fighting != ch
        &&  victim->alignment < max_evil) {
            if (IS_EVIL(victim)) {
                max_evil = -350;
                ech      = victim;
            }
            else
                ech = victim;
        }
    }

    if (victim) {
        doprintf(do_yell, ch, "%s %s!   ! !", victim->name, crime);
        agent_net_printf(ch, victim, ANET_WANTED_FOUND);
        multi_hit(ch, victim, TYPE_UNDEFINED);
        return TRUE;
    }

    if (ech) {
        act("$n  ' !!  !!",
            ch, NULL, NULL, TO_ROOM);
        multi_hit(ch, ech, TYPE_UNDEFINED);
        return TRUE;
    }

    return FALSE;
}

bool spec_special_guard(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
    char *crime;

    if (!IS_AWAKE(ch) || ch->fighting != NULL)
        return FALSE;

    if (IS_AFFECTED(ch, AFF_CHARM))
        return FALSE;

    crime    = str_empty;

    for (victim = ch->in_room->people; victim != NULL; victim = v_next) {
        v_next = victim->next_in_room;

        if (!IS_NPC(victim) && IS_SET(victim->plr_flags, PLR_WANTED)) {
            crime = "";
            break;
        }
    }

    if (victim) {
        doprintf(do_yell, ch, "%s %s!   !!  !!", victim->name, crime);
        multi_hit(ch, victim, TYPE_UNDEFINED);
        return TRUE;
    }

    return FALSE;
}

bool spec_nasty(CHAR_DATA *ch)
{
    CHAR_DATA *victim, *v_next;
    long gold;

    if (!IS_AWAKE(ch))
        return FALSE;

    if (ch->position != POS_FIGHTING) {
        for (victim = ch->in_room->people; victim; victim = v_next) {
            v_next = victim->next_in_room;
            if (!IS_NPC(victim)
            &&  (victim->level > ch->level)
            &&  (victim->level < ch->level + 10)) {
                do_backstab(ch, victim->name);
                if (ch->position != POS_FIGHTING)
                    do_murder(ch, victim->name);
                /* should steal some coins right away? :) */
                return TRUE;
            }
        }
        return FALSE;    /*  No one to attack */
    }

    /* okay, we must be fighting.... steal some coins and flee */
    if ((victim = ch->fighting) == NULL)
        return FALSE;   /* let's be paranoid.... */

    switch (number_bits(2)) {
    case 0:
        act("$n rips apart your coin purse, spilling your gold!",
                ch, NULL, victim, TO_VICT);
        act("You slash apart $N's coin purse and gather his gold.",
            ch, NULL, victim, TO_CHAR);
        act("$N's coin purse is ripped apart!",
            ch, NULL, victim, TO_NOTVICT);
        gold = victim->gold / 10;  /* steal 10% of his gold */
        victim->gold -= gold;
        ch->gold     += gold;
        return TRUE;

    case 1:
        do_flee(ch, str_empty);
        return TRUE;

    default:
        return FALSE;
    }
}

bool spec_assassinater(CHAR_DATA *ch)
{
    char* msg;
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
    int rnd_say;

    if (ch->fighting != NULL)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        /* this should kill mobs as well as players */
        v_next = ch->next_in_room;
        if ((victim->class != CLASS_THIEF)
        &&  (victim->class != CLASS_NINJA))
            break;
    }

    if (victim == NULL || victim == ch || IS_IMMORTAL(victim))
        return FALSE;
    if (victim->level > ch->level + 7 || IS_NPC(victim))
        return FALSE;
    if (victim->hit < victim->max_hit)
        return FALSE;

    rnd_say = number_range(1, 40);

    switch (rnd_say) {
        case  5:
        msg = "    ...";
        break;

    case  6:
        msg = " ...";
        break;

    case  7:
        msg = "Cabrone....";
        break;

    case  8:
        msg = "    ...";
        break;

    case  9:
        msg = " ...";
        break;

    case 10:
        msg = "   ...";
        break;

    default:
        return FALSE;
    }

    act_say(ch, msg, victim);
    multi_hit(ch, victim, gsn_assassinate);
    return TRUE;
}

bool spec_captain(CHAR_DATA *ch)
{
    static const char open_path[] =
"Wn0onc0oe1f2212211s2tw3xw3xd3322a22b22yO00d00a0011e1fe1fn0o3300300w3xs2ts2tS.";

    static const char close_path[] =
"Wn0on0oe1f2212211s2twc3xw3x3322d22a22EC0a00d0b0011e1fe1fn0o3300300w3xs2ts2tS.";

    static const char *path;
    static int pos;
    static bool move;

    if (!move) {
        if (time_info.hour ==  6) {
            path = open_path;
            move = TRUE;
            pos  = 0;
        }

        if (time_info.hour == 20) {
            path = close_path;
            move = TRUE;
            pos  = 0;
        }
    }

    if (ch->fighting != NULL)
        return spec_cast_cleric(ch);

    if (!move || ch->position < POS_SLEEPING)
        return FALSE;

    switch (path[pos]) {
    case '0':
    case '1':
    case '2':
    case '3':
        move_char(ch, path[pos] - '0' ,FALSE);
        break;

    case 'W':
        ch->position = POS_STANDING;
        act_puts("$n    .", ch, NULL, NULL, TO_ROOM, POS_RESTING);
        break;

    case 'S':
        ch->position = POS_SLEEPING;
        act_puts("$n   .", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    break;

    case 'a':
        act_say(ch, "!  !", NULL);
        break;

    case 'b':
        act_say(ch, "   .   .", NULL);
        break;

    case 'c':
        act_say(ch, "       .", NULL);
        act_say(ch, "    .", NULL);
        break;

    case 'd':
        act_say(ch, "  !", NULL);
        break;

    case 'y':
        act_say(ch, "    !", NULL);
        break;

    case 'E':
        act_say(ch, "    !", NULL);
        break;

    case 'O':
        do_unlock(ch, "");
        do_open(ch, "");
        break;

    case 'C':
        do_close(ch, "");
        do_lock(ch, "");
        break;

    case 'n':
        do_open(ch, "");
        break;

    case 'o':
        do_close(ch, "");
        break;

    case 's':
        do_open(ch, "");
        break;

    case 't':
        do_close(ch, "");
        break;

    case 'e':
        do_open(ch, "");
        break;

    case 'f':
        do_close(ch, "");
        break;

    case 'w':
        do_open(ch, "");
        break;

    case 'x':
        do_close(ch, "");
        break;

    case '.' :
        move = FALSE;
        break;
    }

    pos++;
    return FALSE;
}

bool spec_headlamia(CHAR_DATA *ch)
{
    static const char path[] = "T111111100003332222232211.";
    static int pos = 0;
    static bool move;
    static int count = 0;
    CHAR_DATA *vch;

    if (!move && count++ == 10000)
        move = 1;

    if (ch->position < POS_SLEEPING || ch->fighting)
        return FALSE;

    for (vch = ch->in_room->people; vch; vch = vch->next_in_room) {
        if (IS_NPC(vch) && vch->pIndexData->vnum == 3143) {
            do_kill(ch, vch->name);
            break;
        }
    }

    if (!move)
        return FALSE;

    switch (path[pos]) {
        case '0':
        case '1':
        case '2':
        case '3':
        move_char(ch, path[pos] - '0', FALSE);
        pos++;
        break;

    case 'T':
        pos++;
        for(vch = char_list; vch; vch = vch->next) {
            if (!IS_NPC(vch))
                continue;

            if (vch->pIndexData->vnum == 5201) {
                if (!vch->fighting && !vch->last_fought) {
                    char_from_room(vch);
                    char_to_room(vch, ch->in_room);
                    vch->master = ch;
                    vch->leader = ch;
                }
            }
        }
        break;

    case '.' :
        move = FALSE;
        count = 0;
        pos = 0;
        break;
    }

    return FALSE;
}

bool spec_cast_beholder(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
    char *spell;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;
        if (victim->fighting == ch && number_bits(1) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    switch (dice(1, 16)) {
    case  0: spell = "fear";        break; /* charm person */
    case  1: spell = "slow";        break; /* charm monster */
    case  2: spell = "cause serious";   break; /* sleep */
    case  3: spell = "cause critical";  break; /* disinteg */
    case  4: spell = "harm";        break;
    case  5: spell = "dispel magic";    break;
    default: return FALSE;
    }

    spec_cast(ch, spell, victim);
    return TRUE;
}

/*----------------------------------------------------------------------------
 * local functions
 */

/*
 * Core procedure for dragons.
 */
static bool dragon(CHAR_DATA *ch, const char *spell_name)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) {
        v_next = victim->next_in_room;
        if (((RIDDEN(ch) && RIDDEN(ch)->fighting == victim) ||
             victim->fighting == ch)
        &&  number_bits(3) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    spec_cast(ch, spell_name, victim);
    return TRUE;
}

void spec_cast(CHAR_DATA *ch, const char *spell_name, CHAR_DATA *victim)
{
    int num = 1;
    CHAR_DATA *vch;
    char name[MAX_STRING_LENGTH];
    int sn;
    flag32_t target;

    if ((sn = sn_lookup(spell_name)) < 0)
        return;
    target = SKILL(sn)->target;

    if (ch->fighting == victim
    && (target == TAR_CHAR_OFFENSIVE || target == TAR_OBJ_CHAR_OFF)) 
    {
        doprintf(interpret, ch, "cast '%s'", spell_name);
        return;
    }

    one_argument(victim->name, name, sizeof(name));
    for (vch = ch->in_room->people; vch; vch = vch->next_in_room) 
    {
        if (vch == victim)
            break;
        if (can_see(ch, vch) && is_name(name, vch->name))
            num++;
    }

    if (vch == NULL)
        return;     /* can't happen */

    doprintf(interpret, ch, "cast '%s' %d.'%s'", spell_name, num, name);
}

bool spec_powerman(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;

    if (ch->position != POS_FIGHTING) 
    {
        if (ch->hit < ch->max_hit && number_bits(2) == 1)
            do_bandage(ch, str_empty);
        return FALSE;
    }

    for (victim = ch->in_room->people; victim; victim = v_next) 
    {
        v_next = victim->next_in_room;
        if (victim->fighting == ch && number_bits(1) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    return TRUE;
}

/* some stuff for pwipe*/

bool spec_stalker(CHAR_DATA *ch)
{
    int direction, i, range, door;
    static bool find_it = FALSE;

    if (!ch->hunting) {
        log_printf("spec_stalker: No char to hunt.");
        return FALSE;
    }

    if (ch->position < POS_STANDING) {
        ch->position = POS_STANDING;
        act_puts("$n .", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    }

    if (!find_it) {
        range = number_range(1, 6);
        for (i = 0; i < range; i++) {
        if (ch->in_room != ch->hunting->in_room) {
            direction = find_path(ch->in_room->vnum,ch->hunting->in_room->vnum, ch, -40000, 0);
            act_puts("direction $j", ch, (const void *) direction, NULL, TO_CHAR, POS_DEAD);
            switch (direction) {
            case -1: 
                log_printf("spec_stalker: Can\'t find way to char: %s.\n", ch->hunting->name);
                break;
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
                move_char(ch, direction ,FALSE);
                break;
            default : log_printf("spec_stalker: error in direction");
                break;
            }
        }
        else break; /* for */
        }
    }

    if (ch->in_room == ch->hunting->in_room) {
        ROOM_INDEX_DATA *room;
        AFFECT_DATA af;
        int sn = sn_lookup("power word stun");

        room = get_room_index(5);
        char_act("We find him/her", ch);
        act_puts("$n         .\n  ,   ,  .", ch, NULL, ch->hunting, TO_VICT, POS_RESTING);
        act_puts("$n   $N      .\n  ,   ,  $N   $gN{}.\n$n          .", ch, NULL, ch->hunting, TO_NOTVICT, POS_RESTING);

                af.where     = TO_AFFECTS;
                af.type      = sn;
                af.level     = 100;
                af.duration  = 3;
                af.location  = APPLY_DEX;
                af.modifier  = - 3;
                af.bitvector = AFF_STUN;

                affect_to_char(ch->hunting, &af);
                act(" .", ch->hunting, NULL, NULL, TO_CHAR);

        char_from_room(ch);
        char_to_room(ch, room);
        char_from_room(ch->hunting);
        char_to_room(ch->hunting, room);
                do_look(ch->hunting, "auto");
        door = 0; /* north, i think ;) */
            act_puts("  $N  $t.", ch, dir_name[door], ch->hunting, TO_CHAR, POS_DEAD);
            act_puts("$n    $t.", ch, dir_name[door], ch->hunting, TO_VICT, POS_DEAD);
            act_puts("$n  $N  $t.", ch, dir_name[door], ch->hunting, TO_NOTVICT, POS_RESTING);
            move_char(ch->hunting, door, FALSE);

        ch->hunting = NULL;
        find_it = TRUE;
    }
    else
        find_it = FALSE;

        return TRUE;

}

/* very dangerous spec, deletes player w/o confirm. */

bool spec_exterminator(CHAR_DATA *ch)
{
    CHAR_DATA *vch, *vch1 = NULL;
    char *name;
    CLAN_MEMBER * member ;
    CLAN_MEMBER * prev   ;
    clan_t   * clan   ;

    vch = ch->in_room->people ;
    while (vch)
    {
        if (vch != ch && is_affected(vch, gsn_pwipe) && !IS_IMMORTAL(vch))
        {
            vch1 = vch ; break ;
        }

        vch = vch->next_in_room ;
    }

    if (vch1 == NULL) return FALSE ;

    // remove from clanlist if this player was a clan member
    clan = CLAN (vch1->clan) ;
    if (clan)       
    {
        prev = NULL ;
        for (member = clan->member_list ; member ; prev = member, member = member->next)
        {
            if (str_cmp (member->name, vch1->name)) continue ;
                                          
            // memory clean-up
            free_string (member->name) ;
            free_string (member->last_login) ;

            if (prev) prev->next   = member->next ;
            else clan->member_list = member->next ;

            --clan->cur_clan_members ;

            free (member) ;
            break ;
        }
    }

    wiznet (" $N ̣.", vch1, NULL, 0, 0, 0) ;
    RESET_FIGHT_TIME (vch1) ;
    name = capitalize (vch1->name) ;
    do_quit_count (vch1, str_empty) ;
    dunlink (PLAYER_PATH, name) ;

    return TRUE ;
}

bool spec_bot(CHAR_DATA *ch) {

        CHAR_DATA *victim;
        CHAR_DATA *v_next;

        if (ch->position != POS_FIGHTING)
                return FALSE;

        for (victim = ch->in_room->people; victim; victim = v_next) {
                v_next = victim->next_in_room;
                if (victim->fighting == ch 
        || (ch->master && victim->fighting == ch->master))
                        break;
        }

        if (victim == NULL)
                return FALSE;

    switch (number_bits(3)) {
        case 0:
        case 1: spec_cast(ch, "shocking grasp", victim);
            break;
        case 2:
        case 3: 
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:;
    };

return TRUE;
}


bool spec_cast_animated(CHAR_DATA *ch) {

        CHAR_DATA *victim;
        CHAR_DATA *v_next;
    char *spell = str_empty;
    int min_stat = 0;

        if (ch->position != POS_FIGHTING)
                return FALSE;

        for (victim = ch->in_room->people; victim; victim = v_next) {
                v_next = victim->next_in_room;
                if ((victim->fighting == ch || ch->fighting == victim)
        && number_bits(2) == 0)
                        break;
        }

        if (victim == NULL)
                return FALSE;

        switch (number_bits(4)) {
                case 0: min_stat = 5; spell = "magic missile"; break;
                case 1: min_stat = 10; spell = "shocking grasp"; break;
                case 2: min_stat = 10; spell = "burning hands"; break;
                case 3: min_stat = 15; spell = "colour spray"; break;
                case 4: min_stat = 15; spell = "acid arrow"; break;
                case 5: min_stat = 17; spell = "magic missile"; break;
                case 6: min_stat = 17; spell = "shocking grasp"; break;
                case 7: min_stat = 17; spell = "burning hands"; break;
                case 8: min_stat = 18; spell = "chill touch"; break;
                case 9: min_stat = 20; spell = "lightning bolt"; break;
                case 10: min_stat = 21; spell = "iceball"; break;
                case 11: min_stat = 22; spell = "fireball"; break;
                case 12: min_stat = 23; spell = "acid blast"; break;
                case 13: min_stat = 24; spell = "lightning breath"; break;
                case 14: min_stat = 25; spell = "fire breath"; break;
        default:;
        };

    if (get_curr_stat(ch, STAT_INT) < min_stat)
        return FALSE;

spec_cast(ch, spell, victim);
return TRUE;
}

bool spec_cast_animated2(CHAR_DATA *ch) {

        CHAR_DATA *victim;
        CHAR_DATA *v_next;
        char *spell = str_empty;
    int min_stat = 0;

        if (ch->position != POS_FIGHTING)
                return FALSE;

        for (victim = ch->in_room->people; victim; victim = v_next) {
                v_next = victim->next_in_room;
                if ((victim->fighting == ch || ch->fighting == victim)
                && number_bits(2) == 0)
                        break;
        }

        if (victim == NULL) {
        int num=1;

        switch (number_bits(2)) {
        case 0: min_stat = 0; spell = "cure critical"; break;
        case 1: min_stat = 17; spell = "heal"; break;
        case 2: min_stat = 22; spell = "heal"; break;
        default:;
        };

    if (get_curr_stat(ch, STAT_WIS) < min_stat)
        return FALSE;

    if (number_bits(1) || ch->master == NULL) {
        doprintf(interpret, ch, "cast '%s' self", spell);
        }
    else {
        CHAR_DATA *vch;
        char name[MAX_STRING_LENGTH];

        one_argument(ch->master->name, name, sizeof(name));
            for (vch = ch->in_room->people; vch; vch = vch->next_in_room) {
                    if (vch == ch->master)
                            break;
                    if (can_see(ch, vch) && is_name(name, vch->name))
                            num++;
            }
        doprintf(interpret, ch, "cast '%s' %d.'%s'", spell, num, name);
            }

    }
    else {
            switch (number_bits(3)) {

                case 0: min_stat = 0; spell = "cause critical"; break;
                case 1: min_stat = 16; spell = "harm"; break;
                case 2: min_stat = 16; spell = "flamestrike"; break;
                case 3: min_stat = 17; spell = "blindness"; break;
                case 4: min_stat = 18; spell = "plague"; break;
                case 5: min_stat = 22; spell = "dispel magic"; break;
                case 6: min_stat = 25; spell = "curse"; break;
                default:;
            };

    if (get_curr_stat(ch, STAT_WIS) >= min_stat)
        spec_cast(ch, spell, victim);
    }

return TRUE;
}

bool spec_decap( CHAR_DATA *ch)
{
    char buf[MAX_STRING_LENGTH];
    OBJ_DATA *object;
    OBJ_DATA *obj2;
    OBJ_DATA *object_next;

    /*wear stuff??*/
    for ( object = ch->in_room->contents; object; object = object_next )
    {
        object_next = object->next_content;
        if ( object == NULL )
            continue;

        if (IS_SET(object->pIndexData->extra_flags, ITEM_QUEST) )
            continue;


        if ( object ->pIndexData->limit != -1)
            continue;

        if (object ->pIndexData->level + object ->pIndexData->level/10 >= ch->level )
        {
            if ( object->timer == 0)
                do_sacrifice(ch,object->pIndexData->name);
            continue;
        }

        if ( object->pIndexData->item_type == ITEM_CORPSE_PC )
        {
            act_say(ch, "Any corpses roll here.... ", NULL);
            do_sacrifice(ch,object->name); 
            continue;         
        }

        if ( !IS_SET( object->wear_flags, ITEM_TAKE ) )
            continue;

        if ( object->pIndexData->item_type == ITEM_CORPSE_NPC )
            continue;


        if ( ( object->pIndexData->item_type != ITEM_DRINK_CON
               && object->pIndexData->item_type != ITEM_TRASH )
             &&

             !(( IS_OBJ_STAT( object, ITEM_ANTI_EVIL   ) && IS_EVIL   ( ch ) ) ||
               ( IS_OBJ_STAT( object, ITEM_ANTI_GOOD   ) && IS_GOOD   ( ch ) ) ||
               ( IS_OBJ_STAT( object, ITEM_ANTI_NEUTRAL) && IS_NEUTRAL( ch ) ) ) )
        {
            act("$n picks up $p and examines it carefully.", ch, object, NULL, TO_ROOM );
            obj_from_room( object );
            obj_to_char( object, ch );
            /*Now compare it to what we already have*/
            for ( obj2 = ch->carrying; obj2; obj2 = obj2->next_content )
            {
                if ( obj2->wear_loc != WEAR_NONE
                     && can_see_obj( ch, obj2 )
                     && object->pIndexData->item_type == obj2->pIndexData->item_type
                     && ( object->wear_flags & obj2->wear_flags & ~ITEM_TAKE) != 0 )
                    break;
            }
            if (!obj2)
            {
                switch (object->pIndexData->item_type)
                {
                default:
                    snprintf(buf, sizeof(buf), "Hey, what a find!");
                    do_say(ch,buf);
                    break;
                case ITEM_FOOD:
                    snprintf(buf, sizeof(buf), "This looks like a tasty morsel!");
                    do_say(ch,buf);
                    do_eat(ch,object->name);
                    break;
                case ITEM_WAND:
                    snprintf(buf, sizeof(buf), "Wow, a magic wand!");
                    do_say(ch,buf);
                    wear_obj(ch,object,FALSE);
                    break;
                case ITEM_STAFF:
                    snprintf(buf, sizeof(buf), "Kewl, a magic staff!");
                    do_say(ch,buf);
                    wear_obj(ch,object,FALSE);
                    break;
                case ITEM_WEAPON:
                    snprintf(buf, sizeof(buf), "Hey, this looks like a nifty weapon!");
                    do_say(ch,buf);
                    wear_obj(ch,object,FALSE);
                    break;
                case ITEM_ARMOR:
                    snprintf(buf, sizeof(buf), "Oooh...a nice piece of armor!");
                    do_say(ch,buf);
                    wear_obj(ch,object,FALSE);
                    break;
                }
                return TRUE;
            }

            if ((object->level > obj2->level))
            {
                snprintf(buf, sizeof(buf), "Now THIS looks like an improvement!");
                do_say(ch,buf);
                remove_obj(ch,obj2->wear_loc,TRUE);
                wear_obj(ch,object,FALSE);
            } else
            {
                snprintf(buf, sizeof(buf), "I don't want this piece of junk!");
                do_say(ch,buf);
                act("You don't like the look of $p.", ch, object, NULL, TO_CHAR);
                do_drop(ch,object->name);
                do_sacrifice(ch,object->name);
            }
            return TRUE;
        }
    }
    return TRUE;
}

bool spec_protector(CHAR_DATA *ch)
{
    char       buf[MAX_STRING_LENGTH]; 
    int        number; 
    CHAR_DATA *vch; 
    CHAR_DATA *vch_next; 
    
    if (ch->fighting == NULL)
        return FALSE; 

    for (; ;)
    {
        for (vch = ch->in_room->people; vch != NULL; vch = vch_next)
        {
            vch_next = vch->next_in_room; 

            if (vch->fighting == ch && number_bits(2) == 0)
                break; 
        }
        
        if (vch != NULL)
            break; 
    }

    number = number_percent(); 
    if (number < 5)
    {
        do_say(ch,"You are breaking the Law! Leave now or be punished!"); 
        return TRUE; 
    }
    else 
    if (number < 10 && number_bits(2) == 0 && !IS_SET(vch->plr_flags, PLR_WANTED))
    {
        sprintf(buf,"%s, you must pay for your crimes!",vch->name); 
        do_say(ch,buf); 
        do_wanted(ch,vch->name); 
    }
    
    if (IS_SET(vch->plr_flags, PLR_WANTED))
    {
        act("$n points at $N and says, 'Defend the Protectorate!'",ch,0,vch,TO_NOTVICT); 
        act("$n points at you and says, 'Defend the Protectorate!",ch,0,vch,TO_VICT); 
        spell_hand_of_vengeance(sn_lookup("hand of vengeance"),ch->level,ch,vch,TARGET_CHAR);
        return TRUE; 
    }

    return spec_breath_lightning(ch);
    return FALSE;
}

bool spec_horn_prick(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;
//    char *spell;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) 
    {
        v_next = victim->next_in_room;
        if (victim->fighting == ch && number_bits(1) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    do_horn_prick(ch, victim->name);
    return TRUE;
}

bool spec_hydra(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *victim1;
    CHAR_DATA *victim2;
    CHAR_DATA *victim3;
    CHAR_DATA *v_next;
    char *spell1;
    char *spell2;
    char *spell3;
    int level, i;
    int sn1, sn2, sn3;

    if ( ch->position != POS_FIGHTING  && ch->last_fought != NULL)
    return FALSE;

    if (ch->position != POS_FIGHTING)
    {
    if (number_percent() < 30)
        return FALSE;
        act("$n swings it's heads about in anger then turns and slips back to where it came.",ch,0,0,TO_ROOM);
        extract_char(ch,TRUE);
        return TRUE;
    }

    sn1 = 0;    sn2 = 0;    sn3 = 0;
    victim1 = NULL;
    victim2 = NULL;
    victim3 = NULL;
    level = ch->level;

    for (i = 0; i < 3; i++)
    {
          if (victim3 != NULL)
               break;
               
          for ( victim = ch->in_room->people; victim != NULL; victim = v_next )
          {
               v_next = victim->next_in_room;
               
               if ( victim->fighting == ch && number_percent() < 30 )
               {
                    if (victim1 == NULL)
                         victim1 = victim;
                    else if (victim2 == NULL)
                         victim2 = victim;
                    else if (victim3 == NULL)
                         victim3 = victim;
                    else
                         break;
               }
          }
    }

    if ( victim1 == NULL )
        return FALSE;

    switch(number_range(0,3))
    {
        case 0:  spell1 = "acid blast";                 break;
        case 1:  spell1 = "fireball";     level = 50;   break;
        case 3:  spell1 = "flame scorch";               break;
        default: spell1 = "flame scorch";               break;
    }
    
    sn1 = sn_lookup(spell1);
    
    spell2 = "weaken";

    if (victim2 != NULL && (sn1 != gsn_flame_scorch))
    {
        switch(number_range(0,3))
        {
          case 1:   spell2 = "poison"; level = 53;   break;
          case 2:   spell2 = "slow";   level = 55;   break;
          case 3:   spell2 = "weaken"; level = 55;   break;
        }
        
        sn2 = sn_lookup(spell2);
    }

    if (victim3 != NULL && (sn1 != gsn_flame_scorch))
    {
        switch(number_range(0,4))
        {
            case 1:  spell3 = "harm";         level = 58; break;
            case 2:  spell3 = "iceball";      level = 55; break;
            default: spell3 = "dispel magic"; level = 54; break;
        }
        
        sn3 = sn_lookup(spell3);
    }

    if (sn1 == gsn_flame_scorch)
    {
        act("The hydra's heads swing around and rise up above you.",ch,0,0,TO_ROOM);
        (*(skill_lookup(sn1)->spell_fun)) ( sn1, level, ch, victim1, skill_lookup(sn1)->target );
        return TRUE;
    }
    else if (  sn1 >= 0 )
    {
         act("$n brings it's massive red head down to bear upon $N!",ch,0,victim1,TO_NOTVICT);
         act("$n brings it's massive red head around to bear upon you!",ch,0,victim1,TO_VICT);
        (*(skill_lookup(sn1)->spell_fun)) ( sn1, level, ch, victim1,skill_lookup(sn1)->target );
        
    }
    
    if (victim2 != NULL)
    {
        if ( ( sn2 >= 0 ) && victim2->in_room == ch->in_room) 
        {
              act("$n brings it's massive green head down to bear upon $N!",ch,0,victim2,TO_NOTVICT);
              act("$n brings it's massive green head around to bear upon you!",ch,0,victim2,TO_VICT);
              (*(skill_lookup(sn2)->spell_fun)) ( sn2, level, ch, victim2, skill_lookup(sn2)->target );
        }
    }
    
    if (victim3 != NULL && victim3->in_room == ch->in_room)
    {
         if (  sn3 >= 0 )
         {
              act("$n brings it's massive blue head down to bear upon $N!",ch,0,victim3,TO_NOTVICT);
              act("$n brings it's massive blue head around to bear upon you!",ch,0,victim3,TO_VICT);
              (*(skill_lookup(sn3)->spell_fun)) ( sn3, level, ch, victim3, skill_lookup(sn1)->target );
         }
    }

    return TRUE;
}

bool spec_fire_dragon(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) 
    {
        v_next = victim->next_in_room;
        if (victim->fighting == ch && number_bits(4) == 0)
            break;
        if (ch->fighting == victim && number_bits(1) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    spec_cast(ch, "firebolt", victim);
    return TRUE;
}

bool spec_ice_dragon(CHAR_DATA *ch)
{
    CHAR_DATA *victim;
    CHAR_DATA *v_next;

    if (ch->position != POS_FIGHTING)
        return FALSE;

    for (victim = ch->in_room->people; victim; victim = v_next) 
    {
        v_next = victim->next_in_room;
        if (victim->fighting == ch && number_bits(4) == 0)
            break;
        if (ch->fighting == victim && number_bits(1) == 0)
            break;
    }

    if (victim == NULL)
        return FALSE;

    spec_cast(ch, "icebolt", victim);
    return TRUE;
}
