/* $Id: str.h,v 1.666 2004/09/20 10:49:53 shrike Exp $                               */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#ifndef _STR_H_
#define _STR_H_

enum {
		ALIGN_LEFT,
		ALIGN_CENTER,
		ALIGN_RIGHT,
		MAX_ALIGN
};

const char *	str_dup		(const char *str);
const char *	str_qdup	(const char *str);
void			free_string	(const char *str);
const char *	str_printf	(const char *format,...);

extern char	str_empty[1];
	
char *	strnzcpy(char *dest, size_t len, const char *src);
#define strnzncpy(dest, len, src, count) \
        strnzcpy((dest), UMIN((len), (count)+1), (src))
char *	strnzcat(char *dest, size_t len, const char *src);
char *	strnzncat(char *dest, size_t len, const char *src, size_t count);
const char *fmt_color_string(const char *txt, int max, int align);
#define fmt_color_str(txt, max) \
		fmt_color_string((txt), (max), ALIGN_LEFT)
const char * fmt_wrap_str(const char * txt, int len, const char * pad);
#if !defined (WIN32)
char *	strlwr(const char *s);
#endif

int	str_cmp		(const char *astr, const char *bstr);
int	str_ncmp	(const char *astr, const char *bstr, size_t len);
bool	str_prefix	(const char *astr, const char *bstr);
bool	str_infix	(const char *astr, const char *bstr);
bool	str_suffix	(const char *astr, const char *bstr);

int hashstr(const char *s, int maxn, int hashs);
int hashistr(const char *s, int maxn, int hashs);

int cmpstr(const void*, const void*);

int toupper1 (int c);
int tolower1 (int c);
int isupper1 (int c);
int islower1 (int c);

#endif
