/* $Id: tables.c,v 1.666 2004/09/20 10:49:54 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <time.h>
#include "merc.h"
#include "db/lang.h"
#include "price.h"
#include "meteor.h"
#include "planets.h"

flag_t slang_table[] =
    {
        { str_empty,        TABLE_INTVAL,               },
        { "common",         SLANG_COMMON,       TRUE    },
        { "human",          SLANG_HUMAN,        TRUE    },
        { "elvish",         SLANG_ELVISH,       TRUE    },
        { "dwarvish",       SLANG_DWARVISH,     TRUE    },
        { "gnomish",        SLANG_GNOMISH,      TRUE    },
        { "giant",          SLANG_GIANT,        TRUE    },
        { "trollish",       SLANG_TROLLISH,     TRUE    },
        { "cat",            SLANG_CAT,          TRUE    },
        { "illithid",       SLANG_ILLITHID,     TRUE    },
        { "mothertongue",   SLANG_MAX,          FALSE   },
        { NULL }
    };

flag_t size_table[] =
    {
        { str_empty,        TABLE_INTVAL,                   },
        { "tiny",           SIZE_TINY,              TRUE    },
        { "tiny_min",       SIZE_TINY_MIN,          TRUE    },
        { "tiny_max",       SIZE_TINY_MAX,          TRUE    },
        { "small",          SIZE_SMALL,             TRUE    },
        { "small_min",      SIZE_SMALL_MIN,         TRUE    },
        { "small_max",      SIZE_SMALL_MAX,         TRUE    },
        { "medium",         SIZE_MEDIUM,            TRUE    },
        { "medium_min",     SIZE_MEDIUM_MIN,        TRUE    },
        { "medium_max",     SIZE_MEDIUM_MAX,        TRUE    },
        { "large",          SIZE_LARGE,             TRUE    },
        { "large_min",      SIZE_LARGE_MIN,         TRUE    },
        { "large_max",      SIZE_LARGE_MAX,         TRUE    },
        { "huge",           SIZE_HUGE,              TRUE    },
        { "huge_min",       SIZE_HUGE_MIN,          TRUE    },
        { "huge_max",       SIZE_HUGE_MAX,          TRUE    },
        { "giant",          SIZE_GIANT,             TRUE    },
        { "giant_min",      SIZE_GIANT_MIN,         TRUE    },
        { "giant_max",      SIZE_GIANT_MAX,         TRUE    },
        { "gargantuan",     SIZE_GARGANTUAN,        TRUE    },
        { "gargantuan_min", SIZE_GARGANTUAN_MIN,    TRUE    },
        { "gargantuan_max", SIZE_GARGANTUAN_MAX,    TRUE    },
        { NULL }
    };

flag_t act_flags[] =
    {
        { str_empty,        TABLE_BITVAL,                        },
        { "npc",            ACT_NPC,            FALSE,   "{WN{z" },
        { "sentinel",       ACT_SENTINEL,       TRUE,    "{rS{z" },
        { "scavenger",      ACT_SCAVENGER,      TRUE,    "{rs{z" },
        { "aggressive",     ACT_AGGRESSIVE,     TRUE,    "{rA{z" },
        { "stay_area",      ACT_STAY_AREA,      TRUE,    "{cs{z" },
        { "wimpy",          ACT_WIMPY,          TRUE,    "{cw{z" },
        { "pet",            ACT_PET,            TRUE,    "{rP{z" },
        { "train",          ACT_TRAIN,          TRUE,    "{yT{z" },
        { "practice",       ACT_PRACTICE,       TRUE,    "{yP{z" },
        { "hunter",         ACT_HUNTER,         TRUE,    "{rH{z" },
        { "undead",         ACT_UNDEAD,         TRUE,    "{DU{z" },
        { "cleric",         ACT_CLERIC,         TRUE,    "{WC{z" },
        { "mage",           ACT_MAGE,           TRUE,    "{WM{z" },
        { "thief",          ACT_THIEF,          TRUE,    "{WT{z" },
        { "warrior",        ACT_WARRIOR,        TRUE,    "{WW{z" },
        { "noalign",        ACT_NOALIGN,        TRUE,    "{ca{z" },
        { "nopurge",        ACT_NOPURGE,        TRUE,    "{cp{z" },
        { "outdoors",       ACT_OUTDOORS,       TRUE,    "{co{z" },
        { "questor",        ACT_QUESTOR,        TRUE,    "{yq{z" },
        { "indoors",        ACT_INDOORS,        TRUE,    "{cd{z" },
        { "rideable",       ACT_RIDEABLE,       TRUE,    "{cr{z" },
        { "healer",         ACT_HEALER,         TRUE,    "{yh{z" },
        { "gain",           ACT_GAIN,           TRUE,    "{yg{z" },
        { "update_always",  ACT_UPDATE_ALWAYS,  TRUE,    "{cu{z" },
        { "changer",        ACT_CHANGER,        TRUE,    "{yc{z" },
        { "notrack",        ACT_NOTRACK,        TRUE,    "{ct{z" },
        { "clan_guard",     ACT_CLAN_GUARD,     TRUE,    "{CC{z" },
        { "repair_man",     ACT_REPAIRMAN,      TRUE,    "{yr{z" },
        { "forger",         ACT_FORGER,         TRUE,    "{yf{z" },
        { "noquest",        ACT_NOQUEST,        TRUE,    "{cq{z" },
        { "area_guard",     ACT_AREA_GUARD,     TRUE,    "{cA{z" },
        { "wanderer",       ACT_WANDERER,       TRUE,    "{cw{z" },
        { "receive_level",  ACT_RECEIVE_LEVEL,  TRUE,    "{cL{z" },
        { NULL }
    };

flag_t plr_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "npc",            PLR_NPC,            FALSE   },
        { "autolook",       PLR_AUTOLOOK,       FALSE   },
        { "autoassist",     PLR_AUTOASSIST,     FALSE   },
        { "autodamage",     PLR_AUTODAMAGE,     FALSE   },
        { "autoexit",       PLR_AUTOEXIT,       FALSE   },
        { "autoloot",       PLR_AUTOLOOT,       FALSE   },
        { "autosac",        PLR_AUTOSAC,        FALSE   },
        { "autogold",       PLR_AUTOGOLD,       FALSE   },
        { "autosilver",     PLR_AUTOSILVER,     FALSE   },
        { "autosplit",      PLR_AUTOSPLIT,      FALSE   },
        { "color",          PLR_COLOR,          FALSE   },
        { "bought_pet",     PLR_BOUGHT_PET,     FALSE   },
        { "holylight",      PLR_HOLYLIGHT,      FALSE   },
        { "autotitle",      PLR_AUTOTITLE,      FALSE   },
        { "nosummon",       PLR_NOSUMMON,       FALSE   },
        { "nofollow",       PLR_NOFOLLOW,       FALSE   },
        { "permit",         PLR_PERMIT,         TRUE    },
        { "log",            PLR_LOG,            FALSE   },
        { "deny",           PLR_DENY,           FALSE   },
        { "freeze",         PLR_FREEZE,         FALSE   },
        { "wanted",         PLR_WANTED,         FALSE   },
        { "ghost",          PLR_GHOST,          FALSE   },
        { "notitle",        PLR_NOTITLE,        FALSE   },
        { "noexp",          PLR_NOEXP,          FALSE   },
        { "hara_kiri",      PLR_HARA_KIRI,      FALSE   },
        { "blink",          PLR_BLINK,          FALSE   },
        { "soul",           PLR_SOUL,           FALSE   },
        {"nosoul",          PLR_NOSOUL,         FALSE   },
        { NULL }
    };

flag_t affect_flags[] =
    {
        { str_empty,            TABLE_BITVAL,                        },
        { "blind",              AFF_BLIND,          TRUE,    "{DB{z" },
        { "invisible",          AFF_INVIS,          TRUE,    "{yI{z" },
        { "detect_evil",        AFF_DETECT_EVIL,    TRUE,    "{me{z" },
        { "detect_invis",       AFF_DETECT_INVIS,   TRUE,    "{mi{z" },
        { "detect_magic",       AFF_DETECT_MAGIC,   TRUE,    "{mm{z" },
        { "detect_hidden",      AFF_DETECT_HIDDEN,  TRUE,    "{mh{z" },
        { "detect_good",        AFF_DETECT_GOOD,    TRUE,    "{mg{z" },
        { "sanctuary",          AFF_SANCTUARY,      TRUE,    "{Ws{z" },
        { "faerie_fire",        AFF_FAERIE_FIRE,    TRUE,    "{Df{z" },
        { "infrared",           AFF_INFRARED,       TRUE,    "{ri{z" },
        { "curse",              AFF_CURSE,          TRUE,    "{Dc{z" },
        { "corruption",         AFF_CORRUPTION,     TRUE,    "{Dr{z" },
        { "poison",             AFF_POISON,         TRUE,    "{Dp{z" },
        { "protect_evil",       AFF_PROTECT_EVIL,   TRUE,    "{ge{z" },
        { "protect_good",       AFF_PROTECT_GOOD,   TRUE,    "{gg{z" },
        { "sneak",              AFF_SNEAK,          TRUE,    "{yS{z" },
        { "hide",               AFF_HIDE,           TRUE,    "{yH{z" },
        { "sleep",              AFF_SLEEP,          TRUE,    "{Ds{z" },
        { "charm",              AFF_CHARM,          TRUE,    "{DC{z" },
        { "flying",             AFF_FLYING,         TRUE,    "{Bf{z" },
        { "pass_door",          AFF_PASS_DOOR,      TRUE,    "{BD{z" },
        { "haste",              AFF_HASTE,          TRUE,    "{BH{z" },
        { "calm",               AFF_CALM,           TRUE,    "{MC{z" },
        { "plague",             AFF_PLAGUE,         TRUE,    "{DP{z" },
        { "spellbane",          AFF_SPELLBANE,      TRUE,    "{BS{z" },
        { "dark_vision",        AFF_DARK_VISION,    TRUE,    "{BV{z" },
        { "berserk",            AFF_BERSERK,        TRUE,    "{Bb{z" },
        { "swim",               AFF_SWIM,           TRUE,    "{Bs{z" },
        { "regeneration",       AFF_REGENERATION,   TRUE,    "{Br{z" },
        { "autorepair",         AFF_AUTOREPAIR,     TRUE,    "{Ba{z" },
        { "slow",               AFF_SLOW,           TRUE,    "{DS{z" },
        { "camouflage",         AFF_CAMOUFLAGE,     TRUE,    "{Bm{z" },
        { "imp_invis",          AFF_IMP_INVIS,      TRUE,    "{ui{z" },
        { "fade",               AFF_FADE,           TRUE,    "{yf{z" },
        { "absorb",             AFF_ABSORB,         TRUE,    "{MA{z" },
        { "bloodthirst",        AFF_BLOODTHIRST,    TRUE,    "{DB{z" },
        { "stun",               AFF_STUN,           TRUE,    "{GS{z" },
        { "suffocate",          AFF_SUFFOCATE,      TRUE,    "{Gs{z" },
        { "weak_stun",          AFF_WEAK_STUN,      TRUE,    "{Gw{z" },
        { "detect_imp_invis",   AFF_DETECT_IMP_INVIS, TRUE,  "{mi{z" },
        { "detect_fade",        AFF_DETECT_FADE,    TRUE,    "{mF{z" },
        { "detect_undead",      AFF_DETECT_UNDEAD,  TRUE,    "{mU{z" },
        { "fear",               AFF_FEAR,           TRUE,    "{GF{z" },
        { "earthfade",          AFF_EARTHFADE,      TRUE,    "{yE{z" },
        { "grounding",          AFF_GROUNDING,      TRUE,    "{GG{z" },
        { "web",                AFF_WEB,            TRUE,    "{GW{z" },
        { "detect_life",        AFF_DETECT_LIFE,    TRUE,    "{mL{z" },
        { "acute_vision",       AFF_ACUTE_VISION,   TRUE,    "{ma{z" },
        { "black_shroud",       AFF_BLACK_SHROUD,   TRUE,    "{gS{z" },
        { "trap",               AFF_TRAP,           TRUE,    "{yT{z" },
        { "resistance",         AFF_RESISTANCE,     TRUE,    "{gR{z" },
        { "detect_trap",        AFF_DETECT_TRAP,    TRUE,    "{mT{z" },
        { "protection",         AFF_PROTECTION,     TRUE,    "{gP{z" },
        { NULL }
    };

flag_t off_flags[] =
    {
        { str_empty,        TABLE_BITVAL,                   },
        { "area_attack",    OFF_AREA_ATTACK,TRUE,    "{wa{z"},
        { "backstab",       OFF_BACKSTAB,   TRUE,    "{wB{z"},
        { "bash",           OFF_BASH,       TRUE,    "{wb{z"},
        { "berserk",        OFF_BERSERK,    TRUE,    "{wN{z"},
        { "disarm",         OFF_DISARM,     TRUE,    "{wn{z"},
        { "dodge",          OFF_DODGE,      TRUE,    "{wD{z"},
        { "fade",           OFF_FADE,       TRUE,    "{wf{z"},
        { "fast",           OFF_FAST,       TRUE,    "{wF{z"},
        { "kick",           OFF_KICK,       TRUE,    "{wk{z"},
        { "dirt_kick",      OFF_DIRT_KICK,  TRUE,    "{wK{z"},
        { "parry",          OFF_PARRY,      TRUE,    "{wp{z"},
        { "rescue",         OFF_RESCUE,     TRUE,    "{wR{z"},
        { "tail",           OFF_TAIL,       TRUE,    "{wT{z"},
        { "trip",           OFF_TRIP,       TRUE,    "{wt{z"},
        { "crush",          OFF_CRUSH,      TRUE,    "{wc{z"},
        { "assist_all",     ASSIST_ALL,     TRUE,    "{wH{z"},
        { "assist_align",   ASSIST_ALIGN,   TRUE,    "{wA{z"},
        { "assist_race",    ASSIST_RACE,    TRUE,    "{wF{z"},
        { "assist_players", ASSIST_PLAYERS, TRUE,    "{wR{z"},
        { "assist_guard",   ASSIST_GUARD,   TRUE,    "{wP{z"},
        { "assist_vnum",    ASSIST_VNUM,    TRUE,    "{wV{z"},
        { NULL }
    };

flag_t form_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "edible",         FORM_EDIBLE,        TRUE    },
        { "poison",         FORM_POISON,        TRUE    },
        { "magical",        FORM_MAGICAL,       TRUE    },
        { "instant_decay",  FORM_INSTANT_DECAY, TRUE    },
        { "other",          FORM_OTHER,         TRUE    },
        { "animal",         FORM_ANIMAL,        TRUE    },
        { "sentient",       FORM_SENTIENT,      TRUE    },
        { "undead",         FORM_UNDEAD,        TRUE    },
        { "construct",      FORM_CONSTRUCT,     TRUE    },
        { "mist",           FORM_MIST,          TRUE    },
        { "intangible",     FORM_INTANGIBLE,    TRUE    },
        { "biped",          FORM_BIPED,         TRUE    },
        { "centaur",        FORM_CENTAUR,       TRUE    },
        { "insect",         FORM_INSECT,        TRUE    },
        { "spider",         FORM_SPIDER,        TRUE    },
        { "crustacean",     FORM_CRUSTACEAN,    TRUE    },
        { "worm",           FORM_WORM,          TRUE    },
        { "blob",           FORM_BLOB,          TRUE    },
        { "mammal",         FORM_MAMMAL,        TRUE    },
        { "bird",           FORM_BIRD,          TRUE    },
        { "reptile",        FORM_REPTILE,       TRUE    },
        { "snake",          FORM_SNAKE,         TRUE    },
        { "dragon",         FORM_DRAGON,        TRUE    },
        { "amphibian",      FORM_AMPHIBIAN,     TRUE    },
        { "fish",           FORM_FISH ,         TRUE    },
        { "cold_blood",     FORM_COLD_BLOOD,    TRUE    },
        { "vampire",        FORM_VAMPIRE,       TRUE    },
        { "cyborg",         FORM_CYBORG,        TRUE    },
        { "mech",           FORM_MECH,          TRUE    },
        { "demon",          FORM_DEMON_AIR,     TRUE    },
        { "demon",          FORM_DEMON_WATER,   TRUE    },
        { "demon",          FORM_DEMON_EARTH,   TRUE    },
        { "demon",          FORM_DEMON_FIRE,    TRUE    },
        { "bear",           FORM_BEAR,          TRUE    },
        { "wolf",           FORM_WOLF,          TRUE    },
        { NULL }
    };

flag_t form_brief_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "undead",         FORM_UNDEAD,        TRUE    },
        { "vampire",        FORM_VAMPIRE,       TRUE    },
        { "mech",           FORM_MECH,          TRUE    },
        { "demon",          FORM_DEMON_AIR | FORM_DEMON_WATER | FORM_DEMON_EARTH | FORM_DEMON_FIRE,     TRUE    },
        { "bear",           FORM_BEAR,          TRUE    },
        { "wolf",           FORM_WOLF,          TRUE    },
        { NULL }
    };

flag_t part_flags[] =
    {
        { str_empty,           TABLE_BITVAL,            },
        { "head",              PART_HEAD,       TRUE    },
        { "arms",              PART_ARMS,       TRUE    },
        { "legs",              PART_LEGS,       TRUE    },
        { "heart",             PART_HEART,      TRUE    },
        { "brains",            PART_BRAINS,     TRUE    },
        { "guts",              PART_GUTS,       TRUE    },
        { "hands",             PART_HANDS,      TRUE    },
        { "feet",              PART_FEET,       TRUE    },
        { "fingers",           PART_FINGERS,    TRUE    },
        { "ear",               PART_EAR,        TRUE    },
        { "eye",               PART_EYE,        TRUE    },
        { "long_tongue",       PART_LONG_TONGUE,TRUE    },
        { "eyestalks",         PART_EYESTALKS,  TRUE    },
        { "tentacles",         PART_TENTACLES,  TRUE    },
        { "fins",              PART_FINS,       TRUE    },
        { "wings",             PART_WINGS,      TRUE    },
        { "tail",              PART_TAIL,       TRUE    },
        { "claws",             PART_CLAWS,      TRUE    },
        { "fangs",             PART_FANGS,      TRUE    },
        { "horns",             PART_HORNS,      TRUE    },
        { "scales",            PART_SCALES,     TRUE    },
        { "tusks",             PART_TUSKS,      TRUE    },
        { NULL }
    };

flag_t comm_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "quiet",          COMM_QUIET,         TRUE    },
        { "deaf",           COMM_DEAF,          TRUE    },
        { "nowiz",          COMM_NOWIZ,         TRUE    },
        { "nogossip",       COMM_NOGOSSIP,      TRUE    },
        { "noquestion",     COMM_NOQUESTION,    TRUE    },
        { "noauction",      COMM_NOAUCTION,     TRUE    },
        { "nomusic",        COMM_NOMUSIC,       TRUE    },
        { "warinfo",        COMM_WARINFO,       TRUE    },
        { "noclan",         COMM_NOCLAN,        TRUE    },
        { "nortalk",        COMM_NORTALK,       TRUE    },
        { "quiet_editor",   COMM_QUIET_EDITOR,  TRUE    },
        { "compact",        COMM_COMPACT,       TRUE    },
        { "brief",          COMM_BRIEF,         TRUE    },
        { "bust",           COMM_BUST_PROMPT,   TRUE    },
        { "prompt",         COMM_PROMPT,        TRUE    },
        { "long",           COMM_LONG,          TRUE    },
        { "combine",        COMM_COMBINE,       TRUE    },
        { "telnet_ga",      COMM_TELNET_GA,     TRUE    },
        { "showaff",        COMM_SHOWAFF,       TRUE    },
        { "autosnoop",      COMM_AUTOSNOOP,     FALSE   },
        { "color",          COMM_COLOR,         TRUE    },
        { "noemote",        COMM_NOEMOTE,       FALSE   },
        { "nocast",         COMM_NOCAST,        FALSE   },
        { "notell",         COMM_NOTELL,        FALSE   },
        { "nochannels",     COMM_NOCHANNELS,    FALSE   },
        { "snoop_proof",    COMM_SNOOP_PROOF,   FALSE   },
        { "afk",            COMM_AFK,           TRUE    },
        { "notelnet",       COMM_NOTELNET,      TRUE    },
        { "noiac",          COMM_NOIAC,         TRUE    },
        { "noverbose",      COMM_NOVERBOSE,     TRUE    },
        { "nonote",         COMM_NONOTE,        FALSE   },
        { "noquest",        COMM_NOQUEST,       FALSE   },
        { "noooc",          COMM_NOOOC,         FALSE   },
        { "nohero",         COMM_NOHERO,        FALSE   },
        { "chat",           COMM_CHAT,          FALSE   },
        { "nosend",         COMM_NOSEND,        FALSE   },
        { "nogive",         COMM_NOGIVE,        FALSE   },
        { "peaceful",       PLR_PEACE,          FALSE   },
        { "fishing",        COMM_FISHING,       FALSE   },
        { "fish_on",        COMM_FISH_ON,       FALSE   },
        { "bonus",          COMM_BONUS,         FALSE   },
        { "noeng",          COMM_NOENG,         TRUE    },
        { "info",           COMM_INFO,          FALSE   },
        { "nogquest",       COMM_NOGQUEST,      FALSE   },
        { "memorial",       COMM_MEMORIAL,      FALSE   },
        { "agentnet",       COMM_AGENTNET,      FALSE   },
        { "track",          COMM_TRACK,         FALSE   },
        { NULL }
    };

flag_t comm2_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "nowar",          COMM2_NOWAR,        FALSE, "{DW"   },
        { "vnum_show",      COMM2_VNUM_SHOW,    TRUE,  "{CV"   },
       { NULL }
    };

flag_t clan_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "hidden",         CLAN_HIDDEN,        TRUE    },
        { "rulers",         CLAN_RULERS,        TRUE    },
        { "hate_magic",     CLAN_HATE_MAGIC,    TRUE    },
        { "love_magic",     CLAN_LOVE_MAGIC,    TRUE    },
        { "can_see",        CLAN_CAN_SEE,       TRUE    },
        { "changed",        CLAN_CHANGED,       FALSE   },
        { NULL }
    };

flag_t area_flags[] =
    {
        { str_empty,            TABLE_BITVAL,                    },
        { "hometown",           AREA_HOMETOWN,           TRUE    },
        { "under_construction", AREA_UNDER_CONSTRUCTION, TRUE    },
        { "noquest",            AREA_NOQUEST,            TRUE    },
        { "graveyard",          AREA_GRAVEYARD,          FALSE   },
        { "noweather",          AREA_NOWEATHER,          TRUE    },
        { "nometeor",           AREA_NOMETEOR,           TRUE    },
        { "war_enabled",        AREA_WAR_ENABLED,        TRUE    },
        { "nowquest",           AREA_NOWQUEST,           TRUE    },
        { "hidden",             AREA_HIDDEN,             TRUE    },
        { "has_quest",          AREA_HAS_QUEST,          TRUE    },
        { "changed",            AREA_CHANGED,            FALSE   },
        { NULL }
    };

flag_t climat_flags[] =
    {
        {   str_empty,         TABLE_INTVAL,                    },
        {   "continental",     CLIMAT_CONTINENTAL,      TRUE    },
        {   "tropical",        CLIMAT_TROPIC,           TRUE    },
        {   "arctic",          CLIMAT_ARCTIC,           TRUE    },
        {   "sea",             CLIMAT_SEA,              TRUE    },
        {   "deserted",        CLIMAT_DESSERT,          TRUE    },
        {   "mountain",        CLIMAT_MOUNTAIN,         TRUE    },
        {   "highmountain",    CLIMAT_HIGHMOUNTAIN,     TRUE    },
        {   NULL}
    };

flag_t weather_flags[] =
    {
        {   str_empty,         TABLE_INTVAL,                    },
        {   "normal",          WEATHER_NORMAL,          TRUE    },
        {   "fine",            WEATHER_FINE,            TRUE    },
        {   "bad",             WEATHER_BAD,             TRUE    },
        {   "rain",            WEATHER_RAIN,            TRUE    },
        {   "disgusting",      WEATHER_DISGUSTING,      TRUE    },
        {   "cataclysm",       WEATHER_CATACLYSM,       TRUE    },
        {   NULL}
    };

flag_t planet_flags[] =
    {
        {   str_empty,         TABLE_INTVAL,                    },
        {   "Earth",           PLANET_EARTH,            TRUE    },
        {   "Hyperion",        PLANET_HYPERION,         TRUE    },
        {   NULL}
    };

flag_t sex_table[] =
    {
        { str_empty,    TABLE_INTVAL,           },
        { "none",       SEX_NEUTRAL,    TRUE    },
        { "male",       SEX_MALE,       TRUE    },
        { "female",     SEX_FEMALE,     TRUE    },
        { "either",     SEX_EITHER,     TRUE    },
        { "random",     SEX_EITHER,     TRUE    },
        { "neutral",    SEX_NEUTRAL,    TRUE    },
        { "plural",     SEX_PLURAL,     TRUE    },
        { NULL  }
    };

flag_t gender_table[] =
    {
        { str_empty,    TABLE_INTVAL,           },
        { "none",       SEX_NEUTRAL,    TRUE    },
        { "male",       SEX_MALE,       TRUE    },
        { "female",     SEX_FEMALE,     TRUE    },
        { "neutral",    SEX_NEUTRAL,    TRUE    },
        { "plural",     SEX_PLURAL,     TRUE    },
        { NULL  }
    };

flag_t exit_flags[] =
    {
        { str_empty,        TABLE_BITVAL,                  },
        { "door",           EX_ISDOOR,      TRUE, "{WD"    },
        { "closed",         EX_CLOSED,      TRUE, "{WC"    },
        { "locked",         EX_LOCKED,      TRUE, "{WL"    },
        { "noflee",         EX_NOFLEE,      TRUE, "{DF"    },
        { "pickproof",      EX_PICKPROOF,   TRUE, "{WR"    },
        { "nopass",         EX_NOPASS,      TRUE, "{DP"    },
        { "easy",           EX_EASY,        TRUE, "{WE"    },
        { "hard",           EX_HARD,        TRUE, "{WH"    },
        { "infuriating",    EX_INFURIATING, TRUE, "{WI"    },
        { "noclose",        EX_NOCLOSE,     TRUE, "{DC"    },
        { "nolock",         EX_NOLOCK,      TRUE, "{DL"    },
        { "invisible",      EX_INVIS,       TRUE, "{YI"    },
        { "noscan",         EX_NOSCAN,      TRUE, "{DS"    },
	{ "trap",           EX_TRAP,        TRUE, "{RT"    },
        { NULL }
    };

flag_t door_resets[] =
    {
        { str_empty,     TABLE_INTVAL,              },
        { "open",                   0,      TRUE    },
        { "closed",                 1,      TRUE    },
        { "closed and locked",      2,      TRUE    },
        { NULL }
    };

flag_t room_flags[] =
    {
        { str_empty,            TABLE_BITVAL,                    },
        { "dark",               ROOM_DARK,               TRUE    },
        { "nomob",              ROOM_NOMOB,              TRUE    },
        { "indoors",            ROOM_INDOORS,            TRUE    },
        { "peace",              ROOM_PEACE,              TRUE    },
        { "private",            ROOM_PRIVATE,            TRUE    },
        { "safe",               ROOM_SAFE,               TRUE    },
        { "solitary",           ROOM_SOLITARY,           TRUE    },
        { "pet_shop",           ROOM_PET_SHOP,           TRUE    },
        { "norecall",           ROOM_NORECALL,           TRUE    },
        { "imp_only",           ROOM_IMP_ONLY,           TRUE    },
        { "gods_only",          ROOM_GODS_ONLY,          TRUE    },
        { "heroes_only" ,       ROOM_HEROES_ONLY,        TRUE    },
        { "newbies_only",       ROOM_NEWBIES_ONLY,       TRUE    },
        { "law",                ROOM_LAW,                TRUE    },
        { "nowhere",            ROOM_NOWHERE,            TRUE    },
        { "bank",               ROOM_BANK,               TRUE    },
        { "nomagic",            ROOM_NOMAGIC,            TRUE    },
        { "nosummon",           ROOM_NOSUMMON,           TRUE    },
        { "battle_arena",       ROOM_BATTLE_ARENA,       TRUE    },
        { "registry",           ROOM_REGISTRY,           TRUE    },
        { "clanbank",           ROOM_CLANBANK,           TRUE    },
        { "full_pk",            ROOM_FULL_PK,            TRUE    },
        { "gamble",             ROOM_GAMBLE,             TRUE    },
        { "saltwater_fishing",  ROOM_SALTWATER_FISH,     TRUE    },
        { "freshwater_fishing", ROOM_FRESHWATER_FISH,    TRUE    },
        { "magic",              ROOM_MAGIC,              TRUE    },
        { "notimer",            ROOM_NOTIMER,            TRUE    },
        { "noexplore",          ROOM_NOEXPLORE,          TRUE    },
        { "nohp",               ROOM_NOHP,               TRUE    },
        { "nomana",             ROOM_NOMANA,             TRUE    },
        { "nomove",             ROOM_NOMOVE,             TRUE    },
        { "road",               ROOM_ROAD,               TRUE    },
        { "exit",               ROOM_EXIT,               TRUE    },
        { NULL }
    };

flag_t sector_types[] =
    {
        { str_empty,    TABLE_INTVAL,               },
        { "inside",     SECT_INSIDE,        TRUE    },
        { "city",       SECT_CITY,          TRUE    },
        { "field",      SECT_FIELD,         TRUE    },
        { "forest",     SECT_FOREST,        TRUE    },
        { "hills",      SECT_HILLS,         TRUE    },
        { "mountain",   SECT_MOUNTAIN,      TRUE    },
        { "swim",       SECT_WATER_SWIM,    TRUE    },
        { "noswim",     SECT_WATER_NOSWIM,  TRUE    },
        { "unused",     SECT_UNUSED,        TRUE    },
        { "air",        SECT_AIR,           TRUE    },
        { "desert",     SECT_DESERT,        TRUE    },
        { NULL }
    };

flag_t item_types[] =
    {
        { str_empty,         TABLE_INTVAL,               },
        { "light",           ITEM_LIGHT,         TRUE    },
        { "scroll",          ITEM_SCROLL,        TRUE    },
        { "wand",            ITEM_WAND,          TRUE    },
        { "staff",           ITEM_STAFF,         TRUE    },
        { "weapon",          ITEM_WEAPON,        TRUE    },
        { "treasure",        ITEM_TREASURE,      TRUE    },
        { "armor",           ITEM_ARMOR,         TRUE    },
        { "potion",          ITEM_POTION,        TRUE    },
        { "clothing",        ITEM_CLOTHING,      TRUE    },
        { "furniture",       ITEM_FURNITURE,     TRUE    },
        { "trash",           ITEM_TRASH,         TRUE    },
        { "container",       ITEM_CONTAINER,     TRUE    },
        { "drink",           ITEM_DRINK_CON,     TRUE    },
        { "key",             ITEM_KEY,           TRUE    },
        { "food",            ITEM_FOOD,          TRUE    },
        { "money",           ITEM_MONEY,         TRUE    },
        { "boat",            ITEM_BOAT,          TRUE    },
        { "npc_corpse",      ITEM_CORPSE_NPC,    TRUE    },
        { "pc_corpse",       ITEM_CORPSE_PC,     FALSE   },
        { "fountain",        ITEM_FOUNTAIN,      TRUE    },
        { "pill",            ITEM_PILL,          TRUE    },
        { "protect",         ITEM_PROTECT,       TRUE    },
        { "map",             ITEM_MAP,           TRUE    },
        { "portal",          ITEM_PORTAL,        TRUE    },
        { "warp_stone",      ITEM_WARP_STONE,    TRUE    },
        { "room_key",        ITEM_ROOM_KEY,      TRUE    },
        { "gem",             ITEM_GEM,           TRUE    },
        { "jewelry",         ITEM_JEWELRY,       TRUE    },
        { "jukebox",         ITEM_JUKEBOX,       TRUE    },
        { "tattoo",          ITEM_TATTOO,        TRUE    },
        { "fishing_pole",    ITEM_POLE,          TRUE    },
        { "scabbard",        ITEM_SCABBARD,      TRUE    },
        { "window",          ITEM_WINDOW,        TRUE    },
        { "slot_machine",    ITEM_SLOT_MACHINE,  TRUE    },
        { "riddle",          ITEM_RIDDLE,        TRUE    },
        { "religion_altar",  ITEM_RALTAR,        TRUE    },
        { "shaman_tattoo",   ITEM_SHAMAN_TATTOO, TRUE    },
        { "paint",           ITEM_PAINT,         TRUE    },
        { "learning_book",   ITEM_LEARN_BOOK,    TRUE    },
        { "keyring",         ITEM_KEYRING,       TRUE    },
        { NULL }
    };

flag_t extra_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "glow",           ITEM_GLOW,          TRUE    },
        { "hum",            ITEM_HUM,           TRUE    },
        { "dark",           ITEM_DARK,          TRUE    },
        { "lock",           ITEM_LOCK,          TRUE    },
        { "evil",           ITEM_EVIL,          TRUE    },
        { "invis",          ITEM_INVIS,         TRUE    },
        { "magic",          ITEM_MAGIC,         TRUE    },
        { "nodrop",         ITEM_NODROP,        TRUE    },
        { "bless",          ITEM_BLESS,         TRUE    },
        { "antigood",       ITEM_ANTI_GOOD,     TRUE    },
        { "antievil",       ITEM_ANTI_EVIL,     TRUE    },
        { "antineutral",    ITEM_ANTI_NEUTRAL,  TRUE    },
        { "noremove",       ITEM_NOREMOVE,      TRUE    },
        { "inventory",      ITEM_INVENTORY,     TRUE    },
        { "nopurge",        ITEM_NOPURGE,       TRUE    },
        { "rotdeath",       ITEM_ROT_DEATH,     TRUE    },
        { "visdeath",       ITEM_VIS_DEATH,     TRUE    },
        { "nosac",          ITEM_NOSAC,         TRUE    },
        { "nonmetal",       ITEM_NONMETAL,      TRUE    },
        { "nolocate",       ITEM_NOLOCATE,      TRUE    },
        { "meltdrop",       ITEM_MELT_DROP,     TRUE    },
        { "hadtimer",       ITEM_HAD_TIMER,     TRUE    },
        { "sellextract",    ITEM_SELL_EXTRACT,  TRUE    },
        { "burnproof",      ITEM_BURN_PROOF,    TRUE    },
        { "nouncurse",      ITEM_NOUNCURSE,     TRUE    },
        { "nosell",         ITEM_NOSELL,        TRUE    },
        { "not_edible",     ITEM_NOT_EDIBLE,    TRUE    },
        { "quest",          ITEM_QUEST,         TRUE    },
        { "pit",            ITEM_PIT,           TRUE    },
        { "enchanted",      ITEM_ENCHANTED,     TRUE    },
        { "mage_only",      ITEM_MAGE_ONLY,     TRUE    },
        { "warrior_only",   ITEM_WARRIOR_ONLY,  TRUE    },
        { "hero_only",      ITEM_HERO_ONLY,     TRUE    },
        { "god_only",       ITEM_GOD_ONLY,      TRUE    },
        { "nofind",         ITEM_NOFIND,        TRUE    },
        { "noloot",         ITEM_NOLOOT,        TRUE    },
        { "indestructable", ITEM_INDESTRUCTABLE,TRUE    },
        { "hidurability",   ITEM_HIDURABILITY,  TRUE    },
        { "oldstyle",       ITEM_OLDSTYLE,      FALSE   },
        { NULL }
    };

flag_t wear_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "take",           ITEM_TAKE,          TRUE    },
        { "head",           ITEM_WEAR_HEAD,     TRUE    },
        { "ear",            ITEM_WEAR_EAR,      TRUE    },
        { "neck",           ITEM_WEAR_NECK,     TRUE    },
        { "about",          ITEM_WEAR_ABOUT,    TRUE    },
        { "arms",           ITEM_WEAR_ARMS,     TRUE    },
        { "body",           ITEM_WEAR_BODY,     TRUE    },
        { "waist",          ITEM_WEAR_WAIST,    TRUE    },
        { "wrist",          ITEM_WEAR_WRIST,    TRUE    },
        { "finger",         ITEM_WEAR_FINGER,   TRUE    },
        { "hands",          ITEM_WEAR_HANDS,    TRUE    },
        { "wield",          ITEM_WIELD,         TRUE    },
        { "shield",         ITEM_WEAR_SHIELD,   TRUE    },
        { "hold",           ITEM_HOLD,          TRUE    },
        { "legs",           ITEM_WEAR_LEGS,     TRUE    },
        { "feet",           ITEM_WEAR_FEET,     TRUE    },
        { "nosac",          ITEM_WEAR_NOSAC,    TRUE    },
        { "tattoo",         ITEM_WEAR_TATTOO,   TRUE    },
        { "clanmark",       ITEM_WEAR_CLANMARK, TRUE    },
        { "float_around",   ITEM_WEAR_FLOAT,    TRUE    },
        { "plug_in",        ITEM_WEAR_PLUG_IN,  TRUE    },
        { "tail",           ITEM_WEAR_TAIL,     TRUE    },
        { "face",           ITEM_WEAR_FACE,     TRUE    },
        /*  { "twohands",       ITEM_TWO_HANDS,     TRUE    }, */
        { NULL }
    };

// ----------------------------------------------------------------------------
// for shamans
// ----------------------------------------------------------------------------
flag_t tattoo_wear_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "head",           ITEM_WEAR_HEAD,     TRUE    },
        { "neck",           ITEM_WEAR_NECK,     TRUE    },
        { "arms",           ITEM_WEAR_ARMS,     TRUE    },
        { "body",           ITEM_WEAR_BODY,     TRUE    },
        { "waist",          ITEM_WEAR_WAIST,    TRUE    },
        { "wrist",          ITEM_WEAR_WRIST,    TRUE    },
        { "hands",          ITEM_WEAR_HANDS,    TRUE    },
        { "legs",           ITEM_WEAR_LEGS,     TRUE    },
        { "feet",           ITEM_WEAR_FEET,     TRUE    },
        { "face",           ITEM_WEAR_FACE,     TRUE    },
        { NULL }
    };

flag_t paint_color_flags[] =
    {
        { str_empty,        TABLE_BITVAL,                   },
        { "red",            F_TATTOO_COLOR_RED,     TRUE    },
        { "blue",           F_TATTOO_COLOR_BLUE,    TRUE    },
        { "green",          F_TATTOO_COLOR_GREEN,   TRUE    },
        { "magenta",        F_TATTOO_COLOR_MAGENTA, TRUE    },
        { "white",          F_TATTOO_COLOR_WHITE,   TRUE    },
        { "black",          F_TATTOO_COLOR_BLACK,   TRUE    },
        { "gold",           F_TATTOO_COLOR_GOLD,    TRUE    },
        { "silver",         F_TATTOO_COLOR_SILVER,  TRUE    },
        { "brown",          F_TATTOO_COLOR_BROWN,   TRUE    },
        { NULL }
    };

flag_t paint_color_int_flags[] =
    {
        { str_empty,        TABLE_INTVAL,                 },
        { "red",            TATTOO_COLOR_RED,     TRUE    },
        { "blue",           TATTOO_COLOR_BLUE,    TRUE    },
        { "green",          TATTOO_COLOR_GREEN,   TRUE    },
        { "magenta",        TATTOO_COLOR_MAGENTA, TRUE    },
        { "white",          TATTOO_COLOR_WHITE,   TRUE    },
        { "black",          TATTOO_COLOR_BLACK,   TRUE    },
        { "gold",           TATTOO_COLOR_GOLD,    TRUE    },
        { "silver",         TATTOO_COLOR_SILVER,  TRUE    },
        { "brown",          TATTOO_COLOR_BROWN,   TRUE    },
        { NULL }
    };

flag_t tattoo_extra_flags[] =
    {
        { str_empty,        TABLE_BITVAL,                 },
        { "paint_other",    TE_PAINT_OTHER,       TRUE    },
        { "one_copy",       TE_ONE_COPY,          TRUE    },
        { "spellup",        TE_SPELLUP,          TRUE    },
        { NULL }
    };

flag_t ritual_extra_flags[] =
    {
        { str_empty,        TABLE_BITVAL,                 },
        { "no_adrenalin",   RE_NO_ADRENALIN,      TRUE    },
        { "full_hp",        RE_FULL_HP,           TRUE    },
        { "spellup",        TE_SPELLUP,           TRUE    },
        { NULL }
    };

flag_t sector_flag_types[] =
    {
        { str_empty,        TABLE_BITVAL,                 },
        { "inside",         F_SECT_INSIDE,        TRUE    },
        { "city",           F_SECT_CITY,          TRUE    },
        { "field",          F_SECT_FIELD,         TRUE    },
        { "forest",         F_SECT_FOREST,        TRUE    },
        { "hills",          F_SECT_HILLS,         TRUE    },
        { "mountain",       F_SECT_MOUNTAIN,      TRUE    },
        { "swim",           F_SECT_WATER_SWIM,    TRUE    },
        { "noswim",         F_SECT_WATER_NOSWIM,  TRUE    },
        { "unused",         F_SECT_UNUSED,        TRUE    },
        { "air",            F_SECT_AIR,           TRUE    },
        { "desert",         F_SECT_DESERT,        TRUE    },
        { NULL }
    };

flag_t time_flag_types[] =
    {
        { str_empty,        TABLE_BITVAL,                 },
        { "dark",           F_SUN_DARK,           TRUE    },
        { "sunrise",        F_SUN_RISE,           TRUE    },
        { "light",          F_SUN_LIGHT,          TRUE    },
        { "sunset",         F_SUN_SET,            TRUE    },
        { NULL }
    };
// ----------------------------------------------------------------------------
// end of shamans' section
// ----------------------------------------------------------------------------

/*
* Used when adding an affect to tell where it goes.
* See addaffect and delaffect in act_olc.c
*/
flag_t apply_flags[] =
    {
        { str_empty,        TABLE_INTVAL,                   },
        { "none",           APPLY_NONE,             TRUE    },
        { "strength",       APPLY_STR,              TRUE    },
        { "dexterity",      APPLY_DEX,              TRUE    },
        { "intelligence",   APPLY_INT,              TRUE    },
        { "wisdom",         APPLY_WIS,              TRUE    },
        { "constitution",   APPLY_CON,              TRUE    },
        { "charisma",       APPLY_CHA,              TRUE    },
        { "sex",            APPLY_SEX,              TRUE    },
        { "level",          APPLY_LEVEL,            TRUE    },
        { "age",            APPLY_AGE,              TRUE    },
        { "height",         APPLY_HEIGHT,           TRUE    },
        { "weight",         APPLY_WEIGHT,           TRUE    },
        { "mana",           APPLY_MANA,             TRUE    },
        { "hp",             APPLY_HIT,              TRUE    },
        { "move",           APPLY_MOVE,             TRUE    },
        { "gold",           APPLY_GOLD,             TRUE    },
        { "experience",     APPLY_EXP,              TRUE    },
        { "ac",             APPLY_AC,               TRUE    },
        { "hitroll",        APPLY_HITROLL,          TRUE    },
        { "damroll",        APPLY_DAMROLL,          TRUE    },
        { "saves",          APPLY_SAVES,            TRUE    },
        { "savingpara",     APPLY_SAVING_PARA,      TRUE    },
        { "savingrod",      APPLY_SAVING_ROD,       TRUE    },
        { "savingpetri",    APPLY_SAVING_PETRI,     TRUE    },
        { "savingbreath",   APPLY_SAVING_BREATH,    TRUE    },
        { "savingspell",    APPLY_SAVING_SPELL,     TRUE    },
        { "spellaffect",    APPLY_SPELL_AFFECT,     TRUE    },
        { "size",           APPLY_SIZE,             TRUE    },
        { "class",          APPLY_CLASS,            TRUE    },
        { "race",           APPLY_RACE,             TRUE    },
        { "lck",            APPLY_LCK,              TRUE    },
        { NULL }
    };

flag_t rapply_flags[] =
    {
        { str_empty,        TABLE_INTVAL,               },
        { "healrate",       APPLY_ROOM_HEAL,    TRUE    },
        { "manarate",       APPLY_ROOM_MANA,    TRUE    },
        { NULL }
    };

/*
 * What is seen.
 */
flag_t wear_loc_strings[] =
    {
        { str_empty,                TABLE_INTVAL,               },
        { " ",            WEAR_NONE,          TRUE    },
        { "",                 WEAR_LIGHT,         TRUE    },
        { " ",              WEAR_HEAD,          TRUE    },
        { " ",                  WEAR_EAR,           TRUE    },
        { " ",                 WEAR_NECK_1,        TRUE    },
        { "  ",      WEAR_ABOUT,         TRUE    },
        { " ",              WEAR_ARMS,          TRUE    },
        { " ",                WEAR_BODY,          TRUE    },
        { " ",           WEAR_WAIST,         TRUE    },
        { "  ",      WEAR_WRIST_L,       TRUE    },
        { "  ",     WEAR_WRIST_R,       TRUE    },
        { "   ",   WEAR_FINGER_L,      TRUE    },
        { "   ",  WEAR_FINGER_R,      TRUE    },
        { " ",               WEAR_HANDS,         TRUE    },
        { "",                 WEAR_WIELD,         TRUE    },
        { " ",          WEAR_SECOND_WIELD,  TRUE    },
        { "",                    WEAR_SHIELD,        TRUE    },
        { "  ",          WEAR_HOLD,          TRUE    },
        { " ",               WEAR_LEGS,          TRUE    },
        { " ",             WEAR_FEET,          TRUE    },
        { "",             WEAR_TATTOO,        TRUE    },
        { " ",          WEAR_CLANMARK,      TRUE    },
        { " ",           WEAR_FLOAT,         TRUE    },
        { "",               WEAR_STUCK_IN,      TRUE    },
        { " ",    WEAR_PLUG_IN,       TRUE    },
        { "  ",    WEAR_TAIL,          TRUE    },
        { " ",                WEAR_FACE,          TRUE    },
        { NULL }
    };

flag_t wear_loc_flags[] =
    {
        { str_empty,    TABLE_INTVAL,               },
        { "none",       WEAR_NONE,          TRUE    },
        { "inventory",  WEAR_NONE,          TRUE    },
        { "light",      WEAR_LIGHT,         TRUE    },
        { "head",       WEAR_HEAD,          TRUE    },
        { "ear",        WEAR_EAR,           TRUE    },
        { "neck1",      WEAR_NECK_1,        TRUE    },
        { "about",      WEAR_ABOUT,         TRUE    },
        { "arms",       WEAR_ARMS,          TRUE    },
        { "body",       WEAR_BODY,          TRUE    },
        { "waist",      WEAR_WAIST,         TRUE    },
        { "lwrist",     WEAR_WRIST_L,       TRUE    },
        { "rwrist",     WEAR_WRIST_R,       TRUE    },
        { "lfinger",    WEAR_FINGER_L,      TRUE    },
        { "rfinger",    WEAR_FINGER_R,      TRUE    },
        { "hands",      WEAR_HANDS,         TRUE    },
        { "wielded",    WEAR_WIELD,         TRUE    },
        { "second",     WEAR_SECOND_WIELD,  TRUE    },
        { "shield",     WEAR_SHIELD,        TRUE    },
        { "hold",       WEAR_HOLD,          TRUE    },
        { "legs",       WEAR_LEGS,          TRUE    },
        { "feet",       WEAR_FEET,          TRUE    },
        { "tattoo",     WEAR_TATTOO,        TRUE    },
        { "clanmark",   WEAR_CLANMARK,      TRUE    },
        { "floating",   WEAR_FLOAT,         TRUE    },
        { "stuck",      WEAR_STUCK_IN,      TRUE    },
        { "plug_in",    WEAR_PLUG_IN,       TRUE    },
        { "tail",       WEAR_TAIL,          TRUE    },
        { "face",       WEAR_FACE,          TRUE    },
        { NULL }
    };

flag_t cont_flags[] =
    {
        { str_empty,    TABLE_BITVAL,               },
        { "closable",   CONT_CLOSEABLE,     TRUE    },
        { "pickproof",  CONT_PICKPROOF,     TRUE    },
        { "closed",     CONT_CLOSED,        TRUE    },
        { "locked",     CONT_LOCKED,        TRUE    },
        { "put_on",     CONT_PUT_ON,        TRUE    },
        { "quiver",     CONT_QUIVER,        TRUE    },
        { "roomy",      CONT_ROOMY,         TRUE    },
        { NULL }
    };

flag_t ac_type[] =
    {
        { str_empty,    TABLE_INTVAL,           },
        { "pierce",     AC_PIERCE,      TRUE    },
        { "bash",       AC_BASH,        TRUE    },
        { "slash",      AC_SLASH,       TRUE    },
        { "exotic",     AC_EXOTIC,      TRUE    },
        { NULL }
    };

flag_t weapon_class[] =
    {
        { str_empty,    TABLE_INTVAL,               },
        { "exotic",     WEAPON_EXOTIC,      TRUE    },
        { "sword",      WEAPON_SWORD,       TRUE    },
        { "dagger",     WEAPON_DAGGER,      TRUE    },
        { "spear",      WEAPON_SPEAR,       TRUE    },
        { "staff",      WEAPON_SPEAR,       TRUE    }, /* compat */
        { "mace",       WEAPON_MACE,        TRUE    },
        { "axe",        WEAPON_AXE,         TRUE    },
        { "flail",      WEAPON_FLAIL,       TRUE    },
        { "whip",       WEAPON_WHIP,        TRUE    },
        { "polearm",    WEAPON_POLEARM,     TRUE    },
        { "bow",        WEAPON_BOW,         TRUE    },
        { "arrow",      WEAPON_ARROW,       TRUE    },
        { "lance",      WEAPON_LANCE,       TRUE    },
        { "shuriken",   WEAPON_SHURIKEN,    TRUE    },
        { "knife",      WEAPON_KNIFE,       TRUE    },
        { "grenade",    WEAPON_GRENADE,     TRUE    },
        { "lightsaber", WEAPON_LIGHTSABER,  TRUE    },
        { NULL }
    };

flag_t weapon_type2[] =
    {
        { str_empty,    TABLE_BITVAL,                        },
        { "flaming",    WEAPON_FLAMING,     TRUE,   "{RF{z"  },
        { "frost",      WEAPON_FROST,       TRUE,   "{cO{z"  },
        { "vampiric",   WEAPON_VAMPIRIC,    TRUE,   "{DV{z"  },
        { "sharp",      WEAPON_SHARP,       TRUE,   "{WS{z"  },
        { "vorpal",     WEAPON_VORPAL,      TRUE,   "{BL{z"  },
        { "twohands",   WEAPON_TWO_HANDS,   TRUE,   "{gT{z"  },
        { "shocking",   WEAPON_SHOCKING,    TRUE,   "{CG{z"  },
        { "poison",     WEAPON_POISON,      TRUE,   "{GP{z"  },
        { "holy",       WEAPON_HOLY,        TRUE,   "{YH{z"  },
        { "katana",     WEAPON_KATANA,      TRUE,   "{mK{z"  },
        { "radiation",  WEAPON_RADIATION,   TRUE,   "{yR{z"  },
        { NULL }
    };

flag_t res_flags[] =
    {
        { str_empty,    TABLE_BITVAL,           },
        { "summon",     RES_SUMMON,     TRUE    },
        { "charm",      RES_CHARM,      TRUE    },
        { "magic",      RES_MAGIC,      TRUE    },
        { "weapon",     RES_WEAPON,     TRUE    },
        { "bash",       RES_BASH,       TRUE    },
        { "pierce",     RES_PIERCE,     TRUE    },
        { "slash",      RES_SLASH,      TRUE    },
        { "fire",       RES_FIRE,       TRUE    },
        { "cold",       RES_COLD,       TRUE    },
        { "light",      RES_LIGHT,      TRUE    },
        { "lightning",  RES_LIGHTNING,  TRUE    },
        { "acid",       RES_ACID,       TRUE    },
        { "poison",     RES_POISON,     TRUE    },
        { "negative",   RES_NEGATIVE,   TRUE    },
        { "holy",       RES_HOLY,       TRUE    },
        { "energy",     RES_ENERGY,     TRUE    },
        { "mental",     RES_MENTAL,     TRUE    },
        { "disease",    RES_DISEASE,    TRUE    },
        { "physical",   RES_PHYSICAL,   TRUE    },
        { "sound",      RES_SOUND,      TRUE    },
        { "radiation",  RES_RADIATION,  TRUE    },
        { "silver",     RES_SILVER,     TRUE    },
        { "iron",       RES_IRON,       TRUE    },
        { "wood",       RES_WOOD,       TRUE    },
        { NULL }
    };

flag_t position_table[] =
    {
        { str_empty,    TABLE_INTVAL,           },
        { "dead",       POS_DEAD,       TRUE    },
        { "mort",       POS_MORTAL,     TRUE    },
        { "incap",      POS_INCAP,      TRUE    },
        { "stun",       POS_STUNNED,    TRUE    },
        { "sleep",      POS_SLEEPING,   TRUE    },
        { "rest",       POS_RESTING,    TRUE    },
        { "sit",        POS_SITTING,    TRUE    },
        { "fight",      POS_FIGHTING,   TRUE    },
        { "stand",      POS_STANDING,   TRUE    },
        { NULL }
    };

flag_t position_names[] =
    {
        { str_empty,            TABLE_INTVAL,   },
        { "",              POS_DEAD        },
        { " ",   POS_MORTAL      },
        { " ",             POS_INCAP       },
        { "",            POS_STUNNED     },
        { "",              POS_SLEEPING    },
        { "",          POS_RESTING     },
        { "",             POS_SITTING     },
        { "",         POS_FIGHTING    },
        { "",             POS_STANDING    },
        { NULL }
    };

flag_t portal_flags[]=
    {
        { str_empty,     TABLE_BITVAL,                       },
        { "normal_exit", GATE_NORMAL_EXIT,   TRUE,  "{wN"    },
        { "nocurse",     GATE_NOCURSE,       TRUE,  "{DC"    },
        { "gowith",      GATE_GOWITH,        TRUE,  "{CW"    },
        { "buggy",       GATE_BUGGY,         TRUE,  "{CB"    },
        { "random",      GATE_RANDOM,        TRUE,  "{CR"    },
        { "transparent", GATE_TRANSPARENT,   TRUE,  "{YT"    },
        { "nopumped",    GATE_NOPUMPED,      TRUE,  "{RP"    },
        { NULL }
    };

flag_t furniture_flags[]=
    {
        { str_empty,    TABLE_BITVAL,           },
        { "stand_at",   STAND_AT,       TRUE    },
        { "stand_on",   STAND_ON,       TRUE    },
        { "stand_in",   STAND_IN,       TRUE    },
        { "sit_at",     SIT_AT,         TRUE    },
        { "sit_on",     SIT_ON,         TRUE    },
        { "sit_in",     SIT_IN,         TRUE    },
        { "rest_at",    REST_AT,        TRUE    },
        { "rest_on",    REST_ON,        TRUE    },
        { "rest_in",    REST_IN,        TRUE    },
        { "sleep_at",   SLEEP_AT,       TRUE    },
        { "sleep_on",   SLEEP_ON,       TRUE    },
        { "sleep_in",   SLEEP_IN,       TRUE    },
        { "put_at",     PUT_AT,         TRUE    },
        { "put_on",     PUT_ON,         TRUE    },
        { "put_in",     PUT_IN,         TRUE    },
        { "put_inside", PUT_INSIDE,     TRUE    },
        { NULL }
    };

flag_t apply_types[] =
    {
        { str_empty,        TABLE_INTVAL,           },
        { "affects",        TO_AFFECTS,     TRUE    },
        { "immune",         TO_IMMUNE,      TRUE    },
        { "resist",         TO_RESIST,      TRUE    },
        { "form",           TO_FORM,        TRUE    },
        /*  { "object",     TO_OBJECT,      TRUE    }, */
        /*  { "vuln",       TO_VULN,        TRUE    },*/
        /*  { "weapon",     TO_WEAPON,      TRUE    }, */
        { NULL }
    };

flag_t raffect_flags[] =
    {
        { str_empty,    TABLE_BITVAL,               },
        { "shocking",   RAFF_SHOCKING,      TRUE    },
        { "lshield",    RAFF_LSHIELD,       TRUE    },
        { "thief_trap", RAFF_THIEF_TRAP,    TRUE    },
        { "randomizer", RAFF_RANDOMIZER,    TRUE    },
        { "espirit",    RAFF_ESPIRIT,       TRUE    },
        { "curse",      RAFF_CURSE,         TRUE    },
        { "poison",     RAFF_POISON,        TRUE    },
        { "sleep",      RAFF_SLEEP,         TRUE    },
        { "plague",     RAFF_PLAGUE,        TRUE    },
        { "slow",       RAFF_SLOW,          TRUE    },
        { "radiation",  RAFF_RADIATION,     TRUE    },
        { "prevent",    RAFF_PREVENT,       TRUE    },
        { "fwall",      RAFF_FWALL,         TRUE    },
        { "protection", RAFF_PROTECTION,    TRUE    },
        { NULL }
    };

flag_t skill_groups[] =
    {
        { str_empty,        TABLE_BITVAL,                     },
        { "none",           GROUP_NONE,               TRUE    },
        { "weaponsmaster",  GROUP_WEAPONSMASTER,      TRUE    },
        { "attack",         GROUP_ATTACK,             TRUE    },
        { "beguiling",      GROUP_BEGUILING,          TRUE    },
        { "benedictions",   GROUP_BENEDICTIONS,       TRUE    },
        { "combat",         GROUP_COMBAT,             TRUE    },
        { "summoning",      GROUP_SUMMONING,          TRUE    },
        { "curative",       GROUP_CURATIVE,           TRUE    },
        { "detection",      GROUP_DETECTION,          TRUE    },
        { "draconian",      GROUP_DRACONIAN,          TRUE    },
        { "enchantment",    GROUP_ENCHANTMENT,        TRUE    },
        { "enhancement",    GROUP_ENHANCEMENT,        TRUE    },
        { "harmful",        GROUP_HARMFUL,            TRUE    },
        { "healing",        GROUP_HEALING,            TRUE    },
        { "illusion",       GROUP_ILLUSION,           TRUE    },
        { "maladictions",   GROUP_MALADICTIONS,       TRUE    },
        { "protective",     GROUP_PROTECTIVE,         TRUE    },
        { "transportation", GROUP_TRANSPORTATION,     TRUE    },
        { "weather",        GROUP_WEATHER,            TRUE    },
        { "fightmaster",    GROUP_FIGHTMASTER,        TRUE    },
        { "abjuration",     GROUP_ABJURATION,         TRUE    },
        { "meditation",     GROUP_MEDITATION,         TRUE    },
        { "clan",           GROUP_CLAN,               TRUE    },
        { "defensive",      GROUP_DEFENSIVE,          TRUE    },
        { "wizard",         GROUP_WIZARD,             TRUE    },
        { "psionics",       GROUP_PSIONICS,           TRUE    },
        { "covert",         GROUP_COVERT,             TRUE    },
        { "craft",          GROUP_CRAFT,              TRUE    },
        { "natural",        GROUP_NATURAL,            TRUE    },
        { "necromancy",     GROUP_NECROMANCY,         TRUE    },
        { "elemental",      GROUP_ELEMENTAL,          TRUE    },
        { "fishing",        GROUP_FISHING,            TRUE    },
        { "tattoo",         GROUP_TATTOO,             TRUE    },
        { "ritual",         GROUP_RITUAL,             TRUE    },
        { NULL }
    };

flag_t psi_disciplines[] =
    {
        { str_empty,            TABLE_INTVAL,                   },
        { "clairsentience",     DISC_CLAIRSENTIENCE,    TRUE    },
        { "psychokinesis",      DISC_PSYCHOKINESIS,     TRUE    },
        { "psychometabolism",   DISC_PSYCHOMETABOLISM,  TRUE    },
        { "psychoportation",    DISC_PSYCHOPORTATION,   TRUE    },
        { "telepathy",          DISC_TELEPATHY,         TRUE    },
        { "metapsionics",       DISC_METAPSIONICS,      TRUE    },
        { NULL }
    };

flag_t mptrig_types[] =
    {
        { str_empty,    TABLE_INTVAL,           },
        { "act",        TRIG_ACT,       TRUE    },
        { "bribe",      TRIG_BRIBE,     TRUE    },
        { "death",      TRIG_DEATH,     TRUE    },
        { "entry",      TRIG_ENTRY,     TRUE    },
        { "fight",      TRIG_FIGHT,     TRUE    },
        { "give",       TRIG_GIVE,      TRUE    },
        { "greet",      TRIG_GREET,     TRUE    },
        { "grall",      TRIG_GRALL,     TRUE    },
        { "kill",       TRIG_KILL,      TRUE    },
        { "hpcnt",      TRIG_HPCNT,     TRUE    },
        { "random",     TRIG_RANDOM,    TRUE    },
        { "speech",     TRIG_SPEECH,    TRUE    },
        { "exit",       TRIG_EXIT,      TRUE    },
        { "exall",      TRIG_EXALL,     TRUE    },
        { "delay",      TRIG_DELAY,     TRUE    },
        { "surr",       TRIG_SURR,      TRUE    },
        { "start",      TRIG_START,     TRUE    },
        { NULL }
    };

flag_t oprog_flags[] =
    {
        { str_empty,        TABLE_INTVAL,           },
        {   "act",          TRIG_ACT,       TRUE    },
        {   "fight",        TRIG_FIGHT,     TRUE    },
        {   "give",         TRIG_GIVE,      TRUE    },
        {   "greet",        TRIG_GRALL,     TRUE    },
        {   "random",       TRIG_RANDOM,    TRUE    },
        {   "speech",       TRIG_SPEECH,    TRUE    },
        {   "exall",        TRIG_EXALL,     TRUE    },
        {   "delay",        TRIG_DELAY,     TRUE    },
        {   "drop",         TRIG_DROP,      TRUE    },
        {   "get",          TRIG_GET,       TRUE    },
        {   "sit",          TRIG_SIT,       TRUE    },
        {   NULL },
    };

flag_t rprog_flags[] =
    {
        { str_empty,        TABLE_INTVAL,           },
        {   "act",          TRIG_ACT,       TRUE    },
        {   "fight",        TRIG_FIGHT,     TRUE    },
        {   "drop",         TRIG_DROP,      TRUE    },
        {   "greet",        TRIG_GRALL,     TRUE    },
        {   "random",       TRIG_RANDOM,    TRUE    },
        {   "speech",       TRIG_SPEECH,    TRUE    },
        {   "exall",        TRIG_EXALL,     TRUE    },
        {   "delay",        TRIG_DELAY,     TRUE    },
        {   NULL },
    };

flag_t optrig_flags[] =
    {
        { str_empty,        TABLE_BITVAL,           },
        { "case-sensitive", TRIG_CASEDEP,   FALSE   },
        { NULL }
    };

flag_t rptrig_flags[] =
    {
        { str_empty,        TABLE_BITVAL,           },
        { "case-sensitive", TRIG_CASEDEP,   FALSE   },
        { NULL }
    };

flag_t mptrig_flags[] =
    {
        { str_empty,        TABLE_BITVAL,           },
        { "case-sensitive", TRIG_CASEDEP,   FALSE   },
        { NULL }
    };

flag_t skill_targets[] =
    {
        { str_empty,        TABLE_INTVAL,               },
        { "ignore",         TAR_IGNORE,         TRUE    },
        { "charoff",        TAR_CHAR_OFFENSIVE, TRUE    },
        { "chardef",        TAR_CHAR_DEFENSIVE, TRUE    },
        { "charself",       TAR_CHAR_SELF,      TRUE    },
        { "objinv",         TAR_OBJ_INV,        TRUE    },
        { "objchardef",     TAR_OBJ_CHAR_DEF,   TRUE    },
        { "objcharoff",     TAR_OBJ_CHAR_OFF,   TRUE    },
        { NULL }
    };

flag_t skill_types[] =
    {
        { str_empty,    TABLE_INTVAL,           },
        { "skill",      TYPE_SKILL,     TRUE    },
        { "spell",      TYPE_SPELL,     TRUE    },
        { "miracle",    TYPE_MIRACLE,   TRUE    },
        { "power",      TYPE_POWER,     TRUE    },
        { "song",       TYPE_SONG,      TRUE    },
        { "program",    TYPE_PROGRAM,   TRUE    },
        { "auto",       TYPE_AUTO,      TRUE    },
        { "language",   TYPE_LANGUAGE,  TRUE    },
        { "ability",    TYPE_ABILITY,   TRUE    },
        { "tattoo" ,    TYPE_TATTOO,    TRUE    },
        { "ritual",     TYPE_RITUAL,    TRUE    },
        { NULL }
    };

flag_t stat_names[] =
    {
        { str_empty,    TABLE_INTVAL,           },
        { "str",        STAT_STR,       TRUE    },
        { "int",        STAT_INT,       TRUE    },
        { "wis",        STAT_WIS,       TRUE    },
        { "dex",        STAT_DEX,       TRUE    },
        { "con",        STAT_CON,       TRUE    },
        { "cha",        STAT_CHA,       TRUE    },
        { "lck",        STAT_LCK,       TRUE    },
        { NULL }
    };

flag_t skill_flags[] =
    {
        { str_empty,            TABLE_BITVAL,                   },
        { "clan",               SKILL_CLAN,             TRUE    },
        { "range",              SKILL_RANGE,            TRUE    },
        { "area_attack",        SKILL_AREA_ATTACK,      TRUE    },
        { "scribe",             SKILL_SCRIBE,           TRUE    },
        { "mental",             SKILL_MENTAL,           TRUE    },
        { "verbal",             SKILL_VERBAL,           TRUE    },
        { "gest",               SKILL_GEST,             TRUE    },
        { "nodispel",           SKILL_NODISPEL,         TRUE    },
        { "questionable",       SKILL_QUESTIONABLE,     TRUE    },
        { "extraordinary",      SKILL_EXTRAORDINARY,    TRUE    },
        { "hidden",             SKILL_HIDDEN,           TRUE    },
        { "contact_required",   SKILL_CONTACT_REQUIRED, TRUE    },
        { "mindlink_required",  SKILL_MINDLINK_REQUIRED,TRUE    },
        { "no_arena",           SKILL_NOARENA,          TRUE    },
        { "vampire",            SKILL_VAMPIRE,          TRUE    },
        { NULL }
    };

flag_t class_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "hidden",         CLASS_HIDDEN,       TRUE    },
        { "mage",           CLASS_MAGIC,        TRUE    },
        { "warrior",        CLASS_WARR,         TRUE    },
        { "noch",           CLASS_NOCH,         TRUE    },
        { "changed",        CLASS_CHANGED,      FALSE   },
        { NULL }
    };

/*
 * Race and PCrace flags
 */

flag_t race_flags[] =
    {
        { str_empty,    TABLE_BITVAL,               },
        { "hidden",     RACE_HIDDEN,        TRUE    },
        { "noch",       RACE_NOCH,          TRUE    },
        { "changed",    RACE_CHANGED,       FALSE   },
        { NULL }
    };

flag_t religion_flags[] =
    {
        { str_empty,            TABLE_BITVAL,                           },
        { "hidden",             RELIGION_HIDDEN,                TRUE    },
        { "classes_restricted", RELIGION_CLASSES_RESTRICTED,    TRUE    },
        { "races_restricted",   RELIGION_RACES_RESTRICTED,      TRUE    },
        { "nopk",               RELIGION_NOPK_ONLY,             TRUE    },
        { "changed",            RELIGION_CHANGED,               FALSE   },
        { NULL }
    };

flag_t hometown_flags[] =
    {
        { str_empty,            TABLE_BITVAL,                           },
        { "hidden",             HOMETOWN_HIDDEN,                TRUE    },
        { "classes_restricted", HOMETOWN_CLASSES_RESTRICTED,    TRUE    },
        { "races_restricted",   HOMETOWN_RACES_RESTRICTED,      TRUE    },
        { "changed",            HOMETOWN_CHANGED,               FALSE   },
        { NULL }
    };

flag_t status_table[] =
    {
        { str_empty,    TABLE_BITVAL,                           },
        { "allowed",    STATUS_ALLOWED,                 TRUE    },
        { "denied",     STATUS_DENIED,                  TRUE    },
        { "beloved",    STATUS_BELOVED,                 TRUE    },
        { "behated",    STATUS_BEHATED,                 TRUE    },
        { NULL }
    };

flag_t material_wear_status[] =
    {
        { str_empty,    TABLE_BITVAL,                           },
        { "denied",     STATUS_DENIED,                  TRUE    },
        { NULL }
    };    
    
flag_t ralign_names[] =
    {
        { str_empty,    TABLE_BITVAL,           },
        { "evil",       RA_EVIL,        TRUE    },
        { "neutral",    RA_NEUTRAL,     TRUE    },
        { "good",       RA_GOOD,        TRUE    },
        { NULL }
    };

flag_t align_names[] =
    {
        { str_empty,    TABLE_INTVAL,             },
        { "evil",       ANUM_EVIL,        TRUE    },
        { "neutral",    ANUM_NEUTRAL,     TRUE    },
        { "good",       ANUM_GOOD,        TRUE    },
        { NULL }
    };

flag_t lang_flags[] =
    {
        { str_empty,    TABLE_BITVAL,               },
        { "hidden",     LANG_HIDDEN,        TRUE    },
        { "changed",    LANG_CHANGED,       FALSE   },
        { NULL }
    };

flag_t rulecl_names[] =
    {
        { str_empty,    TABLE_INTVAL,           },
        { "cases",      RULES_CASE,     TRUE    },
        { "genders",    RULES_GENDER,   TRUE    },
        { "qtys",       RULES_QTY,      TRUE    },
        { NULL }
    };

flag_t rulecl_flags[] =
    {
        { str_empty,        TABLE_BITVAL,           },
        { "expl_changed",   RULES_EXPL_CHANGED      },
        { "impl_changed",   RULES_IMPL_CHANGED      },
        { NULL }
    };

flag_t note_types[] =
    {
        { str_empty,    TABLE_INTVAL,       },

        { "note",       NOTE_NOTE           },
        { "idea",       NOTE_IDEA           },
        { "penalty",    NOTE_PENALTY        },
        { "news",       NOTE_NEWS           },
        { "change",     NOTE_CHANGES        },

        { NULL }
    };

flag_t ethos_table[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "lawful",         ETHOS_LAWFUL,       TRUE    },
        { "neutral",        ETHOS_NEUTRAL,      TRUE    },
        { "chaotic",        ETHOS_CHAOTIC,      TRUE    },
        { NULL }
    };

flag_t restrict_sex_table[] =
    {
        { str_empty,            TABLE_BITVAL,                   },
        { "neutral",            R_SEX_NEUTRAL,          TRUE    },
        { "male",               R_SEX_MALE,             TRUE    },
        { "female",             R_SEX_FEMALE,           TRUE    },
        { NULL }
    };

flag_t dam_flags[] =
    {
        { str_empty,        TABLE_INTVAL,                   },
        { "none",           DAM_NONE,               TRUE    },
        { "any",            DAM_NONE,               TRUE    },
        { "bash",           DAM_BASH,               TRUE    },
        { "pierce",         DAM_PIERCE,             TRUE    },
        { "slash",          DAM_SLASH,              TRUE    },
        { "fire",           DAM_FIRE,               TRUE    },
        { "cold",           DAM_COLD,               TRUE    },
        { "light",          DAM_LIGHT,              TRUE    },
        { "lightning",      DAM_LIGHTNING,          TRUE    },
        { "acid",           DAM_ACID,               TRUE    },
        { "poison",         DAM_POISON,             TRUE    },
        { "negative",       DAM_NEGATIVE,           TRUE    },
        { "holy",           DAM_HOLY,               TRUE    },
        { "energy",         DAM_ENERGY,             TRUE    },
        { "mental",         DAM_MENTAL,             TRUE    },
        { "disease",        DAM_DISEASE,            TRUE    },
        { "physical",       DAM_PHYSICAL,           TRUE    },
        { "other",          DAM_OTHER,              TRUE    },
        { "harm",           DAM_HARM,               TRUE    },
        { "charm",          DAM_CHARM,              TRUE    },
        { "sound",          DAM_SOUND,              TRUE    },
        { "thirst",         DAM_THIRST,             TRUE    },
        { "hunger",         DAM_HUNGER,             TRUE    },
        { "light_v",        DAM_LIGHT_V,            TRUE    },
        { "trap_room",      DAM_TRAP_ROOM,          TRUE    },
        { "space",          DAM_SPACE,              TRUE    },
        { "radiation",      DAM_RADIATION,          TRUE    },
        { "summon",         DAM_SUMMON,             TRUE    },
        { "magic",          DAM_MAGIC,              TRUE    },
        { "weapon",         DAM_WEAPON,             TRUE    },
        { "wood",           DAM_WOOD,               TRUE    },
        { "iron",           DAM_IRON,               TRUE    },
        { "silver",         DAM_SILVER,             TRUE    },
        { NULL }
    };

flag_t imm_flags[] =
    {
        { str_empty,        TABLE_BITVAL,                           },
        { "any",            IMM_NONE,               TRUE,    "{YF{z" },
        { "bash",           IMM_BASH,               TRUE,    "{YB{z" },
        { "pierce",         IMM_PIERCE,             TRUE,    "{YP{z" },
        { "slash",          IMM_SLASH,              TRUE,    "{YS{z" },
        { "fire",           IMM_FIRE,               TRUE,    "{Yf{z" },
        { "cold",           IMM_COLD,               TRUE,    "{YC{z" },
        { "light",          IMM_LIGHT,              TRUE,    "{YL{z" },
        { "lightning",      IMM_LIGHTNING,          TRUE,    "{Yl{z" },
        { "acid",           IMM_ACID,               TRUE,    "{YA{z" },
        { "poison",         IMM_POISON,             TRUE,    "{Yp{z" },
        { "negative",       IMM_NEGATIVE,           TRUE,    "{YN{z" },
        { "holy",           IMM_HOLY,               TRUE,    "{YH{z" },
        { "energy",         IMM_ENERGY,             TRUE,    "{YE{z" },
        { "mental",         IMM_MENTAL,             TRUE,    "{YM{z" },
        { "disease",        IMM_DISEASE,            TRUE,    "{YD{z" },
        { "physical",       IMM_PHYSICAL,           TRUE,    "{Yp{z" },
        { "other",          IMM_OTHER,              TRUE,    "{YO{z" },
        { "harm",           IMM_HARM,               TRUE,    "{Yh{z" },
        { "charm",          IMM_CHARM,              TRUE,    "{Yc{z" },
        { "sound",          IMM_SOUND,              TRUE,    "{Ys{z" },
        { "thirst",         IMM_THIRST,             TRUE,    "{YT{z" },
        { "hunger",         IMM_HUNGER,             TRUE,    "{Yt{z" },
        { "light_v",        IMM_LIGHT_V,            TRUE,    "{Yv{z" },
        { "trap_room",      IMM_TRAP_ROOM,          TRUE,    "{YR{z" },
        { "space",          IMM_SPACE,              TRUE,    "{Ys{z" },
        { "radiation",      IMM_RADIATION,          TRUE,    "{Yr{z" },
        { "summon",         IMM_SUMMON,             TRUE,    "{Yj{z" },
        { "magic",          IMM_MAGIC,              TRUE,    "{Ym{z" },
        { "weapon",         IMM_WEAPON,             TRUE,    "{YW{z" },
        { "wood",           IMM_WOOD,               TRUE,    "{Yw{z" },
        { "iron",           IMM_IRON,               TRUE,    "{Yz{z" },
        { "silver",         IMM_SILVER,             TRUE,    "{YZ{z" },
        { NULL }
    };

flag_t level_table[] =
    {
        { str_empty,            TABLE_INTVAL,                   },
        { "implementor",        ML,                     TRUE    },
        { "creator",            L1,                     TRUE    },
        { "supreme",            L2,                     TRUE    },
        { "deity",              L3,                     TRUE    },
        { "god",                L4,                     TRUE    },
        { "immortal",           L5,                     TRUE    },
        { "demigod",            L6,                     TRUE    },
        { "angel",              L7,                     TRUE    },
        { "avatar",             L8,                     TRUE    },
        { "angel",              IM,                     TRUE    },
        { "hero",               HE,                     TRUE    },
        { NULL }
    };

flag_t log_flags[] =
    {
        { str_empty,            TABLE_BITVAL,                           },
        { "always",             LOG_ALWAYS,             TRUE            },
        { "never",              LOG_NEVER,              TRUE            },
        { NULL }
    };

flag_t command_flags[] =
    {
        { str_empty,            TABLE_BITVAL,                   },
        { "keep_hide",          COMMAND_KEEP_HIDE,      TRUE    },
        { "no_order",           COMMAND_NOORDER,        TRUE    },
        { "charmed_ok",         COMMAND_CHARMED_OK,     TRUE    },
        { "hidden",             COMMAND_HIDDEN,         TRUE    },
        { "disabled",           COMMAND_DISABLED,       TRUE    },
        { "charm_pc_ok",        COMMAND_CHARM_PC_OK,    TRUE    },
        { "soul",               COMMAND_SOUL,           TRUE    },
        { "frozen_ok",          COMMAND_FROZEN_OK,      TRUE    },
        { NULL }
    };

flag_t price_type[]=
    {
        { str_empty,         TABLE_INTVAL,                    },
        { "Gold",            PRICE_GOLD,              TRUE    },
        { "Quest points",    PRICE_QP,                TRUE    },
        { "Bonus points",    PRICE_BP,                TRUE    },
        { "Religion points", PRICE_RP,                TRUE    },
        { NULL }
    };

flag_t aliance_allow_flag[]=
    {
        { str_empty,         TABLE_INTVAL,                    },
        { "Allow",           ALLIANCE_ALLOW,          TRUE    },
        { "Restrict",        ALLIANCE_RESTRICT,       TRUE    },
        { NULL }
    };

flag_t meteor_bool_flags[]=
    {
        { str_empty,          TABLE_INTVAL,                    },
        { "Yes",              METEOR_TRUE,             TRUE    },
        { "No",               METEOR_FALSE,            TRUE    },
        { NULL }
    };

flag_t slot_machine_flags[]=
    {
        { str_empty,           TABLE_INTVAL,                },
        { "is_progressive",    SLOT_IS_PROGRESSIVE,    TRUE },
        { "no_progressive",    SLOT_NO_PROGRESSIVE,    TRUE },
        { NULL }
    };

flag_t muddy_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },
        { "dodge_new",      MUDDY_DODGE_NEW,    TRUE    },
        { "onehit_new",     MUDDY_ONEHIT_NEW,   TRUE    },
        { "newbies",        MUDDY_NEWBIES,      TRUE    },
        { "lock_games",     MUDDY_GAME_LOCK,    TRUE    },
        { "test_mode",      MUDDY_TEST_MODE,    TRUE    },
        { "stock_container",MUDDY_STOCK_CONT,   TRUE    },
        { "random_sleep",   MUDDY_RANDOM_SLEEP, TRUE    },
        { "scribe_new",     MUDDY_SCRIBE_NEW,   TRUE    },
        { "warr_moves",     MUDDY_WARR_MOVES,   TRUE    },
        { "quest_new",      MUDDY_QUEST_NEW,    TRUE    },
        { "spec_parts",     MUDDY_SPEC_PARTS,   TRUE    },
	    { "events",         MUDDY_EVENTS,       TRUE    },
        { "race_wear_rest", MUDDY_RACE_WEAR,    TRUE    },
        { "form_show_new",  MUDDY_FORM_SHOW_NEW,TRUE    },
        { "sector_bonus",   MUDDY_SECTOR_BONUS, TRUE    },
        { NULL }
    };

flag_t liquid_flags[] =
    {
        { str_empty,        TABLE_BITVAL,               },

        { NULL }
    };

flag_t material_flags[] =
    {
        { str_empty,    TABLE_BITVAL,          },
        { "metal",      MAT_METAL,     TRUE    },
        { "armor",      MAT_ARMOR,     TRUE    },
        { "floating",   MAT_FLOAT,     TRUE    },
        { "burns",      MAT_BURNS,     TRUE    },
        { "melts",      MAT_MELTS,     TRUE    },
        { "fragile",    MAT_FRAGILE,   TRUE    },
        { "stone",      MAT_STONE,     TRUE    },
        { NULL }
    };


flag_t clan_status_flags[] =
    {
        { str_empty,            TABLE_INTVAL,                      },
        { "leader",             CLAN_LEADER,               TRUE    },
        { "second",             CLAN_SECOND,               TRUE    },
        { "elite",              CLAN_ELITE,                TRUE    },
        { "veteran",            CLAN_VETERAN,              TRUE    },
        { "commoner",           CLAN_COMMONER,             TRUE    },
        { "newbie",             CLAN_NEWBIE,               TRUE    },
        { NULL }
    };

// Event system
flag_t event_extra_flags [] =
{
    { str_empty,        TABLE_INTVAL,                },
    { "loading",        EVENT_LOADING,               },
    { "temp",           EVENT_TEMPORARY,        TRUE },
    { "death-remove",   EVENT_DEATH_REMOVE,     TRUE },
    { "no-quit",        EVENT_NO_QUIT,          TRUE },
    { "stackable",      EVENT_STACKABLE,        TRUE },

    { NULL }
};


/* wiznet table and prototype for future flag setting */
const   struct wiznet_type      wiznet_table    []              =
    {
        {    "on",           WIZ_ON,         IM
        },
        {    "prefix",       WIZ_PREFIX,     IM },
        {    "ticks",        WIZ_TICKS,      IM },
        {    "logins",       WIZ_LOGINS,     IM },
        {    "sites",        WIZ_SITES,      L4 },
        {    "links",        WIZ_LINKS,      L7 },
        {    "newbies",      WIZ_NEWBIE,     IM },
        {    "spam",         WIZ_SPAM,       L5 },
        {    "deaths",       WIZ_DEATHS,     IM },
        {    "resets",       WIZ_RESETS,     L4 },
        {    "mobdeaths",    WIZ_MOBDEATHS,  L4 },
        {    "flags",        WIZ_FLAGS,      L5 },
        {    "penalties",    WIZ_PENALTIES,  L5 },
        {    "saccing",      WIZ_SACCING,    L5 },
        {    "levels",       WIZ_LEVELS,     IM },
        {    "load",         WIZ_LOAD,       L2 },
        {    "restore",      WIZ_RESTORE,    L2 },
        {    "snoops",       WIZ_SNOOPS,     L2 },
        {    "switches",     WIZ_SWITCHES,   L2 },
        {    "secure",       WIZ_SECURE,     L1 },
        {    "olc",          WIZ_OLC,        IM },
        {    "bugs",         WIZ_BUGS,       IM },
        {    "auction",      WIZ_AUCTION,    IM },
        { NULL }
    };

/* attack table */
const   struct attack_type  attack_table    []      =
    {
        /* name        messge           rus_message         damge_class   gender*/
        { "none",       "hit",          "",             -1      ,0}, /*  0 */
        { "slice",      "slice",        " ",         DAM_SLASH       ,0},
        { "stab",       "stab",         " ",             DAM_PIERCE      ,0},
        { "slash",      "slash",        " ",         DAM_SLASH       ,0},
        { "whip",       "whip",         " ",              DAM_SLASH       ,0},
        { "claw",       "claw",         " ",              DAM_SLASH       ,0}, /*  5 */
        { "blast",      "blast",        " ",         DAM_BASH        ,0},
        { "pound",      "pound",        "֣ ",             DAM_BASH        ,0},
        { "crush",      "crush",        " ",            DAM_BASH        ,0},
        { "grep",       "grep",         "grep",                     DAM_SLASH       ,0},
        { "bite",       "bite",         "",                     DAM_PIERCE      ,0}, /* 10 */
        { "pierce",     "pierce",       "",                     DAM_PIERCE      ,0},
        { "suction",    "suction",      "suction",                  DAM_BASH        ,2},
        { "beating",    "beating",      "",                     DAM_BASH        ,0},
        { "digestion",  "digestion",    " ",            DAM_ACID        ,0},
        { "charge",     "charge",       "   ",     DAM_BASH        ,0}, /* 15 */
        { "slap",       "slap",         "",                   DAM_BASH        ,0},
        { "punch",      "punch",        " ",             DAM_BASH        ,0},
        { "wrath",      "wrath",        "",                     DAM_ENERGY      ,0},
        { "magic",      "magic",        "",                    DAM_ENERGY      ,1},
        { "divine",     "divine power", " ",        DAM_HOLY        ,1}, /* 20 */
        { "cleave",     "cleave",       " ",       DAM_SLASH       ,0},
        { "scratch",    "scratch",      " ",          DAM_PIERCE      ,0},
        { "peck",       "peck",         " ",              DAM_PIERCE      ,0},
        { "peckb",      "peck",         " ",              DAM_BASH        ,0},
        { "chop",       "chop",         " ",             DAM_SLASH       ,0}, /* 25 */
        { "sting",      "sting",        " ",               DAM_PIERCE      ,0},
        { "smash",      "smash",        " ",              DAM_BASH        ,0},
        { "shbite",     "shocking bite"," ",          DAM_LIGHTNING   ,0},
        { "flbite",     "flaming bite", " ",           DAM_FIRE        ,0},
        { "frbite",     "freezing bite"," ",      DAM_COLD        ,0}, /* 30 */
        { "acbite",     "acidic bite",  " ",          DAM_ACID        ,0},
        { "chomp",      "chomp",        " ",        DAM_PIERCE      ,0},
        { "drain",      "life drain",   " ",        DAM_NEGATIVE    ,2},
        { "thrust",     "thrust",       " ",             DAM_PIERCE      ,0},
        { "slime",      "slime",        "",                    DAM_ACID        ,1}, /* 35 */
        { "shock",      "shock",        " ",            DAM_LIGHTNING   ,0},
        { "thwack",     "thwack",       "  ",           DAM_BASH        ,0},
        { "flame",      "flame",        "",                    DAM_FIRE        ,2},
        { "chill",      "chill",        "",                    DAM_COLD        ,0},
        { "kiss",       "kiss",         "",                  DAM_CHARM      ,0}, /* 40 */
        { "laser",      "laser",        "",                    DAM_LIGHT       ,0},
        { "plasma",     "plasma",       "",                   DAM_FIRE        ,1},
        { "sound",      "sound",        "",                     DAM_SOUND       ,0},
        { NULL }
    };

/*
 * Attribute bonus tables.
 */
const   struct  str_app_type    str_app     [26]        =
    {
        {
            -5, -4,   0,  0
        }
        ,  /* 0  */
        { -5, -4,   3,  1 },  /* 1  */
        { -3, -2,   3,  2 },
        { -3, -1,  10,  3 },  /* 3  */
        { -2, -1,  25,  4 },
        { -2, -1,  55,  5 },  /* 5  */
        { -1,  0,  80,  6 },
        { -1,  0,  90,  7 },
        {  0,  0, 100,  8 },
        {  0,  0, 100,  9 },
        {  0,  0, 115, 10 }, /* 10  */
        {  0,  0, 115, 11 },
        {  0,  0, 130, 12 },
        {  0,  0, 130, 13 }, /* 13  */
        {  0,  1, 140, 14 },
        {  1,  1, 150, 15 }, /* 15  */
        {  1,  2, 165, 16 },
        {  2,  3, 180, 22 },
        {  2,  3, 200, 25 }, /* 18  */
        {  3,  4, 225, 30 },
        {  3,  5, 250, 35 }, /* 20  */
        {  4,  6, 300, 40 },
        {  4,  6, 350, 45 },
        {  5,  7, 400, 50 },
        {  5,  8, 450, 55 },
        {  6,  9, 500, 60 }  /* 25   */
    };



const   struct  int_app_type    int_app     [26]        =
    {
        {
            3
        }
        , /*  0 */
        {  5 }, /*  1 */
        {  7 },
        {  8 }, /*  3 */
        {  9 },
        { 10 }, /*  5 */
        { 11 },
        { 12 },
        { 13 },
        { 15 },
        { 17 }, /* 10 */
        { 19 },
        { 22 },
        { 25 },
        { 28 },
        { 31 }, /* 15 */
        { 34 },
        { 37 },
        { 40 }, /* 18 */
        { 44 },
        { 49 }, /* 20 */
        { 55 },
        { 60 },
        { 70 },
        { 80 },
        { 85 }  /* 25 */
    };



const   struct  wis_app_type    wis_app     [26]        =
    {
        {
            0
        }
        ,  /*  0 */
        { 0 },  /*  1 */
        { 0 },
        { 0 },  /*  3 */
        { 0 },
        { 1 },  /*  5 */
        { 1 },
        { 1 },
        { 1 },
        { 1 },
        { 1 },  /* 10 */
        { 1 },
        { 1 },
        { 1 },
        { 1 },
        { 2 },  /* 15 */
        { 2 },
        { 2 },
        { 3 },  /* 18 */
        { 3 },
        { 3 },  /* 20 */
        { 3 },
        { 4 },
        { 4 },
        { 4 },
        { 5 }   /* 25 */
    };



const   struct  dex_app_type    dex_app     [26]        =
    {
        {
            60,  20
        }
        ,   /* 0 */
        {   50,  22 },   /* 1 */
        {   50,  24 },
        {   40,  26 },
        {   30,  28 },
        {   20,  30 },   /* 5 */
        {   10,  32 },
        {    0,  34 },
        {    0,  36 },
        {    0,  38 },
        {    0,  40 },   /* 10 */
        {    0,  43 },
        {    0,  46 },
        {    0,  49 },
        {    0,  52 },
        { - 10,  55 },   /* 15 */
        { - 15,  58 },
        { - 20,  61 },
        { - 30,  64 },
        { - 40,  67 },
        { - 50,  70 },   /* 20 */
        { - 60,  73 },
        { - 75,  76 },
        { - 90,  79 },
        { -105,  82 },
        { -120,  85 }    /* 25 */
    };


const   struct  con_app_type    con_app     [26]        =
    {
        {
            0, 20
        }
        ,   /*  0 */
        {  1, 25 },   /*  1 */
        {  1, 30 },
        {  2, 35 },   /*  3 */
        {  3, 40 },
        {  4, 45 },   /*  5 */
        {  5, 50 },
        {  6, 55 },
        {  7, 60 },
        {  8, 65 },
        {  9, 70 },   /* 10 */
        { 10, 75 },
        { 11, 80 },
        { 12, 85 },
        { 13, 88 },
        { 14, 90 },   /* 15 */
        { 15, 95 },
        { 16, 97 },
        { 17, 99 },   /* 18 */
        { 18, 99 },
        { 19, 99 },   /* 20 */
        { 20, 99 },
        { 21, 99 },
        { 22, 99 },
        { 23, 99 },
        { 24, 99 }    /* 25 */
    };

where_t where_table[] =
    {
        { TO_AFFECTS,   affect_flags,   "'%s' affect"   },
        { TO_IMMUNE,    imm_flags,      "immunity to '%s'"  },
        { TO_RESIST,    dam_flags,      "resistance to '%s'"    },
        /*    { TO_VULN,      vuln_flags,     "vulnerability to '%s'" },*/
        { TO_FORM,      form_flags,     "'%s' form"     },
        { -1 }
    };

where_t *where_lookup(flag32_t where)
{
    where_t *wd;

    for (wd = where_table; wd->where != -1; wd++)
        if (wd->where == where)
            return wd;
    return NULL;
}

