/* $Id: todo.c,v 1.666 2004/09/20 10:49:54 shrike Exp $                                */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "merc.h"
#include "todo.h"


varr todo_list  = {sizeof (todo_t), 4};

todo_t *todo_new()
{
        todo_t * todo;

        todo                      = varr_enew (&todo_list);
        todo->autor               = str_empty;
        todo->subj                = str_empty;
        todo->target              = str_empty;
        todo->todo                = str_empty;
        todo->prioritet           = 0;

        return todo;
}

void todo_free(todo_t *todo)
{
    free_string(todo->autor);
    free_string(todo->target);
    free_string(todo->todo);
    free_string(todo->subj);

    free(todo);
}

const char *todo_autor (int tdn)
{
        todo_t *todo;

	if (tdn < 0 || tdn > todo_list.nused)
	{
		return("None");
	}

	todo = TODO(tdn);
	if (todo != NULL)
		return(todo->autor);
	else
		return("None");
}

const char *todo_target (int tdn)
{
	todo_t *todo;

	if (tdn < 0 || tdn > todo_list.nused)
	{
		return("None");
	}

	todo = TODO(tdn);
	if (todo != NULL)
		return(todo->target);
	else
		return("None");
}

