/* $Id: todo.h,v 1.666 2004/09/20 10:49:54 shrike Exp $                                */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#ifndef _TODO_H_
#define _TODO_H_

typedef struct todo_t todo_t;

extern varr     todo_list;

struct todo_t
{
    const char *autor;
    const char *target;
    const char *subj;
    const char *todo;
    int         prioritet;
};

todo_t *        todo_new    (void);
void            todo_free   (todo_t*);

#define TODO(tdn)           ((todo_t*) VARR_GET(&todo_list, tdn))
#define todo_lookup(tdn)    ((todo_t*) varr_get(&todo_list, tdn))

//int todo_autor_lookup       (const char * name);
//int todo_target_lookup      (const char * name);
const char * todo_autor     (int tdn);
const char * todo_target    (int tdn);

#endif
