/* $Id: update.c,v 1.666 2004/09/20 10:49:54 shrike Exp $                           */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#if !defined (WIN32)
#include <unistd.h>
#endif

#include "merc.h"
#include "update.h"
#include "mob_prog.h"
#include "obj_prog.h"
#include "fight.h"
#include "cyborg.h"
#include "quest.h"
#include "gquest.h"
#include "rating.h"
#include "conquer.h"
#include "riddle.h"


int pulse_point;

/* command procedures needed */
DECLARE_DO_FUN(do_human         );
DECLARE_DO_FUN(do_murder        );
DECLARE_DO_FUN(do_rescue        );
DECLARE_DO_FUN(do_quit          );
DECLARE_DO_FUN(do_quit_count    );
DECLARE_DO_FUN(set_spellbane    );
DECLARE_DO_FUN(do_stand         );
DECLARE_DO_FUN(do_track         );
DECLARE_DO_FUN(do_yell          );

void agent_net_printf(CHAR_DATA *ch, CHAR_DATA *victim, int);

char         * fread_word          (FILE *);
void           back_home           (CHAR_DATA *ch);
extern void    weather_update      (void);
extern void    sunrise             (int day, int month, int year, double breadth, double longitude,int tz);
extern void    service_data_update (void);
extern int     ea_modify_gain      (CHAR_DATA * ch, int gain, int type);
void           check_confuse       (CHAR_DATA *ch);
extern void    wq_update           (void);

/*
 * Local functions.
 */
int     hit_gain            (CHAR_DATA *ch);
int     mana_gain           (CHAR_DATA *ch);
int     move_gain           (CHAR_DATA *ch);
void    mobile_update       (void);
void    char_update         (void);
void    obj_update          (void);
void    aggr_update         (void);
int     potion_cure_level   (OBJ_DATA *potion);
int     potion_arm_level    (OBJ_DATA *potion);
bool    potion_cure_blind   (OBJ_DATA *potion);
bool    potion_cure_poison  (OBJ_DATA *potion);
bool    potion_cure_disease (OBJ_DATA *potion);

/* below done by chronos */
void    quest_update        args((void));
void    auction_update      args((void));
void    light_update        args((void));
void    room_update         args((void));
void    room_affect_update  args((void));
void    check_reboot        args((void));
void    track_update        args((void));
void    check_fishing       args((void));

void    atrim_ch           (CHAR_DATA *ch);
void    limits_strip       (CHAR_DATA * ch);
void    update_member_info (CHAR_DATA * ch);

/* used for saving */

int save_number = 0;
int rebooter    = 0;


/*
 * Advancement stuff.
 */
void advance_level(CHAR_DATA *ch)
{
    int      add_hp;
    int      add_mana;
    int      add_move;
    int      add_rhp;
    int      add_rmana;
    int      add_rmove;
    int      add_prac;
    int      i;
    race_t  *r;
    class_t *cl;
    BUFFER  *output;

    if (IS_NPC(ch))
    {
        bug("Advance_level: a mob to advance!", 0);
        return;
    }

    if ((cl = class_lookup(ch->class)) == NULL)
    {
        log_printf("advance_level", "%s: unknown class %d", ch->name, ch->class);
        return;
    }

    wiznet_printf(ch, NULL, WIZ_LEVELS, 0, 0, "$N  %d !", (int) ch->level);

    ch->pcdata->last_level = (ch->played + (int) (current_time - ch->logon)) / 3600;

    if (IS_SET(ch->plr_flags, PLR_AUTOTITLE))
        set_title(ch, title_lookup(ch));

    ch->pcdata->this_level_played = 0; // we'vnt played this level!

    if (ch->pcdata->plevels > 0)
    {
        ch->pcdata->plevels--;
        return;
    }

    if (ch->level == 91)
    {
        log_printf("%s  91 !", ch->name);
        info(ch, 0, "{r[{RINFO{r]{W : %s reaches {GHERO{z level!{x\n", ch->name);
    }

    r = RACE(ORG_RACE(ch));

    add_hp = (get_curr_stat(ch,STAT_CON) + r->pcdata->hp_bonus + cl->hp_rate -
        (25 - get_curr_stat(ch,STAT_LCK))*2);

    add_mana = (get_curr_stat(ch,STAT_INT) + get_curr_stat(ch,STAT_WIS) +
        r->pcdata->mana_bonus + cl->mana_rate - (25 - get_curr_stat(ch,STAT_LCK))*2);

    add_move = ((get_curr_stat(ch,STAT_CON) + get_curr_stat(ch,STAT_DEX)) / 4 -
        (25 - get_curr_stat(ch,STAT_LCK)) * 2);

    add_rhp     = (ch->perm_stat[STAT_CON] + r->pcdata->hp_bonus + cl->hp_rate);
    add_rmana   = (ch->perm_stat[STAT_INT] + ch->perm_stat[STAT_WIS] +
        r->pcdata->mana_bonus + cl->mana_rate);

    add_rmove   = ((ch->perm_stat[STAT_CON] + ch->perm_stat[STAT_DEX]) / 4);

    add_prac    = wis_app[get_curr_stat(ch,STAT_WIS)].practice;

    if (is_class_warrior(ch))
        add_mana /= 4;
    else
        add_hp /= 2;

    add_hp      = UMAX(5, add_hp);
    add_mana    = UMAX(5, add_mana);
    add_move    = UMAX(5, add_move);

    ch->max_hit     += add_hp;
    ch->max_mana    += add_mana;
    ch->max_move    += add_move;
    ch->practice    += add_prac;
//    ch->train += ch->level % 5 ? 0 : 1;
    ch->train += 1;

    ch->pcdata->perm_hit    += add_hp;
    ch->pcdata->perm_mana   += add_mana;
    ch->pcdata->perm_move   += add_move;

    output = buf_new(ch->lang);

    buf_printf(output, "%s the %s-%s has gained a level!\n{x", ch->name, race_name(ch->race), cl->name);

    buf_printf(output, "Now you are level %d (%s{x){x", ch->level, ch->pcdata->title);

    if (ch->level < LEVEL_HERO)
    {
        buf_printf(output, "\nand need %d more XP for level %d{x", exp_to_level(ch), (ch->level + 1));
    } else if (ch->level > LEVEL_HERO)
        buf_add(output, "\nWelcome to our team, Immortal");
    else
        buf_add(output, "\ntake sincere congratulations, HERO");

    buf_add(output, ".\n");

    buf_printf(output, "You gain %d from %d possible hp, %d from %d possible mana,{x\n",
        add_hp, add_rhp, add_mana, add_rmana);
    buf_printf(output, "%d from %d possible move, %d practice and one train to spend.{x\n",
        add_move, add_rmove, add_prac);

    if (number_range(0, 30) < get_curr_stat(ch, STAT_LCK))
    {
        affect_strip(ch, gsn_plague);
        affect_strip(ch, gsn_poison);
        affect_strip(ch, gsn_blindness);
        affect_strip(ch, gsn_weaken);
        affect_strip(ch, gsn_curse);

        ch->hit     = ch->max_hit;
        ch->mana    = ch->max_mana;
        ch->move    = ch->max_move;
        ch->psp     = psp_max(ch);
        update_pos(ch);
        buf_add(output, "You were lucky enough to be fully restored.\n");
    }

    char_act(buf_string(output), ch);
    buf_free(output);
    for (i = 0; i < ch->pcdata->learned.nused; i++)
    {
        skill_t *sk;
        pcskill_t *ps = VARR_GET(&ch->pcdata->learned, i);
        if ((sk = SKILL(ps->sn)) == NULL)
            continue;
        if (ps->level == ch->level)
            act("You gain '$t'.", ch, SKILL(ps->sn)->name, NULL, TO_CHAR);
    }

    update_member_info (ch);
}

void gain_exp(CHAR_DATA *ch, int gain)
{
    if (IS_NPC(ch) || (ch->level >= LEVEL_HERO && !IS_SET(ch->comm, COMM_BONUS)))
        return;

    if (IS_SET(ch->plr_flags, PLR_NOSOUL) && gain > 0)
    {
        act("You can't gain exp without your spirit.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->plr_flags, PLR_NOEXP) && gain > 0)
    {
        act("You off get exp (see HELP NOEXP).", ch, NULL, NULL, TO_CHAR | ACT_VERBOSE);
        return;
    }

    if (number_bits(999) == 777)
    {
        if (number_percent() < (get_curr_stat(ch, STAT_LCK) * 2))
        {
            act("Your luck helps you!", ch, NULL, NULL, TO_CHAR);
            gain += gain * 2;
        } else
        {
            act("Your luck leds you!", ch, NULL, NULL, TO_CHAR);
            gain -= gain / 2;
        }
    }

    if (exp_to_level(ch) < 0)
    {
        ch->exp_tl = 0;
        ch->exp = exp_for_level(ch, ch->level);
        return;
    }
    if (gain < exp_to_level(ch)) 
    {
        ch->exp_tl += gain;
        ch->exp += gain;
        gain = 0;
    } else
    {
        gain = gain - exp_to_level(ch);
        ch->exp_tl += exp_to_level(ch);
        ch->exp += exp_to_level(ch);
    }

    if (IS_SET(ch->comm, COMM_BONUS) && exp_to_level(ch) <= 0)
    {
        ch->exp_tl = 0;
        ch->exp = exp_for_level(ch, ch->level);
        ch->exp_tl += gain;
        ch->exp += gain;
        ch->pcdata->bonuspoints++;
        ch->pcdata->bp_earned++;
        act("You gain bonus!", ch, NULL, NULL, TO_CHAR);
        wiznet_printf(ch, NULL, WIZ_LEVELS, 0, 0, " $N  %d bp,     %d bp!",
            ch->pcdata->bonuspoints, ch->pcdata->bp_earned);
        save_char_obj(ch, FALSE, FALSE);
        return;
    }

    while (ch->level < LEVEL_HERO && exp_to_level(ch) <= 0)
    {
        ch->level += 1;
        ch->exp_tl = 0;
/*
        if (IS_SAMURAI(ch))
            ch->wimpy = 0;
*/
        advance_level(ch);
        save_char_obj(ch, FALSE, FALSE);
    }
}

/*
 * Regeneration stuff.
 */
int hit_gain(CHAR_DATA *ch)
{
    int gain;
    int number;
    class_t *cl;

    if (ch->in_room == NULL || (cl = class_lookup(ch->class)) == NULL)
        return 0;

    if (IS_SET(ch->in_room->room_flags, ROOM_NOHP))
    {
        return 0;
    }

    if (IS_NPC(ch))
    {
        gain =  5 + ch->level;
        switch (ch->position)
        {
            default:            gain /= 2;          break;
            case POS_SLEEPING:  gain = 3 * gain/2;  break;
            case POS_RESTING:                       break;
            case POS_FIGHTING:  gain /= 3;          break;
        }
    } else
    {
        gain = UMAX(3, 2 * get_curr_stat(ch, STAT_CON) + (7 * ch->level) / 4);
        gain = (gain * cl->hp_rate) / 4;
        number = number_percent();
        if (number < get_skill(ch, gsn_fast_healing))
        {
            gain += number * gain / 100;
            if (ch->hit < ch->max_hit)
                check_improve(ch, gsn_fast_healing, TRUE, 8);
        }

        if (number < get_skill(ch, gsn_trance))
        {
            gain += number * gain / 150;
            if (ch->hit < ch->max_hit)
                check_improve(ch, gsn_trance, TRUE, 8);
        }

        switch (ch->position)
        {
            default:            gain /= 4;      break;
            case POS_SLEEPING:                  break;
            case POS_RESTING:   gain /= 2;      break;
            case POS_FIGHTING:  gain /= 6;      break;
        }

        if (ch->pcdata->condition[COND_HUNGER]   < 0)
            gain = 0;

        if (ch->pcdata->condition[COND_THIRST] < 0)
            gain = 0;
    }

    gain = gain * ch->in_room->heal_rate / 100;

    if (ch->on != NULL && ch->on->pIndexData->item_type == ITEM_FURNITURE)
        gain = gain * ch->on->value[3] / 100;

    if (IS_AFFECTED(ch, AFF_REGENERATION))
        gain *= 2;

    if (IS_AFFECTED(ch, AFF_AUTOREPAIR))
        gain *= 2;

    if (is_affected(ch, gsn_radiation))
        gain /= 10;
    else if (ch->in_room && IS_ROOM_AFFECTED(ch->in_room, RAFF_RADIATION))
        gain /= 3;

    if (IS_AFFECTED(ch, AFF_POISON))
        gain /= 4;

    if (IS_AFFECTED(ch, AFF_PLAGUE))
        gain /= 8;

    if (IS_AFFECTED(ch, AFF_HASTE))
        gain /= 2;

    if (IS_AFFECTED(ch, AFF_SLOW))
        gain *= 2;

    if (IS_HARA_KIRI(ch))
        gain *= 3;

    if (IS_UNDEAD(ch) && ch->class != CLASS_VAMPIRE)
        gain = UMAX(45, LVL(ch));

    if (get_curr_stat(ch, STAT_CON) > 20)
        gain = (gain * 14) / 10;

    gain = areacontrol_modify_gain (ch, gain, GAIN_HP);

    if (altar_works (ch, ALTAR_REGENERATION_POS))
    {
        // 20% better hp/mana rate
        gain += gain * 0.2;
        // and 4% to restore all
        if (number_percent () < 4)
            gain = ch->max_hit - ch->hit;
    }

    gain = ea_modify_gain (ch, gain, GAIN_HP);

    return UMIN(gain, ch->max_hit - ch->hit);
}

int mana_gain(CHAR_DATA *ch)
{
    int gain;
    int number;
    class_t *cl;

    if (ch->in_room == NULL || (cl = class_lookup(ch->class)) == NULL)
        return 0;

    if (IS_SET(ch->in_room->room_flags, ROOM_NOMANA))
    {
        return 0;
    }

    if (is_affected (ch, sn_lookup ("mana shield")))
    {
        char_act ("Your mana shield fully blocks mana regeneration.", ch);
        return 0;
    }

    if (IS_NPC(ch))
    {
        gain = 5 + ch->level;

        switch (ch->position)
        {
            default:            gain /= 2;          break;
            case POS_SLEEPING:  gain = 3 * gain/2;  break;
            case POS_RESTING:                       break;
            case POS_FIGHTING:  gain /= 3;          break;
        }
    } else
    {
        gain = get_curr_stat(ch,STAT_WIS) + (2 * get_curr_stat(ch,STAT_INT)) + ch->level;
        gain = (gain * cl->mana_rate) / 4;

        if (is_class_warrior(ch))
            gain /= 2;
        if (!is_class_mage(ch))
            gain /= 2;

        number = number_percent();
        if (number < get_skill(ch,gsn_meditation))
        {
            gain += number * gain / 100;
            if (ch->mana < ch->max_mana)
                check_improve(ch,gsn_meditation,TRUE,8);
        }

        if (number < get_skill(ch,gsn_trance))
        {
            gain += number * gain / 100;
            if (ch->mana < ch->max_mana)
                check_improve(ch,gsn_trance,TRUE,8);
        }


        switch (ch->position)
        {
            default:            gain /= 4;          break;
            case POS_SLEEPING:                      break;
            case POS_RESTING:   gain /= 2;          break;
            case POS_FIGHTING:  gain /= 6;          break;
        }

        if (ch->pcdata->condition[COND_HUNGER]   < 0)
            gain = 0;

        if (ch->pcdata->condition[COND_THIRST] < 0)
            gain = 0;
    }

    gain = gain * ch->in_room->mana_rate / 100;

    if (ch->on != NULL && ch->on->pIndexData->item_type == ITEM_FURNITURE)
        gain = gain * ch->on->value[4] / 100;

    if (IS_AFFECTED(ch, AFF_AUTOREPAIR))
        gain *= 3;

    if (IS_AFFECTED(ch, AFF_POISON))
        gain /= 4;

    if (IS_AFFECTED(ch, AFF_PLAGUE))
        gain /= 8;

    if (IS_AFFECTED(ch,AFF_HASTE))
        gain /= 2 ;

    if (IS_AFFECTED(ch,AFF_SLOW))
        gain *= 2 ;

    if (get_curr_stat(ch,STAT_INT) > 20)
        gain = (gain * 13) / 10;

    if (get_curr_stat(ch,STAT_WIS) > 20)
        gain = (gain * 11) / 10;

    if (IS_HARA_KIRI(ch))
        gain *= 3;

    gain = areacontrol_modify_gain (ch, gain, GAIN_MANA);

    if (altar_works (ch, ALTAR_REGENERATION_POS))
    {
        // 20% better hp/mana rate
        gain += gain * 0.2;
        // and 4% to restore all
        if (number_percent () < 4)
            gain = ch->max_mana - ch->mana;
    }

    gain = ea_modify_gain (ch, gain, GAIN_MANA);

    return UMIN(gain, ch->max_mana - ch->mana);
}

void strip_maintains(CHAR_DATA *ch)
{
    AFFECT_DATA *af, *af_next;
    skill_t *sk;
    int sn;

    free_contacts(ch);
    for (af = ch->affected; af != NULL; af = af_next)
    {
        af_next = af->next;
        sn = af->type;
        if ((sk=SKILL(sn)) == NULL)
            continue;
        if (sk->maintain > 0)
            affect_strip(ch, sn);
    }
    ch->psi_def = -1;
}

int psp_gain(CHAR_DATA *ch)
{
    int gain, min_gain, number, cost, i, sn;
    class_t *cl;
    skill_t *sk;
    AFFECT_DATA *af, *af_next;
    CHAR_DATA *victim;

    if (ch->in_room == NULL || (cl = class_lookup(ch->class)) == NULL)
        return 0;

    cost = 0;
    for (i=0; i < MAX_CONTACTS; i++)
    {
        if ((victim = ch->contact[i]) == NULL)
            continue;
        cost++;
        if (IS_AFFECTED(victim, AFF_CHARM) && (victim->master == ch)
        && is_affected(victim, sn_lookup("mind control")))
            cost += 2 * psionic_level(victim);
    }
    for (af = ch->affected; af != NULL; af = af_next)
    {
        af_next = af->next;
        sn = af->type;
        if ((sk=SKILL(sn)) == NULL)
            continue;
        cost += sk->maintain;
    }

    if ((sn = ch->psi_def) > 0)
        if ((sk=SKILL(sn)) != NULL)
            cost += sk->maintain;

    if (!IS_AWAKE(ch) && cost > 0)
    {
        char_act("You cannot maintain psionic powers while being unconscious.", ch);
        strip_maintains(ch);
    } else if (cost > 0)
    {
        if (ch->psp > 0)
            ch->psp = UMAX(0, ch->psp - cost);
        if (ch->psp <= 0)
        {
            char_act("Your psionic power is exhausted and you cannot maintain your contacts and powers anymore.", ch);
            strip_maintains(ch);
        }
        return 0;
    }

    if (ch->psp > psp_max(ch))
        return 0;

    if (IS_NPC(ch))
    {
        gain = psp_max(ch);

        switch (ch->position)
        {
            case POS_STANDING:  gain /= 8; break;
            case POS_SITTING:   gain /= 6; break;
            case POS_RESTING:   gain /= 4; break;
            case POS_SLEEPING:  gain /= 2; break;
            default:            gain = 0;  break;
        }
        return gain;
    }

    gain = 3;

    switch (ch->position)
    {
        case POS_STANDING:  min_gain = psp_max(ch) / 6; break;
        case POS_SITTING:   gain *= 2; min_gain = psp_max(ch) / 5; break;
        case POS_RESTING:   gain *= 2; min_gain = psp_max(ch) / 4; break;
        case POS_SLEEPING:  gain *= 4; min_gain = psp_max(ch) / 2; break;
        default:            return 0;  break;
    }

    if (HAS_SKILL(ch, gsn_psionics))
    {
        number = number_percent();
        if (number < get_skill(ch, gsn_meditation))
        {
            gain += UMAX(1, number * gain / 96);
            check_improve(ch, gsn_meditation, TRUE, 8);
        }
        if (number < get_skill(ch, gsn_trance))
        {
            gain += UMAX(1, number * gain / 96);
            check_improve(ch, gsn_trance, TRUE, 8);
        }

        min_gain = (number_range(1, min_gain) + number_range(1, min_gain)) / 2;
        gain = UMAX(gain, min_gain);
    }
// gain = areacontrol_modify_gain (ch, gain, GAIN_PSP);
    gain = UMIN(gain, psp_max(ch) - ch->psp);
    return gain;
}

int move_gain(CHAR_DATA *ch)
{
    int gain;

    if (ch->in_room == NULL)
        return 0;

    if (IS_SET(ch->in_room->room_flags, ROOM_NOMOVE))
    {
        return 0;
    }

    if (IS_NPC(ch))
    {
        gain = ch->level;
    } else
    {
        gain = UMAX(15, 2 * ch->level);

        switch (ch->position)
        {
            case POS_SLEEPING: gain += 2 * (get_curr_stat(ch,STAT_DEX));    break;
            case POS_RESTING:  gain += get_curr_stat(ch,STAT_DEX);      break;
        }

        if (ch->pcdata->condition[COND_HUNGER]   < 0)
            gain = 3;

        if (ch->pcdata->condition[COND_THIRST] < 0)
            gain = 3;
    }

    gain = gain * ch->in_room->heal_rate / 100;

    if (ch->on != NULL && ch->on->pIndexData->item_type == ITEM_FURNITURE)
        gain = gain * ch->on->value[3] / 100;

    if (IS_AFFECTED(ch, AFF_AUTOREPAIR))
        gain *= 4;

    if (IS_AFFECTED(ch, AFF_POISON))
        gain /= 4;

    if (IS_AFFECTED(ch, AFF_PLAGUE))
        gain /= 8;

    if (IS_AFFECTED(ch, AFF_HASTE) || IS_AFFECTED(ch, AFF_SLOW))
        gain /= 2;

    if (get_curr_stat(ch,STAT_DEX) > 20)
        gain = gain * 7 / 5;

    gain = gain * UMAX(20, get_curr_stat(ch, STAT_CON)) / 20;

    if (IS_HARA_KIRI(ch))
        gain *= 3;

    gain = areacontrol_modify_gain (ch, gain, GAIN_MOVES);

    return UMIN(gain, ch->max_move - ch->move);
}

void gain_condition(CHAR_DATA *ch, int iCond, int value)
{
    int condition;
    int damage_hunger;
    int fdone;
    CHAR_DATA *vch,*vch_next;

    if (value == 0 || IS_NPC(ch) || ch->level >= LEVEL_IMMORTAL)
        return;

    if (IS_CYBORG(ch))
        return;

    if ((IS_UNDEAD(ch) || ch->class == CLASS_VAMPIRE)
    && (iCond == COND_THIRST
    || iCond == COND_FULL
    || iCond == COND_HUNGER))
    {
        return;
    }

    condition = ch->pcdata->condition[iCond];

    ch->pcdata->condition[iCond] = URANGE(-6, condition + value, 96);

    if (iCond == COND_FULL && (ch->pcdata->condition[COND_FULL] < 0))
        ch->pcdata->condition[COND_FULL] = 0;

    if ((iCond == COND_DRUNK) && (ch->pcdata->condition[COND_DRUNK] < 1))
        ch->pcdata->condition[COND_DRUNK] = 0;

    if (ch->pcdata->condition[iCond] < 1 &&  ch->pcdata->condition[iCond] > -6)
    {
        switch (iCond)
        {
            case COND_HUNGER:
                act("You are hungry.\n", ch, NULL, NULL, TO_CHAR);
                break;

            case COND_THIRST:
                act("You are thirsty.\n", ch, NULL, NULL, TO_CHAR);
                break;

            case COND_DRUNK:
                if (condition != 0)
                    act("You are sober.\n", ch, NULL, NULL, TO_CHAR);
                break;

            case COND_BLOODLUST:
                if (condition != 0)
                    act("You are hungry for {rblood{x.\n", ch, NULL, NULL, TO_CHAR);
                break;

            case COND_DESIRE:
                if (condition != 0)
                    act("You have missed your home.\n", ch, NULL, NULL, TO_CHAR);
                break;
        }
    }

    if (ch->pcdata->condition[iCond] == -6 && ch->level >= PK_MIN_LEVEL)
    {
        switch (iCond)
        {
            case COND_HUNGER:
                act("   !", ch, NULL, NULL, TO_CHAR);
                act("$n   !",  ch, NULL, NULL, TO_ROOM);
                damage_hunger = ch->max_hit * number_range(2, 4) / 100;

                if (!damage_hunger)
                    damage_hunger = 1;

                if (IS_AFFECTED(ch, AFF_SLEEP))
                {
                    ch->hit -= damage_hunger;
                    return;
                }
                damage(ch, ch, damage_hunger, TYPE_HUNGER, DAM_HUNGER,
                       TRUE);
                if (ch->position == POS_SLEEPING)
                    return;
                break;

            case COND_THIRST:
                act("   !", ch, NULL, NULL, TO_CHAR);
                act("$n   !", ch, NULL, NULL, TO_ROOM);
                damage_hunger = ch->max_hit * number_range(2, 4) / 100;

                if (!damage_hunger)
                    damage_hunger = 1;

                if (IS_AFFECTED(ch, AFF_SLEEP))
                {
                    ch->hit -= damage_hunger;
                    return;
                }
                damage(ch, ch, damage_hunger, TYPE_HUNGER, DAM_THIRST,
                       TRUE);

                if (ch->position == POS_SLEEPING)
                    return;
                break;

            case COND_BLOODLUST:
                fdone = 0;
                act("    {r{z!", ch, NULL, NULL, TO_CHAR);
                act("$n    {r{z!", ch, NULL, NULL, TO_ROOM);

                if (ch->in_room && ch->in_room->people && ch->fighting == NULL)
                {
                    if (!IS_AWAKE(ch))
                        do_stand(ch, str_empty);

                    for (vch = ch->in_room->people;
                        vch != NULL && ch->fighting == NULL;
                        vch = vch_next)
                    {
                        vch_next = vch->next_in_room;
                        if (ch != vch && can_see(ch, vch)
                            &&  !is_safe_nomessage(ch, vch))
                        {
                            do_yell(ch, "{R!    !{z");
                            do_murder(ch, vch->name);
                            fdone = 1;
                        }
                    }
                }

                if (fdone)
                    break;

                damage_hunger = ch->max_hit * number_range(2, 4) / 100;

                if (!damage_hunger)
                    damage_hunger = 1;

                if (IS_AFFECTED(ch, AFF_SLEEP))
                {
                    ch->hit -= damage_hunger;
                    return;
                }

                damage(ch, ch, damage_hunger, TYPE_HUNGER, DAM_THIRST,
                       TRUE);
                if (ch->position == POS_SLEEPING)
                    return;
                break;

            case COND_DESIRE:
                act("   !", ch, NULL, NULL, TO_CHAR);
                act("$n     !", ch, NULL, NULL, TO_ROOM);

                if (ch->position >= POS_STANDING)
                    move_char(ch, number_door(), FALSE);

                break;
        }
    }
}

/* fury and adv fury check for samurai */
void check_fury(CHAR_DATA *ch)
{
/*
    if (IS_SAMURAI(ch) && ch->wimpy > 0)
    {
        if (ch->hit > ch->wimpy)
            ch->hit = ch->wimpy;
    }
*/
    if (is_affected(ch, gsn_adv_fury) && ch->hit >= ch->max_hit / 3)
    {
        affect_strip(ch, gsn_adv_fury);
        act("        p p.", ch, NULL, NULL, TO_CHAR);
        act("$n    .", ch, NULL, NULL, TO_ROOM);
        return;
    }
    if (is_affected(ch, gsn_fury) && ch->hit >= ch->max_hit * 2 / 3)
    {
        affect_strip(ch, gsn_fury);
        if (is_affected(ch, gsn_adv_fury))
            affect_strip(ch, gsn_adv_fury);

        act("       p p.", ch, NULL, NULL, TO_CHAR);
        act("$n   .", ch, NULL, NULL, TO_ROOM);
        return;
    }

    if (is_affected(ch, gsn_adv_fury) || IS_SET(ch->plr_flags, PLR_GHOST))
        return;

    if (ch->hit <= ch->max_hit / 4 && is_affected(ch, gsn_fury) && !is_affected(ch, gsn_adv_fury))
    {
        if (get_skill(ch, gsn_adv_fury) > number_percent())
        {
            AFFECT_DATA af2;

            af2.where        = TO_AFFECTS;
            af2.type         = gsn_adv_fury;
            af2.level        = LVL(ch);
            af2.duration     = -1;
            af2.location     = APPLY_DAMROLL;
            af2.modifier     = ch->damroll / 2;
            af2.bitvector    = 0;
            affect_to_char(ch, &af2);

            af2.location     = APPLY_HITROLL;
            af2.modifier     = ch->hitroll / 2;
            affect_to_char(ch, &af2);

            check_improve(ch, gsn_adv_fury, TRUE, 1);

            do_yell(ch, "      ! ! !");
        } else
            check_improve(ch, gsn_adv_fury, FALSE, 1);
        return;
    }

    if (is_affected(ch, gsn_fury))
        return;

    if (ch->hit <= ch->max_hit / 2)
    {
        if (get_skill(ch, gsn_fury) > number_percent())
        {
            AFFECT_DATA af;

            af.where        = TO_AFFECTS;
            af.type         = gsn_fury;
            af.level        = LVL(ch);
            af.duration     = -1;
            af.location     = APPLY_DAMROLL;
            af.modifier     = ch->damroll;
            af.bitvector    = 0;
            affect_to_char(ch, &af);

            af.location     = APPLY_HITROLL;
            af.modifier     = ch->hitroll;
            affect_to_char(ch, &af);

            check_improve(ch, gsn_fury, TRUE, 1);
            act("        {rp{z!", ch, NULL, NULL, TO_CHAR);
            act("$n  {rp{z!.", ch, NULL, NULL, TO_ROOM);
        } else
            check_improve(ch, gsn_fury, FALSE, 1);
        return;
    }
}

void decrease_injury(CHAR_DATA *ch)
{
    AFFECT_DATA *paf;
    AFFECT_DATA af_mod;
    int sn;
    sn = gsn_cause_critical;
    paf = affect_find(ch->affected, sn);
    if (paf == NULL)
    {
        sn = gsn_cause_serious;
        paf = affect_find(ch->affected, sn);
    }
    if (paf == NULL)
    {
        sn = gsn_cause_light;
        paf = affect_find(ch->affected, sn);
    }
    if (paf == NULL)
        return;
    if (paf->modifier >= -1)
    {
        affect_remove(ch, paf);
        return;
    }

    af_mod.where        = TO_AFFECTS;
    af_mod.type         = paf->type;
    af_mod.level        = paf->level;
    af_mod.duration     = 0;
    af_mod.location     = APPLY_HIT;
    af_mod.modifier     = 1;
    af_mod.bitvector    = 0;

    affect_join (ch, &af_mod);

    update_pos(ch);
}

/*
 * Mob autonomous action.
 * This function takes 25% to 35% of ALL Merc cpu time.
 * -- Furey
 */
void mobile_update(void)
{
    CHAR_DATA *ch, *ch_next;
    EXIT_DATA *pexit;
    int        door;
    clan_t    *clan;
    OBJ_DATA  *obj;

    /* Examine all mobs. */
    for (ch = char_list; ch != NULL; ch = ch_next)
    {
        bool bust_prompt = FALSE;
        flag64_t act;

        ch_next = ch->next;

        if (ch->in_room == NULL)
            continue;

        if (ch->position == POS_FIGHTING)
            SET_FIGHT_TIME(ch);

/* permanent spellbane */
        clan = CLAN(ch->clan);
        if (!IS_NPC(ch))
        {
            if (ch->level < LEVEL_IMMORTAL && IS_SET(clan->flags, CLAN_HATE_MAGIC) && !IS_AFFECTED(ch, AFF_SPELLBANE))
            {
                set_spellbane(ch, str_empty);
            }

/* update ghost state */
            if (ch->last_death_time != -1
            && current_time - ch->last_death_time >= GHOST_DELAY_TIME
            && IS_SET(ch->plr_flags, PLR_GHOST))
            {
                act("You return to your normal form.", ch, NULL, NULL, TO_CHAR);
                REMOVE_BIT(ch->plr_flags, PLR_GHOST);
            }
        }

/* update pumped state */
        if (ch->last_fight_time != -1
        && current_time - ch->last_fight_time >= FIGHT_DELAY_TIME
        && IS_PUMPED(ch))
        {
            REMOVE_BIT((ch)->plr_flags, PLR_PUMPED);

            if (!IS_NPC(ch) && ch->desc != NULL
            && ch->desc->pString == NULL
            && (ch->last_death_time == -1
            || ch->last_death_time < ch->last_fight_time))
            {
                act("You settle down.", ch, NULL, NULL, TO_CHAR);
            }
        }

        if (IS_AFFECTED(ch, AFF_REGENERATION) && ch->in_room != NULL && !IS_UNDEAD(ch))
        {
            if (is_affected(ch, gsn_cause_critical)
            || is_affected(ch, gsn_cause_serious)
            || is_affected(ch, gsn_cause_light))
            {
                decrease_injury(ch);
            }

            if (!IS_SET(ch->in_room->room_flags, ROOM_NOHP))
            {
                ch->hit = UMIN(ch->hit + ch->level / 10, ch->max_hit);

                if (ch->hit != ch->max_hit)
                    bust_prompt = TRUE;
            }
        }

        if (IS_AFFECTED(ch, AFF_CORRUPTION) && ch->in_room != NULL)
        {
            ch->hit -=  1 + ch->level/10;

            if (ch->hit < 1)
            {
                if (IS_IMMORTAL(ch))
                {
                    ch->hit = 1;
                } else
                {
                    ch->position = POS_DEAD;
                    handle_death(ch, ch);
                    continue;
                }
            }

            bust_prompt = TRUE;
        }

        if (IS_AFFECTED(ch, AFF_SUFFOCATE) && ch->in_room != NULL)
        {
            if (number_percent() < ((ch->hit / ch->max_hit) * 100) + 5)
                ch->hit -= number_range(ch->level / 2, ch->level * 4);

            if (ch->hit < 1)
            {
                if (IS_IMMORTAL(ch))
                {
                    ch->hit = 1;
                } else
                {
                    ch->position = POS_DEAD;
                    handle_death(ch, ch);
                    continue;
                }
            } else if (number_percent() < 30)
                act("You cannot breath!", ch, NULL, NULL, TO_CHAR);

            bust_prompt = TRUE;
        }

        if (is_affected(ch, gsn_thumbling) && ch->in_room != NULL)
        {
            ch->mana--;
            ch->move--;

            if (ch->mana < 1 || ch->move < 1)
            {
                act("  ,     .", ch, NULL, NULL, TO_CHAR);
                act("$n  .", ch, NULL, NULL, TO_ROOM);
                affect_strip(ch, gsn_thumbling);
            }

            bust_prompt = TRUE;
        }

        if (is_affected(ch, gsn_forest_fighting) && ch->in_room != NULL)
        {
            ch->mana--;
            ch->move--;

            if (ch->mana < 1 || ch->move < 1)
            {
                act("You stop using your knowledge of forest.", ch, NULL, NULL, TO_CHAR);
                act("$n stop using his knowledge of forest.", ch, NULL, NULL, TO_ROOM);
                affect_strip(ch, gsn_forest_fighting);
            }

            bust_prompt = TRUE;
        }

        if (!IS_NPC(ch) && get_skill(ch, gsn_fury) > 0)
            check_fury(ch);

        // if you affected demon your mana not be regenerate
        if (IS_SET(ch->form, FORM_DEMON))
        {
            ch->mana -= (weather_info.sunlight != SUN_DARK) ? ch->level / 30 : ch->level / 60;
            ch->mana = UMAX(ch->mana,0);
            if (ch->mana == 0)
            {
                act("You power is done.", ch, NULL, NULL, TO_CHAR);
                do_human(ch, str_empty);
            }
        }

        // remove bash affect when you not fight
        if (ch->fighting == NULL)
        {
            affect_strip(ch, gsn_bash);
            affect_strip(ch, gsn_throw);
            affect_strip(ch, gsn_trip);
        }

        if (is_affected(ch, gsn_arrest)
        && ch->in_room->vnum != ROOM_VNUM_RULER_CELL
        && ch->in_room->vnum != ROOM_VNUM_LIMBO)
        {
            affect_strip(ch, gsn_arrest);

            if (!IS_SET(ch->plr_flags, PLR_WANTED))
            {
                TOGGLE_BIT(ch->plr_flags, PLR_WANTED);
                act("   {R{x!", ch, NULL, NULL, TO_CHAR);
            }
        }

        if (ch->desc != NULL
        &&  bust_prompt
        &&  ch->desc->pString == NULL
        &&  ch->desc->showstr_point == NULL
        &&  IS_SET(ch->comm, COMM_BUST_PROMPT))
            char_puts(str_empty, ch);

        /* cyborgs */
        if (IS_CYBORG(ch))
        {
            cyborg_special_update(ch);
        }

        /* missiles */
        /* if (IS_NPC(ch)
                 && ch->pIndexData->vnum == MOB_VNUM_CYBER_BRAIN ) {
                 update_missile(ch);
         }*/

        /* Examine call for special procedure */
        if (ch->spec_fun != 0 &&
           (IS_NPC (ch) && !IS_SET (ch->pIndexData->act, ACT_WANDERER | ACT_RECEIVE_LEVEL)))
        {
            if ((*ch->spec_fun) (ch))
                continue;
        }

/*
 * that's all for PCs and charmed mobiles
 */
        if (!IS_NPC(ch) || IS_AFFECTED(ch, AFF_CHARM))
        {
            continue;
        }

        act = ch->pIndexData->act;
        if (IS_SET(act, ACT_HUNTER) && ch->hunting)
            hunt_victim(ch);

        if (ch->in_room->area->empty && !IS_SET(act, ACT_UPDATE_ALWAYS))
        {
            continue;
        }

        if (ch->spec_fun == spec_lookup("spec_stalker")
        && ch->hunting == NULL)
        {
            act("$n      "
                "     .",
                ch, NULL, NULL, TO_ROOM);
            extract_char(ch, TRUE);
            continue;
        }

        // check triggers (only if mobile still in default position)
        if (ch->position == ch->pIndexData->default_pos)
        {
            if (HAS_TRIGGER_MOB(ch, TRIG_DELAY) &&  ch->mprog_delay > 0)
            {
                if (--ch->mprog_delay <= 0)
                {
                    p_percent_trigger(ch, NULL, NULL, NULL,NULL, NULL, TRIG_DELAY);
                    continue;
                }
            }

            if (HAS_TRIGGER_MOB(ch, TRIG_RANDOM) && p_percent_trigger(ch, NULL, NULL, NULL, NULL,NULL, TRIG_RANDOM))
                continue;
        }

/* potion using and stuff for intelligent mobs */

        if (ch->pIndexData->pShop == NULL
            &&  (ch->position == POS_STANDING
                 || ch->position == POS_RESTING
                 || ch->position == POS_FIGHTING)
            &&  get_curr_stat(ch, STAT_INT) > 15
            &&  (ch->hit < ch->max_hit * 90 / 100
                 || IS_AFFECTED(ch, AFF_BLIND)
                 || IS_AFFECTED(ch, AFF_POISON)
                 || IS_AFFECTED(ch, AFF_PLAGUE)
                 || ch->fighting != NULL))
        {
            for (obj = ch->carrying; obj; obj = obj->next_content)
            {
                if (obj->pIndexData->item_type != ITEM_POTION)
                    continue;

                if (ch->hit < ch->max_hit * 90 / 100)
                {
                    int cl = potion_cure_level(obj);

                    if (cl > 0)
                    {
                        if (ch->hit < ch->max_hit*0.5
                            &&  cl > 3)
                        {
                            quaff_obj(ch, obj);
                            continue;
                        }

                        if (ch->hit < ch->max_hit*0.7)
                        {
                            quaff_obj(ch, obj);
                            continue;
                        }
                    }
                }

                if (IS_AFFECTED(ch, AFF_POISON)
                    &&  potion_cure_poison(obj))
                {
                    quaff_obj(ch, obj);
                    continue;
                }

                if (IS_AFFECTED(ch, AFF_PLAGUE)
                    &&  potion_cure_disease(obj))
                {
                    quaff_obj(ch, obj);
                    continue;
                }

                if (IS_AFFECTED(ch, AFF_BLIND)
                    &&  potion_cure_blind(obj))
                {
                    quaff_obj(ch, obj);
                    continue;
                }

                if (ch->fighting)
                {
                    int al = potion_arm_level(obj);

                    if (ch->level - ch->fighting->level < 7
                        &&  al > 3)
                    {
                        quaff_obj(ch, obj);
                        continue;
                    }

                    if (ch->level - ch->fighting->level < 8
                        &&  al > 2)
                    {
                        quaff_obj(ch, obj);
                        continue;
                    }

                    if (ch->level - ch->fighting->level < 9
                        &&  al > 1)
                    {
                        quaff_obj(ch, obj);
                        continue;
                    }

                    if (ch->level - ch->fighting->level < 10
                        &&  al > 0)
                    {
                        quaff_obj(ch, obj);
                        continue;
                    }
                }
            }
        }

/* That's all for sleeping / busy monster, and empty zones */
        if (ch->position != POS_STANDING)
            continue;

/* Scavenge */
        if (IS_SET(act, ACT_SCAVENGER)
            &&  ch->in_room->contents != NULL
            &&  number_bits(6) == 0)
        {
            OBJ_DATA *obj;
            OBJ_DATA *obj_best = NULL;
            int max = 1;

            for (obj = ch->in_room->contents; obj;
                obj = obj->next_content)
            {
                if (CAN_WEAR(obj, ITEM_TAKE) &&  can_loot(ch, obj) &&  obj->cost > max)
                {
                    obj_best = obj;
                    max  = obj->cost;
                }
            }

            if (obj_best && !can_get_obj(ch, obj_best, TRUE))
                get_obj(ch, obj_best, NULL, TRUE);
        }

/* Wander */
        if (!IS_SET(act, ACT_SENTINEL)
            &&  number_bits(3) == 0
            &&  (door = number_bits(5)) <= 5
            &&  !RIDDEN(ch)
            &&  (pexit = ch->in_room->exit[door]) != NULL
            &&  pexit->to_room.r != NULL
            &&  !IS_SET(pexit->exit_info, EX_CLOSED)
            &&  !IS_SET(pexit->to_room.r->room_flags, ROOM_NOMOB)
            &&  (!IS_SET(act, ACT_STAY_AREA)
                 || pexit->to_room.r->area == ch->in_room->area)
            &&  (!IS_SET(act, ACT_AGGRESSIVE)
                 || !IS_SET(pexit->to_room.r->room_flags, ROOM_PEACE | ROOM_SAFE))
            &&  (!IS_SET(act, ACT_OUTDOORS)
                 || !IS_SET(pexit->to_room.r->room_flags, ROOM_INDOORS))
            &&  (!IS_SET(act, ACT_INDOORS)
                 || IS_SET(pexit->to_room.r->room_flags, ROOM_INDOORS)))
        {
            move_char(ch, door, FALSE);
        }

        // birthday/holiday staff
        if (bdflags == 1 && ch->position == ch->pIndexData->default_pos && number_range(1,50) > 48)
        {
            int number = number_range(0,9);

            if (bdmsg[number])
                act("{Y$n{x $t", ch, bdmsg[number], NULL, TO_ROOM);
        }
    }
}

int potion_cure_level(OBJ_DATA *potion)
{
    int cl;
    int i;

    cl = 0;
    for (i=1;i<5;i++)
    {
        if (sn_lookup("cure critical") == potion->value[i])
            cl += 3;
        if (sn_lookup("cure light") == potion->value[i])
            cl += 1;
        if (sn_lookup("cure serious") == potion->value[i])
            cl += 2;
        if (sn_lookup("heal") == potion->value[i])
            cl += 4;
    }
    return(cl);
}

int potion_arm_level(OBJ_DATA *potion)
{
    int al;
    int i;

    al = 0;
    for (i=1;i<5;i++)
    {
        if (sn_lookup("armor") == potion->value[i])
            al += 1;
        if (sn_lookup("shield") == potion->value[i])
            al += 1;
        if (sn_lookup("stone skin") == potion->value[i])
            al += 2;
        if (sn_lookup("sanctuary") == potion->value[i])
            al += 4;
        if (sn_lookup("protection") == potion->value[i])
            al += 3;
    }
    return(al);
}

bool potion_cure_blind(OBJ_DATA *potion)
{
    int i;

    for (i=0;i<5;i++)
    {
        if (sn_lookup("cure blindness") == potion->value[i])
            return(TRUE);
    }
    return(FALSE);
}

bool potion_cure_poison(OBJ_DATA *potion)
{
    int i;

    for (i=0;i<5;i++)
    {
        if (sn_lookup("cure poison") == potion->value[i])
            return(TRUE);
    }
    return(FALSE);
}

bool potion_cure_disease(OBJ_DATA *potion)
{
    int i;

    for (i=0;i<5;i++)
    {
        if (sn_lookup("cure disease") == potion->value[i])
            return(TRUE);
    }
    return(FALSE);
}

/*
 * Update all chars, including mobs.
*/
void char_update(void)
{
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    CHAR_DATA *ch_quit;
    CONNECTIONS_CACHE_ITEM* ci;
    CONNECTIONS_CACHE_ITEM* ci_next;

    int tim;

    static time_t last_save_time = -1;

    ch_quit = NULL;


    /* update save counter */
    save_number++;

    if (save_number > 29)
        save_number = 0;

    // decrease TTL for cache items
    for (ci = connectionsCache; ci != NULL; ci = ci->next)
    {
        if (--ci->ttl == 0)
        {
            ci_next = ci->next;
            connectionsCache = DeleteItemFromCache(connectionsCache, ci);
            ci = ci_next;
            if (ci == NULL) break;
        }
    }


    for (ch = char_list; ch != NULL; ch = ch_next)
    {
        AFFECT_DATA *paf;
        AFFECT_DATA *paf_next;
        int dam_space;
        race_t *r = race_lookup(ch->race);

        if (!IS_NPC(ch))
            if (ch->desc != 0)
            {
                for (ci = connectionsCache; ci != NULL; ci = ci->next)
                {
                    // update TTL for connected players
                    if (!strcmp(ci->name, ch->name)) ci->ttl = CACHE_TTL;
                }

                if (ch->pcdata != NULL) ++(ch->pcdata->this_level_played);
            }

        if (ch->last_duel_time > 0)
            --ch->last_duel_time;

        ch_next = ch->next;
        if (!r)
            continue;

        if (ch->level > 100 || ch->incog_level > 100 || ch->invis_level > 101)
            atrim_ch (ch);

        if (is_affected(ch, gsn_mount_fighting) && !MOUNTED(ch))
            affect_strip(ch, gsn_mount_fighting);

        if (is_affected(ch, gsn_mount_control) && !MOUNTED(ch))
            affect_strip(ch, gsn_mount_control);

        // update cache content with active players


        // update limit timer for players

        // do not increase timer if player is in limbo, safe zone,
        // battle_arena (planning to add clans here)

        if (!IS_NPC(ch) && ch->in_room != NULL
            && ch->in_room->vnum != ROOM_VNUM_LIMBO
            && !IS_SET(ch->in_room->room_flags, ROOM_PEACE)
            && !IS_SET(ch->in_room->room_flags, ROOM_BATTLE_ARENA)
            && !IS_SET(ch->in_room->room_flags, ROOM_NOTIMER)
            && !IS_SET(ch->plr_flags, PLR_GHOST))
        {
            // increase timer
            tim = ch->pcdata->limit_timer + TPD / TICKS_TO_PLAY ;

            if (ch->pcdata->has_limit)
                tim = URANGE(0, tim, DAYS_TO_PLAY * TPD);
            else
                tim = URANGE(0, tim, 2 * (DAYS_TO_PLAY * TPD) / 3);

            ch->pcdata->limit_timer = tim ;
        }

        if (IS_SET(ch->plr_flags, PLR_WANTED)
            &&  !is_affected(ch, gsn_wanted)
            &&  !IS_PUMPED(ch))
            TOGGLE_BIT(ch->plr_flags, PLR_WANTED);

        if (!ch->fighting)
        {
            flag64_t skip = AFF_FLYING;

            affect_check(ch, TO_AFFECTS, -1 & ~skip);

            /* Remove caltrops effect after fight off */
            if (is_affected(ch, gsn_caltrops))
                affect_strip(ch, gsn_caltrops);

            if (!MOUNTED(ch))
            {
                if (!IS_AFFECTED(ch, AFF_HIDE) &&  (r->aff & AFF_HIDE))
                    act("   .", ch, NULL, NULL, TO_CHAR);

                if (!IS_AFFECTED(ch, AFF_SNEAK) &&  (r->aff & AFF_SNEAK))
                    act("   .", ch, NULL, NULL, TO_CHAR);
            } else
                skip |= AFF_HIDE | AFF_FADE | AFF_INVIS |
                        AFF_IMP_INVIS | AFF_SNEAK |
                        AFF_CAMOUFLAGE | AFF_TRAP;

            SET_BIT(ch->affected_by, r->aff & ~skip);
        }

        // Amnesia AFF remover.
        if (!IS_NPC(ch))
        {
            int i;
            for(i = 0; i < ch->pcdata->learned.nused; i++)
            {
                pcskill_t *ps = VARR_GET(&ch->pcdata->learned, i);
                if (!IS_SET(ps->xs_flags, XS_FORGOT))
                    continue;
                if (number_percent() < get_curr_stat(ch, STAT_LCK))
                {
                    REMOVE_BIT(ps->xs_flags, XS_FORGOT);
                    act("You remembered '$t'.", ch, SKILL(ps->sn)->name, NULL, TO_CHAR | ACT_VERBOSE);
                }
            }
        }

        // Remove vampire affect when morning.
        if (IS_SET(ch->form, FORM_VAMPIRE) &&
            (weather_info.sunlight == SUN_LIGHT || weather_info.sunlight == SUN_RISE))
        {
           CHAR_DATA *gch, *gch_next;

            do_human(ch, str_empty);

            gch = char_list;
            while (gch != NULL)
            {
                gch_next = gch->next;
                if (IS_NPC(gch)
                    && IS_AFFECTED(gch, AFF_CHARM)
                    && gch->master == ch
                    && (gch->pIndexData->vnum == MOB_VNUM_VAMPIRE_BAT))
                    extract_char(gch, TRUE);
                gch = gch_next;
            }
            affect_strip(ch, gsn_bats_call);
        }

        if (!IS_NPC(ch) && is_affected(ch, gsn_thumbling))
        {
            if (dice(5, 8) > (get_curr_stat(ch, STAT_DEX) + get_curr_stat(ch, STAT_STR)))
            {
                act("     .", ch, NULL, NULL, TO_CHAR);
                act("$n  .", ch, NULL, NULL, TO_ROOM);
                affect_strip(ch, gsn_thumbling);
            }
        }

        if (!IS_NPC(ch) && is_affected(ch, gsn_forest_fighting))
        {
            if (ch->in_room->sector_type == SECT_INSIDE)
            {
                if (dice(5, 6) > get_curr_stat(ch, STAT_DEX))
                {
                    act("You can't use your knowledge of forest here.", ch, NULL, NULL, TO_CHAR);
                    act("$n can't use his knowledge of forest here.", ch, NULL, NULL, TO_ROOM);
                    affect_strip(ch, gsn_forest_fighting);
                }
            }
        }

        if (ch->timer > 20 && !IS_NPC(ch))
            ch_quit = ch;

        if (ch->position >= POS_STUNNED)
        {
            int old_hit = ch->hit;
            int old_mana = ch->mana;
            int old_move = ch->move;
            int old_psp  = ch->psp;

            /* check to see if we need to go home */
            if (IS_NPC(ch) && ch->zone != NULL
                &&  ch->in_room != NULL
                &&  ch->zone != ch->in_room->area && ch->desc == NULL
                &&  ch->fighting == NULL
/* && ch->progtypes==0 */
                && !IS_AFFECTED(ch,AFF_CHARM) && ch->last_fought == NULL
                && !RIDDEN(ch))
            {
                if (ch->in_mind != NULL
                    && ch->pIndexData->vnum > 100)
                    back_home(ch);
                else
                {
                    act_puts("$n wanders on home.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
                    extract_char(ch, TRUE);
                }
                continue;
            }

            if (IS_NPC(ch)
                && ch->position != ch->pIndexData->default_pos
                && ch->fighting == NULL
                && !IS_AFFECTED(ch, AFF_CHARM)
                && !IS_AFFECTED(ch, AFF_SLEEP)
                && !RIDDEN(ch)
                && ch->pIndexData->default_pos == POS_STANDING)
            {
                do_stand(ch, str_empty);
            }

            if (ch->hit < ch->max_hit)
                ch->hit += hit_gain(ch);
            else
                ch->hit = ch->max_hit;

            if (!IS_SET(ch->form, FORM_DEMON))
            {
                if (ch->mana < ch->max_mana)
                    ch->mana += mana_gain(ch);
                else
                    ch->mana = ch->max_mana;
            }
            if (ch->move < ch->max_move)
                ch->move += move_gain(ch);
            else
                ch->move = ch->max_move;

        if (ch->psp < psp_max(ch))
                ch->psp += psp_gain(ch);
        else
//   For future:
//          if (!is_affected(ch, sn_lookup("harness subconscious")))
                ch->psp = psp_max(ch);

            if (!IS_NPC(ch) && ch->level < LEVEL_IMMORTAL
                &&  ch->desc != NULL && ch->desc->pString == NULL
                &&  ch->desc->showstr_point == NULL
                &&  (old_hit != ch->hit || old_mana != ch->mana ||
                     old_move != ch->move || old_psp != ch->psp))
                char_puts(str_empty, ch);
        }

        if (ch->position == POS_STUNNED)
            update_pos(ch);

        if (!IS_NPC(ch) && ch->level < LEVEL_IMMORTAL
            &&  ch->in_room != NULL)
        {
            OBJ_DATA *obj;

            if ((obj = get_eq_char(ch, WEAR_LIGHT))
                &&  obj->pIndexData->item_type == ITEM_LIGHT
                &&  obj->value[2] > 0)
            {
                if (--obj->value[2] == 0)
                {
                    if (ch->in_room->light > 0)
                        --ch->in_room->light;
                    act("$p .", ch, obj, NULL, TO_ROOM);
                    act("$p   .", ch, obj, NULL, TO_CHAR);
                    extract_obj(obj);
                } else if (obj->value[2] <= 5)
                    act("$p .", ch, obj, NULL, TO_CHAR);
            }

            if (++ch->timer >= 12)
            {
                if (ch->was_in_room == NULL)
                {
                    ch->was_in_room = ch->in_room;
                    if (ch->fighting != NULL)
                        stop_fighting(ch, TRUE);
                    act("$n   .", ch, NULL, NULL, TO_ROOM);
                    act("   .", ch, NULL, NULL, TO_CHAR);
                    if (ch->level > 1)
                        save_char_obj(ch, FALSE, FALSE);
                    char_from_room(ch);
                    char_to_room(ch, get_room_index(ROOM_VNUM_LIMBO));
                    if (JUST_KILLED(ch))
                        continue;
                }
            }

            if (!ch->was_in_room)
            {
                gain_condition(ch, COND_DRUNK, -1);
                if (HAS_SKILL(ch, gsn_vampire))
                    gain_condition(ch, COND_BLOODLUST, -1);
                if (!IS_UNDEAD(ch))
                {
                    gain_condition(ch, COND_FULL,
                                   ch->size > SIZE_MEDIUM_MAX ? -4 : -2);
                    if (ch->in_room->sector_type == SECT_DESERT)
                        gain_condition(ch, COND_THIRST, -3);
                    else
                        gain_condition(ch, COND_THIRST, -1);
                    gain_condition(ch, COND_HUNGER,
                                   ch->size > SIZE_MEDIUM_MAX ? -2 : -1);

                    if (count_used_space(ch->in_room) > ch->in_room->space)
                    {
                        act("   !", ch, NULL, NULL, TO_CHAR);
                        act("$n   !",  ch, NULL, NULL, TO_ROOM);
                        dam_space = ch->max_hit * number_range(6,
                                                               UMAX(8, ch->size/2)) / 100;
                        damage(ch, ch, dam_space, TYPE_HIT, DAM_SPACE, TRUE);
                    }
                }
            }
        }

        for (paf = ch->affected; paf != NULL; paf = paf_next)
        {
            paf_next = paf->next;
            if (paf->duration > 0)
            {
                paf->duration--;
                if (number_range(0, 4) == 0 && paf->level > 0)
                    paf->level--;
                /* spell strength fades with time */
            } else if (paf->duration == 0)
            {
                if ((paf_next == NULL ||
                     paf_next->type != paf->type ||
                     paf_next->duration > 0)
                    &&  paf->type > 0)
                    dispel_message(ch, paf->type, FALSE);
                affect_remove(ch, paf);
            }
        }

        /*
         * Penalties stuff
         */
        if (!IS_NPC(ch))
        {
            int diff;

            if (IS_SET(ch->plr_flags, PLR_FREEZE)
                && ch->pcdata->freeze != 0)
            {
                diff = ch->pcdata->freeze - current_time;

                if (diff < 0)
                {
                    REMOVE_BIT(ch->plr_flags, PLR_FREEZE);
                    act("   !", ch, NULL, NULL, TO_CHAR);
                    ch->pcdata->freeze = 0;
                }
            }

            if (IS_SET(ch->comm, COMM_NOCHANNELS) && ch->pcdata->nochan != 0)
            {
                diff = ch->pcdata->nochan - current_time;

                if (diff < 0)
                {
                    REMOVE_BIT(ch->comm, COMM_NOCHANNELS);
                    act("     .", ch, NULL, NULL, TO_CHAR);
                    ch->pcdata->nochan = 0;
                }
            }

            if (IS_SET(ch->comm, COMM_NONOTE) && ch->pcdata->nonote != 0)
            {
                diff = ch->pcdata->nonote - current_time;

                if (diff < 0)
                {
                    REMOVE_BIT(ch->comm, COMM_NONOTE);
                    act("    .", ch, NULL, NULL, TO_CHAR);
                    ch->pcdata->nonote = 0;
                }
            }

            if (IS_SET(ch->comm, COMM_NOQUEST) && ch->pcdata->noquest != 0)
            {
                diff = ch->pcdata->noquest - current_time;

                if (diff < 0)
                {
                    REMOVE_BIT(ch->comm, COMM_NOQUEST);
                    act("     .", ch, NULL, NULL, TO_CHAR);
                    ch->pcdata->noquest = 0;
                }
            }

            if (IS_SET(ch->comm, COMM_NOEMOTE) && ch->pcdata->noemote != 0)
            {
                diff = ch->pcdata->noemote - current_time;

                if (diff < 0)
                {
                    REMOVE_BIT(ch->comm, COMM_NOEMOTE);
                    act("     .", ch, NULL, NULL, TO_CHAR);
                    ch->pcdata->noemote = 0;
                }
            }

            if (IS_SET(ch->comm, COMM_NOCAST)  && ch->pcdata->nocast != 0)
            {
                diff = ch->pcdata->nocast - current_time;

                if (diff < 0)
                {
                    REMOVE_BIT(ch->comm, COMM_NOCAST);
                    act("      .", ch, NULL, NULL, TO_CHAR);
                    ch->pcdata->nocast = 0;
                }
            }

            if (IS_SET(ch->comm, COMM_NOTELL) && ch->pcdata->notell != 0)
            {
                diff = ch->pcdata->notell - current_time;

                if (diff < 0)
                {
                    REMOVE_BIT(ch->comm, COMM_NOTELL);
                    act("     .", ch, NULL, NULL, TO_CHAR);
                    ch->pcdata->notell = 0;
                }
            }

            if (IS_SET(ch->comm, PLR_PEACE) && ch->pcdata->peaceful !=0)
            {
                diff = ch->pcdata->peaceful - current_time;

                if (diff < 0)
                {
                    REMOVE_BIT(ch->comm, PLR_PEACE);
                    act("      !", ch, NULL, NULL, TO_CHAR);
                    ch->pcdata->peaceful = 0;
                }
            }
        }

        /*
         * Careful with the damages here,
         *   MUST NOT refer to ch after damage taken,
         *   as it may be lethal damage (on NPC).
         */
        if (is_affected(ch,gsn_bleed) && ch != NULL)
        {
            AFFECT_DATA *bleed;
            bool is_sleep = IS_AFFECTED(ch, AFF_SLEEP);

            bleed = affect_find(ch->affected,gsn_bleed);
            if (bleed != NULL)
            {
                act("Your severed artery continues to bleed.", ch , NULL, NULL, TO_CHAR);
                damage(ch,ch,number_range(bleed->level,2*bleed->level),gsn_bleed, DAM_OTHER,TRUE);
                if (IS_AWAKE (ch) && is_sleep) 
                    ch->position = POS_SLEEPING ;
            }
        }
        if (is_affected(ch,gsn_cross_slice) && ch != NULL)
        {
            AFFECT_DATA *bleed;
            bool is_sleep = IS_AFFECTED(ch, AFF_SLEEP);

            bleed = affect_find(ch->affected,gsn_cross_slice);
            if (bleed != NULL)
            {
                act("Your gashed stomach continues to bleed.", ch , NULL, NULL, TO_CHAR);
                damage(ch,ch,number_range(bleed->level/2,3*bleed->level/2),gsn_bleed, DAM_OTHER,TRUE);
                if (IS_AWAKE (ch) && is_sleep) 
                    ch->position = POS_SLEEPING ;
            }
        }


        if (is_affected(ch, gsn_witch_curse) && ch != NULL)
        {
            AFFECT_DATA *af, witch;

            if (ch->in_room == NULL)
                continue;

            act("$n ,      $gn{} .", ch, NULL, NULL, TO_ROOM);
            act(" ,       .", ch, NULL, NULL, TO_CHAR);

            for (af = ch->affected; af!= NULL; af = af->next)
                if (af->type == gsn_witch_curse)
                    break;

            if (af == NULL)
                continue;

            if (af->level == 1)
                continue;

            witch.where = af->where;
            witch.type  = af->type;
            witch.level = af->level;
            witch.duration = af->duration;
            witch.location = af->location;
            witch.modifier = af->modifier * 2;
            witch.bitvector = 0;

            affect_remove(ch, af);
            affect_to_char(ch ,&witch);
            ch->hit = UMIN(ch->hit, ch->max_hit);
            if (ch->hit < 1)
            {
                ch->position = POS_DEAD;
                handle_death(ch, ch);
                continue;
            }
        }

        if (IS_AFFECTED(ch, AFF_PLAGUE) && ch != NULL)
        {
            AFFECT_DATA *af, plague;
            CHAR_DATA *vch;
            int dam;

            if (ch->in_room == NULL)
                continue;

            act("$n     ,  $gn{} .", ch, NULL, NULL, TO_ROOM);
            act("     .", ch, NULL, NULL, TO_CHAR);
            for (af = ch->affected; af != NULL; af = af->next)
                if (af->type == gsn_plague)
                    break;

            if (af == NULL)
            {
                REMOVE_BIT(ch->affected_by, AFF_PLAGUE);
                continue;
            }

            if (af->level == 1)
                continue;

            plague.where     = TO_AFFECTS;
            plague.type      = gsn_plague;
            plague.level     = af->level - 1;
            plague.duration  = number_range(1,2 * plague.level);
            plague.location  = APPLY_STR;
            plague.modifier  = -5;
            plague.bitvector = AFF_PLAGUE;

            for (vch = ch->in_room->people; vch != NULL;
                vch = vch->next_in_room)
            {
                if (!saves_spell(plague.level + 2, vch, DAM_DISEASE)
                    && !IS_IMMORTAL(vch)
                    && !IS_AFFECTED(vch, AFF_PLAGUE)
                    && number_bits(2) == 0)
                {
                    act(" .", vch, NULL, NULL, TO_CHAR);
                    act_puts("$n shivers and looks very ill.", vch, NULL, NULL, TO_ROOM, POS_RESTING);
                    affect_join(vch, &plague);
                }
            }

            dam = UMIN(ch->level, af->level/5 + 1);
            ch->mana -= dam;
            ch->move -= dam;
            if (IS_AFFECTED(ch, AFF_SLEEP))
                ch->hit -= dam;
            else damage(ch, ch, dam, gsn_plague, DAM_DISEASE,FALSE);
            if (number_range(1, 100) < 70)
                if (IS_AFFECTED(ch, AFF_SLEEP))
                {
                    ch->hit -= UMAX(ch->max_hit/20, 50);
                    return;
                }
            damage(ch, ch, UMAX(ch->max_hit/20, 50), gsn_plague, DAM_DISEASE, TRUE);
        }
        else
        if (IS_AFFECTED(ch, AFF_POISON) && ch != NULL &&  !IS_AFFECTED(ch, AFF_SLOW))
        {
            AFFECT_DATA *poison;

            poison = affect_find(ch->affected, gsn_poison);

            if (poison != NULL)
            {
                act("$n    {G{z .", ch, NULL, NULL, TO_ROOM);
                act("    {G{z .", ch, NULL, NULL, TO_CHAR);
                if (IS_AFFECTED(ch, AFF_SLEEP))
                {
                    ch->hit -= poison->level/5 + 1;
                    return;
                }
                damage(ch, ch, poison->level/5 + 1, gsn_poison, DAM_POISON, TRUE);
            }
        }
        else
        if (ch->position == POS_INCAP &&  number_range(0, 1) == 0)
            damage(ch, ch, 1, TYPE_UNDEFINED, DAM_NONE, FALSE);
        else if (ch->position == POS_MORTAL)
            damage(ch, ch, 1, TYPE_UNDEFINED, DAM_NONE, FALSE);
    } /* global for */

    /*
     * Autosave and autoquit.
     * Check that these chars still exist.
     */

    if (last_save_time == -1 || current_time - last_save_time > 300)
    {
        last_save_time = current_time;
        for (ch = char_list; ch != NULL; ch = ch_next)
        {
            ch_next = ch->next;
            if (!IS_NPC(ch) && !(JUST_KILLED(ch)))
                save_char_obj(ch, FALSE, FALSE);
            if (ch == ch_quit || ch->timer > 20)
                do_quit(ch, str_empty);
        }
    }

    return;
}


void water_float_update(void)
{
    OBJ_DATA *obj_next;
    OBJ_DATA *obj;
    CHAR_DATA *ch;

    for (obj = object_list; obj != NULL; obj = obj_next)
    {
        obj_next = obj->next;

        if (!obj->in_room || !IS_WATER(obj->in_room))
            continue;

        obj->water_float = obj->water_float > 0 ? obj->water_float - 1 : -1;

        if (obj->pIndexData->item_type == ITEM_DRINK_CON)
        {
            obj->value[1] = URANGE(1, obj->value[1]+8, obj->value[0]);
            if ((ch = obj->in_room->people))
                act("$p    .", ch, obj, NULL, TO_ALL);
            obj->water_float = obj->value[0]-obj->value[1];
            obj->value[2] = 0;
        }
        if (obj->water_float == 0)
        {
            if ((ch = obj->in_room->people))
                act("$p   .", ch, obj, NULL, TO_ALL);
            extract_obj(obj);
        }
    }
}

void update_obj_affects(OBJ_DATA *obj)
{
    AFFECT_DATA *paf, *paf_next;

    /* go through affects and decrement */
    for (paf = obj->affected; paf != NULL; paf = paf_next)
    {
        paf_next    = paf->next;

        if (paf->duration > 0)
        {
            paf->duration--;
            /* spell strength fades with time */
            if (number_range(0,4) == 0 && paf->level > 0)
                paf->level--;
        } else if (paf->duration == 0)
        {
            skill_t *sk;

            if ((paf_next == NULL || paf_next->type != paf->type
            || paf_next->duration > 0)
            && paf->type > 0
            && (sk = skill_lookup(paf->type))
            && !IS_NULLSTR(sk->msg_obj))
            {
                if (obj->carried_by != NULL)
                    act(sk->msg_obj, obj->carried_by, obj, NULL, TO_CHAR);

                if (obj->in_room != NULL && obj->in_room->people)
                    act(sk->msg_obj, obj->in_room->people, obj, NULL, TO_ALL);
            }
            affect_remove_obj(obj, paf);
        }
    }
}

bool update_ice_obj(OBJ_DATA *obj)
{
    if (obj->carried_by != NULL
    &&  obj->carried_by->in_room->sector_type == SECT_DESERT
    &&  number_percent() < 40)
    {
        if (IS_OBJ_STAT(obj, ITEM_HIDURABILITY)
        && number_percent() > 40)
            return FALSE;

        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return FALSE;

        act("  $p.", obj->carried_by, obj, NULL, TO_CHAR);
        extract_obj(obj);
        return TRUE;
    }
    if (obj->in_room != NULL
    &&  obj->in_room->sector_type == SECT_DESERT
    &&  number_percent() < 50)
    {
        if (IS_OBJ_STAT(obj, ITEM_HIDURABILITY) && number_percent() > 50)
            return FALSE;

        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return FALSE;

        act("  $p.", obj->in_room->people, obj, NULL, TO_ALL);
        extract_obj(obj);
        return TRUE;
    }
    return FALSE;
}

bool update_glass_obj(OBJ_DATA *obj)
{
    if (obj->carried_by
    && obj->carried_by->in_room->sector_type == SECT_DESERT
    && !IS_NPC(obj->carried_by)
    && number_percent() < 20)
    {
        if (IS_OBJ_STAT(obj, ITEM_HIDURABILITY) && number_percent() > 20)
            return FALSE;

        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return FALSE;

        act("$p .", obj->carried_by, obj, NULL, TO_CHAR);
        extract_obj(obj);
        return TRUE;
    }
    if (obj->in_room && obj->in_room->sector_type == SECT_DESERT && number_percent() < 30)
    {
        if (IS_OBJ_STAT(obj, ITEM_HIDURABILITY) && number_percent() > 30)
            return FALSE;

        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
            return FALSE;

        act("$p   .", obj->in_room->people, obj, NULL, TO_ROOM);
        act("$p   .", obj->in_room->people, obj, NULL, TO_CHAR);
        extract_obj(obj);
        return TRUE;
    }
    return FALSE;
}

void update_pit(OBJ_DATA *obj)
{
    OBJ_DATA *t_obj, *next_obj;
    static int pit_count = 1;
    /* more or less an hour */
//    pit_count = (++pit_count) % 120; // GM Warning FIX
    pit_count++;
    pit_count = pit_count % 120;

    if (!IS_SET(obj->pIndexData->extra_flags, ITEM_PIT) || pit_count)
        return;

    for (t_obj = obj->contains; t_obj != NULL; t_obj = next_obj)
    {
        next_obj = t_obj->next_content;
        obj_from_obj(t_obj);
        extract_obj(t_obj);
    }
}

void contents_to_obj(OBJ_DATA *obj, OBJ_DATA *to_obj)
{
    OBJ_DATA *obj_next;

    for (; obj; obj = obj_next)
    {
        obj_next = obj->next_content;
        obj_from_obj(obj);
        obj_to_obj(obj, to_obj);
    }
}


static inline void
save_corpse_contents(OBJ_DATA *corpse)
{
    OBJ_DATA *obj, *obj_next;
    OBJ_DATA *pit;
    altar_t *altar;

/* in another object */
    if (corpse->in_obj)
    {
        contents_to_obj(corpse->contains, corpse->in_obj);
        return;
    }

/* carried by */
    if (corpse->carried_by)
    {
        for (obj = corpse->contains; obj; obj = obj_next)
        {
            obj_next = obj->next_content;
            obj_from_obj(obj);
            obj_to_char(obj, corpse->carried_by);
        }
        return;
    }

/* pit lookup */
    pit = NULL;
    altar = corpse->altar;

    if (altar != NULL)
        if (altar->room != NULL)
            for (pit = altar->room->contents; pit; pit = pit->next_content)
            {
                if (pit->pIndexData == altar->pit)
                    break;
            }

    if (!pit)
    {
        for (obj = corpse->contains; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            obj_from_obj(obj);

            if (altar && altar->room)
                obj_to_room(obj, altar->room);
            else if (corpse->in_room)
                obj_to_room(obj, corpse->in_room);
        }
        return;
    }

/* put contents into pit */
    contents_to_obj(corpse->contains, pit);
}


void update_one_obj(OBJ_DATA *obj)
{
    OBJ_DATA *t_obj;
    CHAR_DATA *rch;
    char *message;

    update_obj_affects(obj);

    /* find the uppest obj container */
    for (t_obj = obj; t_obj->in_obj; t_obj = t_obj->in_obj)
        ;

    if ((t_obj->in_room != NULL &&
         t_obj->in_room->area->nplayer > 0)
        ||  (t_obj->carried_by &&
             t_obj->carried_by->in_room &&
             t_obj->carried_by->in_room->area->nplayer > 0))
        oprog_call(OPROG_AREA, obj, NULL, NULL);

    if (check_material(obj, "ice") &&  update_ice_obj(obj))
        return;

    if (check_material(obj, "glass")
        &&  obj->pIndexData->item_type == ITEM_POTION
        &&  update_glass_obj(obj))
        return;

    if (obj->condition > -1 && (obj->timer <= 0 || --obj->timer > 0)
        && (!IS_OBJ_STAT(obj, ITEM_RADIATION) || number_range(1,250) != 2))
        return;

    if (IS_OBJ_STAT(obj, ITEM_RADIATION))
    {
        switch (number_range(1,3))
        {
            default:
            case 1:
                message = "{y{Y {y{x $p.";
                break;
            case 2:
                message = "{y {Y {y $p {y{Y {y .{x";
                break;
            case 3:
                message = "$p {y{Y  {y {Y {y.{x";
                break;
        }
    } else
    {
        switch (obj->pIndexData->item_type)
        {
            default:
                message = "$p   .";
                break;
            case ITEM_FOUNTAIN:
                message = "$p .";
                break;
            case ITEM_CORPSE_NPC:
                message = "$p .";
                break;
            case ITEM_CORPSE_PC:
                message = "$p .";
                break;
            case ITEM_FOOD:
                message = "$p .";
                break;
            case ITEM_POTION:
                message = "$p .";
                break;
            case ITEM_PORTAL:
                message = "$p .";
                break;
            case ITEM_CONTAINER:
                if (CAN_WEAR(obj, ITEM_WEAR_FLOAT))
                    if (obj->contains)
                    {
                        message = "$p   ,  "
                                  "   .";
                    } else
                        message = "$p   .";
                else
                    message = "$p   .";
                break;
        }
    }
    if (obj->carried_by != NULL)
    {
        if (IS_NPC(obj->carried_by) &&  obj->carried_by->pIndexData->pShop != NULL)
            obj->carried_by->silver += obj->cost/5;
        else
        {
            act(message, obj->carried_by, obj, NULL, TO_CHAR);
            if (obj->wear_loc == WEAR_FLOAT)
                act(message, obj->carried_by, obj, NULL, TO_ROOM);
        }
    }

    if (obj->in_room && (rch = obj->in_room->people)
        && !(obj->in_obj
             && !IS_SET(obj->pIndexData->extra_flags, ITEM_PIT)
             && !CAN_WEAR(obj->in_obj, ITEM_TAKE)))
        act(message, rch, obj, NULL, TO_ALL);

    if ((obj->pIndexData->item_type == ITEM_CORPSE_PC) && obj->contains)
        save_corpse_contents(obj);
    extract_obj(obj);
}

OBJ_DATA *last_updated_obj;

void obj_update_list(OBJ_DATA *obj)
{
    int i;
    OBJ_DATA *obj_next;

/* some diagnostics */
    obj_next = obj;
    for (i = 0; obj && obj->extracted; obj = obj->next, i++)
        ;
    if (i)
        log_printf("obj_update_list: skipped %d extracted objs, "
                   "object_list == %p, obj == %p, "
                   "last_updated_obj == %p, "
                   "last_updated_obj->next == %p",
                   i, object_list, obj_next,
                   last_updated_obj, last_updated_obj->next);

    for (; obj; obj = obj_next)
    {
        obj_next = obj->next;

        if (obj->extracted)
        {
            obj_update_list(last_updated_obj ? last_updated_obj->next : object_list);
            return;
        }

        update_one_obj(obj);

        if (!obj->extracted)
            last_updated_obj = obj;
    }
}

/*
 * Update all objs.
 * This function is performance sensitive.
 */
void obj_update(void)
{
    last_updated_obj = NULL;
    obj_update_list(object_list);
}

/*
 * Aggress.
 *
 * for each mortal PC
 *     for each mob in room
 *         aggress on some random PC
 *
 * This function takes 25% to 35% of ALL Merc cpu time.
 * Unfortunately, checking on each PC move is too tricky,
 *   because we don't the mob to just attack the first PC
 *   who leads the party into the room.
 *
 * -- Furey
 */
void aggr_update(void)
{
    CHAR_DATA *wch, *wch_next;
    CHAR_DATA *ch, *ch_next;
    CHAR_DATA *vch, *vch_next;
    CHAR_DATA *victim;

    for (wch = char_list; wch != NULL; wch = wch_next)
    {
        if (wch && IS_NPC (wch) && wch->daze > 0)
            --wch->daze;

        wch_next = wch->next;

        // special processing for wanderers
        if (IS_NPC(wch) && IS_SET (wch->pIndexData->act, ACT_WANDERER) && (wch->spec_fun != 0))
        {
            if ((*wch->spec_fun) (wch))
                continue;
        }
        // special processing for intelligent charmies
        if (IS_NPC(wch) && IS_SET (wch->pIndexData->act, ACT_RECEIVE_LEVEL)
            && (IS_AFFECTED (wch, AFF_CHARM))
            && (wch->spec_fun != 0))
        {
            if ((*wch->spec_fun) (wch))
                continue;
        }

        check_confuse(wch);

        if (IS_AWAKE(wch)
        && IS_AFFECTED(wch, AFF_BLOODTHIRST)
        && wch->fighting == NULL)
        {
            for (vch = wch->in_room->people;
            vch != NULL && wch->fighting == NULL;
            vch = vch_next)
            {
                vch_next = vch->next_in_room;
                if (wch != vch && can_see(wch,vch)
                && !is_safe_nomessage(wch,vch)
                && wch != vch->mount)
                {
                    act_puts("{R! !! !!!{x", wch, NULL, NULL, TO_CHAR, POS_RESTING);
                    do_murder(wch, vch->name);
                    if (JUST_KILLED(wch))
                        continue;
                }
            }
        }


        if (IS_NPC(wch)
            ||  wch->level >= LEVEL_IMMORTAL
            ||  wch->in_room == NULL
            ||  wch->in_room->area->empty)
            continue;

        for (ch = wch->in_room->people; ch != NULL; ch = ch_next)
        {
            int count;
            flag64_t act;

            ch_next = ch->next_in_room;

            if (!IS_NPC(ch)
                ||  (!IS_SET(act = ch->pIndexData->act, ACT_AGGRESSIVE)
                     && ch->last_fought == NULL)
                ||  IS_SET(ch->in_room->room_flags, ROOM_PEACE | ROOM_SAFE)
                ||  IS_AFFECTED(ch, AFF_CALM | AFF_CHARM)
                ||  ch->fighting != NULL
                ||  RIDDEN(ch)
                ||  !IS_AWAKE(ch)
                ||  (IS_SET(act, ACT_WIMPY) && IS_AWAKE(wch))
                ||  !can_see(ch, wch)
                ||  number_bits(1) == 0
                ||  is_safe_nomessage(ch,wch))
                continue;

            /* Mad mob attacks! */
            if (ch->last_fought == wch)
            {
                act_yell(ch, "$i!   !", wch, NULL);
                wch = check_guard(wch, ch);
                multi_hit(ch, wch, TYPE_UNDEFINED);
                continue;
            }

            if (ch->last_fought != NULL)
                continue;

            /*
             * Ok we have a 'wch' player character and a 'ch' npc
             * aggressor. Now make the aggressor fight a RANDOM
             * pc victim in the room, giving each 'vch' an equal
             * chance of selection.
             */
            count = 0;
            victim = NULL;
            for (vch = wch->in_room->people;
                vch != NULL; vch = vch_next)
            {
                vch_next = vch->next_in_room;

                if (!IS_NPC(vch)
                    &&  vch->level < LEVEL_IMMORTAL
                    &&  ch->level >= vch->level - 5
                    &&  (!IS_SET(act, ACT_WIMPY)
                         ||   !IS_AWAKE(vch))
                    &&  can_see(ch, vch)
                    /* do not attack vampires */
                    &&  !HAS_SKILL(vch, gsn_vampire)
                    && !(vch->religion == RELIGION_ASTERN)
                    // area is under control
                    && !altar_works (ch, ALTAR_TRANQUILITY_POS)
                    /* good vs good :( */
                    &&  !(IS_GOOD(ch) && IS_GOOD(vch)))
                {
                    if (number_range(0, count) == 0)
                        victim = vch;
                    count++;
                }
            }

            if (victim == NULL)
                continue;

            if (!is_safe_nomessage(ch, victim))
            {
                int dt = TYPE_UNDEFINED;
                int bs_chance;

                victim = check_guard(victim, ch);
                if (get_dam_type(ch, get_eq_char(ch, WEAR_WIELD), &dt) == DAM_PIERCE
                    &&  (bs_chance = get_skill(ch, gsn_backstab))
                    &&  backstab_ok(NULL, victim))
                    backstab(ch, victim, bs_chance);
                else
                    multi_hit(ch, victim, TYPE_UNDEFINED);
            }
        }
    }
}



/*
 * Handle all kinds of updates.
 * Called once per pulse from game loop.
 * Random times to defeat tick-timing clients and players.
 */

void update_handler(void)
{
    static int pulse_area        = 0 ;
    static int pulse_mobile      = 0 ;
    static int pulse_violence    = 0 ;
    static int pulse_point       = 0 ;
    static int pulse_music       = 0 ;
    static int pulse_water_float = 0 ;
    static int pulse_raffect     = 0 ;
    static int pulse_track       = 0 ;
    static int pulse_limit       = PULSE_LIMIT ;
    static int pulse_ranking     = PULSE_RANKING ;

    if (gc.enabled)
    {
        if (gc.char_enabled && (--gc.pulse_char<= 0))
        {
            wiznet("Garbage collector CHAR TICK!", NULL, NULL, WIZ_TICKS, 0, 0);
            gc.pulse_char = gc.pulse_char_default;
            gc_char_update();

        }

        if ( gc.room_enabled && (--gc.pulse_room <= 0))
        {
            wiznet("Garbage collector ROOM TICK!", NULL, NULL, WIZ_TICKS, 0, 0);
            gc.pulse_room = gc.pulse_room_default;
            gc_room_update();

        }
    }
    
    if (IS_SET(muddy_mode, MUDDY_EVENTS))
    {
    	wiznet("EVENT update!", NULL,NULL, WIZ_TICKS,0,0);
    	event_update();
    }

    if (--pulse_area <= 0)
    {
        wiznet("AREA & ROOM TICK!", NULL, NULL, WIZ_TICKS, 0, 0);
        pulse_area = PULSE_AREA;

        riddle_update(NULL);
        area_update();
        room_update();
    }

    if (--pulse_music <= 0)
    {
        pulse_music = PULSE_MUSIC;
/*      song_update(); */
    }

    if (--pulse_mobile <= 0)
    {
        pulse_mobile = PULSE_MOBILE;
        mobile_update();
        light_update();
    }

    if (--pulse_violence <= 0)
    {
        pulse_violence = PULSE_VIOLENCE;
        violence_update();
    }

    if (--pulse_water_float <= 0)
    {
        pulse_water_float = PULSE_WATER_FLOAT;
        water_float_update();
    }

    if (--pulse_raffect <= 0)
    {
        pulse_raffect = PULSE_RAFFECT;
        room_affect_update();
    }

    if (--pulse_track <= 0)
    {
        pulse_track = PULSE_TRACK;
        track_update();
    }

    if (--pulse_point <= 0)
    {
        CHAR_DATA *ch;

        wiznet("CHAR TICK!",NULL,NULL,WIZ_TICKS,0,0);
        pulse_point = PULSE_TICK;
        weather_update();

        if (time_info.hour == 0)
            sunrise(time_info.day, time_info.month, time_info.year, BREADTH, LONGITUDE, TIME_ZONE);

        char_update();
        quest_update();
        gq_update ();                    // global quests
        ranking_update ();
        areacontrol_update ();
        war_update ();
        wq_update ();
        obj_update();
        service_data_update ();
        meteors_update();                //meteors update
        check_clans();
        check_reboot();

        /* room counting */
        for (ch = char_list; ch != NULL; ch = ch->next)
            if (!IS_NPC(ch) && ch->in_room != NULL)
                ch->in_room->area->count++;
    }
    else
        if (((5 * pulse_point - PULSE_TICK/2) % PULSE_TICK) == 0)
            check_fishing();

    if (--pulse_ranking <= 0)
    {
        wiznet ("Ranking updating!", NULL, NULL, WIZ_TICKS, 0, 0);
        pulse_ranking = PULSE_RANKING ;

#ifdef __FreeBSD__
        if (rfork (RFPROC | RFNOWAIT) == 0) /* child */
        {
            execl (RANKING_EXE, RANKING_EXE, NULL); /* returns on error */
            _exit(-1); /* terminate child - do NOT use exit() here */
        }
#endif
    }

    if (--pulse_limit <= 0)
    {
        CHAR_DATA * ch ;
        FILE      * fp ;

        wiznet ("Limit checking!", NULL, NULL, WIZ_TICKS, 0, 0);
        pulse_limit = PULSE_LIMIT ;

        // online characters processing
        for (ch = char_list ; ch != NULL ; ch = ch->next)
        {
            if (!IS_NPC (ch))
            {
                // decrease timer
                ch->pcdata->limit_timer -= (PULSE_LIMIT / PULSE_TICK);
                ch->pcdata->limit_timer  = ch->pcdata->limit_timer < 0 ? 0 : ch->pcdata->limit_timer ;

                // time has come!
                if (ch->pcdata->limit_timer == 0 && ch->pcdata->has_limit && !IS_IMMORTAL(ch))
                {
                    limits_strip (ch);
                    save_char_obj (ch, FALSE, FALSE);
                }
            }
        }

        // offline characters processing
        if ((fp = dfopen (PLAYER_PATH, HOLDER_LIST, "r")) == NULL)
            bug ("Update_handler: unable to open holder.lst.", 0);
        else
        {
            CHAR_DATA *wch;
            FILE * pfile ;
            FILE * tfile ;
            int    timer ;
            bool   ok    ;
            char   word [MAX_STRING_LENGTH] ;
            char   buf  [MAX_STRING_LENGTH] ;
            int    i     ;

            while (!feof (fp) && fgets (word, MAX_STRING_LENGTH, fp))
            {
                // cut down newline terminator
                word [strlen (word) - 1] = '\0' ;

                if (word[0] == '\0' || strlen (word) == 0) continue ;

                // inline capitalize
                for (i = 0 ; word[i] != '\0' ; i++) word[i] = LOWER(word[i]);
                word[0] = UPPER(word[0]);

                // check if that player is online
                for (ch = char_list ; ch != NULL ; ch = ch->next)
                    if (!IS_NPC (ch) && !str_cmp (capitalize(ch->name), word)) break ;

                if (ch != NULL) continue ;

                if ((pfile = dfopen (PLAYER_PATH, word, "r")) == NULL)
                {
                    bug ("Update_handler: can't open player file.", 0);
                    continue ;
                }

                if ((tfile = dfopen (PLAYER_PATH, TMP_FILE, "w")) == NULL)
                {
                    bug ("Update_handler: unable to open temporary file.", 0);
                    continue ;
                }

                // read line by line until LTimer is found
                // and save it the same time, bypassing normal
                // load_char_obj/save_char_obj procedure for speed up

                ok = FALSE ; // indicator that LTimer is found

                while (!feof (pfile) && fgets (buf, MAX_STRING_LENGTH, pfile))
                {
                    // found LTimer
                    if (strncmp (buf, "LTimer", 6) == 0)
                    {
                        sscanf (buf, "LTimer %d", &timer);

                        // this timer is always updated even if the
                        // cheater flag is set

                        timer -= (PULSE_LIMIT / PULSE_TICK);
                        timer  = timer < 0 ? 0 : timer ;

                        fprintf (tfile, "LTimer %d\n", timer);
                        ok = TRUE ;
                    } else fprintf (tfile, "%s", buf);
                }

                fclose (tfile);
                fclose (pfile);

                d2rename (PLAYER_PATH, TMP_FILE, PLAYER_PATH, word);

                // need special processing for limit stripping
                if (ok && timer > 0) continue ;

                // pload
                if ((wch = char_load_special(word)) == NULL)
                    continue;
                reset_char (wch);
                wiznet_printf (wch, NULL, WIZ_SECURE, 0, wch->level, "$N is loaded for offline timer check.");

                // set default timer
                if (!ok)
                {
                    log_printf ("Limit timer is not set for %s - resetting.", wch->name);
                    wch->pcdata->limit_timer = LTIMER_DEFAULT ;
                }

                // strip limit for everyone limited objects and timer being 0
                // but do not process cheaters and immortals

                if (  wch->pcdata->limit_timer == 0 && wch->pcdata->has_limit && !IS_IMMORTAL(wch))
                {
                    log_printf ("Offline limits strip for %s.", wch->name);
                    limits_strip (wch);

                    // save_char_obj is called below
                }

                // punload
                char_nuke(wch);
            }

            fclose (fp);
        }
    }

    aggr_update();
    auction_update();
    tail_chain();

    return;
}

void light_update(void)
{
    CHAR_DATA *ch;
    int dam_light;
    DESCRIPTOR_DATA *d;


    for (d = descriptor_list; d != NULL; d = d->next)
    {
        if (d->connected != CON_PLAYING)
            continue;

        ch = (d->original != NULL) ? d->original : d->character;

        if (!ch)
            continue;

        if (IS_IMMORTAL(ch))
            continue;

        /* also checks vampireness */
        if ((dam_light = isn_dark_safe(ch)) == 0)
            continue;

        if (dam_light != 2 &&  number_percent() < get_skill(ch, gsn_light_resistance))
        {
            check_improve(ch, gsn_light_resistance, TRUE, 32);
            continue;
        }

        if (dam_light == 1)
            act("{W{z    .", ch, NULL, NULL, TO_CHAR);
        else
            act("{Y {W{x  .", ch, NULL, NULL, TO_CHAR);

        dam_light = 1 + (ch->max_hit * 4)/ 100;
        if (IS_AFFECTED(ch, AFF_SLEEP))
        {
            ch->hit -= dam_light;
            return;
        }
        damage(ch, ch, dam_light, TYPE_HUNGER, DAM_LIGHT_V, TRUE);

        if (ch->position == POS_STUNNED)
            update_pos(ch);

        if (number_percent() < 10)
            gain_condition(ch, COND_DRUNK,  -1);
    }
}

void room_update(void)
{
    ROOM_INDEX_DATA *room;
    ROOM_INDEX_DATA *room_next;

    for (room = top_affected_room; room; room = room_next)
    {
        AFFECT_DATA *paf;
        AFFECT_DATA *paf_next;

        room_next = room->aff_next;

        for (paf = room->affected; paf != NULL; paf = paf_next)
        {
            paf_next = paf->next;

            if (paf->duration > 0)
            {
                paf->duration--;
/*
 * spell strength shouldn't fade with time
 * because of checks in safe_rspell with af->level
                if (number_range(0,4) == 0 && paf->level > 0)
                    paf->level--;
*/
            } else if (paf->duration == 0)
                affect_remove_room(room, paf);
        }
    }
}

void room_affect_update(void)
{
    ROOM_INDEX_DATA *room;
    ROOM_INDEX_DATA *room_next;

    for (room = top_affected_room; room ; room = room_next)
    {
        room_next = room->aff_next;

        while (IS_ROOM_AFFECTED(room, RAFF_PLAGUE) && room->people != NULL)
        {
            AFFECT_DATA *af, plague;
            CHAR_DATA *vch;

            for (af = room->affected; af != NULL; af = af->next)
            {
                if (af->type == gsn_black_death)
                    break;
            }

            if (af == NULL)
            {
                REMOVE_BIT(room->affected_by,RAFF_PLAGUE);
                break;
            }

            if (af->level == 1)
                af->level = 2;

            plague.where        = TO_AFFECTS;
            plague.type         = gsn_plague;
            plague.level        = af->level - 1;
            plague.duration     = number_range(1,((plague.level/2)+1));
            plague.location     = APPLY_NONE;
            plague.modifier     = -5;
            plague.bitvector    = AFF_PLAGUE;

            for (vch = room->people; vch != NULL; vch = vch->next_in_room)
            {
                if (!saves_spell(plague.level, vch, DAM_DISEASE)
                && !IS_IMMORTAL(vch)
                && !is_safe_rspell(af->level,vch)
                && !IS_AFFECTED(vch,AFF_PLAGUE) && number_bits(3) == 0)
                {
                    act("You feel hot and feverish.", vch, NULL, NULL, TO_CHAR);
                    act("$n shivers and looks very ill.", vch, NULL, NULL, TO_ROOM);
                    affect_join(vch,&plague);
                }
            }
            break;
        }

        while (IS_ROOM_AFFECTED(room, RAFF_POISON) && room->people != NULL)
        {
            AFFECT_DATA *af, paf;
            CHAR_DATA *vch;

            for (af = room->affected; af != NULL; af = af->next)
            {
                if (af->type == gsn_deadly_venom)
                    break;
            }

            if (af == NULL)
            {
                REMOVE_BIT(room->affected_by,RAFF_POISON);
                break;
            }

            if (af->level == 1)
                af->level = 2;

            paf.where       = TO_AFFECTS;
            paf.type        = gsn_poison;
            paf.level       = af->level - 1;
            paf.duration    = number_range(1,((paf.level/5)+1));
            paf.location    = APPLY_NONE;
            paf.modifier    = -5;
            paf.bitvector   = AFF_POISON;

            for (vch = room->people; vch != NULL; vch = vch->next_in_room)
            {
                if (!saves_spell(paf.level, vch, DAM_POISON)
                && !IS_IMMORTAL(vch)
                && !is_safe_rspell(af->level, vch)
                && !IS_AFFECTED(vch,AFF_POISON) && number_bits(3) == 0)
                {
                    act("You feel very sick.", vch, NULL, NULL, TO_CHAR);
                    act("$n looks very ill.", vch, NULL, NULL, TO_ROOM);
                    affect_join(vch, &paf);
                }
            }
            break;
        }

        while (IS_ROOM_AFFECTED(room, RAFF_SLOW) && room->people != NULL)
        {
            AFFECT_DATA *af, paf;
            CHAR_DATA *vch;

            for (af = room->affected; af != NULL; af = af->next)
            {
                if (af->type == gsn_lethargic_mist)
                    break;
            }

            if (af == NULL)
            {
                REMOVE_BIT(room->affected_by,RAFF_SLOW);
                break;
            }

            if (af->level == 1)
                af->level = 2;

            paf.where       = TO_AFFECTS;
            paf.type        = gsn_slow;
            paf.level       = af->level - 1;
            paf.duration    = number_range(1,((paf.level/5)+1));
            paf.location    = APPLY_NONE;
            paf.modifier    = -5;
            paf.bitvector   = AFF_SLOW;

            for (vch = room->people; vch != NULL; vch = vch->next_in_room)
            {
                if (!saves_spell(paf.level, vch, DAM_MAGIC)
                && !IS_IMMORTAL(vch)
                && !is_safe_rspell(af->level, vch)
                && !IS_AFFECTED(vch, AFF_SLOW) && number_bits(3) == 0)
                {
                    act("You start to move less quickly.", vch, NULL, NULL, TO_CHAR);
                    act("$n is moving less quickly.", vch, NULL, NULL, TO_ROOM);
                    affect_join(vch,&paf);
                }
            }
            break;
        }

        while (IS_ROOM_AFFECTED(room, RAFF_SLEEP) && room->people != NULL)
        {
            AFFECT_DATA *af, paf;
            CHAR_DATA *vch;

            for (af = room->affected; af != NULL; af = af->next)
            {
                if (af->type == gsn_mysterious_dream)
                    break;
            }

            if (af == NULL)
            {
                REMOVE_BIT(room->affected_by,RAFF_SLEEP);
                break;
            }

            if (af->level == 1)
                af->level = 2;

            paf.where       = TO_AFFECTS;
            paf.type        = gsn_sleep;
            paf.level       = af->level - 1;
            paf.duration    = number_range(1,((paf.level/10)+1));
            paf.location    = APPLY_NONE;
            paf.modifier    = -5;
            paf.bitvector   = AFF_SLEEP;

            for (vch = room->people; vch != NULL; vch = vch->next_in_room)
            {
                if (!saves_spell(paf.level - 4,vch,DAM_CHARM)
                &&  !IS_IMMORTAL(vch)
                &&  !is_affected (vch, gsn_insomnia)
                &&  !is_safe_rspell(af->level,vch)
                &&  !IS_UNDEAD(vch)
                &&  !IS_AFFECTED(vch,AFF_SLEEP)
                && number_bits(3) == 0)
                {
                    if (IS_AWAKE(vch))
                    {
                        act("You feel very sleepy.......zzzzzz.", vch, NULL, NULL, TO_CHAR);
                        act("$n goes to sleep.",vch,NULL,NULL,TO_ROOM);
                        vch->position = POS_SLEEPING;
                    }
                    affect_join(vch,&paf);
                }
            }
            break;
        }

// FIRE WALL
        while (IS_ROOM_AFFECTED(room, RAFF_FWALL) && room->people != NULL)
        {
            AFFECT_DATA *af, paf;
            CHAR_DATA *vch;
            int dam = 2000;

            for (af = room->affected; af != NULL; af = af->next)
            {
                if (af->type == gsn_fire_wall)
                    break;
            }

            if (af == NULL)
            {
                REMOVE_BIT(room->affected_by,RAFF_FWALL);
                break;
            }

            if (af->level == 1)
                af->level = 2;

            paf.where       = TO_AFFECTS;
            paf.type        = gsn_fire_wall;
            paf.level       = af->level;
            paf.duration    = af->level / 15;
            paf.modifier    = 0;
            paf.location    = APPLY_NONE;
            paf.bitvector   = 0;

            for (vch = room->people; vch != NULL; vch = vch->next_in_room)
            {
                if (IS_NPC(vch)
                    && (IS_SET(vch->pIndexData->act, ACT_AREA_GUARD)
                        || IS_SET(vch->pIndexData->act, ACT_CLAN_GUARD)))
                    continue;

                if (!saves_spell(paf.level - 4, vch, DAM_FIRE)
                && !IS_IMMORTAL(vch)
                && !is_safe_rspell(af->level,vch))
                {
                    if (is_affected(vch, gsn_fire_wall))
                        dam *= 2;
                    if (saves_spell(paf.level, vch, DAM_FIRE))
                        dam /= 2;
                    else
                        fire_effect(vch, paf.level, dam, TARGET_CHAR);

                    damage(vch, vch, dam, gsn_fire_wall, DAM_FIRE, TRUE);
                }
                if (!is_affected(vch, gsn_fire_wall)
                && saves_spell(paf.level, vch, DAM_FIRE))
                {
                    AFFECT_DATA af2;
                    af2.where       = TO_AFFECTS;
                    af2.type        = gsn_fire_wall;
                    af2.level       = paf.level;
                    af2.duration    = paf.level / 15;
                    af2.modifier    = 0;
                    af2.location    = APPLY_NONE;
                    af2.bitvector   = 0;
                    affect_to_char(vch, &af2);
                }
           }
        break;
        }  // end fire_wall

        while (IS_ROOM_AFFECTED(room, RAFF_ESPIRIT) && room->people != NULL)
        {
            AFFECT_DATA *af, paf;
            CHAR_DATA *vch;

            for (af = room->affected; af != NULL; af = af->next)
            {
                if (af->type == gsn_evil_spirit)
                    break;
            }

            if (af == NULL)
            {
                REMOVE_BIT(room->affected_by,RAFF_ESPIRIT);
                break;
            }

            if (af->level == 1)
                af->level = 2;

            paf.where   = TO_AFFECTS;
            paf.type    = gsn_evil_spirit;
            paf.level   = af->level;
            paf.duration    = paf.level/10;
            paf.location    = APPLY_NONE;
            paf.modifier    = 0;
            paf.bitvector   = 0;

            for (vch = room->people; vch != NULL; vch = vch->next_in_room)
            {
                if (!saves_spell(paf.level + 10,vch, DAM_NEGATIVE)
                 && !is_safe_rspell(af->level,vch)
                 && !is_affected(vch,gsn_evil_spirit))
                {
                    act("You feel worse than ever.", vch, NULL, NULL, TO_CHAR);
                    act("$n looks more evil.",vch,NULL,NULL,TO_ROOM);
                    affect_join(vch,&paf);
                }
            }
            break;
        }


        while (IS_ROOM_AFFECTED(room, RAFF_RADIATION) && room->people != NULL)
        {
            AFFECT_DATA *af;
            CHAR_DATA *vch;
            int level;

            for (af = room->affected; af != NULL; af = af->next)
            {
                if (af->type == gsn_radiation)
                    break;
            }

            if (af == NULL)
            {
                REMOVE_BIT(room->affected_by,RAFF_RADIATION);
                break;
            }

            level = number_range(af->level/2, af->level);

            for (vch = room->people; vch != NULL; vch = vch->next_in_room)
            {
                if (!saves_spell(level,vch,DAM_RADIATION)
                    &&  !IS_IMMORTAL(vch)
                    &&  !is_safe_rspell_nom(af->level,vch)
                    &&  number_bits(3) == 0)
                    radiation_effect(vch, level, TARGET_CHAR);
            }

            break;
        }

/* new ones here
        while (IS_ROOM_AFFECTED(room, RAFF_) && room->people != NULL)
        {
            AFFECT_DATA *af, paf;
            CHAR_DATA *vch;

            for (af = room->affected; af != NULL; af = af->next)
            {
                if (af->type == gsn_)
                    break;
            }

            if (af == NULL)
            {
                REMOVE_BIT(room->affected_by,RAFF_);
                break;
            }

            if (af->level == 1)
                af->level = 2;

        paf.where       = TO_AFFECTS;
            paf.type        = gsn_;
            paf.level       = af->level - 1;
            paf.duration    = number_range(1,((paf.level/5)+1));
            paf.location    = APPLY_NONE;
            paf.modifier    = -5;
            paf.bitvector   = AFF_;

            for (vch = room->people; vch != NULL; vch = vch->next_in_room)
            {
                if (!saves_spell(paf.level + 2,vch,DAM_)
        &&  !IS_IMMORTAL(vch)
        &&  !is_safe_rspell(af->level,vch)
                &&  !IS_AFFECTED(vch,AFF_) && number_bits(3) == 0)
                {
                    act(" .", vch, NULL, NULL, TO_CHAR);
                    act("$n     .",vch,NULL,NULL,TO_ROOM);
                    affect_join(vch,&paf);
                }
            }
     break;
        }
*/
    }
    return;
}


void check_reboot(void)
{
    DESCRIPTOR_DATA *d;

    switch (reboot_counter)
    {
        case -1:
            break;
        case 0:
            reboot_muddy();
            return;
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 10:
        case 15:
            for (d = descriptor_list; d != NULL; d = d->next)
                if (d->character != NULL)
                {
                    if (rebooter || !IS_IMMORTAL(d->character))
                        act_puts("{*{W*****{R     {W$j{R $qj{} {W*****{x", d->character, (const void *) reboot_counter, NULL, TO_CHAR, POS_DEAD);
                    else
                        act_puts("{*{W*****{R      {W$j{R $qj{} {W*****{x", d->character, (const void *) reboot_counter, NULL, TO_CHAR, POS_DEAD);
                }

                /* FALLTHRU */
        default:
            reboot_counter--;
            break;
    }
}

void track_update(void)
{
    CHAR_DATA *ch, *ch_next;

    for (ch = char_list; ch != NULL; ch = ch_next)
    {
        CHAR_DATA *vch, *vch_next;

        ch_next = ch->next;
        if (!IS_NPC(ch)
            ||  IS_AFFECTED(ch, AFF_CALM | AFF_CHARM)
            ||  ch->fighting
            ||  !ch->in_room
            ||  !IS_AWAKE(ch)
            ||  IS_SET(ch->pIndexData->act, ACT_NOTRACK)
            ||  RIDDEN(ch))
            continue;

        if (ch->last_fought != NULL
            &&  ch->in_room != ch->last_fought->in_room)
        {
            do_track(ch, ch->last_fought->name);
            continue;
        }

        if (ch->in_mind == NULL)
            continue;

        for (vch = ch->in_room->people; vch; vch = vch_next)
        {
            vch_next = vch->next_in_room;

            if (IS_IMMORTAL(vch)
                ||  !can_see(ch,vch)
                ||  is_safe_nomessage(ch,vch)
                ||  !is_name(vch->name,ch->in_mind))
                continue;
            act_yell(ch, "So we meet again, $i!", vch, NULL);
            do_murder(ch, vch->name);
        }
    }
}

void atrim_ch(CHAR_DATA *ch)
{
    DESCRIPTOR_DATA *d;
    for (d = descriptor_list; d != NULL; d = d->next)
        if (d == ch->desc)
        {
            ch->level = 91;
            ch->incog_level = 91;
            ch->invis_level = 91;
            close_descriptor(d);
            log_printf("Log: %s tries to use imm command being level above 100 - REJECTED.", ch->name);
            return;
        }
}

void check_fishing()
{
    struct descriptor_data *d;
    int bite;
    CHAR_DATA *ch;

    for (d = descriptor_list; d; d = d->next)
    {
        if (d->connected) continue;
        ch = d->character;
        if ((!IS_SET(ch->in_room->room_flags, ROOM_SALTWATER_FISH) &&
             !IS_SET(ch->in_room->room_flags, ROOM_FRESHWATER_FISH)))
        {
            REMOVE_BIT(ch->comm, COMM_FISHING);
            REMOVE_BIT(ch->comm, COMM_FISH_ON);
        }

        //if (number_percent() > 30)
        if(number_percent() > (35 +
                               get_skill(ch, gsn_expert_fishing)/5 +
                               get_skill(ch, gsn_improved_fishing)/10 +
                               get_skill(ch, gsn_mastering_fishing)/10 +
                               get_skill(ch, gsn_craft_fishing)/3) )
            continue;

        if (IS_SET(ch->comm, COMM_FISHING) && !IS_SET(ch->comm, COMM_FISH_ON))
        {
            bite = number_range(1, 10);
            if (bite >= 7 && bite <= 8)
            {
                act("Time goes by... not even a nibble.", ch, 0, 0, TO_CHAR);
            }
            else if (bite >= 6)
            {
                act("You feel a slight jiggle on your line.", ch, 0, 0, TO_CHAR);
                SET_FIGHT_TIME(ch);
            }
            else if (bite >= 4)
            {
                act("You feel a very solid pull on your line!", ch, 0, 0, TO_CHAR);
                SET_BIT(ch->comm, COMM_FISH_ON);
                SET_FIGHT_TIME(ch);
            }
            else if (bite >= 2)
            {
                act("Your line suddenly jumps to life, FISH ON!!!", ch, 0, 0, TO_CHAR);
                SET_BIT(ch->comm, COMM_FISH_ON);
                SET_FIGHT_TIME(ch);
            }
        }
    }
}

void update_falling_obj(OBJ_DATA *obj)
{
        CHAR_DATA       *rch;
        ROOM_INDEX_DATA *new_room;

    if (obj->in_room
        && obj->in_room->sector_type == SECT_AIR
        && (obj->wear_flags & ITEM_TAKE))
        /* && obj->in_room->exit[5]
        && obj->in_room->exit[5]->to_room) */
    {
        new_room = obj->in_room->exit[5]->to_room.r;

        if (( rch = obj->in_room->people ) != NULL)
        {
            act( "$p falls away.", rch, obj, NULL, TO_ROOM );
            act( "$p falls away.", rch, obj, NULL, TO_CHAR );
        }

        obj_from_room(obj);
        obj_to_room(obj, new_room);

        if (( rch = obj->in_room->people ) != NULL)
        {
            act( "$p floats by.", rch, obj, NULL, TO_ROOM );
            act( "$p floats by.", rch, obj, NULL, TO_CHAR );
        }
    }
}

void gc_char_update(void)
{
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    CHAR_DATA* ch_prev;

//    bool corrupted;
    char buf[MAX_STRING_LENGTH];

    ch_prev = NULL;
    for (ch = char_list; ch != NULL; ch = ch_next)
    {
        ch_next = ch->next;
        // do some analyzing here
        if (ch->name == NULL && ch->in_room != NULL)
        {
            snprintf(buf, sizeof(buf), "GC: Char with null name in room %d. \n", ch->in_room->vnum);
            wiznet_printf(ch, NULL, WIZ_BUGS, 0, 96, "BUG: [%s] $N: %s\n", buf);
            log_printf(buf);

        }

        if (ch->extracted)
        {
            snprintf(buf, sizeof(buf), "GC: Extracted char in char_list!. \n");
            wiznet_printf(ch, NULL, WIZ_BUGS, 0, 96, "BUG: [%s] $N: %s\n", buf);
            log_printf(buf);

            //        
            if (ch == char_list)
                char_list = ch->next;
            else
            {
                if (ch_prev->next == ch)
                {
                    ch_prev->next = ch->next;
                }
            }

            if (ch->desc != NULL)
                ch->desc->character = NULL;
            close_descriptor(ch->desc);
            free_char(ch);

            continue;           // keep ch_prev at real previous char
        }
        ch_prev = ch;
    }

    return;
}

void gc_room_update(void)
{
    return;     // this is da stub
}
