/* $Id: wanderers.h,v 1.666 2004/09/20 10:49:54 shrike Exp $                         */
 
/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#ifndef _WANDERERS_H_
#define _WANDERERS_H_

DECLARE_SPEC_FUN (spec_wandering_necr); 
DECLARE_SPEC_FUN (spec_created_golem);  

// extra flags for mob_spell structure
// todo : need flag SAME_ALIGN for inner fire and frenzy spells
#define MS_GOOD_ONLY            (A)
#define MS_EVIL_ONLY            (B)
#define MS_GOOD_NEUTRAL         (C)
#define MS_EVIL_NEUTRAL         (D)
#define MS_IF_NOT_AFFECTED      (E)
#define MS_TAR_SELF             (F)
#define MS_TAR_ROOM             (G)
#define MS_IF_AFFECTED          (H)

// options for function wanderer_spec_cast
#define SO_SUITABLE             (A) // first spell for which mob has enough mana
#define SO_FIRST                (B) // first spell suitable by level/align
#define SO_RANDOM               (C) // random spell suitable by level/align
#define SO_NO_MANA              (D) // mob will not spend mana for the spell

typedef struct mob_spell MOB_SPELL;
struct mob_spell
{
    char *      name;
    SPELL_FUN * spell_fn;
    int         min_level;
    int         sn;
    flag64_t    extra;
    flag64_t    aff;
};

typedef struct mob_extra MOB_EXTRA;
struct mob_extra
{
    char *      name;           // string to show
    flag64_t    flag;           // extra ability flag
    int         min_rank;       // min mob_level required
    int         percent;        // probability to gain
};

// definitions for where
#define IN_ABILITIES        0
#define IN_OFF              1
#define IN_ACT              2

typedef struct mob_extra_tnl MOB_EXTRA_TNL;
struct mob_extra_tnl
{
    char *      name;           // string to show
    flag64_t    flag;           // extra ability/act/off flag
    int         where;          // where we should find flag
    int         extra_tnl;      // probability to gain
};

// exported functions
bool wanderer_spec_cast (CHAR_DATA *ch, CHAR_DATA * victim, MOB_SPELL spell_table[], 
                         int option, int level, int target);

int levelup_pet_count (CHAR_DATA * ch);

//-------------------------------------------------------------------------------
// extra_abilities; see merc.h (char_data->abilities)
//-------------------------------------------------------------------------------

// poor choice depends on mobile skill model based on OFF_FLAGS and ACT_WARRIOR/THIEF/etc
// 1) extra_attacks (see merc.h char_data->extra_attacks)
// for each one "one_hit" function
// will be called from spec_function (otherwise we should
// rewrite too big piece of code)
// NB! each extra_attack MUST set WAIT_STATE, because
// spec_function for such mobiles is called EASH PULSE

// 2) other extra abilities
#define EA_FAST_REGEN            (A) // heal rate * 5
#define EA_FLASH_REGEN           (B) // 10% chance to restore all hp/mana when sleeping
#define EA_MANA_LINK             (C) // can transfer mana to master
#define EA_IMMUN_VORPAL          (D) // immunity to vorpal
#define EA_GATE_WITH             (E) // goes with master (gate. teleport etc)
#define EA_AUTO_RESC             (F) // mobile will autorescue master
#define EA_AUTO_FIND             (G) // mobile will autofind master (gtell find me) 
                                    // - enemy can follow it... 
// spellcasting extra abilities
#define EA_CURE_SELF             (H) 
#define EA_CURE_MASTER           (I) 
#define EA_HEAL_SELF             (J) 
#define EA_HEAL_MASTER           (K) 
#define EA_PROTECT_SELF          (L) 
#define EA_PROTECT_MASTER        (M) 

#define EA_NO_EXP_CONSUME        (N) 
#define EA_NO_SLEVEL_CONSUME     (O) 
#define EA_BODYGUARD             (P) 
#define EA_SNEAK                 (Q)
#define EA_BLINK                 (R)
#define EA_IMMUN_INSTANT         (S)

#define EA_SAVE                  (T) // used in 'animate dead' function to force saving of improved undeads

// action flags
#define CA_AUTO_FIND             (A) 
#define CA_HEAL_SELF             (B) 
#define CA_CAN_HEAL              (C)  // by master's order
#define CA_CAN_RESCUE            (D)  // by master's order

// record for all mob descriptions (depends on VNUM): extra tnl, upgr. vnums, extra_ability
// tables (todo)
typedef struct mob_desc MOB_DESC;
struct mob_desc
{
    int         vnum;
    int         vnum_10;       // vnum_xx - we will "redraw" mobile when 
    int         vnum_20;       // it reaches "xx" rank with this vnum
    int         vnum_35;
    int         vnum_50;
    int         extra_tnl;     // try to balance this stuff
};

#endif
