/*  $Id: weather.c,v 1.666 2004/09/20 10:49:54 shrike Exp $                          */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *		    	  .88b  d88. db    db d8888b.   .d888b. db   dD             *
 *	    		  88'YbdP`88 88    88 88  `8D   VP  `8D 88 , 8P'            *
 *			  88  88  88 88    88 88   88      odD' 88, 8P              *
 *			  88  88  88 88    88 88   88    .88'   88`8b               *
 *			  88  88  88 88b  d88 88  .8D   j88.    88 `88.             *
 *			  YP  YP  YP ~Y8888P' Y8888D'   888888D YP   YD             *
 *	This material is copyrighted (c) 1999 - 2000 by Thomas J Whiting            *
 *	(twhiting@hawmps.2y.net). Usage of this material  means that you have read  *
 *	and agree to all of the licenses in the ../licenses directory. None of these*
 *	licenses may ever be removed.                                               *
 *	--------------------------------------------------------------------------- *
 *	A LOT of time has gone into this code by a LOT of people. Not just on       *
 *	this individual code, but on all of the codebases this even takes a piece   *
 *	of. I hope that you find this code in some way useful and you decide to     *
 *	contribute a small bit to it. There's still a lot of work yet to do.        *
 ************************************************************************************/


#include <sys/types.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "merc.h"
#include "tables.h"
#include "lookup.h"
#include "db/dofun.h"
#include "db/db.h"
#include "fight.h"

void    lightning        args((void));
void    ice              args((void));
void    hail             args((void));
void    blizzard         args((void));
void    fog              args((void));
void    weather_update   args((void));
extern char *target_name;
#define LI1             MAX_LEVEL/6
#define LI2             MAX_LEVEL/3
#define LI3             MAX_LEVEL

#define HOUR_ON_DAY   24
#define DAY_ON_MONTH  28
#define MONTH_ON_YEAR 12


/*
 * Return number hours from reboot moment
 */  
long get_hours (void) 
{
    return time_info.year  * MONTH_ON_YEAR * DAY_ON_MONTH * HOUR_ON_DAY +
           time_info.month * DAY_ON_MONTH  * HOUR_ON_DAY                +
	   time_info.day   * HOUR_ON_DAY + time_info.hour ;
}

/*
 * Update the weather.
 */ 
void weather_update(void)
{
	const char *buf  = str_empty ;
	const char *buf2 = str_empty ;
	const double period_of_moon = 24 + 5. / 6 ; // around Earth in hours.
	double moon_time ; //The time of rotate moon around Earth. max = 24, min = 0
	int moon_phase ;
	
	DESCRIPTOR_DATA *d;

	time_info.hour = time_info.hour + 1;
	
	moon_time  = fmod (get_hours (), period_of_moon) /period_of_moon * 24;
	moon_phase = time_info.hour - (int)moon_time;
	if (moon_phase < 0)   moon_phase += 24 ;
	if (moon_phase == 24) moon_phase  =  0 ;

	if (time_info.hour == SUN_RISE_TIME + 1)
	{
		weather_info.sunlight = SUN_LIGHT;
		buf = str_dup("The {yday{x has begun.");
	}

	if (time_info.hour == SUN_RISE_TIME)
	{
		weather_info.sunlight = SUN_RISE;
		buf = str_dup("The {Ysun{x rises on the horizont.");
	}

	if (time_info.hour == SUN_SET_TIME)
	{
		weather_info.sunlight = SUN_SET;
		buf = str_dup("The {Ysun{x slowly disappears in the west.");
	}

	if (time_info.hour == SUN_SET_TIME + 1)
	{
		weather_info.sunlight = SUN_DARK;
		buf = str_dup("The {Dnight{x has begun.");
	}

        //Moon motion
	if ((int)moon_time == SUN_RISE_TIME) 
	{
	    if (moon_phase == 0 || moon_phase == 1 || moon_phase == 23)
	    {
		buf2 = str_empty ;
            }	
	    if (moon_phase == 2 || moon_phase == 3)
	    {
	        buf2 = str_dup("The {Cincrescent moon{x rises on the horizont.") ;
    	    }	
	    if (moon_phase >= 4 && moon_phase <= 9) 
	    {
		buf2 = str_dup("The young half {Wmoon{x rises on the horizont.") ;
	    }
	    if (moon_phase >= 10 && moon_phase <= 14)
	    {
		buf2 = str_dup("The full {Wmoon{x rises on the horizont.") ;
	    }
	    if (moon_phase >= 15 && moon_phase <= 20)
	    {
		buf2 = str_dup("The old half {Wmoon{x rises on the horizont.") ;
    	    }
	    if (moon_phase == 21 || moon_phase == 22)
	    {
		buf2 = str_dup("The {Cdecrescent moon{x rises on the horizont.") ;
	    }

	}
	
	if ((int)moon_time == SUN_SET_TIME) 
	{
	    if (moon_phase == 0 || moon_phase == 1 || moon_phase == 23)
	    {
		buf2 = str_empty ;
    	    }	
	    if (moon_phase == 2 || moon_phase == 3)
	    {
		buf2 = str_dup("The {Cincrescent moon{x slowly disappears in the west.") ;
    	    }	
	    if (moon_phase >= 4 && moon_phase <= 9) 
	    {
		buf2 = str_dup("The young half {Wmoon{x slowly disappears in the west.") ;
	    }
	    if (moon_phase >= 10 && moon_phase <= 14)
	    {
		buf2 = str_dup("The full {Wmoon{x slowly disappears in the west.") ;
	    }
	    if (moon_phase >= 15 && moon_phase <= 20)
	    {
		buf2 = str_dup("The old half {Wmoon{x slowly disappears in the west.") ;
    	    }
	    if (moon_phase == 21 || moon_phase == 22)
	    {
		buf2 = str_dup("The {Cdecrescent moon{x slowly disappears in the west.") ;
	    }
	}
        
	if (time_info.hour == HOUR_ON_DAY)
	{
		time_info.hour = 0;
		time_info.day++;
	}

/*
	switch (++time_info.hour)
	{
		case  5:
			weather_info.sunlight = SUN_LIGHT;
			buf = str_dup("The {yday{x has begun.");
			break;

		case  6:
			weather_info.sunlight = SUN_RISE;
			buf = str_dup("The {Ysun{x rises on horizon.");
			break;

		case 19:
			weather_info.sunlight = SUN_SET;
			buf = str_dup("The {Ysun{x slowly disappears in the west.");
			break;

		case 20:
			weather_info.sunlight = SUN_DARK;
			buf = str_dup("The {Dnight{x has begun.");
			break;

		case 24:
			time_info.hour = 0;
			time_info.day++;
			break;

	}
*/

	if (time_info.day   >= DAY_ON_MONTH)
	{
		time_info.day = 1;
		time_info.month++;
	}

	if (time_info.month >= MONTH_ON_YEAR)
	{
		time_info.month = 1;
		time_info.year++;
	}

	/*
	 * Weather change.
	 */
	switch (weather_info.sky)
	{
		default:
			weather_info.sky = SKY_CLOUDLESS;
			break;

		case SKY_CLOUDLESS:
			if ((number_chance(10))&&  (time_info.hour <= 6))
			{
				weather_info.sky = SKY_FOGGY;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_CLOUDY;
			}
			else if (number_chance(30))
			{
				weather_info.sky = SKY_RAINING;
			}
			else
				if (number_chance(45))
			{
				weather_info.sky = SKY_CLOUDLESS;
			}


			break;

		case SKY_CLOUDY:
			if (number_chance(15))
			{
				weather_info.sky = SKY_SNOWING;
			}
			else
				if (number_chance(15))
			{
				weather_info.sky = SKY_HAILSTORM;
			}
			else
				if (number_chance(15))
			{
				weather_info.sky = SKY_THUNDERSTORM;
			}
			else
				if (number_chance(15))
			{
				weather_info.sky = SKY_ICESTORM;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_CLOUDLESS;
			}
			else if (number_chance(25))
			{
				weather_info.sky = SKY_CLOUDY;
			}
		case SKY_RAINING:
			if (number_chance(15))
			{
				weather_info.sky = SKY_LIGHTNING;
				lightning       ();
			}
			else
				if (number_chance(10))
			{
				weather_info.sky = SKY_HAILSTORM;
				hail();
			}
			else
				if (number_chance(10))
			{
				weather_info.sky = SKY_THUNDERSTORM;
			}
			else
				if (number_chance(10))
			{
				weather_info.sky = SKY_CLOUDY;
			}
			else if (number_chance(55))
			{
				weather_info.sky = SKY_RAINING;
			}
			break;

		case SKY_SNOWING:
			if (number_chance(15))
			{
				weather_info.sky = SKY_BLIZZARD;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_CLOUDY;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_RAINING;
			}
			else
				if (number_chance(55))
			{
				weather_info.sky = SKY_SNOWING;
			}

			break;
		case SKY_LIGHTNING:
			if (number_chance(15))
			{
				weather_info.sky = SKY_THUNDERSTORM;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_RAINING;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_CLOUDY;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_HAILSTORM;
			}
			else if (number_chance(40))
			{
				weather_info.sky = SKY_LIGHTNING;
			}
			break;
		case SKY_FOGGY:
			if (number_chance(45))
			{
				weather_info.sky = SKY_CLOUDY;
			}
			else if (number_chance(55))
			{
				fog();
				weather_info.sky = SKY_FOGGY;
				break;
			}

		case SKY_THUNDERSTORM:
			if (number_chance(15))
			{
				weather_info.sky = SKY_RAINING;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_CLOUDY;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_LIGHTNING;
			}
			else if (number_chance(15))
			{
				weather_info.sky = SKY_HAILSTORM;
				hail ();
			}
			else if (number_chance(40))
			{
				weather_info.sky = SKY_THUNDERSTORM;
			}
			break;

		case SKY_HAILSTORM:
			if (number_chance(15))
			{
				weather_info.sky = SKY_CLOUDY;
			}
			else
				if (number_chance(30))
			{
				weather_info.sky = SKY_RAINING;
			}
			else
				if (number_chance(55))
			{
				weather_info.sky = SKY_HAILSTORM;
				hail();
			}
			break;

		case SKY_ICESTORM:
			if (number_chance(15))
			{
				weather_info.sky = SKY_CLOUDY;
			}
			else
				if (number_chance(15))
			{
				weather_info.sky = SKY_BLIZZARD;
			}
			else
				if (number_chance(15))
			{
				weather_info.sky = SKY_SNOWING;
			}
			else
				if (number_chance(55))
			{
				ice();
				weather_info.sky = SKY_ICESTORM;
			}
			break;


		case SKY_BLIZZARD:
			if (number_chance(15))
			{
				weather_info.sky = SKY_SNOWING;
			}
			else if (number_chance(15))
			{
				blizzard();
				weather_info.sky = SKY_ICESTORM;
				ice();
			}
			else if (number_chance(15))
			{
				blizzard();
				weather_info.sky = SKY_CLOUDY;
			}
			else
				if (number_chance(55))
			{
				blizzard();
				weather_info.sky = SKY_BLIZZARD;
			}
			break;

	}

        
	if (buf != str_empty)
	{
		for (d = descriptor_list; d != NULL; d = d->next)
		{
			if (d->connected == CON_PLAYING
				&& IS_OUTDOORS(d->character))
				act("$t", d->character, buf, NULL, TO_CHAR | ACT_TRANS);
		}
	}
	
	if (buf2 != str_empty)
	{
		for (d = descriptor_list; d != NULL; d = d->next)
		{
			if (d->connected == CON_PLAYING
				&& IS_OUTDOORS(d->character))
				act("$t", d->character, buf2, NULL, TO_CHAR | ACT_TRANS);
		}
	}

	return;
}


/*
New weather command. Reads the new weather stats as well as  tells you
what time of day it is (morning, noon, night)
Added so that players don't HAVE to have autoweather enabled*/
void do_weather(CHAR_DATA *ch, const char *argument)
{
	char *suf;
	int day;

	day     = time_info.day + 1;

	if (day > 4 && day <  20) suf = "th";
	else if (day % 10 ==  1) suf = "st";
	else if (day % 10 ==  2) suf = "nd";
	else if (day % 10 ==  3) suf = "rd";
	else							 suf = "th";


	if (!IS_OUTSIDE(ch))
	{
		act("You can't see the weather indoors.\n", ch, NULL, NULL, TO_CHAR);
		return;
	}

	if (weather_info.sky == SKY_RAINING)
	{
		if (number_range(0, 100) <= 15)
		{
			act("{g[{YWeather{g] {CThere is a cold rain trickling down.{x", ch, NULL, NULL, TO_CHAR);
		}
		else
			if (number_range(0, 100) <= 30)
		{
			act("{g[{YWeather{g] {CThere is a warm rain trickling down.{x", ch, NULL, NULL, TO_CHAR);
		}
		else if (number_range(0, 100) <= 45)
		{
			act("{g[{YWeather{g] {CBig Huge {GFrogs{C are dropping from the sky like raindrops.", ch, NULL, NULL, TO_CHAR);
		}

		else
			if (number_range(0, 100) <= 60)
		{
			act("{g[{YWeather{g] {CBig Huge {YDragons{C are falling from the sky.", ch, NULL, NULL, TO_CHAR);
		}
		else
			if (number_range(0, 100) <= 75)
		{
			act("{g[{YWeather{g] {CBig Huge {BPuppies{C are falling out of the sky like raindrops.", ch, NULL, NULL, TO_CHAR);
		}
		else if (number_range(0, 100) <= 85)
		{
			act("{g[{YWeather{g] {YKitten{C Sized animals appear to be falling left and right. Bonzai!!!!!.", ch, NULL, NULL, TO_CHAR);
		}
		else
			if (number_range(0, 100) <= 100)
		{
			act("{g[{YWeather{g] {CBig Huge {RRats{C are falling out of the sky like raindrops.", ch, NULL, NULL, TO_CHAR);
		}
	}

	else if (weather_info.sky == SKY_CLOUDY)
	{
		act("{g[{YWeather{g] {CA $t breeze can be felt about{x.",
			ch, weather_info.change >= 0 ? GETMSG ("warm", ch->lang) : GETMSG ("cold", ch->lang), NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_CLOUDLESS)
	{
		act("{g[{YWeather{g] {CThe sky is beautiful, not a cloud around.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_THUNDERSTORM)
	{
		act("{g[{YWeather{g] {CThe skies thunder as a storm approaches.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_ICESTORM)
	{
		act("{g[{YWeather{g] {CSheets of ice appear to be falling from the sky.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_HAILSTORM)
	{
		act("{g[{YWeather{g] {CGolfball like substances are falling from the sky.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_SNOWING)
	{
		act("{g[{YWeather{g] {CA light snow is falling.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_BLIZZARD)
	{
		act("{g[{YWeather{g] {CThere is a blizzard about.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_FOGGY)
	{
		act("{g[{YWeather{g] {CA misty haze covers the horizon.{x\n", ch, NULL, NULL, TO_CHAR);
	}

	else if (weather_info.sky == SKY_LIGHTNING)
	{
		act("{g[{YWeather{g] {CA {y Lightning{w storm is approaching {x\n", ch, NULL, NULL, TO_CHAR);
	}
	act("{B[{W Time  {B] {RIt is {M$j{R o'clock {Y$T{x\n",
		ch, (const void *) ((time_info.hour%12 == 0) ? 12 : time_info.hour%12),
		time_info.hour >= 12 ? "pm" : "am", TO_CHAR);
	return;

}
/*  Xantha  10/00 */



bool IS_OUTDOORS(CHAR_DATA *ch)
{
	if (!IS_SET(ch->in_room->room_flags, ROOM_INDOORS) &&
		ch->in_room->sector_type != SECT_INSIDE)
		return TRUE;
	else
		return FALSE;
}

void show_weather(CHAR_DATA *ch)
{

/*for weather stuff -- tjw*/
	if (weather_info.sky == SKY_RAINING)
	{
		if (number_range(0, 100) <= 15)
		{
			act("{g[{YWeather{g] {CThere is a cold rain trickling down.{x\n", ch, NULL, NULL, TO_CHAR);
		}
		else
			if (number_range(0, 100) <= 30)
		{
			act("{g[{YWeather{g] {CThere is a warm rain trickling down.{x\n", ch, NULL, NULL, TO_CHAR);
		}
		else if (number_range(0, 100) <= 45)
		{
			act("{g[{YWeather{g] {CBig Huge {GFrogs{C are dropping from the sky like raindrops.{x\n", ch, NULL, NULL, TO_CHAR);
		}
		else
			if (number_range(0, 100) <= 60)
		{
			act("{g[{YWeather{g] {CBig Huge {YPanthers{C are falling out of the sky like raindrops.{x\n", ch, NULL, NULL, TO_CHAR);
		}
		else
			if (number_range(0, 100) <= 75)
		{
			act("{g[{YWeather{g] {CBig Huge {BPuppies{C are falling out of the sky like raindrops.{x\n", ch, NULL, NULL, TO_CHAR);
		}
		else if (number_range(0, 100) <= 85)
		{
			act("{g[{YWeather{g] {YCanth{C Sized animals appear to be falling left and right. Bonzai!!!!!.{x\n", ch, NULL, NULL, TO_CHAR);
		}
		else
			if (number_range(0, 100) <= 100)
		{
			act("{g[{YWeather{g] {CBig Huge {RDRAGONS{C are falling out of the sky like raindrops.{x\n", ch, NULL, NULL, TO_CHAR);
		}
	}

	else if (weather_info.sky == SKY_CLOUDY)
	{
		act("{g[{YWeather{g] {CA $t breeze can be felt about{x.",
			ch, weather_info.change >= 0 ? GETMSG ("warm", ch->lang) : GETMSG ("cold", ch->lang), NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_CLOUDLESS)
	{
		act("{g[{YWeather{g] {CThe sky is beautiful, not a cloud around.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_THUNDERSTORM)
	{
		act("{g[{YWeather{g] {CThe skies thunder as a storm approaches.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_ICESTORM)
	{
		act("{g[{YWeather{g] {CSheets of ice appear to be falling from the sky.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_HAILSTORM)
	{
		act("{g[{YWeather{g] {CGolfball like substances are falling from the sky.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_SNOWING)
	{
		act("{g[{YWeather{g] {CA light snow is falling.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_BLIZZARD)
	{
		act("{g[{YWeather{g] {CThere is a blizzard about.{x\n", ch, NULL, NULL, TO_CHAR);
	}
	else if (weather_info.sky == SKY_FOGGY)
	{
		act("{g[{YWeather{g] {CA misty haze covers the horizon.{x\n", ch, NULL, NULL, TO_CHAR);
	}

	else if (weather_info.sky == SKY_LIGHTNING)
	{
		act("{g[{YWeather{g] {CA {y Lightning{w storm is approaching {x\n", ch, NULL, NULL, TO_CHAR);
	}
	else
	{
		act("{g[{YWeather{g] {CBUG!!!!!!!!!!!!!!! A descriptor does not exist for this condition  {x\n", ch, NULL, NULL, TO_CHAR);
	}
}

void lightning(void)
{
	DESCRIPTOR_DATA *d;
	int dam;

	for (d = descriptor_list; d != NULL; d = d->next)
	{
		if (d->connected == CON_PLAYING
			&& IS_OUTDOORS(d->character)
			&& IS_AWAKE(d->character)
			&& number_chance(10)
			&& !IS_IMMORTAL(d->character)
			&& !IS_SET(d->character->comm, PLR_PEACE)
			&& d->character->level > 17
			&& !IS_SET(d->character->in_room->area->flags, AREA_NOWEATHER)
			&& weather_info.sky == SKY_LIGHTNING)
		{

			act("{x{RYou see a brilliant flash come down from the sky and then black out!{x\n", d->character, NULL, NULL, TO_CHAR);
			act("$n has been struck by lightning!", d->character, NULL, NULL, TO_ROOM);

			if (d->character->level < LI1)
				dam = d->character->max_hit / 25;
			else if (d->character->level < LI2)
				dam = d->character->max_hit / 20;
			else
				dam	= d->character->max_hit / 15;

			damage(d->character, d->character, dam, TYPE_UNDEFINED, DAM_LIGHTNING, DAMF_NONE);
		}
	}
}

void blizzard(void)
{
	DESCRIPTOR_DATA *d;
	for (d = descriptor_list; d != NULL; d = d->next)
	{
		if (d->connected == CON_PLAYING
			&& IS_OUTDOORS(d->character)
			&& !IS_IMMORTAL(d->character)
			&& !IS_SET(d->character->comm, PLR_PEACE)
			&& d->character->level > 10
			&& !IS_SET(d->character->in_room->area->flags, AREA_NOWEATHER)
			&& weather_info.sky == SKY_BLIZZARD)
		{
			if (number_range(0, 2000) <= 1000)
			{
				act("{RThe sky before you is a mist of white blur. Perhaps you should find a safe place indoors.{x \n", d->character, NULL, NULL, TO_CHAR);
			}
			else
				if (number_range(0, 2000) <= 1250)
			{
				act("{RNot being able to see where you are going, you slip and fall into a hole.{x \n", d->character, NULL, NULL, TO_CHAR);
				act("$n falls face first into the oncoming drifts!", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 5;
			}
			else
				if (number_range(0, 2000) <= 1500)
			{
				act("{RYou've managed to slide yourself right into a tree. Good Job. Better hope you didn't break anything!{x \n", d->character, NULL,
					NULL, TO_CHAR);
				act("$n has planted themselves headfirst into a tree. Encore!", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 15;
			}
			else
				if (number_range(0, 2000) <= 1950)
			{
				act("{RThe sky before you is a mist of white blur. Perhaps you should find a safe place indoors.{x \n", d->character, NULL, NULL, TO_CHAR);
			}
			else
				if (number_range(0, 2000) <= 2000)
			{
				act("{RYour body twitches and your limbs start to freeze one by one.{x \n", d->character, NULL, NULL, TO_CHAR);
				act("You watch as $n's limbs start to freeze !", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 30;
			}
		}
	}
}
void ice(void)
{
	DESCRIPTOR_DATA *d;
	for (d = descriptor_list; d != NULL; d = d->next)
	{
		if (d->connected == CON_PLAYING
			&& IS_OUTDOORS(d->character)
			&& !IS_IMMORTAL(d->character)
			&& !IS_SET(d->character->comm, PLR_PEACE)
			&& d->character->level > 10
			&& !IS_SET(d->character->in_room->area->flags, AREA_NOWEATHER)
			&& weather_info.sky == SKY_ICESTORM)
		{
			if (number_range(0, 2000) <= 1000)
			{
				act("{RIt's starting to rain sheets of ice. Perhaps you should find a way inside{x \n", d->character, NULL, NULL, TO_CHAR);
			}
			else
				if (number_range(0, 2000) <= 1250)
			{
				act("{RThe ice around your feet firms up and causes you to fall flat on your face{x \n", d->character, NULL, NULL, TO_CHAR);
				act("$n falls face first into the ground!", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 5;
			}
			else
				if (number_range(0, 2000) <= 1500)
			{
				act("{RYou've managed to slide yourself right into a tree. Good Job. Better hope you didn't break anything!{x \n", d->character, NULL,
					NULL, TO_CHAR);
				act("$n has planted themselves headfirst into a tree. Encore!", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 15;
			}
			else
				if (number_range(0, 2000) <= 1950)
			{
				act("{RThe sky before you is a mist of white blur. Perhaps you should find a safe place indoors.{x \n", d->character, NULL, NULL, TO_CHAR);
			}
			else
				if (number_range(0, 2000) <= 2000)
			{
				act("{RYour body twitches and your limbs start to freeze one by one.{x \n", d->character, NULL, NULL, TO_CHAR);
				act("You watch as $n's limbs start to freeze !", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 30;
			}
		}
	}
}
void hail(void)
{
	DESCRIPTOR_DATA *d;
	for (d = descriptor_list; d != NULL; d = d->next)
	{
		if (d->connected == CON_PLAYING
			&& IS_OUTDOORS(d->character)
			&& !IS_IMMORTAL(d->character)
			&& !IS_SET(d->character->comm, PLR_PEACE)
			&& d->character->level > 10
			&& !IS_SET(d->character->in_room->area->flags, AREA_NOWEATHER)
			&& weather_info.sky == SKY_HAILSTORM)
		{
			if (number_range(0, 2000) <= 1000)
			{
				act("{RWas that a golfball or hail? It might be a good idea to find yourself a way indoors quickly.{x \n", d->character, NULL, NULL,
					TO_CHAR);
			}
			else
				if (number_range(0, 2000) <= 1250)
			{
				act("{ROh MAN! You were just hit in the face by hail!{x\n", d->character, NULL, NULL, TO_CHAR);
				act("You watch in ammusement as $n is hit in the face by a baby iceball...", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 5;
			}
			else
				if (number_range(0, 2000) <= 1950)
			{
				act("{RThe sky before you is a mist of white blur. Perhaps you should find a safe place indoors.{x \n", d->character, NULL, NULL, TO_CHAR);
			}
			else
				if (number_range(0, 2000) <= 2000)
			{
				act("{RYour body twitches and your limbs start to freeze one by one.{x \n", d->character, NULL, NULL, TO_CHAR);
				act("You watch as $n's limbs start to freeze !", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 30;
			}
		}
	}
}

void fog(void)
{
	DESCRIPTOR_DATA *d;
	for (d = descriptor_list; d != NULL; d = d->next)
	{
		if (d->connected == CON_PLAYING
			&& IS_OUTDOORS(d->character)
			&& !IS_IMMORTAL(d->character)
			&& !IS_SET(d->character->comm, PLR_PEACE)
			&& d->character->level > 10
			&& !IS_SET(d->character->in_room->area->flags, AREA_NOWEATHER)
			&& weather_info.sky == SKY_FOGGY)
		{
			if (number_range(0, 2000) <= 1000)
			{
				act("{RThe morning fog is as thick as pea soup. Perhaps you should find your way indoors.{x \n", d->character, NULL, NULL, TO_CHAR);
			}
			else
				if (number_range(0, 2000) <= 1250)
			{
				act("{RNot being able to see where you are going, you slip and fall into a hole.{x \n", d->character, NULL, NULL, TO_CHAR);
				act("$n falls face first into a hole!", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 5;
			}
			else
				if (number_range(0, 2000) <= 1500)
			{
				act("{RYou've walked straight into a tree! Way to go!!{x \n", d->character, NULL, NULL, TO_CHAR);
				act("$n has planted themselves headfirst into a tree. Encore!", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 15;
			}
			else
				if (number_range(0, 2000) <= 1950)
			{
				act("{RThe morning fog is as thick as pea soup. Perhaps you should find your way indoors.{x \n", d->character, NULL, NULL, TO_CHAR);
			}
			else
				if (number_range(0, 2000) <= 2000)
			{
				act("{RNot being able to see where you're going, you fall straight into a river.{x \n", d->character, NULL, NULL, TO_CHAR);
				act("$n pulls $gn{his} clothes out of the river after falling in!", d->character, NULL, NULL, TO_ROOM);
				d->character->hit -= 30;
			}

		}
	}
}

bool number_chance(int num)
{
	if (number_range(1, 100) <= num) return TRUE;
	else return FALSE;
}

SPELL_FUN(spell_control_weather)
{
	if (!str_cmp(target_name, "better"))
	{

		if (weather_info.sky == SKY_CLOUDLESS)
		{
			act("But it's so beautiful outside already\n", ch, NULL, NULL, TO_CHAR);
			return;
		}
		else
			if (weather_info.sky == SKY_CLOUDY)
		{
			act("You recite the ancient spell and the clouds part in obedience\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the clouds part.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_CLOUDLESS;
			return;
		}
		else
			if (weather_info.sky == SKY_RAINING)
		{
			act("You recite the ancient spell and the rain stops in obedience\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the rain stops.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_CLOUDY;
			return;
		}
		else
			if (weather_info.sky == SKY_LIGHTNING)
		{
			act("You recite the ancient spell and the lightning ceases in obedience\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the lightning stops.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_THUNDERSTORM;
			return;
		}
		else
			if (weather_info.sky == SKY_THUNDERSTORM)
		{
			act("You recite the ancient spell and the storm ceases\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the storm ceases.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_RAINING;
			return;
		}
		else
			if (weather_info.sky == SKY_SNOWING)
		{
			act("You recite the ancient spell and the snow ceases in obedience\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the snow ceases.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_CLOUDY;
			return;
		}
		else
			if (weather_info.sky == SKY_BLIZZARD)
		{
			act("You recite the ancient spell and the horizon clears\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the horizon clears.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_SNOWING;
			return;
		}
		else
			if (weather_info.sky == SKY_ICESTORM)
		{
			act("You recite the ancient spell and the horizon clears\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the horizon clears.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_RAINING;
			return;
		}
		else
			if (weather_info.sky == SKY_HAILSTORM)
		{
			act("You recite the ancient spell and the horizon clears\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the horizon clears.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_RAINING;
			return;
		}
		else
			if (weather_info.sky == SKY_FOGGY)
		{
			act("You recite the ancient spell and the horizon clears\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the horizon clears.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_CLOUDY;
			return;
		}
		else
		{
			act("Bad Weather Call. Please notify the imms.\n", ch, NULL, NULL, TO_CHAR);
		}

	}
	else if (!str_cmp(target_name, "worse"))
	{

		if (weather_info.sky == SKY_CLOUDLESS)
		{
			act("You recite the ancient spell and the clouds come at your command.\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the clouds darken the sky.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_CLOUDY;
			return;
		}
		else
			if (weather_info.sky == SKY_CLOUDY)
		{
			act("You recite the ancient spell and the clouds trickle down rain\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the clouds open up to rain.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_RAINING;
			return;
		}
		else
			if (weather_info.sky == SKY_RAINING)
		{
			act("You recite the ancient spell and the rain turns to hail\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the rain turns to hail.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_HAILSTORM;
			return;
		}
		else
			if (weather_info.sky == SKY_LIGHTNING)
		{
			act("You recite the ancient spell and the clouds send down sheets of ice\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the lightning turns to ice.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_ICESTORM;
			return;
		}
		else
			if (weather_info.sky == SKY_THUNDERSTORM)
		{
			act("You recite the ancient spell and the clouds clap in thunderous approval\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the  clouds clap in thunder.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_LIGHTNING;
			return;
		}
		else
			if (weather_info.sky == SKY_SNOWING)
		{
			act("You recite the ancient spell and the snow increases in obedience\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the snow turns to a blizzard.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_BLIZZARD;
			return;
		}
		else
			if (weather_info.sky == SKY_BLIZZARD)
		{
			act("It's already as bad as it can get\n", ch, NULL, NULL, TO_CHAR);
			return;
		}
		else
			if (weather_info.sky == SKY_ICESTORM)
		{
			act("It's already as bad as it can get\n", ch, NULL, NULL, TO_CHAR);
			return;
		}
		else
			if (weather_info.sky == SKY_HAILSTORM)
		{
			act("It's already as bad as it can get\n", ch, NULL, NULL, TO_CHAR);
			return;
		}
		else
			if (weather_info.sky == SKY_FOGGY)
		{
			act("You recite the ancient spell and the horizon clears\n", ch, NULL, NULL, TO_CHAR);
			act("$n makes a strange movement with their hands and the horizon clears.", ch, NULL, NULL, TO_ROOM);
			weather_info.sky = SKY_CLOUDY;
			return;

		}
		else
		{
			act("Bad Weather Call. Please notify the imms.\n", ch, NULL, NULL, TO_CHAR);
		}

	}
	else
		act("Do you want it to get better or worse?", ch, NULL, NULL, TO_CHAR);

	act("Ok.", ch , NULL, NULL, TO_CHAR);
	return;
}


void do_wset(CHAR_DATA *ch, const char *argument)
{
	char arg1 [MAX_INPUT_LENGTH];
	argument = one_argument(argument, arg1 , sizeof(arg1));
	if (arg1[0] == '\0')
	{
		do_help(ch, "WSET");
		return;
	}
	if (!str_cmp(arg1, "cloudless"))
	{
		act("You wave your hands and in reverence to you, the clouds dissapear \n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_CLOUDLESS;
		act("$n makes a strange movement with their hands and the clouds part.", ch, NULL, NULL, TO_ROOM);
	}
	else
		if (!str_cmp(arg1, "fog"))
	{
		act("You wave your hands and in reverence to you, a mist vapors the horizon \n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_FOGGY;
		act("$n makes a strange movement with their hands and a mist vapors the horizon.", ch, NULL, NULL, TO_ROOM);
	}
	else
		if (!str_cmp(arg1, "hail"))
	{
		act("You wave your hands and in reverence to you, hailstones fall from the sky \n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_HAILSTORM;
		act("$n makes a strange movement with their hands and hailstones fall from the sky.", ch, NULL, NULL, TO_ROOM);
	}
	else
		if (!str_cmp(arg1, "icestorm"))
	{
		act("You wave your hands and in reverence to you, it starts raining ice \n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_ICESTORM;
		act("$n makes a strange movement with their hands and it starts raining ice.", ch, NULL, NULL, TO_ROOM);
	}
	else
		if (!str_cmp(arg1, "blizzard"))
	{
		act("You wave your hands and in reverence to you, snowflakes cover the horizon making it impossible to see.\n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_BLIZZARD;
		act("$n makes a strange movement with their hands and snowflakes cover the horizon making it impossibile to see", ch, NULL, NULL, TO_ROOM);
	}
	else
		if (!str_cmp(arg1, "snowing"))
	{
		act("You wave your hands and in reverence to you, snowflakes  fall from the sky..\n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_SNOWING;
		act("$n makes a strange movement with their hands and snowflakes fall from the sky", ch, NULL, NULL, TO_ROOM);
	}
	else
		if (!str_cmp(arg1, "rain"))
	{
		act("You wave your hands and in reverence to you, a warm rain starts to fall.\n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_RAINING;
		act("$n makes a strange movement with their hands and a warm rain starts to fall", ch, NULL, NULL, TO_ROOM);
	}
	else
		if (!str_cmp(arg1, "lightning"))
	{
		act("You wave your hands and in reverence to you, lightning pierces the sky. \n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_LIGHTNING;
		act("$n makes a strange movement with their hands and lightning pierces  the sky", ch, NULL, NULL, TO_ROOM);
	}
	else
		if (!str_cmp(arg1, "thunderstorm"))
	{
		act("You wave your hands and in reverence to you, The clouds clap in thunder.\n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_THUNDERSTORM;
		act("$n makes a strange movement with their hands and the clouds clap in thunder", ch, NULL, NULL, TO_ROOM);
	}
	else
		if (!str_cmp(arg1, "cloudy"))
	{
		act("You wave your hands and in reverence to you, clouds cover the horizon, threatening rain.\n", ch, NULL, NULL, TO_CHAR);
		weather_info.sky = SKY_CLOUDY;
		act("$n makes a strange movement with their hands and clouds cover the horizon, threatening rain", ch, NULL, NULL, TO_ROOM);
	}
/* okay, we haven't met any conditions so far. Did they forget? */
	else
	{
		do_help(ch, "WSET");
		return;
	}

}

void do_climat(CHAR_DATA *ch, const char *argument)
{
	int j;
	char arg [MAX_INPUT_LENGTH];
	AREA_DATA *pArea;
	BUFFER *output;

	argument = one_argument(argument, arg, sizeof(arg));

	if (arg[0] == '\0')
	{
		do_help(ch, "CLIMAT");
		return;
	}

	j = 1;

	if (!str_cmp(arg, "all") || !str_cmp(argument, ""))
	{
		output = buf_new(-1);
		for (pArea = area_first; pArea; pArea = pArea->next)
			if (!IS_SET(pArea->flags, AREA_NOWEATHER))
			{
				buf_printf(output, "%-30s %-15s ", fmt_color_str(pArea->name, 30), flag_string(climat_flags, pArea->climat_type));
				if (j == 2)
				{
					buf_printf(output, "\n\r");
					j=0;
				}
				j++;                          
			}
		buf_printf(output, "\n\r");
		page_to_char(buf_string(output), ch);
		buf_free(output);
		return;
	}
	else

		if (!str_cmp(arg, "continental"))
	{
		output = buf_new(-1);
		for (pArea = area_first; pArea; pArea = pArea->next)
			if (!IS_SET(pArea->flags, AREA_NOWEATHER) && IS_SET(pArea->climat_type, CLIMAT_CONTINENTAL))
			{
				buf_printf(output, "%-30s %-15s ", fmt_color_str(pArea->name, 30), flag_string(climat_flags, pArea->climat_type));
				if (j == 2)
				{
					buf_printf(output, "\n\r");
					j=0;
				}
				j++;                          
			}
		buf_printf(output, "\n\r");
		page_to_char(buf_string(output), ch);
		buf_free(output);
		return;
	}
	else

		if (!str_cmp(arg, "tropical"))
	{
		output = buf_new(-1);
		for (pArea = area_first; pArea; pArea = pArea->next)
			if (!IS_SET(pArea->flags, AREA_NOWEATHER) && IS_SET(pArea->climat_type, CLIMAT_TROPIC))
			{
				buf_printf(output, "%-30s %-15s ", fmt_color_str(pArea->name, 30), flag_string(climat_flags, pArea->climat_type));
				if (j == 2)
				{
					buf_printf(output, "\n\r");
					j=0;
				}
				j++;                          
			}
		buf_printf(output, "\n\r");
		page_to_char(buf_string(output), ch);
		buf_free(output);
		return;
	}
	else
		if (!str_cmp(arg, "arctic"))
	{
		output = buf_new(-1);
		for (pArea = area_first; pArea; pArea = pArea->next)
			if (!IS_SET(pArea->flags, AREA_NOWEATHER) && IS_SET(pArea->climat_type, CLIMAT_ARCTIC))
			{
				buf_printf(output, "%-30s %-10s ", fmt_color_str(pArea->name, 30), flag_string(climat_flags, pArea->climat_type));
				if (j == 2)
				{
					buf_printf(output, "\n\r");
					j=0;
				}
				j++;                          
			}
		buf_printf(output, "\n\r");
		page_to_char(buf_string(output), ch);
		buf_free(output);
		return;
	}
	else
		if (!str_cmp(arg, "sea"))
	{
		output = buf_new(-1);
		for (pArea = area_first; pArea; pArea = pArea->next)
			if (!IS_SET(pArea->flags, AREA_NOWEATHER) && IS_SET(pArea->climat_type, CLIMAT_SEA))
			{
				buf_printf(output, "%-30s %-15s ", fmt_color_str(pArea->name, 30), flag_string(climat_flags, pArea->climat_type));
				if (j == 2)
				{
					buf_printf(output, "\n\r");
					j=0;
				}
				j++;                          
			}
		buf_printf(output, "\n\r");
		page_to_char(buf_string(output), ch);
		buf_free(output);
		return;
	}
	else
		if (!str_cmp(arg, "dessert"))
	{
		output = buf_new(-1);
		for (pArea = area_first; pArea; pArea = pArea->next)
			if (!IS_SET(pArea->flags, AREA_NOWEATHER) && IS_SET(pArea->climat_type, CLIMAT_DESSERT))
			{
				buf_printf(output, "%-30s %-15s ", fmt_color_str(pArea->name, 30), flag_string(climat_flags, pArea->climat_type));
				if (j == 2)
				{
					buf_printf(output, "\n\r");
					j=0;
				}
				j++;                          
			}
		buf_printf(output, "\n\r");
		page_to_char(buf_string(output), ch);
		buf_free(output);
		return;
	}
	else
		if (!str_cmp(arg, "mountain"))
	{
		output = buf_new(-1);
		for (pArea = area_first; pArea; pArea = pArea->next)
			if (!IS_SET(pArea->flags, AREA_NOWEATHER) && IS_SET(pArea->climat_type, CLIMAT_MOUNTAIN))
			{
				buf_printf(output, "%-30s %-15s ", fmt_color_str(pArea->name, 30), flag_string(climat_flags, pArea->climat_type));
				if (j == 2)
				{
					buf_printf(output, "\n\r");
					j=0;
				}
				j++;                          
			}
		buf_printf(output, "\n\r");
		page_to_char(buf_string(output), ch);
		buf_free(output);
		return;
	}
	else
		if (!str_cmp(arg, "highmountain"))
	{
		output = buf_new(-1);
		for (pArea = area_first; pArea; pArea = pArea->next)
			if (!IS_SET(pArea->flags, AREA_NOWEATHER) && IS_SET(pArea->climat_type, CLIMAT_HIGHMOUNTAIN))
			{
				buf_printf(output, "%-30s %-15s ", fmt_color_str(pArea->name, 30), flag_string(climat_flags, pArea->climat_type));
				if (j == 2)
				{
					buf_printf(output, "\n\r");
					j=0;
				}
				j++;                          
			}
		buf_printf(output, "\n\r");
		page_to_char(buf_string(output), ch);
		buf_free(output);
		return;
	}
	else
	{
		do_help(ch, "CLIMAT");
		return;
	}
}

void do_dateset(CHAR_DATA *ch, const char *argument)
{
	char arg1 [MAX_INPUT_LENGTH];
	char arg2 [MAX_INPUT_LENGTH];
	int i;

	argument = one_argument(argument, arg1 , sizeof(arg1));
	one_argument(argument, arg2 , sizeof(arg2));

	if (!is_number(arg2))
	{
		do_help(ch, "DATESET");
		return;
	}

	i= atoi(arg2);

	if (arg1[0] == '\0')
	{
		do_help(ch, "DATESET");
		return;
	}

	if (!str_cmp(arg1, "day"))
	{
		if (i < 0 || i > DAY_ON_MONTH)
		{
			char_printf(ch, "Argument must between 0 and %d\n", DAY_ON_MONTH);
			return;
        }
		time_info.day = i;
		return;
	}
	else
		if (!str_cmp(arg1, "month"))
	{
		if (i < 0 || i > MONTH_ON_YEAR)
		{
			char_printf(ch, "Argument must between 0 and %d\n", MONTH_ON_YEAR);
			return;
        }
		time_info.month = i;
		return;
	}
	else
		if (!str_cmp(arg1, "year"))
	{
		if (i < 0)
		{
			char_printf(ch, "Argument must greater 0\n");
			return;
        }
		time_info.year = i;
		return;
	}
	else
		if (!str_cmp(arg1, "hour"))
	{
		if (i < 0 || i > HOUR_ON_DAY)
		{
			char_printf(ch, "Argument must between 0 and %d\n", HOUR_ON_DAY);
			return;
		}
		time_info.hour = i;
		return;
	}
	else
	{
		do_help(ch, "DATESET");
		return;
	}
}
