/* $Id: wquest.h,v 1.666 2004/09/20 10:49:54 shrike Exp $                             */ 
 
/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 

// Automated quest with windows. Idea by Ambulant.

#ifndef _WQUEST_H
#define _WQUEST_H

#include "typedef.h"

#define WQ_TYPE_MULTIPLAYER   0
#define WQ_TYPE_PERSONAL      1

#define MAX_HINT              3 // max. number of hints that the char can use in wq

typedef struct wq_questdata WQ_QUESTDATA;
typedef struct wq_questplr  WQ_QUESTPLR;
typedef struct wq_master    WQ_MASTER;

// ----------------------------------------------------------------------
// WQ data for single quest
// ----------------------------------------------------------------------
struct wq_questdata
{
    WQ_QUESTDATA * next;        // next in chain

    int          * windows;     // ptrs to objects

    int            level_min;   // minimal level for participant
    int            level_max;   // maximal level for participant
    int            ticks_left;  // ticks left for the quest
    int            ticks_total; // total time for the quest
    int            ticks_start; // ticks to start the quest
    int            room_count;  // room count (size of array)
    int            plr_count;   // number of players
    int            type;        // personal or multiplayer

    WQ_QUESTPLR  * plr;         // list of players
};

// ----------------------------------------------------------------------
// GQ data for single quest participant
// ----------------------------------------------------------------------
struct wq_questplr
{
    WQ_QUESTPLR  * next;        // next in chain
    WQ_QUESTDATA * quest;       // ptr to the quest data
    char*          name;        // name of the player
    int            visited;     // number of total visited places
    int            hints;       // number of hints used
};

// ----------------------------------------------------------------------
// master structure to track GQ information
// ----------------------------------------------------------------------
struct wq_master
{
    WQ_QUESTDATA * quests;      // currently active quest
    int            enable;      // enable/disable indicator
    int            ticks_next;  // ticks to the next autoquest
};

WQ_QUESTPLR * wq_findplr (CHAR_DATA* ch);
WQ_QUESTDATA * wq_findquest (CHAR_DATA* ch);
void wq_init (bool enable);

#endif
